;
; "Owllight"
; by Dave Seidel
;
; Copyright 2007 Dave Seidel, some rights reserved.  This work is licensed under a
; Creative Commons Attribution License (see http://creativecommons.org/licenses/by/3.0/).
;
; For more information, go to http://mysterybear.net/article/22/owllight.
; 
; Add the following lines after <CsoundSynthesizer> and before <CsInstruments> below,
; uncomment by removing the leading semicolons, then edit as desired.
; 
; *** START OF OPTIONS ***
; <CsOptions>
; ; 96K/24-bit
; ;--sample-rate=96000 --control-rate=96000 --format=wav:24bit -o "Owllight-(96-24).wav"
; ; 44.1K/16-bit
; --sample-rate=44100 --control-rate=44100 --format=wav:short -o "Owllight-(44-16).wav"
; </CsOptions>
; *** END OF OPTIONS ***
; 
;
; Generated by blue 0.114.1 (http://csounds.com/stevenyi/blue/index.html)
;

<CsoundSynthesizer>

<CsOptions>

; 96K/24-bit
;--sample-rate=96000 --control-rate=96000 --format=wav:24bit -o "Owllight-(96-24).wav"

; 44.1K/16-bit
--sample-rate=44100 --control-rate=44100 --format=wav:short -o "Owllight-(44-16).wav"

</CsOptions>

<CsInstruments>
sr=96000
ksmps=1
nchnls=2

; sine wave table
giTblSz	init	1048576
gifn1	ftgen	1, 0, giTblSz, 10, 1

; globals left/right channels
gaL	init	0
gaR	init	0






	instr 1	;sine
idur	=	p3				; duration
iamp	=	p4				; amplitude
ifn	=	p5				; function table number (waveform)
ifreq	=	p6
ilr	=	p7				; 1.0 = left <-> 0.0 = right
irise	=	p8
ifall	=	p9
index	=	p10				; display only

kenv	linen	iamp, irise, idur, ifall	; envelope for poscil
asig	poscil3	kenv, ifreq, ifn, -1

gaL	=	gaL + (asig*ilr)
gaR	=	gaR + (asig*(1-ilr))

	endin

	instr 2	;stereo reverb
aL, aR	reverbsc gaL, gaR, p4, p5, sr/1.5, p6, 0
a1	= gaL+(aL*p7)
a2	= gaR+(aR*p7)
	outs	a1, a2
gaL	=	0
gaR	=	0
	endin


</CsInstruments>

<CsScore>



; tempo scaling
t 0 45






i2	0.0	315	.85	30720	.5	.4
i1	0.0	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	3.000825	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	3.000825	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	3.001649	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	6.004948	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	6.001649	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	6.006598	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	9.012371	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	9.007423	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	9.002474	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	9.009897	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	9.014845	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	12.023093	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	12.003299	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	12.026392	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	15.037113	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	15.028866	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	15.020619	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	15.004124	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	15.004124	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	15.008247	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	15.024742	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	15.03299	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	15.041237	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	18.054434	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	18.03464	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	18.004948	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	18.039589	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	18.059381	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	21.075052	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	21.063505	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	21.040413	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	21.028866	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	21.005774	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	21.005774	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	21.011545	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	21.03464	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	21.046186	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	21.069279	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	21.080826	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	24.098969	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	24.006598	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	24.105568	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	27.126186	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	27.11134	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	27.096495	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	27.007423	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	27.007423	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	27.014845	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	27.103918	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	27.118763	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	27.133608	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	30.1567	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	30.12371	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	30.090721	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	30.024742	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	30.008247	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	30.03299	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	30.098969	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	30.13196	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	30.164948	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	33.190514	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	33.17237	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	33.13608	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	33.099792	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	33.08165	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	33.04536	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	33.027218	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	33.00907	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	33.03629	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	33.054432	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	33.09072	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	33.108868	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	33.145157	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	33.181442	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	33.19959	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	36.22763	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	36.148453	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	36.009895	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	36.15835	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	36.237526	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	39.26804	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	39.246597	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	39.225155	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	39.182266	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	39.160824	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	39.13938	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	39.010723	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	39.010723	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	39.021442	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	39.150105	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	39.171547	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	39.19299	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	39.235874	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	39.25732	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	39.278763	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	42.311752	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	42.265568	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	42.173195	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	42.12701	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	42.034637	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	42.011547	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	42.046185	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	42.138557	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	42.184742	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	42.277115	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	42.3233	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	45.358765	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	45.334023	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	45.284534	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	45.259792	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	45.210308	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	45.185566	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	45.13608	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	45.11134	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	45.061855	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	45.037113	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	45.01237	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	45.049484	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	45.074226	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	45.12371	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	45.148453	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	45.197937	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	45.22268	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	45.272163	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	45.296906	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	45.346394	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	45.371136	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	48.409073	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	48.013195	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	48.422268	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	51.46268	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	51.43464	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	51.406597	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	51.014023	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	51.014023	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	51.02804	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	51.42062	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	51.44866	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	51.4767	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	54.51959	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	54.460205	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	54.400826	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	54.044537	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	54.014847	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	54.05938	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	54.41567	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	54.47505	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	54.53443	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	57.579796	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	57.548454	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	57.48577	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	57.42309	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	57.391754	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	57.07835	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	57.04701	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	57.01567	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	57.06268	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	57.09402	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	57.40742	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	57.438763	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	57.501442	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	57.564125	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	57.595463	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	60.6433	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	60.51134	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	60.37938	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	60.115463	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	60.016495	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	60.131958	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	60.395878	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	60.527836	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	60.659794	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	63.710102	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	63.675465	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	63.640823	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	63.571545	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	63.536907	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	63.50227	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	63.43299	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	63.39835	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	63.363712	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	63.155876	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	63.12124	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	63.086597	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	63.01732	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	63.01732	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	63.034637	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	63.103916	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	63.138557	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	63.173195	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	63.38103	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	63.41567	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	63.45031	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	63.51959	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	63.554226	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	63.588867	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	63.658146	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	63.692783	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	63.727425	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	66.780205	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	66.70763	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	66.56248	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	66.41732	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	66.34474	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	66.199585	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	66.12701	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	66.01814	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	66.14516	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	66.217735	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	66.362885	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	66.43546	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	66.58062	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	66.72578	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	66.79835	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	69.85361	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	69.81567	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	69.73979	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	69.70186	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	69.62598	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	69.58804	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	69.5501	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	69.47423	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	69.43629	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	69.36041	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	69.32247	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	69.2466	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	69.20866	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	69.13278	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	69.09485	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	69.01897	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	69.01897	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	69.03794	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	69.113815	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	69.15176	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	69.22763	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	69.265564	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	69.341446	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	69.37938	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	69.45526	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	69.493195	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	69.56907	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	69.60701	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	69.64495	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	69.720825	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	69.758766	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	69.83464	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	69.872574	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	72.930305	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	72.61361	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	72.01979	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	72.6334	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	72.9501	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	76.01031	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	75.96907	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	75.92783	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	75.68041	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	75.639175	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	75.59794	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	75.02062	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	75.02062	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	75.04124	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	75.61856	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	75.6598	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	75.701035	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	75.948456	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	75.98969	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	76.03093	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	79.093605	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	79.007835	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	78.922066	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	78.75052	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	78.66474	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	78.57897	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	78.06433	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	78.02145	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	78.08577	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	78.60041	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	78.68619	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	78.77196	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	78.943504	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	79.02928	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	79.11505	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	82.18021	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	82.13567	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	82.0466	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	81.95753	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	81.91299	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	81.82392	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	81.77938	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	81.69031	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	81.601234	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	81.5567	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	81.11134	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	81.0668	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	81.02227	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	81.08907	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	81.133606	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	81.57897	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	81.623505	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	81.71258	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	81.80165	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	81.84618	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	81.93526	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	81.9798	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	82.06886	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	82.157936	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	82.20248	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	85.2701	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	85.08536	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	84.71587	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	84.531136	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	84.16165	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	84.023094	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	84.184746	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	84.55423	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	84.73897	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	85.10845	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	85.2932	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	88.3633	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	88.31546	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	88.26763	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	88.17196	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	88.12412	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	88.07629	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	87.789276	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	87.74144	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	87.69361	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	87.59794	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	87.5501	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	87.502266	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	87.215256	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	87.16742	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	87.11959	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	87.02392	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	87.02392	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	87.04784	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	87.1435	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	87.19134	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	87.239174	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	87.526184	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	87.57402	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	87.62186	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	87.71753	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	87.76536	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	87.813194	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	88.100204	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	88.14804	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	88.19588	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	88.29155	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	88.33938	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	88.387215	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	91.45979	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	91.360825	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	91.16289	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	91.06392	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	90.86598	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	90.76701	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	90.56907	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	90.4701	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	90.27216	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	90.173195	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	90.02474	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	90.19794	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	90.296906	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	90.49484	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	90.59381	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	90.791756	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	90.890724	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	91.08866	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	91.18763	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	91.38557	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	91.484535	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	94.40619	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	94.35505	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	94.252785	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	94.20165	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	94.09938	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	94.04825	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	93.94598	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	93.894844	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	93.79258	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	93.74144	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	93.639175	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	93.58804	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	93.48577	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	93.43464	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	93.332375	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	93.281235	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	93.17897	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	93.12784	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	93.025566	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	93.025566	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	93.05113	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	93.153404	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	93.20454	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	93.3068	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	93.35794	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	93.460205	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	93.51134	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	93.61361	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	93.66474	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	93.76701	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	93.818146	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	93.92041	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	93.97154	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	94.073814	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	94.12495	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	94.22722	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	94.27835	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	94.380615	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	94.431755	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	97.50433	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	96.02639	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	97.53072	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	100.605774	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	100.55134	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	100.49691	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	99.027214	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	99.027214	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	99.054436	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	100.524124	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	100.57856	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	100.63299	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	103.654434	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	103.59835	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	103.48618	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	102.08412	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	102.02804	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	102.11217	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	103.51423	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	103.62639	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	103.68247	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	106.703094	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	106.5299	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	106.47217	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	105.14433	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	105.0866	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	105.02887	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	105.11546	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	105.173195	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	106.50103	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	106.55876	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	106.73196	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	109.69237	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	109.63299	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	109.45484	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	108.20783	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	108.02969	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	108.237526	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	109.484535	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	109.66268	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	109.72206	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	112.800415	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	112.61732	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	112.55629	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	112.495255	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	112.43423	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	111.274635	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	111.21361	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	111.15258	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	111.03052	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	111.03052	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	111.06103	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	111.18309	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	111.244125	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	111.30515	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	112.464745	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	112.52577	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	112.58681	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	112.647835	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	112.830925	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	115.78639	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	115.72371	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	115.59835	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	115.53567	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	115.41031	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	114.34474	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	114.21938	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	114.03134	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	114.250725	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	114.37608	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	115.44165	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	115.56701	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	115.62969	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	115.75505	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	115.81773	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	118.897736	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	118.447426	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	118.383095	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	117.418144	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	117.35381	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	117.22516	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	117.16083	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	117.032166	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	117.032166	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	117.06433	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	117.19299	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	117.25732	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	117.38598	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	117.45031	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	118.41526	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	118.47959	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	118.92989	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	121.88041	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	121.550514	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	121.35258	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	120.49484	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	120.03299	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	120.52783	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	121.38557	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	121.5835	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	121.9134	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	124.99505	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	124.92742	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	124.859795	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	124.656906	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	124.58928	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	124.52165	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	124.45402	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	124.38639	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	124.31876	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	123.574844	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	123.50722	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	123.43959	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	123.03381	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	123.03381	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	123.06763	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	123.473404	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	123.54103	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	123.60866	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	124.35258	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	124.420204	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	124.48784	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	124.555466	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	124.62309	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	124.69072	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	124.89361	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	124.961235	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	125.02887	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	128.04372	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	127.974434	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	127.83588	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	127.7666	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	127.628044	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	127.55876	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	127.48949	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	127.420204	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	127.28165	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	126.65814	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	126.519585	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	126.38103	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	126.10392	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	126.03464	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	126.13856	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	126.41567	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	126.55423	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	126.69279	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	127.31629	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	127.45484	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	127.524124	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	127.5934	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	127.66268	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	127.80124	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	127.870514	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	128.00908	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	128.07835	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	131.09238	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	130.59587	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	130.52495	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	130.31216	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	130.24124	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	129.74474	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	129.67381	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	129.53195	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	129.3901	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	129.31917	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	129.17732	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	129.1064	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	129.03546	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	129.14186	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	129.21278	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	129.35464	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	129.42557	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	129.56743	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	129.70927	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	129.78021	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	130.2767	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	130.34763	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	130.56041	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	130.63133	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	131.12784	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	134.06845	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	133.70557	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	133.48784	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	133.41525	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	133.19753	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	132.83464	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	132.54433	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	132.03629	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	132.58061	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	132.87093	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	133.23381	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	133.45155	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	133.52412	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	133.74185	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	134.10474	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	137.1897	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	137.11546	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	137.04124	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	136.81856	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	136.74432	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	136.6701	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	136.59587	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	136.3732	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	136.29897	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	136.22475	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	136.15051	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	135.92784	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	135.8536	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	135.77939	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	135.63092	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	135.5567	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	135.48247	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	135.03711	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	135.03711	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	135.07423	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	135.51959	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	135.59381	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	135.66805	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	135.8165	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	135.89072	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	135.96495	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	136.18762	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	136.26186	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	136.33607	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	136.41031	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	136.633	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	136.70721	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	136.78145	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	136.85567	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	137.07835	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	137.15257	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	137.2268	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	140.23836	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	140.16248	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	140.01073	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	139.93484	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	139.7831	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	139.70721	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	139.55547	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	139.47958	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	139.32784	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	139.25195	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	139.1002	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	139.02432	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	138.87257	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	138.56908	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	138.41731	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	138.11382	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	138.03793	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	138.15175	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	138.45526	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	138.60701	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	138.91052	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	139.06227	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	139.13814	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	139.2899	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	139.36577	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	139.51753	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	139.5934	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	139.74515	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	139.82103	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	139.97278	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	140.04866	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	140.20041	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	140.27629	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	143.287	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	141.89154	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	141.81403	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	141.65897	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	141.58144	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	141.42639	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	141.34886	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	141.19382	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	141.11629	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	141.03876	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	141.15504	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	141.23257	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	141.38763	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	141.46515	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	141.62021	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	141.69774	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	141.85278	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	141.93031	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	143.32578	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	146.2565	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	144.98969	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	144.03958	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	145.02928	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	146.29608	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	149.38432	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	149.30351	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	149.22269	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	148.09114	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	148.01031	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	147.92949	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	147.0404	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	147.0404	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	147.08083	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	147.9699	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	148.05072	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	148.13155	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	149.26309	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	149.34392	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	149.42474	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	152.43298	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	152.35051	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	152.18556	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	151.19588	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	151.03093	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	150.86598	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	150.12372	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	150.04124	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	150.16495	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	150.90721	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	151.07216	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	151.2371	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	152.2268	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	152.39175	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	152.47423	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	155.48164	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	155.22928	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	155.14516	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	154.30392	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	154.21979	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	154.05154	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	153.8833	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	153.79918	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	153.21031	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	153.12619	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	153.04207	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	153.16824	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	153.25237	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	153.84123	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	153.92535	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	154.09361	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	154.26186	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	154.34598	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	155.18721	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	155.27135	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	155.52371	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	158.44453	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	158.35876	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	158.10144	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	157.41525	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	157.07216	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	156.72906	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	156.3002	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	156.0429	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	156.3431	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	156.77196	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	157.11505	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	157.45815	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	158.14433	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	158.40164	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	158.48743	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	161.57896	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	161.3167	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	161.22928	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	161.14186	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	161.05443	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	160.52989	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	160.44247	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	160.35506	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	160.1802	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	160.09279	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	160.00536	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	159.83052	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	159.74309	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	159.65567	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	159.3934	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	159.30598	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	159.21855	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	159.04372	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	159.04372	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	159.08742	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	159.26227	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	159.34969	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	159.43712	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	159.69939	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	159.7868	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	159.87422	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	160.04907	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	160.13649	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	160.22392	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	160.39876	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	160.48619	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	160.57361	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	161.09814	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	161.18556	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	161.273	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	161.36041	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	161.62268	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	164.53856	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	164.44948	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	164.27135	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	164.18227	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	164.00412	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	163.64784	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	163.4697	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	163.1134	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	162.75711	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	162.57896	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	162.4899	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	162.31175	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	162.04454	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	162.3563	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	162.53444	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	162.6235	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	162.80165	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	163.15794	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	163.51422	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	163.69237	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	164.04866	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	164.2268	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	164.31587	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	164.49402	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	164.5831	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	167.67628	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	167.04124	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	166.95052	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	166.76907	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	166.67834	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	166.4969	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	166.40619	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	166.22475	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	166.13402	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	166.0433	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	165.86186	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	165.77113	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	165.31752	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	165.2268	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	165.04536	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	165.04536	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	165.09073	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	165.27217	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	165.36288	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	165.8165	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	165.90721	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	166.08865	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	166.17938	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	166.2701	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	166.45155	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	166.54227	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	166.72371	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	166.81444	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	166.99588	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	167.0866	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	167.72165	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	170.63258	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	170.17072	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	169.15463	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	168.69278	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	168.41566	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	168.04619	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	168.46185	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	168.73897	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	169.20082	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	170.2169	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	170.67876	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	173.7736	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	173.67958	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	173.58557	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	173.30351	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	173.20949	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	173.11546	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	172.26927	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	172.17526	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	172.08124	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	171.79918	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	171.70515	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	171.61113	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	171.51712	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	171.4231	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	171.32907	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	171.04701	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	171.04701	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	171.09402	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	171.37608	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	171.47011	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	171.56412	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	171.65814	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	171.75217	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	171.84619	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	172.12825	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	172.22227	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	172.31628	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	173.16248	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	173.2565	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	173.35051	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	173.63258	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	173.7266	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	173.82062	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	176.82227	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	176.7266	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	176.53526	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	176.43959	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	176.24825	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	176.0569	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	175.38722	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	175.19588	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	175.00453	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	174.90886	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	174.71753	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	174.62186	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	174.52618	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	174.43051	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	174.23918	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	174.14351	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	174.04784	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	174.19135	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	174.287	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	174.47835	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	174.57402	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	174.6697	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	174.76537	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	174.9567	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	175.05237	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	175.24371	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	175.43506	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	176.10474	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	176.29608	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	176.48743	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	176.5831	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	176.77443	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	176.8701	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	179.87093	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	179.287	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	179.09238	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	178.99506	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	178.50845	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	178.41113	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	178.21649	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	177.63258	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	177.53526	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	177.04866	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	177.58392	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	177.68124	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	178.26515	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	178.4598	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	178.55711	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	179.04372	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	179.14104	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	179.33566	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	179.91959	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	182.82062	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	182.42474	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	182.32578	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	181.9299	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	181.633	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	181.2371	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	181.13814	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	180.74226	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	180.44536	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	180.04948	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	180.04948	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	180.09897	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	180.49484	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	180.79175	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	181.18762	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	181.28659	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	181.68248	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	181.97939	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	182.37526	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	182.47423	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	182.8701	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	185.96825	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	185.86763	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	185.76701	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	185.56577	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	185.26392	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	185.06268	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	184.96207	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	184.86145	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	184.76082	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	184.6602	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	184.55959	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	184.35835	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	184.05649	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	183.85526	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	183.75464	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	183.65402	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	183.5534	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	183.45279	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	183.35216	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	183.15092	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	183.05031	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	183.20123	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	183.40248	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	183.5031	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	183.60371	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	183.70433	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	183.80495	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	183.90556	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	184.10681	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	184.40866	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	184.6099	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	184.71051	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	184.81113	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	184.91176	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	185.01237	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	185.11299	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	185.31422	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	185.61609	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	185.81732	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	185.91794	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	186.01855	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	189.0169	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	188.91464	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	188.60783	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	188.50557	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	188.4033	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	188.30103	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	187.99423	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	187.89195	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	187.78969	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	187.68742	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	187.38062	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	187.27835	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	187.17609	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	187.0738	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	186.76701	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	186.66475	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	186.56247	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	186.4602	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	186.1534	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	186.05113	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	186.20453	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	186.51134	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	186.6136	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	186.71588	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	186.81815	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	187.12495	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	187.22722	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	187.32948	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	187.43175	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	187.73856	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	187.84082	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	187.9431	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	188.04536	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	188.35216	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	188.45444	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	188.5567	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	188.65897	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	188.96577	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	189.06804	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	192.06557	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	191.85773	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	191.75381	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	191.54597	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	191.44206	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	191.23422	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	191.13031	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	190.92247	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	190.81856	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	190.61072	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	190.5068	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	190.29897	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	190.19505	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	189.98721	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	189.8833	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	189.67546	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	189.57155	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	189.36371	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	189.2598	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	189.15587	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	189.05196	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	189.20784	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	189.31175	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	189.41566	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	189.6235	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	189.72742	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	189.93526	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	190.03917	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	190.24701	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	190.35092	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	190.55876	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	190.66267	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	190.87051	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	190.97443	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	191.18227	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	191.28618	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	191.49402	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	191.59793	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	191.80577	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	191.9097	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	192.11752	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	192.26392	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	192.05278	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	192.3167	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	195.37526	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	195.26804	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	195.16083	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	195.0536	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	195.0536	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	195.10722	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	195.21443	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	195.32166	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	195.42886	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	198.4899	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	198.27217	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	198.1633	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	198.05443	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	198.05443	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	198.10887	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	198.21773	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	198.3266	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	198.54433	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	201.60783	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	201.49731	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	201.16577	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	201.05525	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	201.05525	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	201.11052	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	201.22102	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	201.55258	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	201.66309	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	204.72906	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	204.39258	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	204.28041	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	204.05608	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	204.05608	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	204.11217	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	204.3365	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	204.44865	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	204.78516	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	207.8536	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	207.73979	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	207.62598	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	207.51216	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	207.0569	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	207.56908	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	207.68289	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	207.7967	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	207.91052	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	210.98145	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	210.75052	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	210.63506	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	210.40413	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	210.05774	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	210.05774	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	210.11546	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	210.46185	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	210.69278	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	210.80824	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	211.03917	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	214.11258	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	213.99547	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	213.4099	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	213.29279	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	213.17567	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	213.05856	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	213.23422	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	213.35133	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	213.46846	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	214.05402	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	214.17113	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	217.24701	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	216.89072	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	216.53444	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	216.2969	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	216.05939	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	216.3563	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	216.59381	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	216.9501	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	217.3064	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	220.38474	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	220.26433	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	220.14392	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	220.0235	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	219.90309	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	219.78268	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	219.66226	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	219.54185	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	219.30103	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	219.18062	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	219.06021	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	219.06021	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	219.1204	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	219.24083	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	219.36124	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	219.60207	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	219.72247	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	219.84288	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	219.9633	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	220.08371	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	220.20412	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	220.32454	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	220.44495	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	223.52577	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	223.28165	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	223.15959	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	223.03752	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	222.91547	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	222.7934	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	222.67134	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	222.18309	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	222.06104	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	222.06104	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	222.12206	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	222.24413	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	222.73238	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	222.85443	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	222.9765	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	223.09856	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	223.22061	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	223.34268	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	223.5868	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	226.6701	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	226.54639	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	226.17526	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	226.05154	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	225.92784	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	225.80412	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	225.5567	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	225.30928	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	225.06186	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	225.06186	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	225.12372	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	225.37114	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	225.61856	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	225.86598	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	225.98969	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	226.1134	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	226.2371	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	226.60825	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	226.73196	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	229.81773	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	229.44165	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	229.31628	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	229.06557	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	228.9402	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	228.56412	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	228.3134	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	228.06268	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	228.37608	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	228.6268	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	229.00288	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	229.12825	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	229.37897	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	229.50433	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	229.88042	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	232.96866	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	232.84164	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	232.71465	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	232.58763	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	231.82556	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	231.69856	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	231.57155	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	231.31752	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	231.19052	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	231.0635	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	231.0635	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	231.12701	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	231.25403	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	231.38103	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	231.63506	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	231.76205	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	231.88907	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	232.65114	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	232.77814	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	232.90515	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	233.03217	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	236.1229	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	235.86557	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	235.73691	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	235.47958	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	234.96495	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	234.70763	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	234.193	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	234.06433	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	234.06433	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	234.12866	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	234.25732	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	234.77196	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	235.02928	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	235.54391	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	235.80124	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	235.9299	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	236.18721	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	239.28041	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	239.1501	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	238.49855	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	238.36824	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	238.10764	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	237.97733	4	200.000000	1	900.000000	0.500000	1.500000	1.000000	15
i1	237.7167	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	237.5864	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	237.32578	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	237.06516	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	237.06516	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	237.13031	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	237.39093	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	237.65155	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	237.78186	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	238.04248	4	187.500000	1	960.000000	0.500000	1.500000	1.000000	16
i1	238.17279	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	238.4334	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	238.5637	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	239.21526	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	239.34557	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	242.44124	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	242.04536	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	241.64949	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	240.3299	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	240.06598	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	240.39587	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	241.71547	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	242.11134	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	242.50722	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	245.60536	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	245.47176	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	245.33815	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	245.20453	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	245.07092	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	244.93732	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	244.80371	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	244.6701	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	244.5365	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	243.46764	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	243.33401	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	243.20041	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	243.0668	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	243.0668	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	243.1336	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	243.26721	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	243.40082	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	243.53444	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	244.6033	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	244.73691	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	244.87051	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	245.00412	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	245.13773	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	245.27135	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	245.40495	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	245.53856	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	245.67216	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	248.77278	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	248.50227	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	248.367	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	248.23175	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	248.0965	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	247.96124	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	247.82597	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	247.69072	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	247.42021	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	246.60866	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	246.33815	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	246.20288	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	246.06763	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	246.06763	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	246.13525	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	246.27051	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	246.40578	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	246.67628	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	247.48784	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	247.75835	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	247.8936	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	248.02887	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	248.16412	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	248.29938	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	248.43465	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	248.5699	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	248.84041	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	251.94351	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	251.8066	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	251.39587	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	251.25897	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	251.12206	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	250.98515	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	250.84825	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	250.43753	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	250.30061	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	249.75299	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	249.61609	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	249.20537	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	249.06845	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	249.06845	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	249.1369	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	249.27382	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	249.68454	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	249.82144	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	250.36908	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	250.50598	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	250.9167	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	251.0536	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	251.19052	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	251.32742	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	251.46432	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	251.87505	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	252.01196	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	255.11752	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	254.70186	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	254.5633	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	254.28618	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	254.14763	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	254.00908	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	253.73196	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	253.5934	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	253.17773	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	252.90062	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	252.48495	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	252.34639	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	252.06927	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	252.06927	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	252.13855	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	252.41566	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	252.55423	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	252.9699	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	253.24701	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	253.66267	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	253.80124	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	254.07835	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	254.2169	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	254.35547	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	254.63258	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	254.77113	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	255.1868	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	258.29483	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	258.15463	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	258.01443	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	257.87424	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	257.1732	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	256.47217	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	256.33197	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	256.19174	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	255.91135	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	255.77113	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	255.63092	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	255.0701	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	255.70103	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	255.84123	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	255.98145	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	256.26184	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	256.40207	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	256.54227	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	257.2433	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	257.94434	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	258.08453	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	258.22473	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	258.36496	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	261.47546	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	261.19174	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	261.0499	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	260.76617	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	260.3406	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	260.19876	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	260.05692	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	259.63135	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	259.34763	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	258.7802	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	258.4965	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	258.07092	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	258.07092	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	258.14185	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	258.5674	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	258.85114	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	259.41855	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	259.70227	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	260.12784	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	260.26968	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	260.41156	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	260.83713	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	261.12082	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	261.26266	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	261.5464	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	264.6594	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	264.51587	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	263.79834	4	76.923077	1	2340.000000	0.500000	1.500000	1.000000	39
i1	263.65485	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	263.51135	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	263.22433	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	262.93732	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	262.79382	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	262.6503	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	262.3633	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	262.2198	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	261.93277	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	261.78928	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	261.50226	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	261.35876	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	261.21527	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	261.07175	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	261.28702	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	261.4305	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	261.57404	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	261.86102	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	262.00455	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	262.29153	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	262.43506	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	262.72208	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	262.86557	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	263.00906	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	263.29608	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	263.5831	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	263.7266	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	263.87012	4	75.000000	1	2400.000000	0.500000	1.500000	1.000000	40
i1	264.58762	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	264.73114	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	267.8466	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	267.41113	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	266.97568	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	266.68536	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	266.2499	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	265.81442	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	264.36288	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	264.07257	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	264.43546	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	265.88702	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	266.32248	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	266.75793	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	267.04825	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	267.4837	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	267.9192	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	271.0371	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	270.89032	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	270.7435	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	270.5967	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	270.4499	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	270.3031	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	270.15628	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	270.0095	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	269.71588	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	269.56906	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	269.42227	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	269.27545	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	269.12866	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	268.98184	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	268.83505	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	268.68823	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	267.51382	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	267.367	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	267.2202	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	267.0734	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	267.0734	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	267.1468	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	267.2936	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	267.4404	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	267.58722	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	268.76166	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	268.90845	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	269.05527	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	269.20206	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	269.34888	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	269.49567	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	269.6425	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	269.78928	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	270.0829	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	270.2297	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	270.3765	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	270.5233	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	270.6701	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	270.8169	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	270.9637	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	271.1105	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	274.23093	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	273.93402	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	273.78555	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	273.63712	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	273.48865	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	273.3402	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	273.19174	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	272.59793	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	272.4495	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	272.30103	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	272.1526	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	272.00412	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	271.85568	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	271.55878	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	270.66803	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	270.37112	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	270.2227	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	270.07422	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	270.07422	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	270.14847	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	270.2969	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	270.44537	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	270.74228	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	271.633	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	271.9299	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	272.07834	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	272.2268	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	272.37524	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	272.5237	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	272.67218	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	273.266	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	273.41443	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	273.5629	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	273.71133	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	273.8598	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	274.00824	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	274.30515	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	277.42804	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	277.27792	4	52.631579	1	3420.000000	0.500000	1.500000	1.000000	57
i1	276.82764	4	58.823529	1	3060.000000	0.500000	1.500000	1.000000	51
i1	276.67752	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	276.52744	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	276.37732	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	276.07712	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	275.77692	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	275.4767	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	275.3266	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	275.17648	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	275.0264	4	111.111111	1	1620.000000	0.500000	1.500000	1.000000	27
i1	274.57608	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	274.42596	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	273.82556	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	273.67548	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	273.22516	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	273.07504	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	273.07504	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	273.15012	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	273.3002	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	273.75052	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	273.9006	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	274.50104	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	274.65112	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	275.10144	4	107.142857	1	1680.000000	0.500000	1.500000	1.000000	28
i1	275.25156	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	275.40164	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	275.55176	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	275.85196	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	276.15216	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	276.45236	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	276.60248	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	276.75256	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	276.90268	4	57.692308	1	3120.000000	0.500000	1.500000	1.000000	52
i1	277.353	4	51.724138	1	3480.000000	0.500000	1.500000	1.000000	58
i1	277.50308	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	280.4767	4	50.847458	1	3540.000000	0.500000	1.500000	1.000000	59
i1	280.1732	4	54.545455	1	3300.000000	0.500000	1.500000	1.000000	55
i1	280.02145	4	56.603774	1	3180.000000	0.500000	1.500000	1.000000	53
i1	279.71793	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	279.5662	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	279.11093	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	278.80743	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	278.35217	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	278.2004	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	277.8969	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	277.74515	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	277.2899	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	276.9864	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	276.53113	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	276.3794	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	276.07587	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	276.07587	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	276.15176	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	276.45526	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	276.60703	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	277.06226	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	277.36578	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	277.82104	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	277.97278	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	278.27628	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	278.42804	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	278.8833	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	279.1868	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	279.64206	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	279.79382	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	280.09732	4	55.555556	1	3240.000000	0.500000	1.500000	1.000000	54
i1	280.24908	4	53.571429	1	3360.000000	0.500000	1.500000	1.000000	56
i1	280.55258	4	50.000000	1	3600.000000	0.500000	1.500000	1.000000	60
i1	282.45154	4	66.666667	1	2700.000000	0.500000	1.500000	1.000000	45
i1	282.29816	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	282.14474	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	281.83795	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	281.68454	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	281.53113	4	90.909091	1	1980.000000	0.500000	1.500000	1.000000	33
i1	280.61072	4	142.857143	1	1260.000000	0.500000	1.500000	1.000000	21
i1	280.4573	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	280.30392	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	279.9971	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	279.84372	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	279.6903	4	333.333333	1	540.000000	0.500000	1.500000	1.000000	9
i1	279.0767	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	279.767	4	300.000000	1	600.000000	0.500000	1.500000	1.000000	10
i1	279.9204	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	280.07382	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	280.3806	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	280.53403	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	280.6874	4	136.363636	1	1320.000000	0.500000	1.500000	1.000000	22
i1	281.60785	4	88.235294	1	2040.000000	0.500000	1.500000	1.000000	34
i1	281.76123	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	281.91464	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	282.22144	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	282.37485	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	282.52826	4	65.217391	1	2760.000000	0.500000	1.500000	1.000000	46
i1	285.6437	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	285.33362	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	284.7134	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	284.4033	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	283.78308	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	283.473	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	282.85278	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	282.5427	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	282.0775	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	282.0775	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	282.15506	4	1500.000000	1	120.000000	0.500000	1.500000	1.000000	2
i1	282.6202	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	282.9303	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	283.5505	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	283.86063	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	284.48083	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	284.79092	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	285.41113	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	285.72122	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	288.83917	4	61.224490	1	2940.000000	0.500000	1.500000	1.000000	49
i1	288.68246	4	63.829787	1	2820.000000	0.500000	1.500000	1.000000	47
i1	288.36908	4	69.767442	1	2580.000000	0.500000	1.500000	1.000000	43
i1	288.21237	4	73.170732	1	2460.000000	0.500000	1.500000	1.000000	41
i1	287.89896	4	81.081081	1	2220.000000	0.500000	1.500000	1.000000	37
i1	287.74228	4	85.714286	1	2100.000000	0.500000	1.500000	1.000000	35
i1	287.42886	4	96.774194	1	1860.000000	0.500000	1.500000	1.000000	31
i1	287.27216	4	103.448276	1	1740.000000	0.500000	1.500000	1.000000	29
i1	286.95877	4	120.000000	1	1500.000000	0.500000	1.500000	1.000000	25
i1	286.80206	4	130.434783	1	1380.000000	0.500000	1.500000	1.000000	23
i1	286.48865	4	157.894737	1	1140.000000	0.500000	1.500000	1.000000	19
i1	286.33197	4	176.470588	1	1020.000000	0.500000	1.500000	1.000000	17
i1	286.01855	4	230.769231	1	780.000000	0.500000	1.500000	1.000000	13
i1	285.86185	4	272.727273	1	660.000000	0.500000	1.500000	1.000000	11
i1	285.54846	4	428.571429	1	420.000000	0.500000	1.500000	1.000000	7
i1	285.39175	4	600.000000	1	300.000000	0.500000	1.500000	1.000000	5
i1	285.23505	4	1000.000000	1	180.000000	0.500000	1.500000	1.000000	3
i1	285.07834	4	3000.000000	1	60.000000	0.500000	1.500000	1.000000	1
i1	285.31342	4	750.000000	1	240.000000	0.500000	1.500000	1.000000	4
i1	285.4701	4	500.000000	1	360.000000	0.500000	1.500000	1.000000	6
i1	285.6268	4	375.000000	1	480.000000	0.500000	1.500000	1.000000	8
i1	285.94022	4	250.000000	1	720.000000	0.500000	1.500000	1.000000	12
i1	286.0969	4	214.285714	1	840.000000	0.500000	1.500000	1.000000	14
i1	286.4103	4	166.666667	1	1080.000000	0.500000	1.500000	1.000000	18
i1	286.56702	4	150.000000	1	1200.000000	0.500000	1.500000	1.000000	20
i1	286.8804	4	125.000000	1	1440.000000	0.500000	1.500000	1.000000	24
i1	287.0371	4	115.384615	1	1560.000000	0.500000	1.500000	1.000000	26
i1	287.35052	4	100.000000	1	1800.000000	0.500000	1.500000	1.000000	30
i1	287.5072	4	93.750000	1	1920.000000	0.500000	1.500000	1.000000	32
i1	287.82062	4	83.333333	1	2160.000000	0.500000	1.500000	1.000000	36
i1	287.97733	4	78.947368	1	2280.000000	0.500000	1.500000	1.000000	38
i1	288.2907	4	71.428571	1	2520.000000	0.500000	1.500000	1.000000	42
i1	288.44742	4	68.181818	1	2640.000000	0.500000	1.500000	1.000000	44
i1	288.76083	4	62.500000	1	2880.000000	0.500000	1.500000	1.000000	48
i1	288.9175	4	60.000000	1	3000.000000	0.500000	1.500000	1.000000	50
i1	292.03793	20	58.823529	1	3060.000000	0.500000	1.500000	10.000000	51
i1	288.39587	20	600.000000	1	300.000000	0.500000	1.500000	10.000000	5
i1	288.07916	20	3000.000000	1	60.000000	0.500000	1.500000	10.000000	1
i1	288.47507	20	500.000000	1	360.000000	0.500000	1.500000	10.000000	6
i1	292.11713	20	57.692308	1	3120.000000	0.500000	1.500000	10.000000	52
i1	1.0	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	4.000825	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	4.000825	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	4.001649	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	7.004948	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	7.001649	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	7.006598	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	10.012371	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	10.007423	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	10.002474	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	10.009897	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	10.014845	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	13.023093	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	13.003299	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	13.026392	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	16.037113	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	16.028866	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	16.020618	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	16.004124	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	16.004124	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	16.008247	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	16.024742	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	16.03299	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	16.041237	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	19.054434	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	19.03464	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	19.004948	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	19.039589	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	19.059381	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	22.075052	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	22.063505	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	22.040413	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	22.028866	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	22.005774	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	22.005774	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	22.011545	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	22.03464	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	22.046186	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	22.069279	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	22.080826	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	25.098969	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	25.006598	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	25.105568	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	28.126186	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	28.11134	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	28.096495	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	28.007423	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	28.007423	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	28.014845	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	28.103918	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	28.118763	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	28.133608	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	31.1567	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	31.12371	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	31.090721	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	31.024742	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	31.008247	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	31.03299	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	31.098969	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	31.13196	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	31.164948	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	34.190514	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	34.17237	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	34.13608	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	34.099792	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	34.08165	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	34.04536	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	34.027218	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	34.00907	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	34.03629	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	34.054432	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	34.09072	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	34.108868	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	34.145157	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	34.181442	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	34.19959	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	37.22763	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	37.148453	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	37.009895	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	37.15835	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	37.237526	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	40.26804	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	40.246597	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	40.225155	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	40.182266	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	40.160824	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	40.13938	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	40.010723	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	40.010723	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	40.021442	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	40.150105	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	40.171547	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	40.19299	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	40.235874	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	40.25732	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	40.278763	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	43.311752	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	43.265568	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	43.173195	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	43.12701	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	43.034637	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	43.011547	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	43.046185	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	43.138557	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	43.184742	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	43.277115	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	43.3233	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	46.358765	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	46.334023	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	46.284534	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	46.259792	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	46.210308	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	46.185566	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	46.13608	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	46.11134	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	46.061855	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	46.037113	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	46.01237	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	46.049484	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	46.074226	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	46.12371	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	46.148453	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	46.197937	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	46.22268	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	46.272163	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	46.296906	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	46.346394	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	46.371136	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	49.409073	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	49.013195	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	49.422268	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	52.46268	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	52.43464	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	52.406597	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	52.014023	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	52.014023	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	52.02804	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	52.42062	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	52.44866	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	52.4767	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	55.51959	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	55.460205	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	55.400826	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	55.044537	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	55.014847	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	55.05938	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	55.41567	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	55.47505	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	55.53443	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	58.579796	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	58.548454	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	58.48577	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	58.42309	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	58.391754	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	58.07835	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	58.04701	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	58.01567	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	58.06268	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	58.09402	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	58.40742	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	58.438763	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	58.501442	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	58.564125	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	58.595463	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	61.6433	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	61.51134	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	61.37938	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	61.115463	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	61.016495	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	61.131958	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	61.395878	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	61.527836	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	61.659794	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	64.710106	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	64.67546	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	64.64082	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	64.57155	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	64.5369	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	64.502266	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	64.43299	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	64.39835	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	64.36371	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	64.155876	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	64.12124	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	64.0866	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	64.01732	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	64.01732	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	64.03464	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	64.10392	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	64.13856	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	64.173195	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	64.38103	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	64.41567	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	64.45031	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	64.519585	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	64.55423	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	64.58887	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	64.65814	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	64.69279	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	64.727425	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	67.780205	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	67.70763	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	67.56248	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	67.41732	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	67.34474	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	67.199585	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	67.12701	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	67.01814	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	67.14516	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	67.217735	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	67.362885	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	67.43546	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	67.58062	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	67.72578	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	67.79835	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	70.85361	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	70.81567	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	70.73979	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	70.70186	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	70.62598	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	70.58804	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	70.5501	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	70.47423	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	70.43629	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	70.36041	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	70.32247	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	70.2466	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	70.20866	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	70.13278	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	70.09485	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	70.01897	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	70.01897	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	70.03794	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	70.113815	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	70.15176	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	70.22763	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	70.265564	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	70.341446	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	70.37938	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	70.45526	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	70.493195	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	70.56907	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	70.60701	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	70.64495	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	70.720825	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	70.758766	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	70.83464	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	70.872574	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	73.930305	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	73.61361	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	73.01979	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	73.6334	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	73.9501	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	77.01031	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	76.96907	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	76.92783	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	76.68041	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	76.639175	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	76.59794	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	76.02062	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	76.02062	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	76.04124	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	76.61856	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	76.6598	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	76.701035	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	76.948456	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	76.98969	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	77.03093	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	80.093605	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	80.007835	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	79.922066	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	79.75052	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	79.66474	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	79.57897	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	79.06433	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	79.02145	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	79.08577	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	79.60041	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	79.68619	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	79.77196	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	79.943504	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	80.02928	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	80.11505	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	83.18021	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	83.13567	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	83.0466	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	82.95753	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	82.91299	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	82.82392	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	82.77938	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	82.69031	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	82.601234	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	82.5567	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	82.11134	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	82.0668	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	82.02227	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	82.08907	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	82.133606	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	82.57897	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	82.623505	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	82.71258	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	82.80165	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	82.84618	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	82.93526	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	82.9798	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	83.06886	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	83.157936	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	83.20248	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	86.2701	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	86.08536	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	85.71587	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	85.531136	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	85.16165	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	85.023094	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	85.184746	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	85.55423	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	85.73897	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	86.10845	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	86.2932	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	89.3633	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	89.31546	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	89.26763	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	89.17196	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	89.12412	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	89.07629	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	88.789276	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	88.74144	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	88.69361	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	88.59794	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	88.5501	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	88.502266	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	88.215256	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	88.16742	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	88.11959	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	88.02392	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	88.02392	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	88.04784	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	88.1435	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	88.19134	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	88.239174	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	88.526184	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	88.57402	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	88.62186	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	88.71753	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	88.76536	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	88.813194	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	89.100204	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	89.14804	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	89.19588	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	89.29155	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	89.33938	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	89.387215	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	92.45979	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	92.360825	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	92.16289	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	92.06392	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	91.86598	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	91.76701	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	91.56907	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	91.4701	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	91.27216	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	91.173195	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	91.02474	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	91.19794	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	91.296906	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	91.49484	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	91.59381	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	91.791756	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	91.890724	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	92.08866	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	92.18763	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	92.38557	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	92.484535	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	95.40619	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	95.35505	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	95.252785	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	95.20165	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	95.09938	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	95.04825	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	94.94598	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	94.894844	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	94.79258	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	94.74144	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	94.639175	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	94.58804	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	94.48577	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	94.43464	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	94.332375	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	94.281235	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	94.17897	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	94.12784	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	94.025566	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	94.025566	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	94.05113	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	94.153404	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	94.20454	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	94.3068	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	94.35794	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	94.460205	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	94.51134	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	94.61361	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	94.66474	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	94.76701	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	94.818146	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	94.92041	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	94.97154	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	95.073814	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	95.12495	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	95.22722	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	95.27835	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	95.380615	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	95.431755	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	98.50433	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	97.02639	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	98.53072	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	101.605774	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	101.55134	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	101.49691	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	100.027214	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	100.027214	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	100.054436	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	101.524124	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	101.57856	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	101.63299	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	104.654434	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	104.59835	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	104.48618	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	103.08412	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	103.02804	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	103.11217	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	104.51423	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	104.62639	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	104.68247	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	107.703094	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	107.5299	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	107.47217	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	106.14433	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	106.0866	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	106.02887	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	106.11546	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	106.173195	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	107.50103	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	107.55876	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	107.73196	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	110.69237	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	110.63299	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	110.45484	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	109.20783	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	109.02969	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	109.237526	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	110.484535	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	110.66268	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	110.72206	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	113.800415	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	113.61732	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	113.55629	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	113.495255	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	113.43423	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	112.274635	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	112.21361	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	112.15258	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	112.03052	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	112.03052	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	112.06103	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	112.18309	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	112.244125	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	112.30515	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	113.464745	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	113.52577	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	113.58681	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	113.647835	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	113.830925	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	116.78639	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	116.72371	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	116.59835	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	116.53567	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	116.41031	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	115.34474	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	115.21938	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	115.03134	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	115.250725	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	115.37608	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	116.44165	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	116.56701	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	116.62969	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	116.75505	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	116.81773	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	119.897736	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	119.447426	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	119.383095	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	118.418144	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	118.35381	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	118.22516	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	118.16083	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	118.032166	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	118.032166	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	118.06433	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	118.19299	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	118.25732	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	118.38598	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	118.45031	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	119.41526	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	119.47959	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	119.92989	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	122.88041	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	122.550514	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	122.35258	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	121.49484	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	121.03299	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	121.52783	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	122.38557	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	122.5835	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	122.9134	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	125.99505	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	125.92742	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	125.859795	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	125.656906	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	125.58928	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	125.52165	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	125.45402	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	125.38639	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	125.31876	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	124.574844	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	124.50722	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	124.43959	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	124.03381	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	124.03381	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	124.06763	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	124.473404	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	124.54103	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	124.60866	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	125.35258	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	125.420204	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	125.48784	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	125.555466	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	125.62309	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	125.69072	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	125.89361	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	125.961235	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	126.02887	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	129.04372	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	128.97443	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	128.83588	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	128.7666	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	128.62804	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	128.55876	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	128.48949	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	128.42021	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	128.28165	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	127.65814	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	127.519585	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	127.38103	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	127.10392	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	127.03464	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	127.13856	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	127.41567	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	127.55423	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	127.69279	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	128.31628	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	128.45485	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	128.52412	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	128.5934	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	128.66267	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	128.80124	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	128.87051	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	129.00908	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	129.07835	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	132.09238	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	131.59587	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	131.52495	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	131.31216	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	131.24124	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	130.74474	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	130.67381	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	130.53195	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	130.3901	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	130.31917	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	130.17732	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	130.1064	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	130.03546	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	130.14186	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	130.21278	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	130.35464	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	130.42557	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	130.56743	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	130.70927	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	130.78021	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	131.2767	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	131.34763	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	131.56041	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	131.63133	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	132.12784	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	135.06845	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	134.70557	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	134.48784	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	134.41525	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	134.19753	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	133.83464	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	133.54433	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	133.03629	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	133.58061	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	133.87093	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	134.23381	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	134.45155	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	134.52412	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	134.74185	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	135.10474	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	138.1897	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	138.11546	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	138.04124	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	137.81856	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	137.74432	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	137.6701	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	137.59587	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	137.3732	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	137.29897	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	137.22475	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	137.15051	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	136.92784	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	136.8536	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	136.77939	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	136.63092	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	136.5567	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	136.48247	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	136.03711	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	136.03711	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	136.07423	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	136.51959	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	136.59381	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	136.66805	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	136.8165	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	136.89072	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	136.96495	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	137.18762	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	137.26186	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	137.33607	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	137.41031	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	137.633	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	137.70721	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	137.78145	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	137.85567	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	138.07835	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	138.15257	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	138.2268	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	141.23836	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	141.16248	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	141.01073	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	140.93484	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	140.7831	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	140.70721	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	140.55547	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	140.47958	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	140.32784	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	140.25195	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	140.1002	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	140.02432	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	139.87257	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	139.56908	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	139.41731	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	139.11382	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	139.03793	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	139.15175	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	139.45526	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	139.60701	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	139.91052	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	140.06227	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	140.13814	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	140.2899	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	140.36577	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	140.51753	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	140.5934	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	140.74515	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	140.82103	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	140.97278	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	141.04866	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	141.20041	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	141.27629	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	144.287	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	142.89154	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	142.81403	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	142.65897	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	142.58144	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	142.42639	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	142.34886	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	142.19382	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	142.11629	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	142.03876	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	142.15504	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	142.23257	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	142.38763	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	142.46515	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	142.62021	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	142.69774	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	142.85278	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	142.93031	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	144.32578	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	147.2565	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	145.98969	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	145.03958	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	146.02928	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	147.29608	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	150.38432	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	150.30351	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	150.22269	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	149.09114	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	149.01031	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	148.92949	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	148.0404	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	148.0404	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	148.08083	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	148.9699	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	149.05072	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	149.13155	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	150.26309	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	150.34392	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	150.42474	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	153.43298	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	153.35051	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	153.18556	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	152.19588	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	152.03093	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	151.86598	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	151.12372	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	151.04124	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	151.16495	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	151.90721	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	152.07216	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	152.2371	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	153.2268	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	153.39175	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	153.47423	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	156.48164	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	156.22928	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	156.14516	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	155.30392	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	155.21979	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	155.05154	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	154.8833	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	154.79918	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	154.21031	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	154.12619	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	154.04207	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	154.16824	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	154.25237	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	154.84123	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	154.92535	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	155.09361	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	155.26186	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	155.34598	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	156.18721	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	156.27135	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	156.52371	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	159.44453	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	159.35876	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	159.10144	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	158.41525	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	158.07216	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	157.72906	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	157.3002	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	157.0429	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	157.3431	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	157.77196	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	158.11505	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	158.45815	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	159.14433	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	159.40164	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	159.48743	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	162.57896	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	162.3167	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	162.22928	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	162.14186	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	162.05443	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	161.52989	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	161.44247	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	161.35506	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	161.1802	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	161.09279	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	161.00536	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	160.83052	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	160.74309	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	160.65567	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	160.3934	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	160.30598	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	160.21855	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	160.04372	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	160.04372	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	160.08742	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	160.26227	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	160.34969	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	160.43712	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	160.69939	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	160.7868	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	160.87422	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	161.04907	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	161.13649	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	161.22392	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	161.39876	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	161.48619	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	161.57361	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	162.09814	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	162.18556	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	162.273	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	162.36041	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	162.62268	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	165.53856	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	165.44948	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	165.27135	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	165.18227	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	165.00412	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	164.64784	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	164.4697	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	164.1134	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	163.75711	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	163.57896	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	163.4899	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	163.31175	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	163.04454	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	163.3563	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	163.53444	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	163.6235	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	163.80165	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	164.15794	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	164.51422	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	164.69237	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	165.04866	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	165.2268	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	165.31587	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	165.49402	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	165.5831	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	168.67628	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	168.04124	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	167.95052	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	167.76907	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	167.67834	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	167.4969	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	167.40619	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	167.22475	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	167.13402	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	167.0433	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	166.86186	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	166.77113	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	166.31752	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	166.2268	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	166.04536	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	166.04536	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	166.09073	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	166.27217	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	166.36288	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	166.8165	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	166.90721	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	167.08865	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	167.17938	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	167.2701	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	167.45155	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	167.54227	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	167.72371	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	167.81444	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	167.99588	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	168.0866	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	168.72165	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	171.63258	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	171.17072	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	170.15463	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	169.69278	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	169.41566	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	169.04619	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	169.46185	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	169.73897	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	170.20082	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	171.2169	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	171.67876	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	174.7736	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	174.67958	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	174.58557	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	174.30351	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	174.20949	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	174.11546	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	173.26927	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	173.17526	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	173.08124	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	172.79918	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	172.70515	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	172.61113	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	172.51712	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	172.4231	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	172.32907	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	172.04701	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	172.04701	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	172.09402	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	172.37608	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	172.47011	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	172.56412	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	172.65814	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	172.75217	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	172.84619	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	173.12825	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	173.22227	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	173.31628	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	174.16248	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	174.2565	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	174.35051	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	174.63258	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	174.7266	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	174.82062	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	177.82227	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	177.7266	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	177.53526	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	177.43959	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	177.24825	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	177.0569	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	176.38722	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	176.19588	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	176.00453	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	175.90886	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	175.71753	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	175.62186	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	175.52618	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	175.43051	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	175.23918	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	175.14351	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	175.04784	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	175.19135	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	175.287	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	175.47835	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	175.57402	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	175.6697	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	175.76537	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	175.9567	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	176.05237	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	176.24371	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	176.43506	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	177.10474	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	177.29608	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	177.48743	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	177.5831	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	177.77443	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	177.8701	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	180.87093	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	180.287	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	180.09238	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	179.99506	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	179.50845	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	179.41113	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	179.21649	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	178.63258	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	178.53526	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	178.04866	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	178.58392	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	178.68124	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	179.26515	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	179.4598	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	179.55711	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	180.04372	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	180.14104	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	180.33566	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	180.91959	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	183.82062	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	183.42474	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	183.32578	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	182.9299	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	182.633	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	182.2371	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	182.13814	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	181.74226	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	181.44536	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	181.04948	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	181.04948	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	181.09897	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	181.49484	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	181.79175	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	182.18762	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	182.28659	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	182.68248	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	182.97939	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	183.37526	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	183.47423	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	183.8701	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	186.96825	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	186.86763	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	186.76701	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	186.56577	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	186.26392	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	186.06268	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	185.96207	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	185.86145	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	185.76082	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	185.6602	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	185.55959	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	185.35835	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	185.05649	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	184.85526	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	184.75464	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	184.65402	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	184.5534	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	184.45279	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	184.35216	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	184.15092	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	184.05031	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	184.20123	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	184.40248	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	184.5031	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	184.60371	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	184.70433	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	184.80495	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	184.90556	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	185.10681	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	185.40866	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	185.6099	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	185.71051	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	185.81113	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	185.91176	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	186.01237	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	186.11299	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	186.31422	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	186.61609	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	186.81732	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	186.91794	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	187.01855	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	190.0169	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	189.91464	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	189.60783	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	189.50557	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	189.4033	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	189.30103	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	188.99423	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	188.89195	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	188.78969	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	188.68742	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	188.38062	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	188.27835	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	188.17609	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	188.0738	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	187.76701	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	187.66475	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	187.56247	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	187.4602	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	187.1534	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	187.05113	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	187.20453	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	187.51134	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	187.6136	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	187.71588	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	187.81815	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	188.12495	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	188.22722	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	188.32948	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	188.43175	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	188.73856	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	188.84082	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	188.9431	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	189.04536	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	189.35216	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	189.45444	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	189.5567	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	189.65897	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	189.96577	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	190.06804	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	193.06557	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	192.85773	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	192.75381	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	192.54597	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	192.44206	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	192.23422	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	192.13031	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	191.92247	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	191.81856	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	191.61072	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	191.5068	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	191.29897	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	191.19505	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	190.98721	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	190.8833	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	190.67546	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	190.57155	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	190.36371	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	190.2598	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	190.15587	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	190.05196	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	190.20784	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	190.31175	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	190.41566	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	190.6235	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	190.72742	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	190.93526	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	191.03917	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	191.24701	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	191.35092	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	191.55876	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	191.66267	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	191.87051	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	191.97443	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	192.18227	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	192.28618	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	192.49402	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	192.59793	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	192.80577	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	192.9097	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	193.11752	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	193.26392	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	193.05278	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	193.3167	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	196.37526	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	196.26804	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	196.16083	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	196.0536	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	196.0536	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	196.10722	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	196.21443	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	196.32166	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	196.42886	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	199.4899	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	199.27217	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	199.1633	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	199.05443	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	199.05443	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	199.10887	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	199.21773	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	199.3266	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	199.54433	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	202.60783	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	202.49731	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	202.16577	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	202.05525	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	202.05525	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	202.11052	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	202.22102	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	202.55258	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	202.66309	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	205.72906	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	205.39258	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	205.28041	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	205.05608	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	205.05608	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	205.11217	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	205.3365	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	205.44865	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	205.78516	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	208.8536	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	208.73979	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	208.62598	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	208.51216	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	208.0569	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	208.56908	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	208.68289	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	208.7967	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	208.91052	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	211.98145	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	211.75052	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	211.63506	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	211.40413	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	211.05774	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	211.05774	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	211.11546	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	211.46185	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	211.69278	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	211.80824	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	212.03917	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	215.11258	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	214.99547	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	214.4099	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	214.29279	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	214.17567	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	214.05856	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	214.23422	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	214.35133	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	214.46846	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	215.05402	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	215.17113	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	218.24701	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	217.89072	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	217.53444	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	217.2969	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	217.05939	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	217.3563	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	217.59381	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	217.9501	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	218.3064	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	221.38474	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	221.26433	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	221.14392	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	221.0235	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	220.90309	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	220.78268	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	220.66226	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	220.54185	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	220.30103	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	220.18062	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	220.06021	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	220.06021	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	220.1204	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	220.24083	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	220.36124	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	220.60207	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	220.72247	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	220.84288	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	220.9633	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	221.08371	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	221.20412	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	221.32454	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	221.44495	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	224.52577	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	224.28165	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	224.15959	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	224.03752	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	223.91547	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	223.7934	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	223.67134	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	223.18309	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	223.06104	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	223.06104	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	223.12206	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	223.24413	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	223.73238	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	223.85443	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	223.9765	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	224.09856	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	224.22061	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	224.34268	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	224.5868	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	227.6701	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	227.54639	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	227.17526	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	227.05154	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	226.92784	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	226.80412	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	226.5567	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	226.30928	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	226.06186	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	226.06186	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	226.12372	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	226.37114	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	226.61856	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	226.86598	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	226.98969	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	227.1134	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	227.2371	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	227.60825	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	227.73196	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	230.81773	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	230.44165	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	230.31628	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	230.06557	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	229.9402	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	229.56412	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	229.3134	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	229.06268	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	229.37608	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	229.6268	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	230.00288	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	230.12825	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	230.37897	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	230.50433	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	230.88042	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	233.96866	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	233.84164	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	233.71465	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	233.58763	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	232.82556	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	232.69856	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	232.57155	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	232.31752	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	232.19052	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	232.0635	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	232.0635	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	232.12701	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	232.25403	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	232.38103	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	232.63506	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	232.76205	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	232.88907	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	233.65114	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	233.77814	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	233.90515	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	234.03217	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	237.1229	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	236.86557	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	236.73691	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	236.47958	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	235.96495	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	235.70763	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	235.193	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	235.06433	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	235.06433	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	235.12866	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	235.25732	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	235.77196	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	236.02928	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	236.54391	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	236.80124	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	236.9299	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	237.18721	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	240.28041	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	240.1501	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	239.49855	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	239.36824	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	239.10764	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	238.97733	4	200.000000	1	1350.000000	1.000000	1.500000	1.000000	15
i1	238.7167	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	238.5864	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	238.32578	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	238.06516	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	238.06516	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	238.13031	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	238.39093	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	238.65155	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	238.78186	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	239.04248	4	187.500000	1	1440.000000	1.000000	1.500000	1.000000	16
i1	239.17279	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	239.4334	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	239.5637	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	240.21526	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	240.34557	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	243.44124	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	243.04536	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	242.64949	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	241.3299	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	241.06598	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	241.39587	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	242.71547	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	243.11134	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	243.50722	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	246.60536	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	246.47176	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	246.33815	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	246.20453	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	246.07092	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	245.93732	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	245.80371	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	245.6701	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	245.5365	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	244.46764	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	244.33401	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	244.20041	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	244.0668	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	244.0668	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	244.1336	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	244.26721	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	244.40082	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	244.53444	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	245.6033	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	245.73691	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	245.87051	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	246.00412	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	246.13773	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	246.27135	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	246.40495	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	246.53856	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	246.67216	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	249.77278	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	249.50227	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	249.367	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	249.23175	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	249.0965	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	248.96124	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	248.82597	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	248.69072	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	248.42021	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	247.60866	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	247.33815	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	247.20288	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	247.06763	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	247.06763	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	247.13525	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	247.27051	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	247.40578	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	247.67628	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	248.48784	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	248.75835	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	248.8936	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	249.02887	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	249.16412	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	249.29938	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	249.43465	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	249.5699	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	249.84041	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	252.94351	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	252.8066	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	252.39587	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	252.25897	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	252.12206	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	251.98515	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	251.84825	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	251.43753	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	251.30061	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	250.75299	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	250.61609	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	250.20537	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	250.06845	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	250.06845	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	250.1369	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	250.27382	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	250.68454	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	250.82144	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	251.36908	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	251.50598	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	251.9167	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	252.0536	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	252.19052	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	252.32742	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	252.46432	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	252.87505	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	253.01196	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	256.11752	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	255.70186	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	255.5633	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	255.28618	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	255.14763	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	255.00908	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	254.73196	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	254.5934	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	254.17773	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	253.90062	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	253.48495	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	253.34639	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	253.06927	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	253.06927	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	253.13855	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	253.41566	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	253.55423	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	253.9699	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	254.24701	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	254.66267	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	254.80124	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	255.07835	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	255.2169	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	255.35547	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	255.63258	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	255.77113	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	256.1868	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	259.29483	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	259.15463	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	259.01443	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	258.87424	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	258.1732	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	257.47217	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	257.33197	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	257.19174	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	256.91135	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	256.77115	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	256.63092	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	256.0701	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	256.70102	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	256.84125	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	256.98145	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	257.26184	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	257.40207	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	257.54227	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	258.2433	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	258.94434	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	259.08453	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	259.22473	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	259.36496	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	262.47546	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	262.19174	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	262.0499	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	261.76617	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	261.3406	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	261.19876	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	261.05692	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	260.63135	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	260.34763	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	259.7802	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	259.4965	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	259.07092	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	259.07092	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	259.14185	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	259.5674	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	259.85114	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	260.41855	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	260.70227	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	261.12784	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	261.26968	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	261.41156	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	261.83713	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	262.12082	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	262.26266	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	262.5464	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	265.6594	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	265.51587	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	264.79834	4	76.923077	1	3510.000000	1.000000	1.500000	1.000000	39
i1	264.65485	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	264.51135	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	264.22433	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	263.93732	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	263.79382	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	263.6503	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	263.3633	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	263.2198	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	262.93277	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	262.78928	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	262.50226	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	262.35876	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	262.21527	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	262.07175	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	262.28702	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	262.4305	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	262.57404	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	262.86102	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	263.00455	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	263.29153	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	263.43506	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	263.72208	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	263.86557	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	264.00906	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	264.29608	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	264.5831	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	264.7266	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	264.87012	4	75.000000	1	3600.000000	1.000000	1.500000	1.000000	40
i1	265.58762	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	265.73114	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	268.8466	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	268.41113	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	267.97568	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	267.68536	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	267.2499	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	266.81442	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	265.36288	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	265.07257	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	265.43546	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	266.88702	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	267.32248	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	267.75793	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	268.04825	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	268.4837	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	268.9192	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	272.0371	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	271.89032	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	271.7435	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	271.5967	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	271.4499	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	271.3031	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	271.15628	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	271.0095	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	270.71588	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	270.56906	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	270.42227	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	270.27545	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	270.12866	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	269.98184	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	269.83505	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	269.68823	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	268.51382	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	268.367	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	268.2202	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	268.0734	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	268.0734	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	268.1468	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	268.2936	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	268.4404	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	268.58722	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	269.76166	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	269.90845	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	270.05527	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	270.20206	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	270.34888	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	270.49567	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	270.6425	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	270.78928	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	271.0829	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	271.2297	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	271.3765	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	271.5233	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	271.6701	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	271.8169	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	271.9637	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	272.1105	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	275.23093	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	274.93402	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	274.78555	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	274.63712	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	274.48865	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	274.3402	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	274.19174	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	273.59793	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	273.4495	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	273.30103	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	273.1526	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	273.00412	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	272.85568	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	272.55878	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	271.66803	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	271.37112	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	271.2227	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	271.07422	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	271.07422	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	271.14847	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	271.2969	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	271.44537	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	271.74228	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	272.633	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	272.9299	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	273.07834	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	273.2268	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	273.37524	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	273.5237	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	273.67218	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	274.266	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	274.41443	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	274.5629	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	274.71133	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	274.8598	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	275.00824	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	275.30515	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	278.42804	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	278.27792	4	52.631579	1	5130.000000	1.000000	1.500000	1.000000	57
i1	277.82764	4	58.823529	1	4590.000000	1.000000	1.500000	1.000000	51
i1	277.67752	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	277.52744	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	277.37732	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	277.07712	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	276.77692	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	276.4767	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	276.3266	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	276.17648	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	276.0264	4	111.111111	1	2430.000000	1.000000	1.500000	1.000000	27
i1	275.57608	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	275.42596	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	274.82556	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	274.67548	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	274.22516	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	274.07504	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	274.07504	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	274.15012	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	274.3002	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	274.75052	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	274.9006	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	275.50104	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	275.65112	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	276.10144	4	107.142857	1	2520.000000	1.000000	1.500000	1.000000	28
i1	276.25156	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	276.40164	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	276.55176	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	276.85196	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	277.15216	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	277.45236	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	277.60248	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	277.75256	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	277.90268	4	57.692308	1	4680.000000	1.000000	1.500000	1.000000	52
i1	278.353	4	51.724138	1	5220.000000	1.000000	1.500000	1.000000	58
i1	278.50308	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	281.4767	4	50.847458	1	5310.000000	1.000000	1.500000	1.000000	59
i1	281.1732	4	54.545455	1	4950.000000	1.000000	1.500000	1.000000	55
i1	281.02145	4	56.603774	1	4770.000000	1.000000	1.500000	1.000000	53
i1	280.71793	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	280.5662	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	280.11093	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	279.80743	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	279.35217	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	279.2004	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	278.8969	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	278.74515	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	278.2899	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	277.9864	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	277.53113	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	277.3794	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	277.07587	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	277.07587	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	277.15176	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	277.45526	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	277.60703	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	278.06226	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	278.36578	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	278.82104	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	278.97278	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	279.27628	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	279.42804	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	279.8833	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	280.1868	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	280.64206	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	280.79382	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	281.09732	4	55.555556	1	4860.000000	1.000000	1.500000	1.000000	54
i1	281.24908	4	53.571429	1	5040.000000	1.000000	1.500000	1.000000	56
i1	281.55258	4	50.000000	1	5400.000000	1.000000	1.500000	1.000000	60
i1	283.45154	4	66.666667	1	4050.000000	1.000000	1.500000	1.000000	45
i1	283.29816	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	283.14474	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	282.83795	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	282.68454	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	282.53113	4	90.909091	1	2970.000000	1.000000	1.500000	1.000000	33
i1	281.61072	4	142.857143	1	1890.000000	1.000000	1.500000	1.000000	21
i1	281.4573	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	281.30392	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	280.9971	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	280.84372	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	280.6903	4	333.333333	1	810.000000	1.000000	1.500000	1.000000	9
i1	280.0767	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	280.767	4	300.000000	1	900.000000	1.000000	1.500000	1.000000	10
i1	280.9204	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	281.07382	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	281.3806	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	281.53403	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	281.6874	4	136.363636	1	1980.000000	1.000000	1.500000	1.000000	22
i1	282.60785	4	88.235294	1	3060.000000	1.000000	1.500000	1.000000	34
i1	282.76123	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	282.91464	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	283.22144	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	283.37485	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	283.52826	4	65.217391	1	4140.000000	1.000000	1.500000	1.000000	46
i1	286.6437	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	286.33362	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	285.7134	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	285.4033	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	284.78308	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	284.473	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	283.85278	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	283.5427	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	283.0775	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	283.0775	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	283.15506	4	1500.000000	1	180.000000	1.000000	1.500000	1.000000	2
i1	283.6202	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	283.9303	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	284.5505	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	284.86063	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	285.48083	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	285.79092	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	286.41113	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	286.72122	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	289.83917	4	61.224490	1	4410.000000	1.000000	1.500000	1.000000	49
i1	289.68246	4	63.829787	1	4230.000000	1.000000	1.500000	1.000000	47
i1	289.36908	4	69.767442	1	3870.000000	1.000000	1.500000	1.000000	43
i1	289.21237	4	73.170732	1	3690.000000	1.000000	1.500000	1.000000	41
i1	288.89896	4	81.081081	1	3330.000000	1.000000	1.500000	1.000000	37
i1	288.74228	4	85.714286	1	3150.000000	1.000000	1.500000	1.000000	35
i1	288.42886	4	96.774194	1	2790.000000	1.000000	1.500000	1.000000	31
i1	288.27216	4	103.448276	1	2610.000000	1.000000	1.500000	1.000000	29
i1	287.95877	4	120.000000	1	2250.000000	1.000000	1.500000	1.000000	25
i1	287.80206	4	130.434783	1	2070.000000	1.000000	1.500000	1.000000	23
i1	287.48865	4	157.894737	1	1710.000000	1.000000	1.500000	1.000000	19
i1	287.33197	4	176.470588	1	1530.000000	1.000000	1.500000	1.000000	17
i1	287.01855	4	230.769231	1	1170.000000	1.000000	1.500000	1.000000	13
i1	286.86185	4	272.727273	1	990.000000	1.000000	1.500000	1.000000	11
i1	286.54846	4	428.571429	1	630.000000	1.000000	1.500000	1.000000	7
i1	286.39175	4	600.000000	1	450.000000	1.000000	1.500000	1.000000	5
i1	286.23505	4	1000.000000	1	270.000000	1.000000	1.500000	1.000000	3
i1	286.07834	4	3000.000000	1	90.000000	1.000000	1.500000	1.000000	1
i1	286.31342	4	750.000000	1	360.000000	1.000000	1.500000	1.000000	4
i1	286.4701	4	500.000000	1	540.000000	1.000000	1.500000	1.000000	6
i1	286.6268	4	375.000000	1	720.000000	1.000000	1.500000	1.000000	8
i1	286.94022	4	250.000000	1	1080.000000	1.000000	1.500000	1.000000	12
i1	287.0969	4	214.285714	1	1260.000000	1.000000	1.500000	1.000000	14
i1	287.4103	4	166.666667	1	1620.000000	1.000000	1.500000	1.000000	18
i1	287.56702	4	150.000000	1	1800.000000	1.000000	1.500000	1.000000	20
i1	287.8804	4	125.000000	1	2160.000000	1.000000	1.500000	1.000000	24
i1	288.0371	4	115.384615	1	2340.000000	1.000000	1.500000	1.000000	26
i1	288.35052	4	100.000000	1	2700.000000	1.000000	1.500000	1.000000	30
i1	288.5072	4	93.750000	1	2880.000000	1.000000	1.500000	1.000000	32
i1	288.82062	4	83.333333	1	3240.000000	1.000000	1.500000	1.000000	36
i1	288.97733	4	78.947368	1	3420.000000	1.000000	1.500000	1.000000	38
i1	289.2907	4	71.428571	1	3780.000000	1.000000	1.500000	1.000000	42
i1	289.44742	4	68.181818	1	3960.000000	1.000000	1.500000	1.000000	44
i1	289.76083	4	62.500000	1	4320.000000	1.000000	1.500000	1.000000	48
i1	289.9175	4	60.000000	1	4500.000000	1.000000	1.500000	1.000000	50
i1	293.03793	20	58.823529	1	4590.000000	1.000000	1.500000	10.000000	51
i1	289.39587	20	600.000000	1	450.000000	1.000000	1.500000	10.000000	5
i1	289.07916	20	3000.000000	1	90.000000	1.000000	1.500000	10.000000	1
i1	289.47507	20	500.000000	1	540.000000	1.000000	1.500000	10.000000	6
i1	293.11713	20	57.692308	1	4680.000000	1.000000	1.500000	10.000000	52
i1	2.0	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	5.000825	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	5.000825	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	5.001649	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	8.004948	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	8.001649	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	8.006598	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	11.012371	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	11.007423	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	11.002474	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	11.009897	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	11.014845	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	14.023093	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	14.003299	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	14.026392	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	17.037113	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	17.028866	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	17.020618	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	17.004124	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	17.004124	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	17.008247	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	17.024742	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	17.03299	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	17.041237	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	20.054434	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	20.03464	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	20.004948	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	20.039589	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	20.059381	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	23.075052	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	23.063505	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	23.040413	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	23.028866	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	23.005774	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	23.005774	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	23.011545	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	23.03464	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	23.046186	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	23.069279	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	23.080826	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	26.098969	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	26.006598	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	26.105568	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	29.126186	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	29.11134	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	29.096495	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	29.007423	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	29.007423	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	29.014845	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	29.103918	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	29.118763	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	29.133608	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	32.1567	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	32.12371	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	32.09072	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	32.024742	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	32.008247	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	32.03299	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	32.09897	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	32.131958	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	32.164948	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	35.190514	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	35.17237	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	35.13608	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	35.099792	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	35.08165	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	35.04536	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	35.027218	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	35.00907	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	35.03629	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	35.054432	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	35.09072	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	35.108868	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	35.145157	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	35.181442	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	35.19959	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	38.22763	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	38.148453	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	38.009895	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	38.15835	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	38.237526	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	41.26804	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	41.246597	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	41.225155	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	41.182266	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	41.160824	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	41.13938	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	41.010723	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	41.010723	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	41.021442	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	41.150105	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	41.171547	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	41.19299	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	41.235874	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	41.25732	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	41.278763	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	44.311752	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	44.265568	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	44.173195	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	44.12701	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	44.034637	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	44.011547	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	44.046185	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	44.138557	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	44.184742	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	44.277115	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	44.3233	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	47.358765	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	47.334023	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	47.284534	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	47.259792	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	47.210308	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	47.185566	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	47.13608	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	47.11134	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	47.061855	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	47.037113	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	47.01237	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	47.049484	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	47.074226	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	47.12371	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	47.148453	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	47.197937	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	47.22268	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	47.272163	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	47.296906	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	47.346394	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	47.371136	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	50.409073	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	50.013195	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	50.422268	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	53.46268	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	53.43464	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	53.406597	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	53.014023	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	53.014023	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	53.02804	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	53.42062	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	53.44866	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	53.4767	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	56.51959	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	56.460205	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	56.400826	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	56.044537	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	56.014847	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	56.05938	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	56.41567	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	56.47505	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	56.53443	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	59.579796	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	59.548454	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	59.48577	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	59.42309	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	59.391754	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	59.07835	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	59.04701	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	59.01567	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	59.06268	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	59.09402	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	59.40742	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	59.438763	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	59.501442	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	59.564125	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	59.595463	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	62.6433	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	62.51134	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	62.37938	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	62.115463	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	62.016495	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	62.131958	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	62.395878	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	62.527836	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	62.659794	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	65.710106	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	65.67546	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	65.64082	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	65.57155	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	65.5369	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	65.502266	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	65.43299	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	65.39835	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	65.36371	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	65.155876	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	65.12124	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	65.0866	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	65.01732	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	65.01732	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	65.03464	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	65.10392	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	65.13856	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	65.173195	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	65.38103	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	65.41567	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	65.45031	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	65.519585	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	65.55423	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	65.58887	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	65.65814	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	65.69279	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	65.727425	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	68.780205	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	68.70763	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	68.56248	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	68.41732	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	68.34474	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	68.199585	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	68.12701	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	68.01814	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	68.14516	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	68.217735	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	68.362885	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	68.43546	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	68.58062	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	68.72578	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	68.79835	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	71.85361	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	71.81567	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	71.73979	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	71.70186	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	71.62598	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	71.58804	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	71.5501	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	71.47423	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	71.43629	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	71.36041	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	71.32247	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	71.2466	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	71.20866	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	71.13278	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	71.09485	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	71.01897	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	71.01897	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	71.03794	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	71.113815	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	71.15176	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	71.22763	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	71.265564	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	71.341446	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	71.37938	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	71.45526	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	71.493195	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	71.56907	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	71.60701	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	71.64495	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	71.720825	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	71.758766	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	71.83464	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	71.872574	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	74.930305	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	74.61361	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	74.01979	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	74.6334	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	74.9501	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	78.01031	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	77.96907	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	77.92783	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	77.68041	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	77.639175	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	77.59794	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	77.02062	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	77.02062	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	77.04124	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	77.61856	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	77.6598	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	77.701035	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	77.948456	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	77.98969	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	78.03093	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	81.093605	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	81.007835	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	80.922066	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	80.75052	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	80.66474	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	80.57897	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	80.06433	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	80.02145	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	80.08577	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	80.60041	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	80.68619	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	80.77196	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	80.943504	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	81.02928	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	81.11505	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	84.18021	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	84.13567	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	84.0466	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	83.95753	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	83.91299	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	83.82392	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	83.77938	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	83.69031	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	83.601234	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	83.5567	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	83.11134	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	83.0668	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	83.02227	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	83.08907	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	83.133606	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	83.57897	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	83.623505	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	83.71258	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	83.80165	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	83.84618	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	83.93526	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	83.9798	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	84.06886	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	84.157936	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	84.20248	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	87.2701	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	87.08536	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	86.71587	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	86.531136	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	86.16165	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	86.023094	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	86.184746	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	86.55423	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	86.73897	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	87.10845	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	87.2932	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	90.3633	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	90.31546	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	90.26763	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	90.17196	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	90.12412	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	90.07629	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	89.789276	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	89.74144	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	89.69361	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	89.59794	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	89.5501	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	89.502266	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	89.215256	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	89.16742	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	89.11959	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	89.02392	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	89.02392	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	89.04784	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	89.1435	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	89.19134	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	89.239174	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	89.526184	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	89.57402	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	89.62186	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	89.71753	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	89.76536	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	89.813194	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	90.100204	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	90.14804	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	90.19588	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	90.29155	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	90.33938	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	90.387215	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	93.45979	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	93.360825	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	93.16289	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	93.06392	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	92.86598	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	92.76701	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	92.56907	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	92.4701	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	92.27216	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	92.173195	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	92.02474	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	92.19794	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	92.296906	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	92.49484	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	92.59381	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	92.791756	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	92.890724	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	93.08866	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	93.18763	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	93.38557	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	93.484535	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	96.40619	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	96.35505	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	96.252785	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	96.20165	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	96.09938	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	96.04825	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	95.94598	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	95.894844	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	95.79258	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	95.74144	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	95.639175	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	95.58804	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	95.48577	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	95.43464	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	95.332375	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	95.281235	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	95.17897	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	95.12784	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	95.025566	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	95.025566	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	95.05113	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	95.153404	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	95.20454	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	95.3068	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	95.35794	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	95.460205	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	95.51134	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	95.61361	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	95.66474	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	95.76701	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	95.818146	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	95.92041	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	95.97154	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	96.073814	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	96.12495	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	96.22722	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	96.27835	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	96.380615	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	96.431755	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	99.50433	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	98.02639	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	99.53072	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	102.605774	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	102.55134	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	102.49691	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	101.027214	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	101.027214	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	101.054436	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	102.524124	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	102.57856	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	102.63299	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	105.654434	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	105.59835	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	105.48618	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	104.08412	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	104.02804	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	104.11217	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	105.51423	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	105.62639	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	105.68247	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	108.703094	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	108.5299	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	108.47217	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	107.14433	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	107.0866	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	107.02887	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	107.11546	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	107.173195	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	108.50103	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	108.55876	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	108.73196	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	111.69237	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	111.63299	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	111.45484	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	110.20783	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	110.02969	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	110.237526	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	111.484535	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	111.66268	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	111.72206	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	114.800415	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	114.61732	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	114.55629	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	114.495255	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	114.43423	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	113.274635	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	113.21361	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	113.15258	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	113.03052	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	113.03052	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	113.06103	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	113.18309	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	113.244125	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	113.30515	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	114.464745	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	114.52577	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	114.58681	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	114.647835	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	114.830925	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	117.78639	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	117.72371	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	117.59835	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	117.53567	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	117.41031	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	116.34474	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	116.21938	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	116.03134	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	116.250725	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	116.37608	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	117.44165	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	117.56701	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	117.62969	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	117.75505	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	117.81773	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	120.897736	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	120.447426	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	120.383095	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	119.418144	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	119.35381	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	119.22516	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	119.16083	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	119.032166	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	119.032166	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	119.06433	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	119.19299	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	119.25732	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	119.38598	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	119.45031	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	120.41526	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	120.47959	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	120.92989	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	123.88041	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	123.550514	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	123.35258	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	122.49484	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	122.03299	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	122.52783	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	123.38557	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	123.5835	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	123.9134	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	126.99505	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	126.92742	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	126.859795	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	126.656906	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	126.58928	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	126.52165	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	126.45402	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	126.38639	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	126.31876	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	125.574844	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	125.50722	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	125.43959	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	125.03381	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	125.03381	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	125.06763	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	125.473404	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	125.54103	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	125.60866	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	126.35258	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	126.420204	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	126.48784	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	126.555466	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	126.62309	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	126.69072	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	126.89361	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	126.961235	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	127.02887	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	130.04372	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	129.97443	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	129.83588	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	129.7666	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	129.62804	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	129.55876	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	129.48949	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	129.42021	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	129.28165	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	128.65814	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	128.51959	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	128.38103	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	128.10391	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	128.03464	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	128.13855	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	128.41566	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	128.55423	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	128.69278	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	129.31628	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	129.45485	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	129.52412	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	129.5934	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	129.66267	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	129.80124	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	129.87051	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	130.00908	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	130.07835	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	133.09238	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	132.59587	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	132.52495	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	132.31216	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	132.24124	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	131.74474	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	131.67381	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	131.53195	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	131.3901	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	131.31917	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	131.17732	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	131.1064	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	131.03546	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	131.14186	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	131.21278	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	131.35464	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	131.42557	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	131.56743	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	131.70927	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	131.78021	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	132.2767	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	132.34763	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	132.56041	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	132.63133	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	133.12784	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	136.06845	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	135.70557	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	135.48784	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	135.41525	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	135.19753	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	134.83464	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	134.54433	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	134.03629	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	134.58061	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	134.87093	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	135.23381	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	135.45155	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	135.52412	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	135.74185	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	136.10474	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	139.1897	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	139.11546	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	139.04124	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	138.81856	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	138.74432	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	138.6701	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	138.59587	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	138.3732	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	138.29897	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	138.22475	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	138.15051	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	137.92784	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	137.8536	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	137.77939	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	137.63092	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	137.5567	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	137.48247	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	137.03711	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	137.03711	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	137.07423	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	137.51959	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	137.59381	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	137.66805	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	137.8165	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	137.89072	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	137.96495	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	138.18762	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	138.26186	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	138.33607	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	138.41031	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	138.633	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	138.70721	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	138.78145	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	138.85567	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	139.07835	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	139.15257	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	139.2268	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	142.23836	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	142.16248	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	142.01073	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	141.93484	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	141.7831	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	141.70721	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	141.55547	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	141.47958	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	141.32784	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	141.25195	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	141.1002	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	141.02432	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	140.87257	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	140.56908	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	140.41731	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	140.11382	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	140.03793	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	140.15175	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	140.45526	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	140.60701	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	140.91052	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	141.06227	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	141.13814	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	141.2899	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	141.36577	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	141.51753	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	141.5934	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	141.74515	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	141.82103	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	141.97278	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	142.04866	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	142.20041	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	142.27629	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	145.287	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	143.89154	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	143.81403	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	143.65897	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	143.58144	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	143.42639	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	143.34886	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	143.19382	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	143.11629	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	143.03876	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	143.15504	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	143.23257	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	143.38763	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	143.46515	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	143.62021	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	143.69774	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	143.85278	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	143.93031	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	145.32578	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	148.2565	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	146.98969	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	146.03958	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	147.02928	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	148.29608	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	151.38432	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	151.30351	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	151.22269	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	150.09114	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	150.01031	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	149.92949	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	149.0404	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	149.0404	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	149.08083	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	149.9699	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	150.05072	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	150.13155	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	151.26309	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	151.34392	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	151.42474	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	154.43298	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	154.35051	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	154.18556	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	153.19588	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	153.03093	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	152.86598	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	152.12372	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	152.04124	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	152.16495	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	152.90721	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	153.07216	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	153.2371	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	154.2268	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	154.39175	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	154.47423	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	157.48164	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	157.22928	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	157.14516	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	156.30392	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	156.21979	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	156.05154	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	155.8833	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	155.79918	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	155.21031	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	155.12619	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	155.04207	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	155.16824	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	155.25237	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	155.84123	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	155.92535	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	156.09361	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	156.26186	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	156.34598	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	157.18721	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	157.27135	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	157.52371	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	160.44453	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	160.35876	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	160.10144	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	159.41525	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	159.07216	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	158.72906	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	158.3002	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	158.0429	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	158.3431	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	158.77196	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	159.11505	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	159.45815	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	160.14433	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	160.40164	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	160.48743	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	163.57896	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	163.3167	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	163.22928	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	163.14186	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	163.05443	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	162.52989	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	162.44247	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	162.35506	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	162.1802	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	162.09279	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	162.00536	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	161.83052	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	161.74309	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	161.65567	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	161.3934	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	161.30598	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	161.21855	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	161.04372	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	161.04372	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	161.08742	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	161.26227	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	161.34969	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	161.43712	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	161.69939	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	161.7868	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	161.87422	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	162.04907	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	162.13649	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	162.22392	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	162.39876	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	162.48619	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	162.57361	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	163.09814	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	163.18556	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	163.273	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	163.36041	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	163.62268	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	166.53856	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	166.44948	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	166.27135	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	166.18227	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	166.00412	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	165.64784	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	165.4697	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	165.1134	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	164.75711	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	164.57896	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	164.4899	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	164.31175	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	164.04454	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	164.3563	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	164.53444	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	164.6235	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	164.80165	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	165.15794	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	165.51422	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	165.69237	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	166.04866	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	166.2268	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	166.31587	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	166.49402	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	166.5831	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	169.67628	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	169.04124	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	168.95052	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	168.76907	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	168.67834	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	168.4969	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	168.40619	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	168.22475	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	168.13402	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	168.0433	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	167.86186	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	167.77113	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	167.31752	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	167.2268	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	167.04536	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	167.04536	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	167.09073	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	167.27217	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	167.36288	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	167.8165	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	167.90721	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	168.08865	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	168.17938	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	168.2701	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	168.45155	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	168.54227	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	168.72371	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	168.81444	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	168.99588	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	169.0866	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	169.72165	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	172.63258	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	172.17072	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	171.15463	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	170.69278	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	170.41566	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	170.04619	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	170.46185	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	170.73897	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	171.20082	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	172.2169	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	172.67876	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	175.7736	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	175.67958	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	175.58557	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	175.30351	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	175.20949	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	175.11546	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	174.26927	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	174.17526	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	174.08124	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	173.79918	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	173.70515	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	173.61113	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	173.51712	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	173.4231	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	173.32907	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	173.04701	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	173.04701	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	173.09402	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	173.37608	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	173.47011	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	173.56412	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	173.65814	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	173.75217	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	173.84619	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	174.12825	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	174.22227	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	174.31628	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	175.16248	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	175.2565	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	175.35051	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	175.63258	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	175.7266	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	175.82062	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	178.82227	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	178.7266	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	178.53526	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	178.43959	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	178.24825	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	178.0569	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	177.38722	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	177.19588	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	177.00453	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	176.90886	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	176.71753	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	176.62186	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	176.52618	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	176.43051	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	176.23918	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	176.14351	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	176.04784	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	176.19135	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	176.287	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	176.47835	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	176.57402	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	176.6697	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	176.76537	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	176.9567	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	177.05237	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	177.24371	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	177.43506	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	178.10474	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	178.29608	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	178.48743	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	178.5831	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	178.77443	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	178.8701	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	181.87093	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	181.287	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	181.09238	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	180.99506	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	180.50845	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	180.41113	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	180.21649	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	179.63258	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	179.53526	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	179.04866	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	179.58392	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	179.68124	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	180.26515	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	180.4598	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	180.55711	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	181.04372	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	181.14104	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	181.33566	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	181.91959	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	184.82062	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	184.42474	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	184.32578	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	183.9299	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	183.633	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	183.2371	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	183.13814	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	182.74226	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	182.44536	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	182.04948	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	182.04948	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	182.09897	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	182.49484	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	182.79175	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	183.18762	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	183.28659	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	183.68248	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	183.97939	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	184.37526	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	184.47423	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	184.8701	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	187.96825	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	187.86763	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	187.76701	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	187.56577	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	187.26392	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	187.06268	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	186.96207	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	186.86145	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	186.76082	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	186.6602	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	186.55959	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	186.35835	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	186.05649	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	185.85526	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	185.75464	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	185.65402	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	185.5534	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	185.45279	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	185.35216	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	185.15092	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	185.05031	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	185.20123	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	185.40248	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	185.5031	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	185.60371	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	185.70433	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	185.80495	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	185.90556	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	186.10681	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	186.40866	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	186.6099	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	186.71051	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	186.81113	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	186.91176	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	187.01237	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	187.11299	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	187.31422	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	187.61609	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	187.81732	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	187.91794	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	188.01855	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	191.0169	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	190.91464	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	190.60783	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	190.50557	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	190.4033	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	190.30103	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	189.99423	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	189.89195	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	189.78969	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	189.68742	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	189.38062	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	189.27835	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	189.17609	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	189.0738	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	188.76701	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	188.66475	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	188.56247	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	188.4602	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	188.1534	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	188.05113	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	188.20453	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	188.51134	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	188.6136	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	188.71588	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	188.81815	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	189.12495	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	189.22722	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	189.32948	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	189.43175	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	189.73856	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	189.84082	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	189.9431	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	190.04536	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	190.35216	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	190.45444	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	190.5567	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	190.65897	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	190.96577	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	191.06804	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	194.06557	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	193.85773	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	193.75381	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	193.54597	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	193.44206	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	193.23422	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	193.13031	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	192.92247	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	192.81856	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	192.61072	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	192.5068	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	192.29897	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	192.19505	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	191.98721	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	191.8833	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	191.67546	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	191.57155	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	191.36371	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	191.2598	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	191.15587	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	191.05196	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	191.20784	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	191.31175	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	191.41566	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	191.6235	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	191.72742	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	191.93526	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	192.03917	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	192.24701	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	192.35092	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	192.55876	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	192.66267	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	192.87051	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	192.97443	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	193.18227	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	193.28618	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	193.49402	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	193.59793	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	193.80577	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	193.9097	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	194.11752	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	194.26392	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	194.05278	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	194.3167	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	197.37526	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	197.26804	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	197.16083	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	197.0536	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	197.0536	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	197.10722	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	197.21443	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	197.32166	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	197.42886	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	200.4899	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	200.27217	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	200.1633	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	200.05443	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	200.05443	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	200.10887	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	200.21773	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	200.3266	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	200.54433	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	203.60783	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	203.49731	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	203.16577	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	203.05525	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	203.05525	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	203.11052	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	203.22102	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	203.55258	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	203.66309	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	206.72906	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	206.39258	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	206.28041	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	206.05608	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	206.05608	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	206.11217	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	206.3365	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	206.44865	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	206.78516	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	209.8536	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	209.73979	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	209.62598	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	209.51216	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	209.0569	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	209.56908	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	209.68289	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	209.7967	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	209.91052	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	212.98145	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	212.75052	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	212.63506	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	212.40413	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	212.05774	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	212.05774	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	212.11546	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	212.46185	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	212.69278	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	212.80824	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	213.03917	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	216.11258	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	215.99547	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	215.4099	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	215.29279	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	215.17567	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	215.05856	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	215.23422	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	215.35133	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	215.46846	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	216.05402	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	216.17113	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	219.24701	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	218.89072	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	218.53444	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	218.2969	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	218.05939	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	218.3563	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	218.59381	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	218.9501	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	219.3064	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	222.38474	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	222.26433	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	222.14392	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	222.0235	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	221.90309	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	221.78268	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	221.66226	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	221.54185	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	221.30103	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	221.18062	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	221.06021	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	221.06021	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	221.1204	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	221.24083	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	221.36124	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	221.60207	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	221.72247	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	221.84288	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	221.9633	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	222.08371	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	222.20412	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	222.32454	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	222.44495	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	225.52577	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	225.28165	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	225.15959	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	225.03752	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	224.91547	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	224.7934	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	224.67134	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	224.18309	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	224.06104	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	224.06104	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	224.12206	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	224.24413	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	224.73238	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	224.85443	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	224.9765	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	225.09856	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	225.22061	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	225.34268	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	225.5868	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	228.6701	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	228.54639	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	228.17526	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	228.05154	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	227.92784	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	227.80412	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	227.5567	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	227.30928	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	227.06186	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	227.06186	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	227.12372	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	227.37114	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	227.61856	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	227.86598	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	227.98969	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	228.1134	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	228.2371	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	228.60825	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	228.73196	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	231.81773	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	231.44165	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	231.31628	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	231.06557	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	230.9402	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	230.56412	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	230.3134	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	230.06268	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	230.37608	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	230.6268	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	231.00288	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	231.12825	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	231.37897	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	231.50433	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	231.88042	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	234.96866	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	234.84164	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	234.71465	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	234.58763	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	233.82556	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	233.69856	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	233.57155	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	233.31752	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	233.19052	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	233.0635	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	233.0635	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	233.12701	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	233.25403	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	233.38103	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	233.63506	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	233.76205	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	233.88907	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	234.65114	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	234.77814	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	234.90515	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	235.03217	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	238.1229	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	237.86557	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	237.73691	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	237.47958	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	236.96495	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	236.70763	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	236.193	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	236.06433	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	236.06433	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	236.12866	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	236.25732	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	236.77196	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	237.02928	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	237.54391	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	237.80124	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	237.9299	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	238.18721	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	241.28041	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	241.1501	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	240.49855	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	240.36824	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	240.10764	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	239.97733	4	200.000000	1	1456.227000	0.000000	1.500000	1.000000	15
i1	239.7167	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	239.5864	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	239.32578	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	239.06516	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	239.06516	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	239.13031	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	239.39093	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	239.65155	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	239.78186	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	240.04248	4	187.500000	1	1553.308800	0.000000	1.500000	1.000000	16
i1	240.17279	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	240.4334	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	240.5637	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	241.21526	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	241.34557	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	244.44124	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	244.04536	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	243.64949	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	242.3299	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	242.06598	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	242.39587	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	243.71547	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	244.11134	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	244.50722	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	247.60536	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	247.47176	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	247.33815	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	247.20453	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	247.07092	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	246.93732	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	246.80371	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	246.6701	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	246.5365	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	245.46764	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	245.33401	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	245.20041	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	245.0668	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	245.0668	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	245.1336	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	245.26721	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	245.40082	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	245.53444	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	246.6033	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	246.73691	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	246.87051	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	247.00412	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	247.13773	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	247.27135	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	247.40495	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	247.53856	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	247.67216	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	250.77278	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	250.50227	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	250.367	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	250.23175	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	250.0965	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	249.96124	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	249.82597	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	249.69072	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	249.42021	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	248.60866	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	248.33815	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	248.20288	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	248.06763	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	248.06763	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	248.13525	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	248.27051	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	248.40578	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	248.67628	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	249.48784	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	249.75835	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	249.8936	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	250.02887	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	250.16412	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	250.29938	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	250.43465	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	250.5699	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	250.84041	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	253.94351	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	253.8066	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	253.39587	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	253.25897	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	253.12206	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	252.98515	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	252.84825	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	252.43753	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	252.30061	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	251.75299	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	251.61609	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	251.20537	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	251.06845	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	251.06845	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	251.1369	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	251.27382	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	251.68454	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	251.82144	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	252.36908	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	252.50598	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	252.9167	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	253.0536	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	253.19052	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	253.32742	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	253.46432	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	253.87505	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	254.01196	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	257.11752	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	256.70184	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	256.5633	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	256.2862	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	256.14764	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	256.00906	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	255.73196	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	255.5934	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	255.17773	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	254.90062	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	254.48495	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	254.34639	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	254.06927	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	254.06927	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	254.13855	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	254.41566	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	254.55423	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	254.9699	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	255.24701	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	255.66267	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	255.80124	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	256.07834	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	256.21692	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	256.35547	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	256.63257	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	256.77115	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	257.1868	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	260.29483	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	260.15463	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	260.01443	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	259.87424	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	259.1732	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	258.47217	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	258.33197	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	258.19174	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	257.91135	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	257.77115	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	257.63092	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	257.0701	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	257.70102	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	257.84125	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	257.98145	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	258.26184	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	258.40207	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	258.54227	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	259.2433	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	259.94434	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	260.08453	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	260.22473	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	260.36496	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	263.47546	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	263.19174	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	263.0499	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	262.76617	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	262.3406	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	262.19876	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	262.05692	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	261.63135	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	261.34763	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	260.7802	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	260.4965	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	260.07092	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	260.07092	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	260.14185	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	260.5674	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	260.85114	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	261.41855	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	261.70227	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	262.12784	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	262.26968	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	262.41156	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	262.83713	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	263.12082	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	263.26266	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	263.5464	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	266.6594	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	266.51587	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	265.79834	4	76.923077	1	3786.190200	0.000000	1.500000	1.000000	39
i1	265.65485	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	265.51135	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	265.22433	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	264.93732	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	264.79382	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	264.6503	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	264.3633	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	264.2198	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	263.93277	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	263.78928	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	263.50226	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	263.35876	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	263.21527	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	263.07175	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	263.28702	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	263.4305	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	263.57404	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	263.86102	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	264.00455	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	264.29153	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	264.43506	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	264.72208	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	264.86557	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	265.00906	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	265.29608	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	265.5831	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	265.7266	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	265.87012	4	75.000000	1	3883.272000	0.000000	1.500000	1.000000	40
i1	266.58762	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	266.73114	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	269.8466	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	269.41113	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	268.97568	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	268.68536	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	268.2499	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	267.81442	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	266.36288	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	266.07257	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	266.43546	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	267.88702	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	268.32248	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	268.75793	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	269.04825	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	269.4837	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	269.9192	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	273.0371	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	272.89032	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	272.7435	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	272.5967	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	272.4499	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	272.3031	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	272.15628	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	272.0095	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	271.71588	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	271.56906	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	271.42227	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	271.27545	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	271.12866	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	270.98184	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	270.83505	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	270.68823	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	269.51382	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	269.367	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	269.2202	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	269.0734	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	269.0734	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	269.1468	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	269.2936	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	269.4404	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	269.58722	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	270.76166	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	270.90845	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	271.05527	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	271.20206	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	271.34888	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	271.49567	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	271.6425	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	271.78928	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	272.0829	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	272.2297	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	272.3765	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	272.5233	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	272.6701	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	272.8169	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	272.9637	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	273.1105	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	276.23093	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	275.93402	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	275.78555	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	275.63712	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	275.48865	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	275.3402	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	275.19174	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	274.59793	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	274.4495	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	274.30103	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	274.1526	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	274.00412	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	273.85568	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	273.55878	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	272.66803	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	272.37112	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	272.2227	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	272.07422	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	272.07422	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	272.14847	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	272.2969	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	272.44537	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	272.74228	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	273.633	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	273.9299	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	274.07834	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	274.2268	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	274.37524	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	274.5237	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	274.67218	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	275.266	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	275.41443	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	275.5629	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	275.71133	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	275.8598	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	276.00824	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	276.30515	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	279.42804	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	279.27792	4	52.631579	1	5533.662600	0.000000	1.500000	1.000000	57
i1	278.82764	4	58.823529	1	4951.171800	0.000000	1.500000	1.000000	51
i1	278.67752	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	278.52744	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	278.37732	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	278.07712	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	277.77692	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	277.4767	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	277.3266	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	277.17648	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	277.0264	4	111.111111	1	2621.208600	0.000000	1.500000	1.000000	27
i1	276.57608	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	276.42596	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	275.82556	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	275.67548	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	275.22516	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	275.07504	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	275.07504	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	275.15012	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	275.3002	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	275.75052	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	275.9006	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	276.50104	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	276.65112	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	277.10144	4	107.142857	1	2718.290400	0.000000	1.500000	1.000000	28
i1	277.25156	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	277.40164	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	277.55176	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	277.85196	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	278.15216	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	278.45236	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	278.60248	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	278.75256	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	278.90268	4	57.692308	1	5048.253600	0.000000	1.500000	1.000000	52
i1	279.353	4	51.724138	1	5630.744400	0.000000	1.500000	1.000000	58
i1	279.50308	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	282.4767	4	50.847458	1	5727.826200	0.000000	1.500000	1.000000	59
i1	282.1732	4	54.545455	1	5339.499000	0.000000	1.500000	1.000000	55
i1	282.02145	4	56.603774	1	5145.335400	0.000000	1.500000	1.000000	53
i1	281.71793	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	281.5662	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	281.11093	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	280.80743	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	280.35217	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	280.2004	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	279.8969	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	279.74515	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	279.2899	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	278.9864	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	278.53113	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	278.3794	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	278.07587	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	278.07587	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	278.15176	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	278.45526	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	278.60703	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	279.06226	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	279.36578	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	279.82104	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	279.97278	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	280.27628	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	280.42804	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	280.8833	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	281.1868	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	281.64206	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	281.79382	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	282.09732	4	55.555556	1	5242.417200	0.000000	1.500000	1.000000	54
i1	282.24908	4	53.571429	1	5436.580800	0.000000	1.500000	1.000000	56
i1	282.55258	4	50.000000	1	5824.908000	0.000000	1.500000	1.000000	60
i1	284.45154	4	66.666667	1	4368.681000	0.000000	1.500000	1.000000	45
i1	284.29816	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	284.14474	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	283.83795	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	283.68454	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	283.53113	4	90.909091	1	3203.699400	0.000000	1.500000	1.000000	33
i1	282.61072	4	142.857143	1	2038.717800	0.000000	1.500000	1.000000	21
i1	282.4573	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	282.30392	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	281.9971	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	281.84372	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	281.6903	4	333.333333	1	873.736200	0.000000	1.500000	1.000000	9
i1	281.0767	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	281.767	4	300.000000	1	970.818000	0.000000	1.500000	1.000000	10
i1	281.9204	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	282.07382	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	282.3806	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	282.53403	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	282.6874	4	136.363636	1	2135.799600	0.000000	1.500000	1.000000	22
i1	283.60785	4	88.235294	1	3300.781200	0.000000	1.500000	1.000000	34
i1	283.76123	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	283.91464	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	284.22144	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	284.37485	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	284.52826	4	65.217391	1	4465.762800	0.000000	1.500000	1.000000	46
i1	287.6437	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	287.33362	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	286.7134	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	286.4033	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	285.78308	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	285.473	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	284.85278	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	284.5427	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	284.0775	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	284.0775	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	284.15506	4	1500.000000	1	194.163600	0.000000	1.500000	1.000000	2
i1	284.6202	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	284.9303	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	285.5505	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	285.86063	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	286.48083	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	286.79092	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	287.41113	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	287.72122	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	290.83917	4	61.224490	1	4757.008200	0.000000	1.500000	1.000000	49
i1	290.68246	4	63.829787	1	4562.844600	0.000000	1.500000	1.000000	47
i1	290.36908	4	69.767442	1	4174.517400	0.000000	1.500000	1.000000	43
i1	290.21237	4	73.170732	1	3980.353800	0.000000	1.500000	1.000000	41
i1	289.89896	4	81.081081	1	3592.026600	0.000000	1.500000	1.000000	37
i1	289.74228	4	85.714286	1	3397.863000	0.000000	1.500000	1.000000	35
i1	289.42886	4	96.774194	1	3009.535800	0.000000	1.500000	1.000000	31
i1	289.27216	4	103.448276	1	2815.372200	0.000000	1.500000	1.000000	29
i1	288.95877	4	120.000000	1	2427.045000	0.000000	1.500000	1.000000	25
i1	288.80206	4	130.434783	1	2232.881400	0.000000	1.500000	1.000000	23
i1	288.48865	4	157.894737	1	1844.554200	0.000000	1.500000	1.000000	19
i1	288.33197	4	176.470588	1	1650.390600	0.000000	1.500000	1.000000	17
i1	288.01855	4	230.769231	1	1262.063400	0.000000	1.500000	1.000000	13
i1	287.86185	4	272.727273	1	1067.899800	0.000000	1.500000	1.000000	11
i1	287.54846	4	428.571429	1	679.572600	0.000000	1.500000	1.000000	7
i1	287.39175	4	600.000000	1	485.409000	0.000000	1.500000	1.000000	5
i1	287.23505	4	1000.000000	1	291.245400	0.000000	1.500000	1.000000	3
i1	287.07834	4	3000.000000	1	97.081800	0.000000	1.500000	1.000000	1
i1	287.31342	4	750.000000	1	388.327200	0.000000	1.500000	1.000000	4
i1	287.4701	4	500.000000	1	582.490800	0.000000	1.500000	1.000000	6
i1	287.6268	4	375.000000	1	776.654400	0.000000	1.500000	1.000000	8
i1	287.94022	4	250.000000	1	1164.981600	0.000000	1.500000	1.000000	12
i1	288.0969	4	214.285714	1	1359.145200	0.000000	1.500000	1.000000	14
i1	288.4103	4	166.666667	1	1747.472400	0.000000	1.500000	1.000000	18
i1	288.56702	4	150.000000	1	1941.636000	0.000000	1.500000	1.000000	20
i1	288.8804	4	125.000000	1	2329.963200	0.000000	1.500000	1.000000	24
i1	289.0371	4	115.384615	1	2524.126800	0.000000	1.500000	1.000000	26
i1	289.35052	4	100.000000	1	2912.454000	0.000000	1.500000	1.000000	30
i1	289.5072	4	93.750000	1	3106.617600	0.000000	1.500000	1.000000	32
i1	289.82062	4	83.333333	1	3494.944800	0.000000	1.500000	1.000000	36
i1	289.97733	4	78.947368	1	3689.108400	0.000000	1.500000	1.000000	38
i1	290.2907	4	71.428571	1	4077.435600	0.000000	1.500000	1.000000	42
i1	290.44742	4	68.181818	1	4271.599200	0.000000	1.500000	1.000000	44
i1	290.76083	4	62.500000	1	4659.926400	0.000000	1.500000	1.000000	48
i1	290.9175	4	60.000000	1	4854.090000	0.000000	1.500000	1.000000	50
i1	294.03793	20	58.823529	1	4951.171800	0.000000	1.500000	10.000000	51
i1	290.39587	20	600.000000	1	485.409000	0.000000	1.500000	10.000000	5
i1	290.07916	20	3000.000000	1	97.081800	0.000000	1.500000	10.000000	1
i1	290.47507	20	500.000000	1	582.490800	0.000000	1.500000	10.000000	6
i1	294.11713	20	57.692308	1	5048.253600	0.000000	1.500000	10.000000	52
e

</CsScore>

</CsoundSynthesizer>