/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.type1;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.type1.DamagedFontException;
import org.apache.fontbox.type1.Token;

class Type1Lexer {
    private static final Log LOG = LogFactory.getLog(Type1Lexer.class);
    private final ByteBuffer buffer;
    private Token aheadToken;
    private int openParens = 0;

    Type1Lexer(byte[] byArray) throws IOException {
        this.buffer = ByteBuffer.wrap(byArray);
        this.aheadToken = this.readToken(null);
    }

    public Token nextToken() throws IOException {
        Token token = this.aheadToken;
        this.aheadToken = this.readToken(token);
        return token;
    }

    public Token peekToken() {
        return this.aheadToken;
    }

    private char getChar() {
        return (char)this.buffer.get();
    }

    private Token readToken(Token token) throws IOException {
        boolean bl;
        do {
            bl = false;
            while (this.buffer.hasRemaining()) {
                char c = this.getChar();
                if (c == '%') {
                    this.readComment();
                    continue;
                }
                if (c == '(') {
                    return this.readString();
                }
                if (c == ')') {
                    throw new IOException("unexpected closing parenthesis");
                }
                if (c == '[') {
                    return new Token(c, Token.START_ARRAY);
                }
                if (c == '{') {
                    return new Token(c, Token.START_PROC);
                }
                if (c == ']') {
                    return new Token(c, Token.END_ARRAY);
                }
                if (c == '}') {
                    return new Token(c, Token.END_PROC);
                }
                if (c == '/') {
                    return new Token(this.readRegular(), Token.LITERAL);
                }
                if (c == '<') {
                    char c2 = this.getChar();
                    if (c2 == c) {
                        return new Token("<<", Token.START_DICT);
                    }
                    this.buffer.position(this.buffer.position() - 1);
                    return new Token(c, Token.NAME);
                }
                if (c == '>') {
                    char c3 = this.getChar();
                    if (c3 == c) {
                        return new Token(">>", Token.END_DICT);
                    }
                    this.buffer.position(this.buffer.position() - 1);
                    return new Token(c, Token.NAME);
                }
                if (Character.isWhitespace(c)) {
                    bl = true;
                    continue;
                }
                if (c == '\u0000') {
                    LOG.warn((Object)"NULL byte in font, skipped");
                    bl = true;
                    continue;
                }
                this.buffer.position(this.buffer.position() - 1);
                Token token2 = this.tryReadNumber();
                if (token2 != null) {
                    return token2;
                }
                String string = this.readRegular();
                if (string == null) {
                    throw new DamagedFontException("Could not read token at position " + this.buffer.position());
                }
                if (string.equals("RD") || string.equals("-|")) {
                    if (token.getKind() == Token.INTEGER) {
                        return this.readCharString(token.intValue());
                    }
                    throw new IOException("expected INTEGER before -| or RD");
                }
                return new Token(string, Token.NAME);
            }
        } while (bl);
        return null;
    }

    private Token tryReadNumber() {
        this.buffer.mark();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = null;
        char c = this.getChar();
        boolean bl = false;
        if (c == '+' || c == '-') {
            stringBuilder.append(c);
            c = this.getChar();
        }
        while (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
            bl = true;
        }
        if (c == '.') {
            stringBuilder.append(c);
            c = this.getChar();
        } else if (c == '#') {
            stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            c = this.getChar();
        } else {
            if (stringBuilder.length() == 0 || !bl) {
                this.buffer.reset();
                return null;
            }
            this.buffer.position(this.buffer.position() - 1);
            return new Token(stringBuilder.toString(), Token.INTEGER);
        }
        if (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
        } else {
            this.buffer.reset();
            return null;
        }
        while (Character.isDigit(c)) {
            stringBuilder.append(c);
            c = this.getChar();
        }
        if (c == 'E') {
            stringBuilder.append(c);
            c = this.getChar();
            if (c == '-') {
                stringBuilder.append(c);
                c = this.getChar();
            }
            if (Character.isDigit(c)) {
                stringBuilder.append(c);
                c = this.getChar();
            } else {
                this.buffer.reset();
                return null;
            }
            while (Character.isDigit(c)) {
                stringBuilder.append(c);
                c = this.getChar();
            }
        }
        this.buffer.position(this.buffer.position() - 1);
        if (stringBuilder2 != null) {
            Integer n = Integer.parseInt(stringBuilder.toString(), Integer.parseInt(stringBuilder2.toString()));
            return new Token(n.toString(), Token.INTEGER);
        }
        return new Token(stringBuilder.toString(), Token.REAL);
    }

    private String readRegular() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.buffer.hasRemaining()) {
            this.buffer.mark();
            char c = this.getChar();
            if (Character.isWhitespace(c) || c == '(' || c == ')' || c == '<' || c == '>' || c == '[' || c == ']' || c == '{' || c == '}' || c == '/' || c == '%') {
                this.buffer.reset();
                break;
            }
            stringBuilder.append(c);
        }
        if ((string = stringBuilder.toString()).length() == 0) {
            return null;
        }
        return string;
    }

    private String readComment() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.buffer.hasRemaining() && (c = this.getChar()) != '\r' && c != '\n') {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private Token readString() {
        StringBuilder stringBuilder = new StringBuilder();
        block15: while (this.buffer.hasRemaining()) {
            char c = this.getChar();
            switch (c) {
                case '(': {
                    ++this.openParens;
                    stringBuilder.append('(');
                    continue block15;
                }
                case ')': {
                    if (this.openParens == 0) {
                        return new Token(stringBuilder.toString(), Token.STRING);
                    }
                    stringBuilder.append(')');
                    --this.openParens;
                    continue block15;
                }
                case '\\': {
                    char c2 = this.getChar();
                    switch (c2) {
                        case 'n': 
                        case 'r': {
                            stringBuilder.append("\n");
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        case 'b': {
                            stringBuilder.append('\b');
                            break;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            break;
                        }
                        case '(': {
                            stringBuilder.append('(');
                            break;
                        }
                        case ')': {
                            stringBuilder.append(')');
                        }
                    }
                    if (!Character.isDigit(c2)) continue block15;
                    String string = String.valueOf(new char[]{c2, this.getChar(), this.getChar()});
                    Integer n = Integer.parseInt(string, 8);
                    stringBuilder.append((char)n.intValue());
                    continue block15;
                }
                case '\n': 
                case '\r': {
                    stringBuilder.append("\n");
                    continue block15;
                }
            }
            stringBuilder.append(c);
        }
        return null;
    }

    private Token readCharString(int n) {
        this.buffer.get();
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        return new Token(byArray, Token.CHARSTRING);
    }
}

