/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;

public final class CharHandler
extends PrimitiveHandler {
    static final int LENGTH = 2;
    private static final Character DEFAULTVALUE = new Character('\u0000');

    @Override
    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    @Override
    public int linkLength() {
        return 2;
    }

    @Override
    public Class primitiveJavaClass() {
        return Character.TYPE;
    }

    @Override
    Object read1(ByteArrayBuffer a_bytes) {
        byte b1 = a_bytes.readByte();
        byte b2 = a_bytes.readByte();
        char ret = (char)(b1 & 0xFF | (b2 & 0xFF) << 8);
        return new Character(ret);
    }

    @Override
    public void write(Object a_object, ByteArrayBuffer a_bytes) {
        char char_ = ((Character)a_object).charValue();
        a_bytes.writeByte((byte)(char_ & 0xFF));
        a_bytes.writeByte((byte)(char_ >> 8));
    }

    @Override
    public Object read(ReadContext context) {
        byte b1 = context.readByte();
        byte b2 = context.readByte();
        char charValue = (char)(b1 & 0xFF | (b2 & 0xFF) << 8);
        return new Character(charValue);
    }

    @Override
    public void write(WriteContext context, Object obj) {
        char charValue = ((Character)obj).charValue();
        context.writeBytes(new byte[]{(byte)(charValue & 0xFF), (byte)(charValue >> 8)});
    }

    @Override
    public PreparedComparison internalPrepareComparison(Object source) {
        final char sourceChar = ((Character)source).charValue();
        return new PreparedComparison(){

            @Override
            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                char targetChar = ((Character)target).charValue();
                return sourceChar == targetChar ? 0 : (sourceChar < targetChar ? -1 : 1);
            }
        };
    }
}

