/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import java.io.Serializable;
import org.spaceroots.mantissa.fitting.AbstractCurveFitter;
import org.spaceroots.mantissa.fitting.FFPIterator;
import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

class F2FP2Iterator
implements SampledFunctionIterator,
Serializable {
    private FFPIterator ffpIterator;
    private static final long serialVersionUID = -8113110433795298072L;

    public F2FP2Iterator(AbstractCurveFitter.FitMeasurement[] measurements) {
        this.ffpIterator = new FFPIterator(measurements);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public boolean hasNext() {
        return this.ffpIterator.hasNext();
    }

    @Override
    public VectorialValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        VectorialValuedPair point = this.ffpIterator.nextSamplePoint();
        double[] y = point.y;
        return new VectorialValuedPair(point.x, new double[]{y[0] * y[0], y[1] * y[1]});
    }
}

