/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.SplitFileFetcherStorage;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.SendableGet;
import freenet.node.SendableRequestItem;
import freenet.support.Logger;

public class SplitFileFetcherGet
extends SendableGet
implements HasKeyListener {
    private static volatile boolean logMINOR;
    final SplitFileFetcher parent;
    final SplitFileFetcherStorage storage;

    public SplitFileFetcherGet(SplitFileFetcher fetcher, SplitFileFetcherStorage storage) {
        super(fetcher.parent, fetcher.realTimeFlag);
        this.parent = fetcher;
        this.storage = storage;
    }

    @Override
    public ClientKey getKey(SendableRequestItem token) {
        SplitFileFetcherStorage.MyKey key = (SplitFileFetcherStorage.MyKey)token;
        if (key.get != this.storage) {
            throw new IllegalArgumentException();
        }
        return this.storage.getKey(key);
    }

    @Override
    public Key[] listKeys() {
        return this.storage.listUnfetchedKeys();
    }

    @Override
    public FetchContext getContext() {
        return this.parent.blockFetchContext;
    }

    @Override
    public void onFailure(LowLevelGetException e, SendableRequestItem token, ClientContext context) {
        FetchException fe = SplitFileFetcherGet.translateException(e);
        if (fe.isDefinitelyFatal()) {
            if (logMINOR) {
                Logger.minor(this, "Fatal failure: " + fe + " for " + token);
            }
            this.parent.fail(fe);
        } else {
            SplitFileFetcherStorage.MyKey key = (SplitFileFetcherStorage.MyKey)token;
            if (key.get != this.storage) {
                throw new IllegalArgumentException();
            }
            this.storage.onFailure(key, fe);
        }
    }

    @Override
    public long getWakeupTime(ClientContext context, long now) {
        long wakeTime = this.storage.getCooldownWakeupTime(now);
        if (wakeTime == 0L) {
            return 0L;
        }
        return wakeTime;
    }

    @Override
    public long getCooldownWakeup(SendableRequestItem token, ClientContext context) {
        SplitFileFetcherStorage.MyKey key = (SplitFileFetcherStorage.MyKey)token;
        return this.storage.segments[key.segmentNumber].getCooldownTime(key.blockNumber);
    }

    @Override
    public boolean preRegister(ClientContext context, boolean toNetwork) {
        if (!toNetwork) {
            return false;
        }
        if (this.parent.localRequestOnly()) {
            this.storage.finishedCheckingDatastoreOnLocalRequest(context);
            return true;
        }
        this.storage.setHasCheckedStore(context);
        this.parent.toNetwork();
        this.parent.parent.notifyClients(context);
        return false;
    }

    @Override
    public short getPriorityClass() {
        return this.parent.getPriorityClass();
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ClientContext context) {
        return this.storage.chooseRandomKey();
    }

    @Override
    public long countAllKeys(ClientContext context) {
        return this.storage.countUnfetchedKeys();
    }

    @Override
    public long countSendableKeys(ClientContext context) {
        return this.storage.countSendableKeys();
    }

    @Override
    public boolean isCancelled() {
        return this.parent.hasFinished();
    }

    @Override
    public RequestClient getClient() {
        return this.parent.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent.parent;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    public void schedule(ClientContext context, boolean ignoreStore) {
        ClientRequestScheduler sched = context.getChkFetchScheduler(this.realTimeFlag);
        BlockSet blocks = this.parent.blockFetchContext.blocks;
        sched.register(this, new SendableGet[]{this}, this.persistent, blocks, ignoreStore);
    }

    @Override
    public KeyListener makeKeyListener(ClientContext context, boolean onStartup) {
        return this.storage.keyListener;
    }

    public void cancel(ClientContext context) {
        this.unregister(context, this.parent.getPriorityClass());
    }

    public boolean hasQueued() {
        return this.storage.hasCheckedStore();
    }

    @Override
    protected ClientGetState getClientGetState() {
        return this.parent;
    }

    static {
        Logger.registerClass(SplitFileFetcherGet.class);
    }
}

