/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.CooldownBlockChooser;
import freenet.client.async.PersistentJob;
import freenet.client.async.SplitFileFetcherSegmentStorage;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.node.KeysFetchingLocally;
import java.io.IOException;
import java.util.Random;

public class SplitFileFetcherSegmentBlockChooser
extends CooldownBlockChooser {
    private final SplitFileFetcherSegmentStorage segment;
    private final KeysFetchingLocally keysFetching;
    private final int ignoreLastBlock;

    public SplitFileFetcherSegmentBlockChooser(int blocks, Random random, int maxRetries, int cooldownTries, long cooldownTime, SplitFileFetcherSegmentStorage segment, KeysFetchingLocally keysFetching, int ignoreLastBlock) {
        super(blocks, random, maxRetries, cooldownTries, cooldownTime);
        this.segment = segment;
        this.keysFetching = keysFetching;
        this.ignoreLastBlock = ignoreLastBlock;
    }

    @Override
    protected boolean checkValid(int chosen) {
        if (!super.checkValid(chosen)) {
            return false;
        }
        if (chosen == this.ignoreLastBlock) {
            return false;
        }
        try {
            SplitFileSegmentKeys keys = this.segment.getSegmentKeys();
            return !this.keysFetching.hasKey(keys.getNodeKey(chosen, null, false), this.segment.parent.fetcher.getSendableGet());
        }
        catch (IOException e) {
            this.segment.parent.jobRunner.queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    ((SplitFileFetcherSegmentBlockChooser)SplitFileFetcherSegmentBlockChooser.this).segment.parent.failOnDiskError(e);
                    return true;
                }
            });
            return false;
        }
    }
}

