/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.client.async.CompatibilityAnalyser;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.HexUtil;
import freenet.support.SimpleFieldSet;

public class CompatibilityMode
extends FCPMessage {
    private static final long serialVersionUID = 1L;
    private final CompatibilityAnalyser compat;
    final String identifier;
    final boolean global;

    public CompatibilityMode(String identifier, boolean global, CompatibilityAnalyser compat) {
        this.identifier = identifier;
        this.global = global;
        this.compat = compat;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putOverwrite("Min", this.compat.min().name());
        fs.putOverwrite("Max", this.compat.max().name());
        fs.put("Min.Number", this.compat.min().ordinal());
        fs.put("Max.Number", this.compat.max().ordinal());
        fs.putOverwrite("Identifier", this.identifier);
        fs.put("Global", this.global);
        byte[] cryptoKey = this.compat.getCryptoKey();
        if (cryptoKey != null) {
            fs.putOverwrite("SplitfileCryptoKey", HexUtil.bytesToHex(cryptoKey));
        }
        fs.put("DontCompress", this.compat.dontCompress());
        fs.put("Definitive", this.compat.definitive());
        return fs;
    }

    @Override
    public String getName() {
        return "CompatibilityMode";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new UnsupportedOperationException();
    }

    public InsertContext.CompatibilityMode[] getModes() {
        return this.compat.getModes();
    }
}

