/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.node.stats.StoreAccessStats;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.BlockMetadata;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.support.Ticker;
import java.io.IOException;

public interface FreenetStore<T extends StorableBlock> {
    public T fetch(byte[] var1, byte[] var2, boolean var3, boolean var4, boolean var5, boolean var6, BlockMetadata var7) throws IOException;

    public void put(T var1, byte[] var2, byte[] var3, boolean var4, boolean var5) throws IOException, KeyCollisionException;

    public void setMaxKeys(long var1, boolean var3) throws IOException;

    public long getMaxKeys();

    public long hits();

    public long misses();

    public long writes();

    public long keyCount();

    public long getBloomFalsePositive();

    public boolean probablyInStore(byte[] var1);

    public StoreAccessStats getSessionAccessStats();

    public StoreAccessStats getTotalAccessStats();

    public boolean start(Ticker var1, boolean var2) throws IOException;

    public void close();

    public void setUserAlertManager(UserAlertManager var1);

    public FreenetStore<T> getUnderlyingStore();

    public static enum StoreType {
        CHK,
        PUBKEY,
        SSK;

    }
}

