/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Fields;
import java.util.Arrays;
import java.util.Comparator;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] buf;
    private int hashCode;
    public static final Comparator<ByteArrayWrapper> FAST_COMPARATOR = new Comparator<ByteArrayWrapper>(){

        @Override
        public int compare(ByteArrayWrapper o1, ByteArrayWrapper o2) {
            if (o1.hashCode > o2.hashCode) {
                return 1;
            }
            if (o1.hashCode < o2.hashCode) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public ByteArrayWrapper(byte[] data) {
        this.buf = data;
        this.hashCode = Fields.hashCode(this.buf);
    }

    public boolean equals(Object o) {
        if (o instanceof ByteArrayWrapper) {
            ByteArrayWrapper b = (ByteArrayWrapper)o;
            if (b.buf == this.buf) {
                return true;
            }
            return Arrays.equals(b.buf, this.buf);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] get() {
        return this.buf;
    }

    @Override
    public int compareTo(ByteArrayWrapper arg) {
        if (this == arg) {
            return 0;
        }
        return Fields.compareBytes(this.buf, arg.buf);
    }
}

