/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import freenet.support.LoggerHook;
import java.util.Arrays;

public class LoggerHookChain
extends LoggerHook {
    private LoggerHook[] hooks = new LoggerHook[0];

    public LoggerHookChain() {
        this(Logger.LogLevel.NORMAL);
    }

    public LoggerHookChain(Logger.LogLevel threshold) {
        super(threshold);
    }

    public LoggerHookChain(String threshold) throws LoggerHook.InvalidThresholdException {
        super(threshold);
    }

    @Override
    public synchronized void log(Object o, Class<?> c, String msg, Throwable e, Logger.LogLevel priority) {
        for (LoggerHook hook : this.hooks) {
            hook.log(o, c, msg, e, priority);
        }
    }

    public synchronized void addHook(LoggerHook lh) {
        LoggerHook[] newHooks = Arrays.copyOf(this.hooks, this.hooks.length + 1);
        newHooks[this.hooks.length] = lh;
        this.hooks = newHooks;
    }

    public synchronized void removeHook(LoggerHook lh) {
        int hooksLength = this.hooks.length;
        if (hooksLength == 0) {
            return;
        }
        LoggerHook[] newHooks = new LoggerHook[hooksLength - 1];
        int x = 0;
        for (int i = 0; i < hooksLength; ++i) {
            if (this.hooks[i] == lh) continue;
            if (x == newHooks.length) {
                return;
            }
            newHooks[x++] = this.hooks[i];
        }
        this.hooks = x == newHooks.length ? newHooks : Arrays.copyOf(newHooks, x);
    }

    public synchronized LoggerHook[] getHooks() {
        return this.hooks;
    }

    @Override
    public void setDetailedThresholds(String details) throws LoggerHook.InvalidThresholdException {
        super.setDetailedThresholds(details);
    }

    @Override
    public void setThreshold(Logger.LogLevel thresh) {
        super.setThreshold(thresh);
    }
}

