/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.Arrays;
import java.util.HashSet;

public final class StringValidityChecker {
    private static final HashSet<Character> idnBlacklist = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\u00a0'), Character.valueOf('\u00bc'), Character.valueOf('\u00bd'), Character.valueOf('\u01c3'), Character.valueOf('\u0337'), Character.valueOf('\u0338'), Character.valueOf('\u05c3'), Character.valueOf('\u05f4'), Character.valueOf('\u06d4'), Character.valueOf('\u0702'), Character.valueOf('\u115f'), Character.valueOf('\u1160'), Character.valueOf('\u2000'), Character.valueOf('\u2001'), Character.valueOf('\u2002'), Character.valueOf('\u2003'), Character.valueOf('\u2004'), Character.valueOf('\u2005'), Character.valueOf('\u2006'), Character.valueOf('\u2007'), Character.valueOf('\u2008'), Character.valueOf('\u2009'), Character.valueOf('\u200a'), Character.valueOf('\u200b'), Character.valueOf('\u2024'), Character.valueOf('\u2027'), Character.valueOf('\u2028'), Character.valueOf('\u2029'), Character.valueOf('\u202f'), Character.valueOf('\u2039'), Character.valueOf('\u203a'), Character.valueOf('\u2044'), Character.valueOf('\u205f'), Character.valueOf('\u2154'), Character.valueOf('\u2155'), Character.valueOf('\u2156'), Character.valueOf('\u2159'), Character.valueOf('\u215a'), Character.valueOf('\u215b'), Character.valueOf('\u215f'), Character.valueOf('\u2215'), Character.valueOf('\u23ae'), Character.valueOf('\u29f6'), Character.valueOf('\u29f8'), Character.valueOf('\u2afb'), Character.valueOf('\u2afd'), Character.valueOf('\u2ff0'), Character.valueOf('\u2ff1'), Character.valueOf('\u2ff2'), Character.valueOf('\u2ff3'), Character.valueOf('\u2ff4'), Character.valueOf('\u2ff5'), Character.valueOf('\u2ff6'), Character.valueOf('\u2ff7'), Character.valueOf('\u2ff8'), Character.valueOf('\u2ff9'), Character.valueOf('\u2ffa'), Character.valueOf('\u2ffb'), Character.valueOf('\u3000'), Character.valueOf('\u3002'), Character.valueOf('\u3014'), Character.valueOf('\u3015'), Character.valueOf('\u3033'), Character.valueOf('\u3164'), Character.valueOf('\u321d'), Character.valueOf('\u321e'), Character.valueOf('\u33ae'), Character.valueOf('\u33af'), Character.valueOf('\u33c6'), Character.valueOf('\u33df'), Character.valueOf('\ufe14'), Character.valueOf('\ufe15'), Character.valueOf('\ufe3f'), Character.valueOf('\ufe5d'), Character.valueOf('\ufe5e'), Character.valueOf('\ufeff'), Character.valueOf('\uff0e'), Character.valueOf('\uff0f'), Character.valueOf('\uff61'), Character.valueOf('\uffa0'), Character.valueOf('\ufff9'), Character.valueOf('\ufffa'), Character.valueOf('\ufffb'), Character.valueOf('\ufffc'), Character.valueOf('\ufffd')));
    private static final HashSet<Character> windowsReservedPrintableFilenameCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf(':'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>')));
    private static final HashSet<String> windowsReservedFilenames = new HashSet<String>(Arrays.asList("aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"));
    private static final HashSet<Character> macOSReservedPrintableFilenameCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf(':'), Character.valueOf('/')));

    public static boolean isWindowsReservedPrintableFilenameCharacter(Character c) {
        return windowsReservedPrintableFilenameCharacters.contains(c);
    }

    public static boolean isWindowsReservedFilename(String filename) {
        int nameEnd = (filename = filename.toLowerCase()).indexOf(46);
        if (nameEnd == -1) {
            nameEnd = filename.length();
        }
        return windowsReservedFilenames.contains(filename.substring(0, nameEnd));
    }

    public static boolean isMacOSReservedPrintableFilenameCharacter(Character c) {
        return macOSReservedPrintableFilenameCharacters.contains(c);
    }

    public static boolean isUnixReservedPrintableFilenameCharacter(char c) {
        return c == '/';
    }

    public static boolean containsNoIDNBlacklistCharacters(String text) {
        char[] arr$ = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (!idnBlacklist.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNoLinebreaks(String text) {
        char[] arr$ = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.getType(c.charValue()) != 13 && Character.getType(c.charValue()) != 14 && c.charValue() != '\n' && c.charValue() != '\r') continue;
            return false;
        }
        return true;
    }

    public static boolean containsNoInvalidCharacters(String text) {
        int c;
        for (int i = 0; i < text.length(); i += Character.charCount(c)) {
            c = text.codePointAt(i);
            if ((c & 0xFFFE) != 65534 && Character.getType(c) != 19) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNoControlCharacters(String text) {
        char[] arr$ = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.getType(c.charValue()) != 15) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNoInvalidFormatting(String text) {
        int dirCount = 0;
        boolean inAnnotatedText = false;
        boolean inAnnotation = false;
        char[] arr$ = text.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (c.charValue() == '\u202a' || c.charValue() == '\u202b' || c.charValue() == '\u202d' || c.charValue() == '\u202e') {
                ++dirCount;
                continue;
            }
            if (c.charValue() == '\u202c') {
                if (--dirCount >= 0) continue;
                return false;
            }
            if (c.charValue() == '\ufff9') {
                if (inAnnotatedText || inAnnotation) {
                    return false;
                }
                inAnnotatedText = true;
                continue;
            }
            if (c.charValue() == '\ufffa') {
                if (!inAnnotatedText) {
                    return false;
                }
                inAnnotatedText = false;
                inAnnotation = true;
                continue;
            }
            if (c.charValue() != '\ufffb') continue;
            if (!inAnnotation) {
                return false;
            }
            inAnnotation = false;
        }
        return dirCount == 0 && !inAnnotatedText && !inAnnotation;
    }

    public static boolean isLatinLettersAndNumbersOnly(String text) {
        for (char c : text.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

