/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.util.Base64;

public class FTPHTTPClient
extends FTPClient {
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private static final byte[] CRLF = new byte[]{13, 10};
    private final Base64 base64 = new Base64();
    private String tunnelHost;

    public FTPHTTPClient(String string, int n, String string2, String string3) {
        this.proxyHost = string;
        this.proxyPort = n;
        this.proxyUsername = string2;
        this.proxyPassword = string3;
        this.tunnelHost = null;
    }

    public FTPHTTPClient(String string, int n) {
        this(string, n, null, null);
    }

    @Override
    @Deprecated
    protected Socket _openDataConnection_(int n, String string) throws IOException {
        return super._openDataConnection_(n, string);
    }

    @Override
    protected Socket _openDataConnection_(String string, String string2) throws IOException {
        boolean bl;
        if (this.getDataConnectionMode() != 2) {
            throw new IllegalStateException("Only passive connection mode supported");
        }
        boolean bl2 = this.getRemoteAddress() instanceof Inet6Address;
        String string3 = null;
        boolean bl3 = bl = this.isUseEPSVwithIPv4() || bl2;
        if (bl && this.epsv() == 229) {
            this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            string3 = this.tunnelHost;
        } else {
            if (bl2) {
                return null;
            }
            if (this.pasv() != 227) {
                return null;
            }
            this._parsePassiveModeReply((String)this._replyLines.get(0));
            string3 = this.getPassiveHost();
        }
        Socket socket = this._socketFactory_.createSocket(this.proxyHost, this.proxyPort);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.tunnelHandshake(string3, this.getPassivePort(), inputStream, outputStream);
        if (this.getRestartOffset() > 0L && !this.restart(this.getRestartOffset())) {
            socket.close();
            return null;
        }
        if (!FTPReply.isPositivePreliminary(this.sendCommand(string, string2))) {
            socket.close();
            return null;
        }
        return socket;
    }

    @Override
    public void connect(String string, int n) throws SocketException, IOException {
        BufferedReader bufferedReader;
        this._socket_ = this._socketFactory_.createSocket(this.proxyHost, this.proxyPort);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        try {
            bufferedReader = this.tunnelHandshake(string, n, this._input_, this._output_);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Could not connect to " + string + " using port " + n);
            iOException.initCause(exception);
            throw iOException;
        }
        super._connectAction_(bufferedReader);
    }

    private BufferedReader tunnelHandshake(String string, int n, InputStream inputStream, OutputStream outputStream) throws IOException, UnsupportedEncodingException {
        Object object;
        Object object2;
        String string2 = "CONNECT " + string + ":" + n + " HTTP/1.1";
        String string3 = "Host: " + string + ":" + n;
        this.tunnelHost = string;
        outputStream.write(string2.getBytes("UTF-8"));
        outputStream.write(CRLF);
        outputStream.write(string3.getBytes("UTF-8"));
        outputStream.write(CRLF);
        if (this.proxyUsername != null && this.proxyPassword != null) {
            object2 = this.proxyUsername + ":" + this.proxyPassword;
            object = "Proxy-Authorization: Basic " + this.base64.encodeToString(((String)object2).getBytes("UTF-8"));
            outputStream.write(((String)object).getBytes("UTF-8"));
        }
        outputStream.write(CRLF);
        object2 = new ArrayList();
        object = new BufferedReader(new InputStreamReader(inputStream, this.getCharsetName()));
        String string4 = ((BufferedReader)object).readLine();
        while (string4 != null && string4.length() > 0) {
            object2.add(string4);
            string4 = ((BufferedReader)object).readLine();
        }
        int n2 = object2.size();
        if (n2 == 0) {
            throw new IOException("No response from proxy");
        }
        String string5 = null;
        String string6 = (String)object2.get(0);
        if (!string6.startsWith("HTTP/") || string6.length() < 12) {
            throw new IOException("Invalid response from proxy: " + string6);
        }
        string5 = string6.substring(9, 12);
        if (!"200".equals(string5)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("HTTPTunnelConnector: connection failed\r\n");
            stringBuilder.append("Response received from the proxy:\r\n");
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                stringBuilder.append(string7);
                stringBuilder.append("\r\n");
            }
            throw new IOException(stringBuilder.toString());
        }
        return object;
    }
}

