/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.io.File;
import java.text.ParseException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class OS400FTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "yy/MM/dd HH:mm:ss";
    private static final String REGEX = "(\\S+)\\s+(?:(\\d+)\\s+)?(?:(\\S+)\\s+(\\S+)\\s+)?(\\*STMF|\\*DIR|\\*FILE|\\*MEM)\\s+(?:(\\S+)\\s*)?";

    public OS400FTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public OS400FTPEntryParser(FTPClientConfig fTPClientConfig) {
        super(REGEX);
        this.configure(fTPClientConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FTPFile parseFTPEntry(String string) {
        int n;
        int n2;
        FTPFile fTPFile = new FTPFile();
        fTPFile.setRawListing(string);
        if (!this.matches(string)) return null;
        String string2 = this.group(1);
        String string3 = this.group(2);
        String string4 = "";
        if (!this.isNullOrEmpty(this.group(3)) || !this.isNullOrEmpty(this.group(4))) {
            string4 = this.group(3) + " " + this.group(4);
        }
        String string5 = this.group(5);
        String string6 = this.group(6);
        boolean bl = true;
        try {
            fTPFile.setTimestamp(super.parseTimestamp(string4));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (string5.equalsIgnoreCase("*STMF")) {
            n2 = 0;
            if (this.isNullOrEmpty(string3)) return null;
            if (this.isNullOrEmpty(string6)) {
                return null;
            }
        } else if (string5.equalsIgnoreCase("*DIR")) {
            n2 = 1;
            if (this.isNullOrEmpty(string3)) return null;
            if (this.isNullOrEmpty(string6)) {
                return null;
            }
        } else if (string5.equalsIgnoreCase("*FILE")) {
            if (string6 == null || !string6.toUpperCase().endsWith(".SAVF")) return null;
            bl = false;
            n2 = 0;
        } else if (string5.equalsIgnoreCase("*MEM")) {
            bl = false;
            n2 = 0;
            if (this.isNullOrEmpty(string6)) {
                return null;
            }
            if (!this.isNullOrEmpty(string3) || !this.isNullOrEmpty(string4)) {
                return null;
            }
            string6 = string6.replace('/', File.separatorChar);
        } else {
            n2 = 3;
        }
        fTPFile.setType(n2);
        fTPFile.setUser(string2);
        try {
            fTPFile.setSize(Long.parseLong(string3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string6.endsWith("/")) {
            string6 = string6.substring(0, string6.length() - 1);
        }
        if (bl && (n = string6.lastIndexOf(47)) > -1) {
            string6 = string6.substring(n + 1);
        }
        fTPFile.setName(string6);
        return fTPFile;
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("OS/400", DEFAULT_DATE_FORMAT, null, null, null, null);
    }
}

