/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.io.DotTerminatedMessageReader;
import org.apache.commons.net.io.DotTerminatedMessageWriter;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.nntp.Article;
import org.apache.commons.net.nntp.ArticleInfo;
import org.apache.commons.net.nntp.ArticleIterator;
import org.apache.commons.net.nntp.ArticlePointer;
import org.apache.commons.net.nntp.NNTP;
import org.apache.commons.net.nntp.NNTPReply;
import org.apache.commons.net.nntp.NewGroupsOrNewsQuery;
import org.apache.commons.net.nntp.NewsgroupInfo;
import org.apache.commons.net.nntp.NewsgroupIterator;
import org.apache.commons.net.nntp.ReplyIterator;

public class NNTPClient
extends NNTP {
    private void __parseArticlePointer(String string, ArticleInfo articleInfo) throws MalformedServerReplyException {
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 3) {
            int n = 1;
            try {
                articleInfo.articleNumber = Long.parseLong(stringArray[n++]);
                articleInfo.articleId = stringArray[n++];
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse article pointer.\nServer reply: " + string);
    }

    private static void __parseGroupReply(String string, NewsgroupInfo newsgroupInfo) throws MalformedServerReplyException {
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 5) {
            int n = 1;
            try {
                newsgroupInfo._setArticleCount(Long.parseLong(stringArray[n++]));
                newsgroupInfo._setFirstArticle(Long.parseLong(stringArray[n++]));
                newsgroupInfo._setLastArticle(Long.parseLong(stringArray[n++]));
                newsgroupInfo._setNewsgroup(stringArray[n++]);
                newsgroupInfo._setPostingPermission(0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new MalformedServerReplyException("Could not parse newsgroup info.\nServer reply: " + string);
    }

    static NewsgroupInfo __parseNewsgroupListEntry(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 4) {
            return null;
        }
        NewsgroupInfo newsgroupInfo = new NewsgroupInfo();
        int n = 0;
        newsgroupInfo._setNewsgroup(stringArray[n++]);
        try {
            long l = Long.parseLong(stringArray[n++]);
            long l2 = Long.parseLong(stringArray[n++]);
            newsgroupInfo._setFirstArticle(l2);
            newsgroupInfo._setLastArticle(l);
            if (l2 == 0L && l == 0L) {
                newsgroupInfo._setArticleCount(0L);
            } else {
                newsgroupInfo._setArticleCount(l - l2 + 1L);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        switch (stringArray[n++].charAt(0)) {
            case 'Y': 
            case 'y': {
                newsgroupInfo._setPostingPermission(2);
                break;
            }
            case 'N': 
            case 'n': {
                newsgroupInfo._setPostingPermission(3);
                break;
            }
            case 'M': 
            case 'm': {
                newsgroupInfo._setPostingPermission(1);
                break;
            }
            default: {
                newsgroupInfo._setPostingPermission(0);
            }
        }
        return newsgroupInfo;
    }

    static Article __parseArticleEntry(String string) {
        Article article = new Article();
        article.setSubject(string);
        String[] stringArray = string.split("\t");
        if (stringArray.length > 6) {
            int n = 0;
            try {
                article.setArticleNumber(Long.parseLong(stringArray[n++]));
                article.setSubject(stringArray[n++]);
                article.setFrom(stringArray[n++]);
                article.setDate(stringArray[n++]);
                article.setArticleId(stringArray[n++]);
                article.addReference(stringArray[n++]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return article;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NewsgroupInfo[] __readNewsgroupListing() throws IOException {
        Vector<NewsgroupInfo> vector = new Vector<NewsgroupInfo>(2048);
        try (DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);){
            String string;
            while ((string = ((BufferedReader)dotTerminatedMessageReader).readLine()) != null) {
                NewsgroupInfo newsgroupInfo = NNTPClient.__parseNewsgroupListEntry(string);
                if (newsgroupInfo != null) {
                    vector.addElement(newsgroupInfo);
                    continue;
                }
                throw new MalformedServerReplyException(string);
            }
        }
        int n = vector.size();
        if (n < 1) {
            return new NewsgroupInfo[0];
        }
        Object[] objectArray = new NewsgroupInfo[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private BufferedReader __retrieve(int n, String string, ArticleInfo articleInfo) throws IOException {
        if (string != null ? !NNTPReply.isPositiveCompletion(this.sendCommand(n, string)) : !NNTPReply.isPositiveCompletion(this.sendCommand(n))) {
            return null;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    private BufferedReader __retrieve(int n, long l, ArticleInfo articleInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.sendCommand(n, Long.toString(l)))) {
            return null;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public BufferedReader retrieveArticle(String string, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(0, string, articleInfo);
    }

    public Reader retrieveArticle(String string) throws IOException {
        return this.retrieveArticle(string, (ArticleInfo)null);
    }

    public Reader retrieveArticle() throws IOException {
        return this.retrieveArticle(null);
    }

    public BufferedReader retrieveArticle(long l, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(0, l, articleInfo);
    }

    public BufferedReader retrieveArticle(long l) throws IOException {
        return this.retrieveArticle(l, null);
    }

    public BufferedReader retrieveArticleHeader(String string, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(3, string, articleInfo);
    }

    public Reader retrieveArticleHeader(String string) throws IOException {
        return this.retrieveArticleHeader(string, (ArticleInfo)null);
    }

    public Reader retrieveArticleHeader() throws IOException {
        return this.retrieveArticleHeader(null);
    }

    public BufferedReader retrieveArticleHeader(long l, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(3, l, articleInfo);
    }

    public BufferedReader retrieveArticleHeader(long l) throws IOException {
        return this.retrieveArticleHeader(l, null);
    }

    public BufferedReader retrieveArticleBody(String string, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(1, string, articleInfo);
    }

    public Reader retrieveArticleBody(String string) throws IOException {
        return this.retrieveArticleBody(string, (ArticleInfo)null);
    }

    public Reader retrieveArticleBody() throws IOException {
        return this.retrieveArticleBody(null);
    }

    public BufferedReader retrieveArticleBody(long l, ArticleInfo articleInfo) throws IOException {
        return this.__retrieve(1, l, articleInfo);
    }

    public BufferedReader retrieveArticleBody(long l) throws IOException {
        return this.retrieveArticleBody(l, null);
    }

    public boolean selectNewsgroup(String string, NewsgroupInfo newsgroupInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.group(string))) {
            return false;
        }
        if (newsgroupInfo != null) {
            NNTPClient.__parseGroupReply(this.getReplyString(), newsgroupInfo);
        }
        return true;
    }

    public boolean selectNewsgroup(String string) throws IOException {
        return this.selectNewsgroup(string, null);
    }

    public String listHelp() throws IOException {
        if (!NNTPReply.isInformational(this.help())) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);
        Util.copyReader(dotTerminatedMessageReader, stringWriter);
        ((BufferedReader)dotTerminatedMessageReader).close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public String[] listOverviewFmt() throws IOException {
        String string;
        if (!NNTPReply.isPositiveCompletion(this.sendCommand("LIST", "OVERVIEW.FMT"))) {
            return null;
        }
        DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = ((BufferedReader)dotTerminatedMessageReader).readLine()) != null) {
            arrayList.add(string);
        }
        ((BufferedReader)dotTerminatedMessageReader).close();
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean selectArticle(String string, ArticleInfo articleInfo) throws IOException {
        if (string != null ? !NNTPReply.isPositiveCompletion(this.stat(string)) : !NNTPReply.isPositiveCompletion(this.stat())) {
            return false;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return true;
    }

    public boolean selectArticle(String string) throws IOException {
        return this.selectArticle(string, (ArticleInfo)null);
    }

    public boolean selectArticle(ArticleInfo articleInfo) throws IOException {
        return this.selectArticle(null, articleInfo);
    }

    public boolean selectArticle(long l, ArticleInfo articleInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.stat(l))) {
            return false;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return true;
    }

    public boolean selectArticle(long l) throws IOException {
        return this.selectArticle(l, null);
    }

    public boolean selectPreviousArticle(ArticleInfo articleInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.last())) {
            return false;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return true;
    }

    public boolean selectPreviousArticle() throws IOException {
        return this.selectPreviousArticle((ArticleInfo)null);
    }

    public boolean selectNextArticle(ArticleInfo articleInfo) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.next())) {
            return false;
        }
        if (articleInfo != null) {
            this.__parseArticlePointer(this.getReplyString(), articleInfo);
        }
        return true;
    }

    public boolean selectNextArticle() throws IOException {
        return this.selectNextArticle((ArticleInfo)null);
    }

    public NewsgroupInfo[] listNewsgroups() throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.list())) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public Iterable<String> iterateNewsgroupListing() throws IOException {
        if (NNTPReply.isPositiveCompletion(this.list())) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups() throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing());
    }

    public NewsgroupInfo[] listNewsgroups(String string) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.listActive(string))) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public Iterable<String> iterateNewsgroupListing(String string) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.listActive(string))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("LIST ACTIVE " + string + " command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewsgroups(String string) throws IOException {
        return new NewsgroupIterator(this.iterateNewsgroupListing(string));
    }

    public NewsgroupInfo[] listNewNewsgroups(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newgroups(newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return null;
        }
        return this.__readNewsgroupListing();
    }

    public Iterable<String> iterateNewNewsgroupListing(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newgroups(newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWGROUPS command failed: " + this.getReplyString());
    }

    public Iterable<NewsgroupInfo> iterateNewNewsgroups(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        return new NewsgroupIterator(this.iterateNewNewsgroupListing(newGroupsOrNewsQuery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listNewNews(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.newnews(newGroupsOrNewsQuery.getNewsgroups(), newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        try (DotTerminatedMessageReader dotTerminatedMessageReader = new DotTerminatedMessageReader(this._reader_);){
            String string;
            while ((string = ((BufferedReader)dotTerminatedMessageReader).readLine()) != null) {
                vector.addElement(string);
            }
        }
        int n = vector.size();
        if (n < 1) {
            return new String[0];
        }
        Object[] objectArray = new String[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Iterable<String> iterateNewNews(NewGroupsOrNewsQuery newGroupsOrNewsQuery) throws IOException {
        if (NNTPReply.isPositiveCompletion(this.newnews(newGroupsOrNewsQuery.getNewsgroups(), newGroupsOrNewsQuery.getDate(), newGroupsOrNewsQuery.getTime(), newGroupsOrNewsQuery.isGMT(), newGroupsOrNewsQuery.getDistributions()))) {
            return new ReplyIterator(this._reader_);
        }
        throw new IOException("NEWNEWS command failed: " + this.getReplyString());
    }

    public boolean completePendingCommand() throws IOException {
        return NNTPReply.isPositiveCompletion(this.getReply());
    }

    public Writer postArticle() throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.post())) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public Writer forwardArticle(String string) throws IOException {
        if (!NNTPReply.isPositiveIntermediate(this.ihave(string))) {
            return null;
        }
        return new DotTerminatedMessageWriter(this._writer_);
    }

    public boolean logout() throws IOException {
        return NNTPReply.isPositiveCompletion(this.quit());
    }

    public boolean authenticate(String string, String string2) throws IOException {
        int n = this.authinfoUser(string);
        if (n == 381 && (n = this.authinfoPass(string2)) == 281) {
            this._isAllowedToPost = true;
            return true;
        }
        return false;
    }

    private BufferedReader __retrieveArticleInfo(String string) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xover(string))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public BufferedReader retrieveArticleInfo(long l) throws IOException {
        return this.__retrieveArticleInfo(Long.toString(l));
    }

    public BufferedReader retrieveArticleInfo(long l, long l2) throws IOException {
        return this.__retrieveArticleInfo(l + "-" + l2);
    }

    public Iterable<Article> iterateArticleInfo(long l, long l2) throws IOException {
        BufferedReader bufferedReader = this.retrieveArticleInfo(l, l2);
        if (bufferedReader == null) {
            throw new IOException("XOVER command failed: " + this.getReplyString());
        }
        return new ArticleIterator(new ReplyIterator(bufferedReader, false));
    }

    private BufferedReader __retrieveHeader(String string, String string2) throws IOException {
        if (!NNTPReply.isPositiveCompletion(this.xhdr(string, string2))) {
            return null;
        }
        return new DotTerminatedMessageReader(this._reader_);
    }

    public BufferedReader retrieveHeader(String string, long l) throws IOException {
        return this.__retrieveHeader(string, Long.toString(l));
    }

    public BufferedReader retrieveHeader(String string, long l, long l2) throws IOException {
        return this.__retrieveHeader(string, l + "-" + l2);
    }

    @Deprecated
    public Reader retrieveHeader(String string, int n, int n2) throws IOException {
        return this.retrieveHeader(string, (long)n, (long)n2);
    }

    @Deprecated
    public Reader retrieveArticleInfo(int n, int n2) throws IOException {
        return this.retrieveArticleInfo((long)n, (long)n2);
    }

    @Deprecated
    public Reader retrieveHeader(String string, int n) throws IOException {
        return this.retrieveHeader(string, (long)n);
    }

    @Deprecated
    public boolean selectArticle(int n, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        boolean bl = this.selectArticle((long)n, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bl;
    }

    @Deprecated
    public Reader retrieveArticleInfo(int n) throws IOException {
        return this.retrieveArticleInfo((long)n);
    }

    @Deprecated
    public boolean selectArticle(int n) throws IOException {
        return this.selectArticle((long)n);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int n) throws IOException {
        return this.retrieveArticleHeader((long)n);
    }

    @Deprecated
    public Reader retrieveArticleHeader(int n, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticleHeader((long)n, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public Reader retrieveArticleBody(int n) throws IOException {
        return this.retrieveArticleBody((long)n);
    }

    @Deprecated
    public Reader retrieveArticle(int n, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticle((long)n, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public Reader retrieveArticle(int n) throws IOException {
        return this.retrieveArticle((long)n);
    }

    @Deprecated
    public Reader retrieveArticleBody(int n, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticleBody((long)n, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public Reader retrieveArticle(String string, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticle(string, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public Reader retrieveArticleBody(String string, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticleBody(string, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public Reader retrieveArticleHeader(String string, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        BufferedReader bufferedReader = this.retrieveArticleHeader(string, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bufferedReader;
    }

    @Deprecated
    public boolean selectArticle(String string, ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        boolean bl = this.selectArticle(string, articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bl;
    }

    @Deprecated
    public boolean selectArticle(ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        boolean bl = this.selectArticle(articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bl;
    }

    @Deprecated
    public boolean selectNextArticle(ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        boolean bl = this.selectNextArticle(articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bl;
    }

    @Deprecated
    public boolean selectPreviousArticle(ArticlePointer articlePointer) throws IOException {
        ArticleInfo articleInfo = this.__ap2ai(articlePointer);
        boolean bl = this.selectPreviousArticle(articleInfo);
        this.__ai2ap(articleInfo, articlePointer);
        return bl;
    }

    private ArticleInfo __ap2ai(ArticlePointer articlePointer) {
        if (articlePointer == null) {
            return null;
        }
        ArticleInfo articleInfo = new ArticleInfo();
        return articleInfo;
    }

    private void __ai2ap(ArticleInfo articleInfo, ArticlePointer articlePointer) {
        if (articlePointer != null) {
            articlePointer.articleId = articleInfo.articleId;
            articlePointer.articleNumber = (int)articleInfo.articleNumber;
        }
    }
}

