/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import java.io.IOException;

public abstract class ValueInstantiator {
    public Class<?> getValueClass() {
        return Object.class;
    }

    public String getValueTypeDesc() {
        Class<?> clazz = this.getValueClass();
        if (clazz == null) {
            return "UNKNOWN";
        }
        return clazz.getName();
    }

    public boolean canInstantiate() {
        return this.canCreateUsingDefault() || this.canCreateUsingDelegate() || this.canCreateFromObjectWith() || this.canCreateFromString() || this.canCreateFromInt() || this.canCreateFromLong() || this.canCreateFromDouble() || this.canCreateFromBoolean();
    }

    public boolean canCreateFromString() {
        return false;
    }

    public boolean canCreateFromInt() {
        return false;
    }

    public boolean canCreateFromLong() {
        return false;
    }

    public boolean canCreateFromDouble() {
        return false;
    }

    public boolean canCreateFromBoolean() {
        return false;
    }

    public boolean canCreateUsingDefault() {
        return this.getDefaultCreator() != null;
    }

    public boolean canCreateUsingDelegate() {
        return false;
    }

    public boolean canCreateUsingArrayDelegate() {
        return false;
    }

    public boolean canCreateFromObjectWith() {
        return false;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public JavaType getArrayDelegateType(DeserializationConfig deserializationConfig) {
        return null;
    }

    public Object createUsingDefault(DeserializationContext deserializationContext) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no default no-arguments constructor found", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no creator with arguments specified", new Object[0]);
    }

    public Object createFromObjectWith(DeserializationContext deserializationContext, SettableBeanProperty[] settableBeanPropertyArray, PropertyValueBuffer propertyValueBuffer) throws IOException {
        return this.createFromObjectWith(deserializationContext, propertyValueBuffer.getParameters(settableBeanPropertyArray));
    }

    public Object createUsingDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no delegate creator specified", new Object[0]);
    }

    public Object createUsingArrayDelegate(DeserializationContext deserializationContext, Object object) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no array delegate creator specified", new Object[0]);
    }

    public Object createFromString(DeserializationContext deserializationContext, String string) throws IOException {
        return this._createFromStringFallbacks(deserializationContext, string);
    }

    public Object createFromInt(DeserializationContext deserializationContext, int n) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no int/Int-argument constructor/factory method to deserialize from Number value (%s)", n);
    }

    public Object createFromLong(DeserializationContext deserializationContext, long l) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no long/Long-argument constructor/factory method to deserialize from Number value (%s)", l);
    }

    public Object createFromDouble(DeserializationContext deserializationContext, double d) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no double/Double-argument constructor/factory method to deserialize from Number value (%s)", d);
    }

    public Object createFromBoolean(DeserializationContext deserializationContext, boolean bl) throws IOException {
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no boolean/Boolean-argument constructor/factory method to deserialize from boolean value (%s)", bl);
    }

    public AnnotatedWithParams getDefaultCreator() {
        return null;
    }

    public AnnotatedWithParams getDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getArrayDelegateCreator() {
        return null;
    }

    public AnnotatedWithParams getWithArgsCreator() {
        return null;
    }

    public AnnotatedParameter getIncompleteParameter() {
        return null;
    }

    protected Object _createFromStringFallbacks(DeserializationContext deserializationContext, String string) throws IOException {
        if (this.canCreateFromBoolean()) {
            String string2 = string.trim();
            if ("true".equals(string2)) {
                return this.createFromBoolean(deserializationContext, true);
            }
            if ("false".equals(string2)) {
                return this.createFromBoolean(deserializationContext, false);
            }
        }
        if (string.length() == 0 && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return null;
        }
        return deserializationContext.handleMissingInstantiator(this.getValueClass(), deserializationContext.getParser(), "no String-argument constructor/factory method to deserialize from String value ('%s')", string);
    }

    public static class Base
    extends ValueInstantiator {
        protected final Class<?> _valueType;

        public Base(Class<?> clazz) {
            this._valueType = clazz;
        }

        public Base(JavaType javaType) {
            this._valueType = javaType.getRawClass();
        }

        @Override
        public String getValueTypeDesc() {
            return this._valueType.getName();
        }

        @Override
        public Class<?> getValueClass() {
            return this._valueType;
        }
    }
}

