/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.mrbean;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.module.mrbean.BeanBuilder;
import com.fasterxml.jackson.module.mrbean.PackageVersion;
import com.fasterxml.jackson.module.mrbean.TypeBuilder;
import java.lang.reflect.Modifier;

public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "com.fasterxml.jackson.module.mrbean.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "com.fasterxml.jackson.module.mrbean.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(classLoader);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._featureFlags & feature.getMask()) != 0;
    }

    public void enable(Feature feature) {
        this._featureFlags |= feature.getMask();
    }

    public void disable(Feature feature) {
        this._featureFlags &= ~feature.getMask();
    }

    public void set(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
    }

    public void setDefaultPackage(String string) {
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this._defaultPackage = string;
    }

    public JavaType resolveAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (javaType.isContainerType() || javaType.isPrimitive() || javaType.isEnumType() || javaType.isThrowable() || javaType.getRawClass() == Number.class) {
            return null;
        }
        Class clazz = javaType.getRawClass();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            if (this.isEnabled(Feature.FAIL_ON_NON_PUBLIC_TYPES)) {
                throw new IllegalArgumentException("Can not materialize implementation of " + clazz + " since it is not public ");
            }
            return null;
        }
        return deserializationConfig.constructType(this.materializeType((MapperConfig<?>)deserializationConfig, javaType));
    }

    public Class<?> materializeType(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (javaType.containedTypeCount() > 0) {
            return this.materializeGenericType(mapperConfig, javaType);
        }
        return this.materializeRawType(mapperConfig, javaType.getRawClass());
    }

    public Class<?> materializeGenericType(MapperConfig<?> mapperConfig, JavaType javaType) {
        Class clazz = javaType.getRawClass();
        String string = this._defaultPackage + "abstract." + clazz.getName() + "_TYPE_RESOLVE";
        TypeBuilder typeBuilder = new TypeBuilder(javaType);
        byte[] byArray = typeBuilder.buildAbstractBase(string);
        Class<?> clazz2 = this._classLoader.loadAndResolve(string, byArray, clazz);
        return this.materializeRawType(mapperConfig, clazz2);
    }

    public Class<?> materializeRawType(MapperConfig<?> mapperConfig, Class<?> clazz) {
        String string = this._defaultPackage + clazz.getName();
        BeanBuilder beanBuilder = new BeanBuilder(clazz, mapperConfig.getTypeFactory());
        byte[] byArray = beanBuilder.implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(string);
        return this._classLoader.loadAndResolve(string, byArray, clazz);
    }

    @Deprecated
    public Class<?> materializeClass(DeserializationConfig deserializationConfig, JavaType javaType) {
        return this.materializeType((MapperConfig<?>)deserializationConfig, javaType);
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class<?> loadAndResolve(String string, byte[] byArray, Class<?> clazz) throws IllegalArgumentException {
            Class<?> clazz2;
            Class<?> clazz3 = this.findLoadedClass(string);
            if (clazz3 != null && clazz.isAssignableFrom(clazz3)) {
                return clazz3;
            }
            try {
                clazz2 = this.defineClass(string, byArray, 0, byArray.length);
            }
            catch (LinkageError linkageError) {
                throw new IllegalArgumentException("Failed to load class '" + string + "': " + linkageError.getMessage(), linkageError);
            }
            this.resolveClass(clazz2);
            return clazz2;
        }
    }

    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false),
        FAIL_ON_NON_PUBLIC_TYPES(true);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

