/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    @Override
    public final float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return this.paint(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f);
    }

    @Override
    public float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, false, false);
    }

    @Override
    public float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, !bl, false);
    }

    protected void paintBackground(float f, float f2, float f3, float f4, Graphics2D graphics2D, int n, RSyntaxTextArea rSyntaxTextArea, Color color) {
        graphics2D.setColor(color);
        this.bgRect.setRect(f, f2 - (float)n, f3, f4);
        graphics2D.fillRect((int)f, (int)(f2 - (float)n), (int)f3, (int)f4);
    }

    protected float paintImpl(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl, boolean bl2) {
        int n = (int)f;
        int n2 = token.getTextOffset();
        char[] cArray = token.getTextArray();
        int n3 = n2 + token.length();
        float f4 = f;
        int n4 = 0;
        int n5 = n2;
        Color color = bl2 ? rSyntaxTextArea.getSelectedTextColor() : rSyntaxTextArea.getForegroundForToken(token);
        Color color2 = bl ? null : rSyntaxTextArea.getBackgroundForToken(token);
        graphics2D.setFont(rSyntaxTextArea.getFontForTokenType(token.getType()));
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.getType());
        block3: for (int i = n2; i < n3; ++i) {
            switch (cArray[i]) {
                case '\t': {
                    f4 = tabExpander.nextTabStop(f + (float)fontMetrics.charsWidth(cArray, n5, n4), 0);
                    if (color2 != null) {
                        this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
                    }
                    if (n4 > 0) {
                        graphics2D.setColor(color);
                        graphics2D.drawChars(cArray, n5, n4, (int)f, (int)f2);
                        n4 = 0;
                    }
                    n5 = i + 1;
                    f = f4;
                    continue block3;
                }
                default: {
                    ++n4;
                }
            }
        }
        f4 = f + (float)fontMetrics.charsWidth(cArray, n5, n4);
        Rectangle rectangle = rSyntaxTextArea.getMatchRectangle();
        if (n4 > 0 && f4 >= f3) {
            if (color2 != null) {
                this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
            }
            if (token.length() == 1 && rectangle != null && (float)rectangle.x == f) {
                ((RSyntaxTextAreaUI)rSyntaxTextArea.getUI()).paintMatchedBracketImpl(graphics2D, rSyntaxTextArea, rectangle);
            }
            graphics2D.setColor(color);
            graphics2D.drawChars(cArray, n5, n4, (int)f, (int)f2);
        }
        if (rSyntaxTextArea.getUnderlineForToken(token)) {
            graphics2D.setColor(color);
            int n6 = (int)(f2 + 1.0f);
            graphics2D.drawLine(n, n6, (int)f4, n6);
        }
        if (rSyntaxTextArea.getPaintTabLines() && n == rSyntaxTextArea.getMargin().left) {
            this.paintTabLines(token, n, (int)f2, (int)f4, graphics2D, tabExpander, rSyntaxTextArea);
        }
        return f4;
    }

    @Override
    public float paintSelected(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, boolean bl) {
        return this.paintSelected(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f, bl);
    }

    @Override
    public float paintSelected(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, true, bl);
    }

    protected void paintTabLines(Token token, int n, int n2, int n3, Graphics2D graphics2D, TabExpander tabExpander, RSyntaxTextArea rSyntaxTextArea) {
        Token token2;
        int n4;
        if (token.getType() != 21) {
            int n5;
            for (n5 = 0; n5 < token.length() && RSyntaxUtilities.isWhitespace(token.charAt(n5)); ++n5) {
            }
            if (n5 < 2) {
                return;
            }
            n3 = (int)token.getWidthUpTo(n5, rSyntaxTextArea, tabExpander, 0.0f);
        }
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.getType());
        int n6 = rSyntaxTextArea.getTabSize();
        if (tabBuf == null || tabBuf.length < n6) {
            tabBuf = new char[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                DefaultTokenPainter.tabBuf[n4] = 32;
            }
        }
        n4 = fontMetrics.charsWidth(tabBuf, 0, n6);
        graphics2D.setColor(rSyntaxTextArea.getTabLineColor());
        int n7 = n + n4;
        int n8 = n2 - fontMetrics.getAscent();
        if ((n8 & 1) > 0) {
            ++n8;
        }
        if ((token2 = token.getNextToken()) == null || !token2.isPaintable()) {
            ++n3;
        }
        while (n7 < n3) {
            int n9 = n8 + rSyntaxTextArea.getLineHeight();
            for (int i = n8; i < n9; i += 2) {
                graphics2D.drawLine(n7, i, n7, i);
            }
            n7 += n4;
        }
    }
}

