/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.transparent;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import net.java.sip.communicator.plugin.desktoputil.transparent.AWTUtilitiesWrapper;

public class TransparentFrame
extends JFrame
implements RootPaneContainer {
    private static final long serialVersionUID = 0L;
    public static boolean isTranslucencySupported;

    public static TransparentFrame createTransparentFrame() {
        isTranslucencySupported = AWTUtilitiesWrapper.isTranslucencySupported(AWTUtilitiesWrapper.PERPIXEL_TRANSLUCENT);
        GraphicsConfiguration translucencyCapableGC = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (!AWTUtilitiesWrapper.isTranslucencyCapable(translucencyCapableGC)) {
            translucencyCapableGC = null;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            for (int i = 0; i < devices.length && translucencyCapableGC == null; ++i) {
                GraphicsConfiguration[] configs = devices[i].getConfigurations();
                for (int j = 0; j < configs.length && translucencyCapableGC == null; ++j) {
                    if (!AWTUtilitiesWrapper.isTranslucencyCapable(configs[j])) continue;
                    translucencyCapableGC = configs[j];
                }
            }
            if (translucencyCapableGC == null) {
                isTranslucencySupported = false;
            }
        }
        if (isTranslucencySupported) {
            return new TransparentFrame(translucencyCapableGC);
        }
        return new TransparentFrame();
    }

    private TransparentFrame(GraphicsConfiguration gc) {
        super(gc);
        this.setUndecorated(true);
        AWTUtilitiesWrapper.setWindowOpaque(this, false);
        AWTUtilitiesWrapper.setWindowOpacity(this, 1.0f);
    }

    private TransparentFrame() {
        this.setUndecorated(true);
    }
}

