/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.codec.audio.AudioCodec;

public class RateConverter
extends AudioCodec {
    public RateConverter() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR")};
    }

    /*
     * Unable to fully structure code
     */
    private int doByteCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        inData = (byte[])in.getData();
        outData = this.validateByteArraySize(out, outLen);
        outOffset = 0;
        out.setData(outData);
        out.setFormat(this.outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        sum = 0.0;
        outPtr = outOffset;
        inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            d = new byte[step];
            for (inPtr = inOffset; inPtr <= inEnd - step; inPtr += step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                }
                block5: while (true) {
                    sum += ratio;
                    if (!(v0 < 1.0)) break;
                    if (outPtr > outLen - step) continue;
                    i = 0;
                    while (true) {
                        if (i < step) ** break;
                        continue block5;
                        outData[outPtr++] = d[i];
                        ++i;
                    }
                    break;
                }
                sum -= 1.0;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int doIntCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        inData = (int[])in.getData();
        outData = this.validateIntArraySize(out, outLen);
        outOffset = 0;
        out.setData(outData);
        out.setFormat(this.outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        sum = 0.0;
        outPtr = outOffset;
        inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            d = new int[step];
            for (inPtr = inOffset; inPtr <= inEnd - step; inPtr += step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                }
                block5: while (true) {
                    sum += ratio;
                    if (!(v0 < 1.0)) break;
                    if (outPtr > outLen - step) continue;
                    i = 0;
                    while (true) {
                        if (i < step) ** break;
                        continue block5;
                        outData[outPtr++] = d[i];
                        ++i;
                    }
                    break;
                }
                sum -= 1.0;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private int doShortCvrt(Buffer in, int inLen, int inOffset, Buffer out, int outLen, int step, double ratio) {
        inData = (short[])in.getData();
        outData = this.validateShortArraySize(out, outLen);
        outOffset = 0;
        out.setData(outData);
        out.setFormat(this.outputFormat);
        out.setOffset(0);
        out.setLength(outLen);
        sum = 0.0;
        outPtr = outOffset;
        inEnd = inOffset + inLen;
        if (ratio == 1.0) {
            System.arraycopy(inData, inOffset, outData, outOffset, inLen);
            return 0;
        }
        if (ratio > 1.0) {
            while (inPtr <= inEnd - step && outPtr <= outLen - step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                }
                sum += ratio;
                while (sum > 0.0) {
                    inPtr += step;
                    sum -= 1.0;
                }
            }
        } else {
            d = new short[step];
            for (inPtr = inOffset; inPtr <= inEnd - step; inPtr += step) {
                for (i = 0; i < step; ++i) {
                    outData[outPtr++] = inData[inPtr + i];
                    d[i] = inData[inPtr + i];
                }
                block5: while (true) {
                    sum += ratio;
                    if (!(v0 < 1.0)) break;
                    if (outPtr > outLen - step) continue;
                    i = 0;
                    while (true) {
                        if (i < step) ** break;
                        continue block5;
                        outData[outPtr++] = d[i];
                        ++i;
                    }
                    break;
                }
                sum -= 1.0;
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return "Rate Conversion";
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            int ssize = af.getSampleSizeInBits();
            int chnl = af.getChannels();
            int endian = af.getEndian();
            int signed = af.getSigned();
            this.outputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 11025.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 16000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 22050.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 32000.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 44100.0, ssize, chnl, endian, signed), new AudioFormat("LINEAR", 48000.0, ssize, chnl, endian, signed)};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    @Override
    public synchronized int process(Buffer in, Buffer out) {
        if (!this.checkInputBuffer(in)) {
            return 1;
        }
        if (this.isEOM(in)) {
            this.propagateEOM(out);
            return 0;
        }
        int inOffset = in.getOffset();
        int inLen = in.getLength();
        double inRate = ((AudioFormat)this.inputFormat).getSampleRate();
        double outRate = ((AudioFormat)this.outputFormat).getSampleRate();
        int chnl = ((AudioFormat)this.inputFormat).getChannels();
        int bsize = ((AudioFormat)this.inputFormat).getSampleSizeInBits() / 8;
        int step = 0;
        step = chnl == 2 ? (bsize == 2 ? 4 : 2) : (bsize == 2 ? 2 : 1);
        if (outRate == 0.0 || inRate == 0.0) {
            return 1;
        }
        double ratio = inRate / outRate;
        int outLen = (int)((double)(inLen - inOffset) * outRate / inRate + 0.5);
        switch (step) {
            case 2: {
                if (outLen % 2 != 1) break;
                ++outLen;
                break;
            }
            case 4: {
                if (outLen % 4 == 0) break;
                outLen = outLen / 4 + 1 << 2;
            }
        }
        if (this.inputFormat.getDataType() == Format.byteArray) {
            return this.doByteCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        if (this.inputFormat.getDataType() == Format.shortArray) {
            return this.doShortCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        if (this.inputFormat.getDataType() == Format.intArray) {
            return this.doIntCvrt(in, inLen, inOffset, out, outLen, step, ratio);
        }
        return 1;
    }
}

