/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.metahistory;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.mock.MockBasicInstantMessaging;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockOperationSetBasicTelephony;
import net.java.sip.communicator.impl.protocol.mock.MockOperationSetFileTransfer;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.metahistory.MetaHistoryServiceLick;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TestMetaHistoryService
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestMetaHistoryService.class);
    static final String TEST_CONTACT_NAME_1 = "Mincho_Penchev_the_fisrt";
    static final String TEST_CONTACT_NAME_2 = "Mincho_Penchev_the_second";
    public static MockProvider mockProvider = null;
    public static MockPersistentPresenceOperationSet mockPresOpSet = null;
    public static MockOperationSetFileTransfer mockFTOpSet = null;
    public static MockBasicInstantMessaging mockBImOpSet = null;
    public static MockOperationSetBasicTelephony mockBTelphonyOpSet = null;
    private static ServiceReference metaHistoryServiceRef = null;
    public static MetaHistoryService metaHistoryService = null;
    private static MockContact testContact = null;
    private static ServiceReference metaCLref = null;
    private static MetaContactListService metaClService = null;
    private static MetaContact testMetaContact = null;
    public static ServiceRegistration mockPrServiceRegistration = null;
    private static Message[] messagesToSend = null;
    private static Date controlDate1 = null;
    private static Date controlDate2 = null;
    private static Vector<String> participantAddresses = new Vector();
    private static File[] files = null;

    public TestMetaHistoryService(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestMetaHistoryService("messageTests"));
        suite.addTest((Test)new TestMetaHistoryService("callTests"));
        suite.addTest((Test)new TestMetaHistoryService("fileTests"));
        suite.addTest((Test)new TestMetaHistoryService("metaTests"));
        return suite;
    }

    protected void setUp() throws Exception {
        this.setupContact();
        ((MessageHistoryService)ServiceUtils.getService((BundleContext)MetaHistoryServiceLick.bc, MessageHistoryService.class)).eraseLocallyStoredHistory();
        ((HistoryService)ServiceUtils.getService((BundleContext)MetaHistoryServiceLick.bc, HistoryService.class)).purgeLocallyCachedHistories();
        this.writeRecords();
    }

    protected void tearDown() throws Exception {
        this.testPurgeLocalContactListCopy();
    }

    public void setupContact() {
        System.setProperty("HistoryServiceDirectory", "test-filehistory");
        mockProvider = new MockProvider("FileHistoryMockUser");
        Map supportedOperationSets = mockProvider.getSupportedOperationSets();
        mockPresOpSet = (MockPersistentPresenceOperationSet)supportedOperationSets.get(OperationSetPersistentPresence.class.getName());
        mockBTelphonyOpSet = (MockOperationSetBasicTelephony)mockProvider.getOperationSet(OperationSetBasicTelephony.class);
        mockBImOpSet = (MockBasicInstantMessaging)supportedOperationSets.get(OperationSetBasicInstantMessaging.class.getName());
        mockFTOpSet = (MockOperationSetFileTransfer)supportedOperationSets.get(OperationSetFileTransfer.class.getName());
        metaHistoryServiceRef = MetaHistoryServiceLick.bc.getServiceReference(MetaHistoryService.class.getName());
        metaHistoryService = (MetaHistoryService)MetaHistoryServiceLick.bc.getService(metaHistoryServiceRef);
        MockContactGroup root = (MockContactGroup)mockPresOpSet.getServerStoredContactListRoot();
        testContact = new MockContact(TEST_CONTACT_NAME_1, mockProvider);
        root.addContact(testContact);
        metaCLref = MetaHistoryServiceLick.bc.getServiceReference(MetaContactListService.class.getName());
        metaClService = (MetaContactListService)MetaHistoryServiceLick.bc.getService(metaCLref);
        System.setProperty("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        Hashtable<String, String> mockProvProperties = new Hashtable<String, String>();
        mockProvProperties.put("PROTOCOL_NAME", mockProvider.getProtocolName());
        mockProvProperties.put("net.java.sip.communicator.service.contactlist.PROVIDER_MASK", "1");
        mockPrServiceRegistration = MetaHistoryServiceLick.bc.registerService(ProtocolProviderService.class.getName(), (Object)mockProvider, mockProvProperties);
        logger.debug((Object)"Registered a mock protocol provider! ");
        testMetaContact = metaClService.getRoot().getMetaContact((ProtocolProviderService)mockProvider, TEST_CONTACT_NAME_1);
        metaClService.addNewContactToMetaContact((ProtocolProviderService)mockProvider, testMetaContact, TEST_CONTACT_NAME_2);
        messagesToSend = new Message[]{mockBImOpSet.createMessage("test message word1-" + Math.random()), mockBImOpSet.createMessage("test message word2-" + Math.random()), mockBImOpSet.createMessage("test message word3-" + Math.random()), mockBImOpSet.createMessage("test message word4 participant_address_4 t4 -" + Math.random()), mockBImOpSet.createMessage("test message word5-" + Math.random()), mockBImOpSet.createMessage("test message word6 participant_address_1 t1 -" + Math.random())};
        participantAddresses.add("participant_address_1");
        participantAddresses.add("participant_address_2");
        participantAddresses.add("participant_address_3");
        participantAddresses.add("participant_address_4");
        participantAddresses.add("participant_address_5");
        participantAddresses.add("participant_address_6");
        files = new File[]{new File("t1.txt"), new File("t2.txt"), new File("t3.txt"), new File("t4.txt"), new File("t5.txt"), new File("t6.txt")};
    }

    public void writeRecords() {
        logger.info((Object)"write records ");
        TestMetaHistoryService.assertNotNull((String)"No metacontact", (Object)testMetaContact);
        FileTransfer ft = mockFTOpSet.sendFile((Contact)testContact, files[0]);
        this.waitSeconds(200L);
        mockFTOpSet.changeFileTransferStatus(ft, 1);
        TransferListener tl = new TransferListener(files[1].getName(), true, true);
        mockFTOpSet.addFileTransferListener((FileTransferListener)tl);
        this.waitSeconds(200L);
        mockFTOpSet.receiveFile(files[1], (Contact)testContact);
        mockFTOpSet.removeFileTransferListener((FileTransferListener)tl);
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(0));
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(1));
        this.waitSeconds(200L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[0]);
        this.waitSeconds(200L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[1]);
        this.waitSeconds(200L);
        controlDate1 = new Date();
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(2));
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(3));
        this.waitSeconds(200L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[2]);
        this.waitSeconds(200L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[3]);
        this.waitSeconds(200L);
        ft = mockFTOpSet.sendFile((Contact)testContact, files[2]);
        this.waitSeconds(200L);
        mockFTOpSet.changeFileTransferStatus(ft, 0);
        this.waitSeconds(200L);
        tl = new TransferListener(files[3].getName(), false, false);
        mockFTOpSet.addFileTransferListener((FileTransferListener)tl);
        mockFTOpSet.receiveFile(files[3], (Contact)testContact);
        this.waitSeconds(200L);
        mockFTOpSet.removeFileTransferListener((FileTransferListener)tl);
        controlDate2 = new Date();
        this.waitSeconds(200L);
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(4));
        this.waitSeconds(200L);
        this.generateCall(participantAddresses.get(5));
        this.waitSeconds(200L);
        ft = mockFTOpSet.sendFile((Contact)testContact, files[4]);
        this.waitSeconds(200L);
        mockFTOpSet.changeFileTransferStatus(ft, 3);
        this.waitSeconds(200L);
        tl = new TransferListener(files[5].getName(), true, true);
        mockFTOpSet.addFileTransferListener((FileTransferListener)tl);
        this.waitSeconds(200L);
        mockFTOpSet.receiveFile(files[5], (Contact)testContact);
        this.waitSeconds(200L);
        mockFTOpSet.removeFileTransferListener((FileTransferListener)tl);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_1, messagesToSend[4]);
        this.waitSeconds(200L);
        mockBImOpSet.deliverMessage(TEST_CONTACT_NAME_2, messagesToSend[5]);
        this.waitSeconds(200L);
    }

    private void generateCall(String participant) {
        try {
            Call newCall = mockBTelphonyOpSet.placeCall(participant);
            Vector<CallPeer> v = new Vector<CallPeer>();
            Iterator iter = newCall.getCallPeers();
            while (iter.hasNext()) {
                CallPeer item = (CallPeer)iter.next();
                v.add(item);
            }
            this.waitSeconds(2000L);
            for (CallPeer item : v) {
                mockBTelphonyOpSet.hangupCallPeer(item);
            }
        }
        catch (Exception ex1) {
            logger.error((Object)"Cannot place mock call", (Throwable)ex1);
            TestMetaHistoryService.fail((String)("Cannot place mock call to " + participant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSeconds(long secs) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(secs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void messageTests() {
        Collection rs = metaHistoryService.findByKeyword(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, "test");
        TestMetaHistoryService.assertTrue((String)"Nothing found findByKeyword ", (!rs.isEmpty() ? 1 : 0) != 0);
        List<String> msgs = this.getMessages(rs);
        TestMetaHistoryService.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 5 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeyword(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, "Test", false);
        TestMetaHistoryService.assertTrue((String)"Nothing found findByKeyword caseINsensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertTrue((String)"Messages too few - findByKeyword", (msgs.size() >= 5 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeyword(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, "Test", true);
        TestMetaHistoryService.assertFalse((String)"Something found by findByKeyword casesensitive search", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = metaHistoryService.findByEndDate(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate2);
        TestMetaHistoryService.assertTrue((String)"Nothing found findByEndDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertTrue((String)"Messages too few - findByEndDate", (msgs.size() >= 3 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeywords(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"test", "word2"});
        TestMetaHistoryService.assertTrue((String)"Nothing found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertTrue((String)"Messages too few - findByKeywords", (msgs.size() >= 1 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeywords(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"test1", "word2"});
        TestMetaHistoryService.assertFalse((String)"Something found findByKeywords", (!rs.isEmpty() ? 1 : 0) != 0);
        rs = metaHistoryService.findByPeriod(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2);
        TestMetaHistoryService.assertFalse((String)"Nothing found findByPeriod", (boolean)rs.isEmpty());
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 2", (int)2, (int)msgs.size());
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        rs = metaHistoryService.findByPeriod(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2, new String[]{"word3"});
        TestMetaHistoryService.assertTrue((String)"Nothing found findByPeriod", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 1", (int)msgs.size(), (int)1);
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        rs = metaHistoryService.findByStartDate(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate2);
        TestMetaHistoryService.assertTrue((String)"Nothing found findByStartDate", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 2", (int)msgs.size(), (int)2);
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[5].getContent()));
        rs = metaHistoryService.findLast(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, 3);
        TestMetaHistoryService.assertTrue((String)"Nothing found 8", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 3", (int)msgs.size(), (int)3);
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[5].getContent()));
        rs = metaHistoryService.findFirstMessagesAfter(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, 3);
        TestMetaHistoryService.assertTrue((String)"Nothing found 9", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 3", (int)msgs.size(), (int)3);
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[4].getContent()));
        rs = metaHistoryService.findLastMessagesBefore(new String[]{MessageHistoryService.class.getName()}, (Object)testMetaContact, controlDate2, 3);
        TestMetaHistoryService.assertTrue((String)"Nothing found 10", (!rs.isEmpty() ? 1 : 0) != 0);
        msgs = this.getMessages(rs);
        TestMetaHistoryService.assertEquals((String)"Messages must be 3", (int)msgs.size(), (int)3);
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[1].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[2].getContent()));
        TestMetaHistoryService.assertTrue((String)"Message no found", (boolean)msgs.contains(messagesToSend[3].getContent()));
    }

    public void callTests() {
        Collection rs = metaHistoryService.findByEndDate(new String[]{CallHistoryService.class.getName()}, null, controlDate2);
        Iterator<Object> resultIter = this.getCalls(rs).iterator();
        TestMetaHistoryService.assertTrue((String)"Calls too few - findByEndDate", (rs.size() >= 3 ? 1 : 0) != 0);
        rs = metaHistoryService.findByPeriod(new String[]{CallHistoryService.class.getName()}, null, controlDate1, controlDate2);
        resultIter = rs.iterator();
        TestMetaHistoryService.assertEquals((String)"Calls must be 2", (int)rs.size(), (int)2);
        CallRecord rec = (CallRecord)resultIter.next();
        CallPeerRecord participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(2)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(3)));
        rs = metaHistoryService.findByStartDate(new String[]{CallHistoryService.class.getName()}, null, controlDate2);
        resultIter = rs.iterator();
        TestMetaHistoryService.assertEquals((String)"Calls must be 2", (int)rs.size(), (int)2);
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(4)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(5)));
        rs = metaHistoryService.findLast(new String[]{CallHistoryService.class.getName()}, null, 3);
        resultIter = rs.iterator();
        TestMetaHistoryService.assertEquals((String)"Calls must be 3", (int)rs.size(), (int)3);
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(3)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(4)));
        rec = (CallRecord)resultIter.next();
        participant = (CallPeerRecord)rec.getPeerRecords().get(0);
        TestMetaHistoryService.assertTrue((String)"Participant incorrect ", (boolean)participant.getPeerAddress().equals(participantAddresses.get(5)));
    }

    public void fileTests() {
        Collection<FileRecord> rs = this.getFileRecords(metaHistoryService.findByStartDate(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 4", (int)4, (int)rs.size());
        rs = this.getFileRecords(metaHistoryService.findByEndDate(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate2));
        TestMetaHistoryService.assertTrue((String)"FileTransfers too few - findByEndDate", (rs.size() >= 4 ? 1 : 0) != 0);
        rs = this.getFileRecords(metaHistoryService.findByPeriod(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)rs.size(), (int)2);
        Iterator<FileRecord> it = rs.iterator();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)it.next().getFile().getName().equals(files[2].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)it.next().getFile().getName().equals(files[3].getName()));
        rs = this.getFileRecords(metaHistoryService.findByPeriod(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2, new String[]{"t3"}));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 1", (int)rs.size(), (int)1);
        it = rs.iterator();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)it.next().getFile().getName().equals(files[2].getName()));
        rs = this.getFileRecords(metaHistoryService.findByPeriod(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2, new String[]{"T3"}, true));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)rs.size(), (int)0);
        rs = this.getFileRecords(metaHistoryService.findLast(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, 2));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)rs.size(), (int)2);
        it = rs.iterator();
        FileRecord fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[4].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("refused"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("out"));
        fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[5].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("completed"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("in"));
        rs = this.getFileRecords(metaHistoryService.findByKeyword(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, "t3"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers must be atleast 1", (rs.size() > 0 ? 1 : 0) != 0);
        it = rs.iterator();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)it.next().getFile().getName().equals(files[2].getName()));
        rs = this.getFileRecords(metaHistoryService.findByKeyword(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, "T3", true));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)rs.size(), (int)0);
        rs = this.getFileRecords(metaHistoryService.findByKeywords(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"t3"}));
        TestMetaHistoryService.assertTrue((String)"Filetransfers must be atleast 1", (rs.size() > 0 ? 1 : 0) != 0);
        it = rs.iterator();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)it.next().getFile().getName().equals(files[2].getName()));
        rs = this.getFileRecords(metaHistoryService.findByKeywords(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"T3"}, true));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)rs.size(), (int)0);
        rs = this.getFileRecords(metaHistoryService.findFirstMessagesAfter(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, 2));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)rs.size(), (int)2);
        it = rs.iterator();
        fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[2].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("completed"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("out"));
        fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[3].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("active"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("in"));
        rs = this.getFileRecords(metaHistoryService.findLastMessagesBefore(new String[]{FileHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, 2));
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)rs.size(), (int)2);
        it = rs.iterator();
        fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[0].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("canceled"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("out"));
        fr = it.next();
        TestMetaHistoryService.assertTrue((String)"Filetransfers not found", (boolean)fr.getFile().getName().equals(files[1].getName()));
        TestMetaHistoryService.assertTrue((String)"Filetransfers status wrong", (boolean)fr.getStatus().equals("completed"));
        TestMetaHistoryService.assertTrue((String)"Filetransfers direction wrong", (boolean)fr.getDirection().equalsIgnoreCase("in"));
    }

    public void metaTests() {
        Collection rs = metaHistoryService.findByStartDate(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1);
        TestMetaHistoryService.assertEquals((String)"Records must be 12", (int)12, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 4", (int)4, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 4", (int)4, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 4", (int)4, (int)this.getMessages(rs).size());
        rs = metaHistoryService.findByEndDate(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1);
        TestMetaHistoryService.assertTrue((String)"Records must be atleast", (rs.size() >= 6 ? 1 : 0) != 0);
        rs = metaHistoryService.findByPeriod(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2);
        TestMetaHistoryService.assertEquals((String)"Records must be 6", (int)6, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)2, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 2", (int)2, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 2", (int)2, (int)this.getMessages(rs).size());
        rs = metaHistoryService.findByPeriod(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2, new String[]{"t4", "participant_address_4", "word4"});
        TestMetaHistoryService.assertEquals((String)"Records must be 1", (int)1, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)0, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 0", (int)0, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 1", (int)1, (int)this.getMessages(rs).size());
        rs = metaHistoryService.findByPeriod(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, controlDate2, new String[]{"T4", "participant_address_4", "word4"}, true);
        TestMetaHistoryService.assertEquals((String)"Records must be 0", (int)0, (int)rs.size());
        rs = metaHistoryService.findByKeyword(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, "T1");
        TestMetaHistoryService.assertTrue((String)"Records must be atleast 2", (rs.size() >= 2 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeyword(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, "Word6", true);
        TestMetaHistoryService.assertEquals((String)"Records must be 0", (int)0, (int)rs.size());
        rs = metaHistoryService.findByKeywords(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"t4", "participant_address_4", "word4"});
        TestMetaHistoryService.assertTrue((String)"Records must be atleast 1", (rs.size() >= 1 ? 1 : 0) != 0);
        rs = metaHistoryService.findByKeywords(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, new String[]{"T4", "participant_address_4", "word4"}, true);
        TestMetaHistoryService.assertEquals((String)"Records must be 0", (int)0, (int)rs.size());
        rs = metaHistoryService.findLast(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, 4);
        TestMetaHistoryService.assertEquals((String)"Records must be 4", (int)4, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 2", (int)2, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 0", (int)0, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 2", (int)2, (int)this.getMessages(rs).size());
        rs = metaHistoryService.findFirstMessagesAfter(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, 2);
        TestMetaHistoryService.assertEquals((String)"Records must be 2", (int)2, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)0, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 2", (int)2, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 0", (int)0, (int)this.getMessages(rs).size());
        rs = metaHistoryService.findLastMessagesBefore(new String[]{MessageHistoryService.class.getName(), FileHistoryService.class.getName(), CallHistoryService.class.getName()}, (Object)testMetaContact, controlDate1, 2);
        TestMetaHistoryService.assertEquals((String)"Records must be 2", (int)2, (int)rs.size());
        TestMetaHistoryService.assertEquals((String)"Filetransfers must be 0", (int)0, (int)this.getFileRecords(rs).size());
        TestMetaHistoryService.assertEquals((String)"CallRecords must be 0", (int)0, (int)this.getCalls(rs).size());
        TestMetaHistoryService.assertEquals((String)"MessageRecords must be 2", (int)2, (int)this.getMessages(rs).size());
    }

    public void testPurgeLocalContactListCopy() {
        metaClService.purgeLocallyStoredContactListCopy();
    }

    private List<String> getMessages(Collection<Object> rs) {
        Vector<String> result = new Vector<String>();
        for (Object item : rs) {
            if (item instanceof MessageDeliveredEvent) {
                result.add(((MessageDeliveredEvent)item).getSourceMessage().getContent());
                continue;
            }
            if (!(item instanceof MessageReceivedEvent)) continue;
            result.add(((MessageReceivedEvent)item).getSourceMessage().getContent());
        }
        return result;
    }

    private List<CallRecord> getCalls(Collection<Object> rs) {
        Vector<CallRecord> result = new Vector<CallRecord>();
        for (Object item : rs) {
            if (!(item instanceof CallRecord)) continue;
            result.add((CallRecord)item);
        }
        return result;
    }

    private Collection<FileRecord> getFileRecords(Collection<Object> rs) {
        Vector<FileRecord> result = new Vector<FileRecord>();
        for (Object item : rs) {
            if (!(item instanceof FileRecord)) continue;
            result.add((FileRecord)item);
        }
        return result;
    }

    private class TransferListener
    implements FileTransferListener {
        String fileName = null;
        boolean accept = true;
        boolean finishTransfer = true;

        TransferListener(String fileName, boolean accept, boolean finishTransfer) {
            this.fileName = fileName;
            this.accept = accept;
            this.finishTransfer = finishTransfer;
        }

        public void fileTransferRequestReceived(FileTransferRequestEvent event) {
            if (this.accept) {
                FileTransfer ft = event.getRequest().acceptFile(new File(this.fileName));
                if (this.finishTransfer) {
                    mockFTOpSet.changeFileTransferStatus(ft, 0);
                } else {
                    mockFTOpSet.changeFileTransferStatus(ft, 1);
                }
            } else {
                event.getRequest().rejectFile();
            }
        }

        public void fileTransferCreated(FileTransferCreatedEvent event) {
        }

        public void fileTransferRequestRejected(FileTransferRequestEvent event) {
        }

        public void fileTransferRequestCanceled(FileTransferRequestEvent event) {
        }
    }
}

