/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms.SearchChatRoomPanel;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.util.skin.Skinnable;

public class JoinChatRoomDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private SearchChatRoomPanel searchPanel;
    private JButton joinButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.JOIN"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_CHAT_ICON)));
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private ChatRoomProviderWrapper chatRoomProvider;

    public JoinChatRoomDialog(ChatRoomProviderWrapper provider) {
        this.chatRoomProvider = provider;
        this.searchPanel = new SearchChatRoomPanel(this.chatRoomProvider);
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.JOIN_CHAT_ROOM"));
        this.getRootPane().setDefaultButton(this.joinButton);
        this.joinButton.setName("join");
        this.cancelButton.setName("cancel");
        this.joinButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.JOIN"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10));
        this.joinButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttonsPanel.add(this.joinButton);
        this.buttonsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.iconLabel, "West");
        this.getContentPane().add((Component)((Object)this.searchPanel), "Center");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        if (name.equals("service.gui.JOIN")) {
            GuiActivator.getMUCService().joinChatRoom(this.searchPanel.getChatRoomName(), this.chatRoomProvider);
        }
        this.dispose();
    }

    protected void close(boolean escaped) {
        this.cancelButton.doClick();
    }

    public void showDialog() {
        this.setVisible(true);
        this.searchPanel.requestFocusInField();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_CHAT_ICON)));
    }
}

