/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.awt.Image;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.MetaContactRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.call.MetaContactPhoneUtil;

public class MetaUIContact
extends UIContactImpl {
    private static final String AVATAR_DATA_KEY = MetaUIContact.class.getName() + ".avatar";
    private final List<String> searchStrings = new LinkedList<String>();
    private MetaContact metaContact;
    private ContactNode contactNode;
    private UIGroup parentUIGroup;
    boolean subscribed = false;

    public MetaUIContact(MetaContact metaContact) {
        this.metaContact = metaContact;
        this.initSearchStrings();
    }

    public Object getDescriptor() {
        return this.metaContact;
    }

    @Override
    public String getDisplayName() {
        String displayName = this.metaContact.getDisplayName();
        if (displayName == null || displayName.trim().length() == 0) {
            Iterator contactIter = this.metaContact.getContacts();
            int contactCount = 0;
            String address = null;
            while (contactIter.hasNext()) {
                Contact contact = (Contact)contactIter.next();
                ++contactCount;
                displayName = contact.getDisplayName();
                if (displayName != null && displayName.trim().length() != 0) break;
                address = contactCount == 1 ? contact.getAddress() : null;
            }
            if (address != null && address.trim().length() != 0 && (displayName == null || displayName.trim().length() == 0)) {
                displayName = address;
            }
        }
        return displayName;
    }

    public int getSourceIndex() {
        MetaContactGroup parentMetaContactGroup = this.metaContact.getParentMetaContactGroup();
        int groupSourceIndex = 0;
        if (parentMetaContactGroup == null) {
            return -1;
        }
        MetaContactGroup parentGroup = parentMetaContactGroup.getParentMetaContactGroup();
        if (parentGroup != null) {
            groupSourceIndex = parentGroup.indexOf(parentMetaContactGroup) * UIGroup.MAX_CONTACTS;
        }
        return GuiActivator.getContactList().getMetaContactListSource().getIndex() * UIGroup.MAX_GROUPS + groupSourceIndex + parentMetaContactGroup.indexOf(this.metaContact) + 1;
    }

    public Iterator<String> getSearchStrings() {
        return this.searchStrings.iterator();
    }

    @Override
    public ImageIcon getStatusIcon() {
        PresenceStatus status = null;
        Iterator i = this.metaContact.getContacts();
        while (i.hasNext()) {
            Contact protoContact = (Contact)i.next();
            PresenceStatus contactStatus = protoContact.getPresenceStatus();
            if (status == null) {
                status = contactStatus;
                continue;
            }
            status = contactStatus.compareTo(status) > 0 ? contactStatus : status;
        }
        if (status != null) {
            return new ImageIcon(Constants.getStatusIcon(status));
        }
        return null;
    }

    public UIGroup getParentGroup() {
        return this.parentUIGroup;
    }

    public void setParentGroup(UIGroup parentGroup) {
        this.parentUIGroup = parentGroup;
    }

    public UIContactDetail getDefaultContactDetail(Class<? extends OperationSet> opSetClass) {
        List<UIContactDetail> details = this.getContactDetailsForOperationSet(opSetClass);
        return details != null && !details.isEmpty() ? details.get(0) : null;
    }

    public List<UIContactDetail> getContactDetailsForOperationSet(Class<? extends OperationSet> opSetClass) {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        Iterator contacts = this.metaContact.getContactsForOperationSet(opSetClass).iterator();
        while (contacts.hasNext()) {
            resultList.add((UIContactDetail)new MetaContactDetail((Contact)contacts.next()));
        }
        return resultList;
    }

    public List<UIContactDetail> getContactDetails() {
        LinkedList<UIContactDetail> resultList = new LinkedList<UIContactDetail>();
        Iterator contacts = this.metaContact.getContacts();
        while (contacts.hasNext()) {
            resultList.add((UIContactDetail)new MetaContactDetail((Contact)contacts.next()));
        }
        return resultList;
    }

    @Override
    public byte[] getAvatar() {
        return this.metaContact.getAvatar();
    }

    @Override
    public ImageIcon getScaledAvatar(boolean isSelected, int width, int height) {
        byte[] avatarBytes = this.metaContact.getAvatar(true);
        if (avatarBytes == null || avatarBytes.length <= 0) {
            if (!this.subscribed) {
                return ImageUtils.getScaledRoundedIcon((Image)ImageLoader.getImage(ImageLoader.UNAUTHORIZED_CONTACT_PHOTO), (int)width, (int)height);
            }
            return null;
        }
        if (isSelected) {
            return ImageUtils.getScaledRoundedIcon((byte[])avatarBytes, (int)width, (int)height);
        }
        Object[] avatarCache = (Object[])this.metaContact.getData((Object)AVATAR_DATA_KEY);
        ImageIcon avatar = null;
        if (avatarCache != null && avatarCache[0] == avatarBytes) {
            avatar = (ImageIcon)avatarCache[1];
        }
        if (avatar == null) {
            avatar = ImageUtils.getScaledRoundedIcon((byte[])avatarBytes, (int)width, (int)height);
        }
        if (avatarCache == null) {
            if (avatar != null) {
                this.metaContact.setData((Object)AVATAR_DATA_KEY, (Object)new Object[]{avatarBytes, avatar});
            }
        } else {
            avatarCache[0] = avatarBytes;
            avatarCache[1] = avatar;
        }
        return avatar;
    }

    public String getDisplayDetails() {
        String displayDetails = null;
        Iterator protoContacts = this.metaContact.getContacts();
        String subscriptionDetails = null;
        while (protoContacts.hasNext()) {
            Contact protoContact = (Contact)protoContacts.next();
            OperationSetExtendedAuthorizations authOpSet = (OperationSetExtendedAuthorizations)protoContact.getProtocolProvider().getOperationSet(OperationSetExtendedAuthorizations.class);
            if (authOpSet != null && authOpSet.getSubscriptionStatus(protoContact) != null && !authOpSet.getSubscriptionStatus(protoContact).equals((Object)OperationSetExtendedAuthorizations.SubscriptionStatus.Subscribed)) {
                OperationSetExtendedAuthorizations.SubscriptionStatus status = authOpSet.getSubscriptionStatus(protoContact);
                if (status.equals((Object)OperationSetExtendedAuthorizations.SubscriptionStatus.SubscriptionPending)) {
                    subscriptionDetails = GuiActivator.getResources().getI18NString("service.gui.WAITING_AUTHORIZATION");
                    continue;
                }
                if (!status.equals((Object)OperationSetExtendedAuthorizations.SubscriptionStatus.NotSubscribed)) continue;
                subscriptionDetails = GuiActivator.getResources().getI18NString("service.gui.NOT_AUTHORIZED");
                continue;
            }
            if (protoContact.getStatusMessage() != null && protoContact.getStatusMessage().length() > 0) {
                this.subscribed = true;
                displayDetails = protoContact.getStatusMessage();
                break;
            }
            this.subscribed = true;
        }
        if (!(displayDetails != null && displayDetails.length() > 0 || this.subscribed || subscriptionDetails == null || subscriptionDetails.length() <= 0)) {
            displayDetails = subscriptionDetails;
        }
        return displayDetails;
    }

    public ExtendedTooltip getToolTip() {
        ExtendedTooltip tip = new ExtendedTooltip(true);
        byte[] avatarImage = this.metaContact.getAvatar();
        if (avatarImage != null && avatarImage.length > 0) {
            tip.setImage(new ImageIcon(avatarImage));
        }
        tip.setTitle(this.metaContact.getDisplayName());
        this.loadTooltip(tip);
        return tip;
    }

    private void loadTooltip(final ExtendedTooltip tip) {
        Iterator i = this.metaContact.getContacts();
        MetaContactPhoneUtil contactPhoneUtil = MetaContactPhoneUtil.getPhoneUtil((MetaContact)this.metaContact);
        String statusMessage = null;
        boolean isLoading = false;
        while (i.hasNext()) {
            Contact protocolContact = (Contact)i.next();
            if (statusMessage == null && (statusMessage = protocolContact.getStatusMessage()) != null && statusMessage.length() == 0) {
                statusMessage = null;
            }
            if (ConfigurationUtils.isHideAccountStatusSelectorsEnabled()) break;
            ImageIcon protocolStatusIcon = MetaUIContact.getContactPresenceStatusIcon(protocolContact);
            if (protocolStatusIcon != null) {
                protocolStatusIcon = ImageLoader.getIndexedProtocolIcon(protocolStatusIcon.getImage(), protocolContact.getProtocolProvider());
            }
            String contactAddress = protocolContact.getAddress();
            tip.addLine((Icon)protocolStatusIcon, this.filterAddressDisplay(contactAddress));
            this.addContactResourceTooltipLines(tip, protocolContact);
            if (!protocolContact.getProtocolProvider().isRegistered()) continue;
            List phones = contactPhoneUtil.getPhones(protocolContact, new OperationSetServerStoredContactInfo.DetailsResponseListener(){

                public void detailsRetrieved(final Iterator<ServerStoredDetails.GenericDetail> details) {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.detailsRetrieved(details);
                            }
                        });
                        return;
                    }
                    tip.removeAllLines();
                    MetaUIContact.this.loadTooltip(tip);
                }
            }, true);
            if (phones != null) {
                this.addPhoneTooltipLines(tip, phones.iterator());
                continue;
            }
            isLoading = true;
        }
        if (isLoading) {
            tip.addLine(null, GuiActivator.getResources().getI18NString("service.gui.LOADING"));
        }
        if (statusMessage != null) {
            tip.setBottomText(statusMessage);
        }
    }

    private void addContactResourceTooltipLines(ExtendedTooltip tip, Contact protocolContact) {
        Collection contactResources = protocolContact.getResources();
        if (contactResources == null) {
            return;
        }
        for (ContactResource contactResource : contactResources) {
            String resourceName;
            ImageIcon protocolStatusIcon = null;
            if (contactResources.size() > 1) {
                protocolStatusIcon = ImageLoader.getIndexedProtocolIcon(ImageUtils.getBytesInImage((byte[])contactResource.getPresenceStatus().getStatusIcon()), protocolContact.getProtocolProvider());
            }
            String string = resourceName = contactResource.getPriority() >= 0 ? contactResource.getResourceName() + " (" + contactResource.getPriority() + ")" : contactResource.getResourceName();
            if (contactResource.isMobile()) {
                resourceName = resourceName + " " + GuiActivator.getResources().getI18NString("service.gui.ON_MOBILE_TOOLTIP");
            }
            if (protocolStatusIcon == null) {
                tip.addSubLine((Icon)protocolStatusIcon, resourceName, 27);
                continue;
            }
            tip.addSubLine((Icon)protocolStatusIcon, resourceName, 20);
        }
        tip.revalidate();
        tip.repaint();
    }

    private void addPhoneTooltipLines(ExtendedTooltip tip, Iterator<String> phones) {
        while (phones.hasNext()) {
            tip.addSubLine(null, this.filterAddressDisplay(phones.next()), 27);
        }
        tip.revalidate();
        tip.repaint();
    }

    @Override
    public ContactNode getContactNode() {
        return this.contactNode;
    }

    @Override
    public void setContactNode(ContactNode contactNode) {
        this.contactNode = contactNode;
        if (contactNode == null) {
            MetaContactListSource.removeUIContact(this.metaContact);
        }
    }

    private void initSearchStrings() {
        this.searchStrings.add(this.metaContact.getDisplayName());
        Iterator contacts = this.metaContact.getContacts();
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            this.searchStrings.add(contact.getDisplayName());
            this.searchStrings.add(contact.getAddress());
        }
    }

    public JPopupMenu getRightButtonMenu() {
        return new MetaContactRightButtonMenu(this.metaContact);
    }

    public Collection<SIPCommButton> getContactCustomActionButtons() {
        return MetaContactListSource.getContactCustomActionButtons(this);
    }

    private static ImageIcon getContactPresenceStatusIcon(Contact contact) {
        byte[] bytes = contact.getPresenceStatus().getStatusIcon();
        return bytes == null ? null : new ImageIcon(bytes);
    }

    private class MetaContactDetail
    extends UIContactDetailImpl {
        private Contact contact;

        public MetaContactDetail(Contact contact) {
            super(contact.getAddress(), contact.getDisplayName(), MetaUIContact.getContactPresenceStatusIcon(contact), (Object)contact);
            this.contact = contact;
            ProtocolProviderService parentProvider = contact.getProtocolProvider();
            for (Class opSetClass : parentProvider.getSupportedOperationSetClasses()) {
                this.addPreferredProtocolProvider(opSetClass, parentProvider);
                this.addPreferredProtocol(opSetClass, parentProvider.getProtocolName());
            }
        }

        public PresenceStatus getPresenceStatus() {
            return this.contact.getPresenceStatus();
        }
    }
}

