/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.calendar;

import java.util.Map;
import net.java.sip.communicator.service.calendar.FreeBusySateListener;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public interface CalendarService {
    public static final String PNAME_FREE_BUSY_STATUS_DISABLED = "net.java.sip.communicator.service.calendar.FreeBusyStatus.disabled";

    public BusyStatusEnum getStatus();

    public void addFreeBusySateListener(FreeBusySateListener var1);

    public void removeFreeBusySateListener(FreeBusySateListener var1);

    public boolean onThePhoneStatusChanged(Map<ProtocolProviderService, PresenceStatus> var1);

    public Map<ProtocolProviderService, PresenceStatus> getRememberedStatuses();

    public static enum BusyStatusEnum {
        FREE(0L),
        IN_MEETING(1L),
        BUSY(2L),
        OUT_OF_OFFICE(3L);

        private final long value;
        private final Integer priority;

        private BusyStatusEnum(Long value) {
            this.value = value;
            this.priority = null;
        }

        public long getValue() {
            return this.value;
        }

        public static BusyStatusEnum getFromLong(Long value) {
            for (BusyStatusEnum state : BusyStatusEnum.values()) {
                if (state.getValue() != value.longValue()) continue;
                return state;
            }
            return FREE;
        }

        public int getPriority() {
            if (this.priority != null) {
                return this.priority;
            }
            return this.ordinal();
        }
    }
}

