/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Set;
import net.java.sip.communicator.impl.protocol.icq.IcqAccountID;
import net.java.sip.communicator.impl.protocol.icq.IcqActivator;
import net.java.sip.communicator.impl.protocol.icq.InfoRetreiver;
import net.java.sip.communicator.impl.protocol.icq.OperationSetAdHocMultiUserChatIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetBasicInstantMessagingIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetExtendedAuthorizationsIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetFileTransferIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetServerStoredAccountInfoIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetServerStoredContactInfoIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetTypingNotificationsIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetWebAccountRegistrationIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetWebContactInfoIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolIconAimImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolIconIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderFactoryIcqImpl;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.OperationSetWebAccountRegistration;
import net.java.sip.communicator.service.protocol.OperationSetWebContactInfo;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapPacketListener;
import net.kano.joscar.flapcmd.CloseFlapCmd;
import net.kano.joscar.net.ClientConn;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.DefaultAppSession;
import net.kano.joustsim.oscar.DisconnectedStateInfo;
import net.kano.joustsim.oscar.LoginFailureStateInfo;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateInfo;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.loginstatus.AuthFailureInfo;
import net.kano.joustsim.oscar.oscar.loginstatus.LoginFailureInfo;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;

public class ProtocolProviderServiceIcqImpl
extends AbstractProtocolProviderService {
    private static final Logger logger = Logger.getLogger(ProtocolProviderServiceIcqImpl.class);
    private DefaultAppSession session = null;
    private AimSession aimSession = null;
    private AimConnection aimConnection = null;
    private IcbmService icbmService = null;
    private AimConnStateListener aimConnStateListener = null;
    private AimIcbmListener aimIcbmListener = new AimIcbmListener();
    private boolean isInitialized = false;
    private Object initializationLock = new Object();
    private AccountID accountID = null;
    private InfoRetreiver infoRetreiver = null;
    private ProtocolIconIcqImpl icqIcon = new ProtocolIconIcqImpl();
    private ProtocolIconAimImpl aimIcon = new ProtocolIconAimImpl();
    boolean USING_ICQ = true;
    private SecurityAuthority authority = null;
    private RegistrationState lastRegistrationState = null;
    private static final String AIM_DEFAULT_LOGIN_SERVER = "login.oscar.aol.com";
    private static final String ICQ_DEFAULT_LOGIN_SERVER = "login.icq.com";

    public RegistrationState getRegistrationState() {
        if (this.getAimConnection() == null || this.lastRegistrationState == null) {
            return RegistrationState.UNREGISTERED;
        }
        return this.lastRegistrationState;
    }

    private RegistrationState joustSimStateToRegistrationState(State joustSimConnState, StateInfo joustSimConnStateInfo) {
        if (joustSimConnState == State.ONLINE) {
            return RegistrationState.REGISTERED;
        }
        if (joustSimConnState == State.CONNECTING) {
            return RegistrationState.REGISTERING;
        }
        if (joustSimConnState == State.AUTHORIZING) {
            return RegistrationState.AUTHENTICATING;
        }
        if (joustSimConnState == State.CONNECTINGAUTH) {
            return RegistrationState.AUTHENTICATING;
        }
        if (joustSimConnState == State.SIGNINGON) {
            return RegistrationState.REGISTERING;
        }
        if (joustSimConnState == State.DISCONNECTED || joustSimConnState == State.NOTCONNECTED) {
            if (joustSimConnStateInfo != null && joustSimConnStateInfo instanceof DisconnectedStateInfo && !((DisconnectedStateInfo)joustSimConnStateInfo).isOnPurpose()) {
                return RegistrationState.CONNECTION_FAILED;
            }
            return RegistrationState.UNREGISTERED;
        }
        if (joustSimConnState == State.FAILED) {
            LoginFailureInfo lfInfo;
            if (joustSimConnStateInfo != null && joustSimConnStateInfo instanceof LoginFailureStateInfo && (lfInfo = ((LoginFailureStateInfo)joustSimConnStateInfo).getLoginFailureInfo()) instanceof AuthFailureInfo) {
                return RegistrationState.AUTHENTICATION_FAILED;
            }
            return RegistrationState.CONNECTION_FAILED;
        }
        logger.warn((Object)("Unknown state " + joustSimConnState + ". Defaulting to " + RegistrationState.UNREGISTERED));
        return RegistrationState.UNREGISTERED;
    }

    public void register(SecurityAuthority authority) throws OperationFailedException {
        if (authority == null) {
            throw new IllegalArgumentException("The register method needs a valid non-null authority impl  in order to be able and retrieve passwords.");
        }
        this.authority = authority;
        this.connectAndLogin(authority, 0);
    }

    void reconnect(int reasonCode) {
        try {
            this.connectAndLogin(this.authority, reasonCode);
        }
        catch (OperationFailedException ex) {
            this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.CONNECTION_FAILED, -1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndLogin(SecurityAuthority authority, int reasonCode) throws OperationFailedException {
        Object object = this.initializationLock;
        synchronized (object) {
            ProtocolProviderFactoryIcqImpl protocolProviderFactory = null;
            protocolProviderFactory = this.USING_ICQ ? IcqActivator.getIcqProtocolProviderFactory() : IcqActivator.getAimProtocolProviderFactory();
            String password = protocolProviderFactory.loadPassword(this.getAccountID());
            if (password == null) {
                UserCredentials credentials = new UserCredentials();
                credentials.setUserName(this.getAccountID().getUserID());
                credentials = authority.obtainCredentials(this.accountID.getDisplayName(), credentials, reasonCode);
                if (credentials == null) {
                    this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "");
                    return;
                }
                char[] pass = credentials.getPassword();
                if (pass == null) {
                    this.fireRegistrationStateChanged(RegistrationState.UNREGISTERED, RegistrationState.UNREGISTERED, 0, "");
                    return;
                }
                password = new String(pass);
                if (credentials.isPasswordPersistent()) {
                    protocolProviderFactory.storePassword(this.getAccountID(), password);
                }
            }
            this.session = new DefaultAppSession();
            this.aimSession = this.session.openAimSession(new Screenname(this.getAccountID().getUserID()));
            String globalProxyType = IcqActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyType");
            if (globalProxyType != null && globalProxyType.equals(ProxyInfo.ProxyType.HTTP.name())) {
                int proxyPort;
                String globalProxyAddress = IcqActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyAddress");
                String globalProxyPortStr = IcqActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPort");
                try {
                    proxyPort = Integer.parseInt(globalProxyPortStr);
                }
                catch (NumberFormatException ex) {
                    throw new OperationFailedException("Wrong port", 7, (Throwable)ex);
                }
                String globalProxyUsername = IcqActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyUsername");
                String globalProxyPassword = IcqActivator.getConfigurationService().getString("net.java.sip.communicator.service.connectionProxyPassword");
                if (globalProxyAddress == null || globalProxyAddress.length() <= 0) {
                    throw new OperationFailedException("Missing Proxy Address", 7);
                }
                AimConnectionProperties connProps = new AimConnectionProperties(new Screenname(this.getAccountID().getUserID()), password);
                if (this.USING_ICQ) {
                    connProps.setLoginHost(ICQ_DEFAULT_LOGIN_SERVER);
                } else {
                    connProps.setLoginHost(AIM_DEFAULT_LOGIN_SERVER);
                }
                connProps.setLoginPort(443);
                this.aimConnection = this.aimSession.openConnection(connProps);
                this.aimConnection.setProxy(AimProxyInfo.forHttp(globalProxyAddress, proxyPort, globalProxyUsername, globalProxyPassword));
            } else {
                AimConnectionProperties connProps = new AimConnectionProperties(new Screenname(this.getAccountID().getUserID()), password);
                if (this.USING_ICQ) {
                    connProps.setLoginHost(ICQ_DEFAULT_LOGIN_SERVER);
                } else {
                    connProps.setLoginHost(AIM_DEFAULT_LOGIN_SERVER);
                }
                this.aimConnection = this.aimSession.openConnection(connProps);
            }
            this.aimConnStateListener = new AimConnStateListener();
            this.aimConnection.addStateListener(this.aimConnStateListener);
            this.aimConnection.connect();
        }
    }

    public void unregister() {
        this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERING, 0, null);
        if (this.aimConnection != null) {
            this.aimConnection.disconnect(true);
        }
    }

    public boolean isSignalingTransportSecure() {
        return false;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.TCP;
    }

    public String getProtocolName() {
        if (this.USING_ICQ) {
            return "ICQ";
        }
        return "AIM";
    }

    public String getProtocolDisplayName() {
        if (this.USING_ICQ) {
            return "ICQ";
        }
        return "AIM";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String screenname, AccountID accountID) {
        Object object = this.initializationLock;
        synchronized (object) {
            this.accountID = accountID;
            if (IcqAccountID.isAIM(accountID.getAccountProperties())) {
                this.USING_ICQ = false;
            }
            this.addSupportedOperationSet(OperationSetInstantMessageTransform.class, (OperationSet)new OperationSetInstantMessageTransformImpl());
            OperationSetPersistentPresenceIcqImpl persistentPresence = new OperationSetPersistentPresenceIcqImpl(this, screenname);
            this.addSupportedOperationSet(OperationSetPersistentPresence.class, (OperationSet)persistentPresence);
            this.addSupportedOperationSet(OperationSetPresence.class, (OperationSet)persistentPresence);
            this.addSupportedOperationSet(OperationSetBasicInstantMessaging.class, (OperationSet)new OperationSetBasicInstantMessagingIcqImpl(this));
            this.addSupportedOperationSet(OperationSetAdHocMultiUserChat.class, (OperationSet)new OperationSetAdHocMultiUserChatIcqImpl(this));
            this.addSupportedOperationSet(OperationSetTypingNotifications.class, (OperationSet)new OperationSetTypingNotificationsIcqImpl(this));
            if (this.USING_ICQ) {
                this.infoRetreiver = new InfoRetreiver(this, screenname);
                this.addSupportedOperationSet(OperationSetServerStoredContactInfo.class, (OperationSet)new OperationSetServerStoredContactInfoIcqImpl(this.infoRetreiver, this));
                OperationSetServerStoredAccountInfoIcqImpl serverStoredAccountInfoOpSet = new OperationSetServerStoredAccountInfoIcqImpl(this.infoRetreiver, screenname, this);
                this.addSupportedOperationSet(OperationSetServerStoredAccountInfo.class, (OperationSet)serverStoredAccountInfoOpSet);
                this.addSupportedOperationSet(OperationSetWebAccountRegistration.class, (OperationSet)new OperationSetWebAccountRegistrationIcqImpl());
                this.addSupportedOperationSet(OperationSetWebContactInfo.class, (OperationSet)new OperationSetWebContactInfoIcqImpl());
                this.addSupportedOperationSet(OperationSetExtendedAuthorizations.class, (OperationSet)new OperationSetExtendedAuthorizationsIcqImpl(this));
            }
            this.addSupportedOperationSet(OperationSetFileTransfer.class, (OperationSet)new OperationSetFileTransferIcqImpl(this));
            this.isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.initializationLock;
        synchronized (object) {
            this.icbmService = null;
            this.session = null;
            this.aimSession = null;
            this.aimConnection = null;
            this.aimConnStateListener = null;
            this.aimIcbmListener = null;
            this.isInitialized = false;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    private void fireRegistrationStateChanged(State oldJoustSimState, StateInfo oldJoustSimStateInfo, State newJoustSimState, StateInfo newJoustSimStateInfo, int reasonCode, String reason) {
        RegistrationState oldRegistrationState = this.joustSimStateToRegistrationState(oldJoustSimState, oldJoustSimStateInfo);
        RegistrationState newRegistrationState = this.joustSimStateToRegistrationState(newJoustSimState, newJoustSimStateInfo);
        this.fireRegistrationStateChanged(oldRegistrationState, newRegistrationState, reasonCode, reason);
    }

    public void fireRegistrationStateChanged(RegistrationState oldState, RegistrationState newState, int reasonCode, String reason) {
        this.lastRegistrationState = newState;
        super.fireRegistrationStateChanged(oldState, newState, reasonCode, reason);
    }

    protected InfoRetreiver getInfoRetreiver() {
        return this.infoRetreiver;
    }

    protected AimSession getAimSession() {
        return this.aimSession;
    }

    protected AimConnection getAimConnection() {
        return this.aimConnection;
    }

    public ProtocolIcon getProtocolIcon() {
        if (this.USING_ICQ) {
            return this.icqIcon;
        }
        return this.aimIcon;
    }

    public static class ConnectionClosedListener
    implements FlapPacketListener {
        private AimConnection aimConnection = null;
        private static final int REASON_MULTIPLE_LOGINS = 1;
        private static final int REASON_BAD_PASSWORD_A = 4;
        private static final int REASON_BAD_PASSWORD_B = 5;
        private static final int REASON_NON_EXISTING_ICQ_UIN_A = 7;
        private static final int REASON_NON_EXISTING_ICQ_UIN_B = 8;
        private static final int REASON_MANY_CLIENTS_FROM_SAME_IP_A = 21;
        private static final int REASON_MANY_CLIENTS_FROM_SAME_IP_B = 22;
        private static final int REASON_CONNECTION_RATE_EXCEEDED = 24;
        private static final int REASON_CONNECTION_TOO_FAST = 29;
        private static final int REASON_TRY_AGAIN = 30;
        private static final String REASON_STRING_MULTIPLE_LOGINS = "multiple logins (on same UIN)";
        private static final String REASON_STRING_BAD_PASSWORD = "bad password";
        private static final String REASON_STRING_NON_EXISTING_ICQ_UIN = "non-existant UIN";
        private static final String REASON_STRING_MANY_CLIENTS_FROM_SAME_IP = "too many clients from same IP";
        private static final String REASON_STRING_CONNECTION_RATE_EXCEEDED = "Rate exceeded. The server temporarily bans you.";
        private static final String REASON_STRING_CONNECTION_TOO_FAST = "You are reconnecting too fast";
        private static final String REASON_STRING_TRY_AGAIN = "Can't register on ICQ network, try again soon.";
        private static final String REASON_STRING_NOT_SPECIFIED = "Not Specified";

        ConnectionClosedListener(AimConnection aimConnection) {
            this.aimConnection = aimConnection;
        }

        @Override
        public void handleFlapPacket(FlapPacketEvent evt) {
            FlapCommand flapCommand = evt.getFlapCommand();
            if (flapCommand instanceof CloseFlapCmd) {
                CloseFlapCmd closeCmd = (CloseFlapCmd)flapCommand;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("received close command with code : " + closeCmd.getCode()));
                }
                this.aimConnection.disconnect();
            }
        }

        static int convertCodeToRegistrationStateChangeEvent(int reasonCode) {
            switch (reasonCode) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 7: {
                    return 3;
                }
                case 8: {
                    return 3;
                }
                case 21: {
                    return 4;
                }
                case 22: {
                    return 4;
                }
                case 24: {
                    return 5;
                }
                case 29: {
                    return 5;
                }
                case 30: {
                    return 5;
                }
            }
            return -1;
        }

        static String convertCodeToStringReason(int reasonCode) {
            switch (reasonCode) {
                case 1: {
                    return REASON_STRING_MULTIPLE_LOGINS;
                }
                case 4: {
                    return REASON_STRING_BAD_PASSWORD;
                }
                case 5: {
                    return REASON_STRING_BAD_PASSWORD;
                }
                case 7: {
                    return REASON_STRING_NON_EXISTING_ICQ_UIN;
                }
                case 8: {
                    return REASON_STRING_NON_EXISTING_ICQ_UIN;
                }
                case 21: {
                    return REASON_STRING_MANY_CLIENTS_FROM_SAME_IP;
                }
                case 22: {
                    return REASON_STRING_MANY_CLIENTS_FROM_SAME_IP;
                }
                case 24: {
                    return REASON_STRING_CONNECTION_RATE_EXCEEDED;
                }
                case 29: {
                    return REASON_STRING_CONNECTION_TOO_FAST;
                }
                case 30: {
                    return REASON_STRING_TRY_AGAIN;
                }
            }
            return REASON_STRING_NOT_SPECIFIED;
        }

        static int convertAuthCodeToReasonCode(AuthFailureInfo afi) {
            switch (afi.getErrorCode()) {
                case 5: {
                    return 4;
                }
                case 24: {
                    return 24;
                }
                case 29: {
                    return 24;
                }
                case 1: {
                    return 7;
                }
                case 4: {
                    return 8;
                }
                case 16: {
                    return 21;
                }
                case 17: {
                    return 22;
                }
            }
            return -1;
        }
    }

    public static class AimConversationListener
    implements ConversationListener {
        @Override
        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("reveived ConversationEventInfo:" + event));
            }
        }

        @Override
        public void conversationClosed(Conversation co) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"conversation closed");
            }
        }

        @Override
        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"goet other event");
            }
            if (event instanceof TypingInfo) {
                TypingInfo ti = (TypingInfo)event;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("got typing info and state is: " + (Object)((Object)ti.getTypingState())));
                }
            } else if (event instanceof MessageInfo) {
                MessageInfo ti = (MessageInfo)event;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("got message info for msg: " + ti.getMessage()));
                }
            }
        }

        @Override
        public void canSendMessageChanged(Conversation con, boolean canSend) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"can send message event");
            }
        }

        @Override
        public void conversationOpened(Conversation con) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"conversation opened event");
            }
        }

        @Override
        public void sentMessage(Conversation con, MessageInfo minfo) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"sent message event");
            }
        }

        @Override
        public void gotMessage(Conversation con, MessageInfo minfo) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("got message event" + minfo.getMessage().getMessageBody()));
            }
        }
    }

    public static class AimIcbmListener
    implements IcbmListener {
        @Override
        public void newConversation(IcbmService service, Conversation conv) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Received a new conversation event");
            }
            conv.addConversationListener(new AimConversationListener());
        }

        @Override
        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Got a BuddINFO event");
            }
        }

        @Override
        public void sendAutomaticallyFailed(IcbmService service, Message message, Set<Conversation> triedConversations) {
        }
    }

    private class RegisteredEventThread
    extends Thread {
        private RegisteredEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object w;
            Object object = w = new Object();
            synchronized (object) {
                try {
                    w.wait(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ProtocolProviderServiceIcqImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceIcqImpl.this.lastRegistrationState, RegistrationState.REGISTERED, -1, null);
        }
    }

    private class AimConnStateListener
    implements StateListener {
        private AimConnStateListener() {
        }

        @Override
        public void handleStateChange(StateEvent event) {
            LoginFailureInfo loginFailure;
            State newState = event.getNewState();
            State oldState = event.getOldState();
            AimConnection conn = event.getAimConnection();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ICQ protocol provider " + ProtocolProviderServiceIcqImpl.this.getProtocolName() + " changed registration status from " + oldState + " to " + newState));
            }
            int reasonCode = -1;
            String reasonStr = null;
            if (newState == State.ONLINE) {
                ProtocolProviderServiceIcqImpl.this.icbmService = conn.getIcbmService();
                ProtocolProviderServiceIcqImpl.this.icbmService.addIcbmListener(ProtocolProviderServiceIcqImpl.this.aimIcbmListener);
                conn.getInfoService().getOscarConnection().getSnacProcessor().getFlapProcessor().addPacketListener(new ConnectionClosedListener(conn));
            } else if (newState == State.DISCONNECTED) {
                MainBosService service = ProtocolProviderServiceIcqImpl.this.aimConnection.getBosService();
                if (service != null) {
                    int discconectCode = service.getOscarConnection().getLastCloseCode();
                    reasonCode = ConnectionClosedListener.convertCodeToRegistrationStateChangeEvent(discconectCode);
                    reasonStr = ConnectionClosedListener.convertCodeToStringReason(discconectCode);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("The aim Connection was disconnected! with reason : " + reasonStr));
                    }
                }
                if (reasonCode == -1 && event.getNewStateInfo() instanceof DisconnectedStateInfo) {
                    if (((DisconnectedStateInfo)event.getNewStateInfo()).isOnPurpose()) {
                        reasonCode = 0;
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The aim Connection was disconnected!");
                }
            } else if (newState == State.FAILED) {
                if (oldState == State.CONNECTINGAUTH && conn.getLoginService() != null && conn.getLoginService().getOscarConnection() != null && conn.getLoginService().getOscarConnection().getConnectionState() == ClientConn.STATE_RESOLVING) {
                    ProtocolProviderServiceIcqImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceIcqImpl.this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "Disconnected due to assumed DNSSEC failure");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The aim Connection failed! " + event.getNewStateInfo()));
                }
            }
            if (event.getNewStateInfo() instanceof LoginFailureStateInfo && (loginFailure = ((LoginFailureStateInfo)event.getNewStateInfo()).getLoginFailureInfo()) instanceof AuthFailureInfo) {
                AuthFailureInfo afi = (AuthFailureInfo)loginFailure;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("AuthFailureInfo code : " + afi.getErrorCode()));
                }
                int code = ConnectionClosedListener.convertAuthCodeToReasonCode(afi);
                reasonCode = ConnectionClosedListener.convertCodeToRegistrationStateChangeEvent(code);
                reasonStr = ConnectionClosedListener.convertCodeToStringReason(code);
            }
            if (reasonCode == 1) {
                if (ProtocolProviderServiceIcqImpl.this.USING_ICQ) {
                    IcqActivator.getIcqProtocolProviderFactory().storePassword(ProtocolProviderServiceIcqImpl.this.getAccountID(), null);
                } else {
                    IcqActivator.getAimProtocolProviderFactory().storePassword(ProtocolProviderServiceIcqImpl.this.getAccountID(), null);
                }
                ProtocolProviderServiceIcqImpl.this.reconnect(1);
            }
            if (newState == State.ONLINE) {
                ProtocolProviderServiceIcqImpl.this.fireRegistrationStateChanged(ProtocolProviderServiceIcqImpl.this.lastRegistrationState, RegistrationState.FINALIZING_REGISTRATION, -1, null);
                new RegisteredEventThread().start();
            } else {
                ProtocolProviderServiceIcqImpl.this.fireRegistrationStateChanged(oldState, event.getOldStateInfo(), newState, event.getNewStateInfo(), reasonCode, reasonStr);
            }
        }
    }
}

