/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.loc.LocCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class LocRightsCmd
extends LocCommand {
    private static final int TYPE_MAX_INFO_LEN = 1;
    private final int maxInfoLength;

    protected LocRightsCmd(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        this.maxInfoLength = chain.getUShort(1);
    }

    public LocRightsCmd(int maxInfoLength) {
        super(3);
        DefensiveTools.checkRange(maxInfoLength, "maxInfoLength", 0);
        this.maxInfoLength = maxInfoLength;
    }

    public final int getMaxInfoLength() {
        return this.maxInfoLength;
    }

    public void writeData(OutputStream out) throws IOException {
        Tlv.getUShortInstance(1, this.maxInfoLength).write(out);
    }

    public String toString() {
        return "LocRightsCmd: max info length=" + this.maxInfoLength;
    }
}

