/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Arrays;
import javax.net.ServerSocketFactory;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PassiveConnector;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.WaitingForConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SocketStreamInfo;

public abstract class PassiveConnectionController
extends AbstractConnectionController {
    public PassiveConnectionController() {
        this.setConnector(new MyConnector());
    }

    public PassiveConnector getConnector() {
        return (PassiveConnector)super.getConnector();
    }

    protected void initializeBeforeStarting() throws IOException {
    }

    protected abstract void sendRequest() throws IOException;

    protected void handleResolvingState() {
    }

    protected void handleConnectingState() {
        EventPost post = this.getRvConnection().getEventPost();
        RvConnectionInfo connInfo = this.getRvSessionInfo().getConnectionInfo();
        post.fireEvent(new WaitingForConnectionEvent(connInfo.getInternalIP(), connInfo.getPort()));
    }

    protected void prepareStream() throws IOException {
        super.prepareStream();
        this.sendRequest();
    }

    private class MyConnector
    implements PassiveConnector {
        private ServerSocket serverSocket;
        private int localPort = -1;

        private MyConnector() {
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public InetAddress getLocalHost() {
            InetAddress addr = this.serverSocket.getInetAddress();
            if (Arrays.equals(addr.getAddress(), new byte[]{0, 0, 0, 0})) {
                try {
                    return InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return addr;
        }

        public SocketStreamInfo createStream() throws IOException {
            PassiveConnectionController.this.handleConnectingState();
            return new SocketStreamInfo(this.serverSocket.accept().getChannel());
        }

        public void prepareStream() throws IOException {
            ServerSocketFactory ssf = PassiveConnectionController.this.getRvConnection().getSettings().getProxyInfo().getServerSocketFactory();
            this.serverSocket = ssf == null ? ServerSocketChannel.open().socket() : ssf.createServerSocket();
            this.serverSocket.bind(null);
            this.serverSocket.setSoTimeout(6000);
            this.localPort = this.serverSocket.getLocalPort();
        }

        public void checkConnectionInfo() throws Exception {
        }
    }
}

