/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.globalchooser;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutEntry;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.Resources;

public class GlobalShortcutTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private List<GlobalShortcutEntry> shortcuts = new ArrayList<GlobalShortcutEntry>();

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Resources.getString("plugin.keybindings.globalchooser.SHORTCUT_NAME");
            }
            case 1: {
                return Resources.getString("plugin.keybindings.globalchooser.SHORTCUT_PRIMARY");
            }
            case 2: {
                return Resources.getString("plugin.keybindings.globalchooser.SHORTCUT_SECOND");
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    @Override
    public int getRowCount() {
        return this.shortcuts.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getEntryAt(row).getAction();
            }
            case 1: {
                return this.getEntryAt(row).getEditShortcut1() ? "Press key" : GlobalShortcutEntry.getShortcutText(this.getEntryAt(row).getShortcut());
            }
            case 2: {
                return this.getEntryAt(row).getEditShortcut2() ? "Press key" : GlobalShortcutEntry.getShortcutText(this.getEntryAt(row).getShortcut2());
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    public GlobalShortcutEntry getEntryAt(int row) {
        int i = 0;
        for (GlobalShortcutEntry entry : this.shortcuts) {
            if (i == row) {
                return entry;
            }
            ++i;
        }
        throw new IllegalArgumentException("row not found");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    public void ssetValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException("non editable column!");
        }
    }

    public void addEntry(GlobalShortcutEntry entry) {
        this.shortcuts.add(entry);
    }

    public void removeEntry(GlobalShortcutEntry entry) {
        this.shortcuts.remove(entry);
    }

    public List<GlobalShortcutEntry> getEntries() {
        return this.shortcuts;
    }
}

