/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionAdapter;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetPresence
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetPresence.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private OperationSetPresence operationSetPresence = null;
    private String statusMessageRoot = new String("Our status is now: ");
    private static AuthEventCollector authEventCollector = new AuthEventCollector();

    public TestOperationSetPresence(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this ICQ implementation. ");
        }
        this.operationSetPresence = (OperationSetPresence)supportedOperationSets.get(OperationSetPresence.class.getName());
        if (this.operationSetPresence == null) {
            throw new NullPointerException("An implementation of the ICQ service must provide an implementation of at least the one of the Presence Operation Sets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        if (IcqSlickFixture.onlineTestingDisabled) {
            TestSuite suite = new TestSuite();
            suite.addTest((Test)new TestOperationSetPresence("testSupportedStatusSetForCompleteness"));
            return suite;
        }
        TestSuite suite = new TestSuite(TestOperationSetPresence.class);
        suite.addTest((Test)new TestOperationSetPresence("postTestSubscribe"));
        suite.addTest((Test)new TestOperationSetPresence("postTestUnsubscribe"));
        suite.addTest((Test)new TestOperationSetPresence("postTestReceiveAuthorizatinonRequest"));
        return suite;
    }

    public void testSupportedStatusSetForCompleteness() {
        Iterator supportedStatusSetIter = this.operationSetPresence.getSupportedStatusSet();
        LinkedList supportedStatusSet = new LinkedList();
        while (supportedStatusSetIter.hasNext()) {
            supportedStatusSet.add(supportedStatusSetIter.next());
        }
        List requiredStatusSetCopy = (List)IcqStatusEnum.icqStatusSet.clone();
        requiredStatusSetCopy.removeAll(supportedStatusSet);
        int unsupported = requiredStatusSetCopy.size();
        TestOperationSetPresence.assertTrue((String)("There are " + unsupported + " statuses as follows:" + requiredStatusSetCopy), (unsupported == 0 ? 1 : 0) != 0);
    }

    public void testChangingStateToAway() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.AWAY);
    }

    public void testChangingStateToNotAvailable() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.NOT_AVAILABLE);
    }

    public void testChangingStateToDnd() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.DO_NOT_DISTURB);
    }

    public void testChangingStateToInvisible() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.INVISIBLE);
    }

    public void testChangingStateToOccupied() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.OCCUPIED);
    }

    public void testChangingStateToFreeForChat() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.FREE_FOR_CHAT);
    }

    public void testChangingStateToOnline() throws Exception {
        this.subtestStateTransition(IcqStatusEnum.ONLINE);
    }

    public void subtestStateTransition(IcqStatusEnum newStatus) throws Exception {
        logger.trace((Object)" --=== beginning state transition test ===--");
        PresenceStatus oldStatus = this.operationSetPresence.getPresenceStatus();
        String oldStatusMessage = this.operationSetPresence.getCurrentStatusMessage();
        String newStatusMessage = this.statusMessageRoot + newStatus;
        logger.debug((Object)("old status is=" + oldStatus.getStatusName() + " new status=" + newStatus.getStatusName()));
        PresenceStatusEventCollector statusEventCollector = new PresenceStatusEventCollector();
        this.operationSetPresence.addProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        this.operationSetPresence.publishPresenceStatus((PresenceStatus)newStatus, newStatusMessage);
        statusEventCollector.waitForPresEvent(10000L);
        statusEventCollector.waitForStatMsgEvent(10000L);
        if (statusEventCollector.collectedPresEvents.size() == 0) {
            logger.trace((Object)"Will query again status as we haven't received one");
            this.operationSetPresence.queryContactStatus(IcqSlickFixture.icqAccountID.getUserID());
            statusEventCollector.waitForPresEvent(10000L);
        }
        this.operationSetPresence.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)statusEventCollector);
        TestOperationSetPresence.assertEquals((String)"Events dispatched during an event transition.", (int)1, (int)statusEventCollector.collectedPresEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong old status.", (Object)oldStatus, (Object)((ProviderPresenceStatusChangeEvent)statusEventCollector.collectedPresEvents.get(0)).getOldStatus());
        TestOperationSetPresence.assertEquals((String)"A status changed event contained wrong new status.", (Object)newStatus, (Object)((ProviderPresenceStatusChangeEvent)statusEventCollector.collectedPresEvents.get(0)).getNewStatus());
        TestOperationSetPresence.assertEquals((String)"opSet.getPresenceStatus() did not return properly.", (Object)newStatus, (Object)this.operationSetPresence.getPresenceStatus());
        IcqStatusEnum actualStatus = IcqSlickFixture.testerAgent.getBuddyStatus(IcqSlickFixture.icqAccountID.getUserID());
        TestOperationSetPresence.assertEquals((String)"The underlying implementation did not switch to the requested presence status.", (Object)newStatus, (Object)actualStatus);
        TestOperationSetPresence.assertEquals((String)"No status message events.", (int)1, (int)statusEventCollector.collectedStatMsgEvents.size());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong old value.", (Object)oldStatusMessage, (Object)((PropertyChangeEvent)statusEventCollector.collectedStatMsgEvents.get(0)).getOldValue());
        TestOperationSetPresence.assertEquals((String)"A status message event contained wrong new value.", (Object)newStatusMessage, (Object)((PropertyChangeEvent)statusEventCollector.collectedStatMsgEvents.get(0)).getNewValue());
        TestOperationSetPresence.assertEquals((String)"opSet.getCurrentStatusMessage() did not return properly.", (String)newStatusMessage, (String)this.operationSetPresence.getCurrentStatusMessage());
        logger.trace((Object)" --=== finished test ===--");
        this.pauseBetweenStateChanges();
    }

    private void pauseBetweenStateChanges() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Pausing between state changes was interrupted", (Throwable)ex);
        }
    }

    public void testQueryContactStatus() throws Exception {
        logger.debug((Object)"Will Query an AWAY contact.");
        this.subtestQueryContactStatus(1L, (PresenceStatus)IcqStatusEnum.AWAY);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query an NA contact.");
        this.subtestQueryContactStatus(4L, (PresenceStatus)IcqStatusEnum.NOT_AVAILABLE);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query a DND contact.");
        this.subtestQueryContactStatus(2L, (PresenceStatus)IcqStatusEnum.DO_NOT_DISTURB);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query a Free For Chat contact.");
        this.subtestQueryContactStatus(32L, (PresenceStatus)IcqStatusEnum.FREE_FOR_CHAT);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query an Invisible contact.");
        this.subtestQueryContactStatus(256L, (PresenceStatus)IcqStatusEnum.INVISIBLE);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query an Occupied contact.");
        this.subtestQueryContactStatus(16L, (PresenceStatus)IcqStatusEnum.OCCUPIED);
        this.pauseBetweenStateChanges();
        logger.debug((Object)"Will Query an Online contact.");
        this.subtestQueryContactStatus(0x1000000L, (PresenceStatus)IcqStatusEnum.ONLINE);
        this.pauseBetweenStateChanges();
    }

    public void subtestQueryContactStatus(long taStatusLong, PresenceStatus expectedReturn) throws Exception {
        if (!IcqSlickFixture.testerAgent.enterStatus(taStatusLong)) {
            throw new RuntimeException("Tester UserAgent Failed to switch to the " + expectedReturn.getStatusName() + " state.");
        }
        PresenceStatus actualReturn = this.operationSetPresence.queryContactStatus(IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetPresence.assertEquals((String)("Querying a " + expectedReturn.getStatusName() + " state did not return as expected"), (Object)expectedReturn, (Object)actualReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestSubscribe() throws Exception {
        Object obj;
        logger.debug((Object)"Testing Subscription and Subscription Event Dispatch.");
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        logger.trace((Object)"set Auth Handler");
        this.operationSetPresence.setAuthorizationHandler((AuthorizationHandler)authEventCollector);
        AuthEventCollector authEventCollector = TestOperationSetPresence.authEventCollector;
        synchronized (authEventCollector) {
            Object obj2;
            TestOperationSetPresence.authEventCollector.authorizationRequestReason = "Please deny my request!";
            IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr = "First authorization I will Deny!!!";
            IcqSlickFixture.testerAgent.getAuthCmdFactory().ACCEPT = false;
            this.operationSetPresence.subscribe(IcqSlickFixture.testerAgent.getIcqUIN());
            SubscriptionEventCollector moveEvtCollector = new SubscriptionEventCollector();
            this.operationSetPresence.addSubscriptionListener((SubscriptionListener)moveEvtCollector);
            logger.debug((Object)"Waiting for authorization error and authorization response...");
            TestOperationSetPresence.authEventCollector.waitForAuthResponse(15000L);
            TestOperationSetPresence.assertTrue((String)("Error adding buddy not recieved or the buddy(" + IcqSlickFixture.testerAgent.getIcqUIN() + ") doesn't require authorization"), (boolean)TestOperationSetPresence.authEventCollector.isAuthorizationRequestSent);
            TestOperationSetPresence.assertNotNull((String)"Agent haven't received any reason for authorization", (Object)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr);
            TestOperationSetPresence.assertEquals((String)"Error sent request reason is not as the received one", (String)TestOperationSetPresence.authEventCollector.authorizationRequestReason, (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr);
            logger.debug((Object)("authEventCollector.isAuthorizationResponseReceived " + TestOperationSetPresence.authEventCollector.isAuthorizationResponseReceived));
            TestOperationSetPresence.assertTrue((String)"Response not received!", (boolean)TestOperationSetPresence.authEventCollector.isAuthorizationResponseReceived);
            boolean isAcceptedAuthReuest = TestOperationSetPresence.authEventCollector.response.getResponseCode().equals(AuthorizationResponse.ACCEPT);
            TestOperationSetPresence.assertEquals((String)"Response is not as the sent one", (boolean)IcqSlickFixture.testerAgent.getAuthCmdFactory().ACCEPT, (boolean)isAcceptedAuthReuest);
            TestOperationSetPresence.assertNotNull((String)"We didn't receive any reason! ", (Object)TestOperationSetPresence.authEventCollector.authorizationResponseString);
            TestOperationSetPresence.assertEquals((String)"The sent response reason is not as the received one", (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr, (String)TestOperationSetPresence.authEventCollector.authorizationResponseString);
            SubscriptionEventCollector subscriptionEventCollector = moveEvtCollector;
            synchronized (subscriptionEventCollector) {
                moveEvtCollector.waitForEvent(20000L);
                this.operationSetPresence.removeSubscriptionListener((SubscriptionListener)moveEvtCollector);
            }
            Contact c = this.operationSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
            logger.debug((Object)("I will remove " + c + " from group : " + c.getParentContactGroup()));
            UnsubscribeWait unsubscribeEvtCollector = new UnsubscribeWait();
            this.operationSetPresence.addSubscriptionListener((SubscriptionListener)unsubscribeEvtCollector);
            UnsubscribeWait unsubscribeWait = unsubscribeEvtCollector;
            synchronized (unsubscribeWait) {
                this.operationSetPresence.unsubscribe(c);
                logger.debug((Object)"Waiting to be removed...");
                unsubscribeEvtCollector.waitForUnsubscribre(20000L);
                logger.debug((Object)"Received unsubscribed ok or we lost patients!");
                this.operationSetPresence.removeSubscriptionListener((SubscriptionListener)unsubscribeEvtCollector);
            }
            TestOperationSetPresence.authEventCollector.authorizationRequestReason = "Please accept my request!";
            IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr = "Second authorization I will Accept!!!";
            IcqSlickFixture.testerAgent.getAuthCmdFactory().ACCEPT = true;
            TestOperationSetPresence.authEventCollector.isAuthorizationRequestSent = false;
            TestOperationSetPresence.authEventCollector.isAuthorizationResponseReceived = false;
            TestOperationSetPresence.authEventCollector.authorizationResponseString = null;
            logger.debug((Object)("I will add buddy does it exists ?  " + (this.operationSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN()) != null)));
            this.operationSetPresence.addSubscriptionListener((SubscriptionListener)subEvtCollector);
            this.operationSetPresence.subscribe(IcqSlickFixture.testerAgent.getIcqUIN());
            logger.debug((Object)"Waiting ... Subscribe must fail and the authorization process to be trigered again so waiting for auth response ...");
            TestOperationSetPresence.authEventCollector.waitForAuthResponse(15000L);
            TestOperationSetPresence.assertTrue((String)("Error adding buddy not recieved or the buddy(" + IcqSlickFixture.testerAgent.getIcqUIN() + ") doesn't require authorization"), (boolean)TestOperationSetPresence.authEventCollector.isAuthorizationRequestSent);
            TestOperationSetPresence.assertNotNull((String)"Agent haven't received any reason for authorization", (Object)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr);
            TestOperationSetPresence.assertEquals((String)"Error sent request reason", (String)TestOperationSetPresence.authEventCollector.authorizationRequestReason, (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr);
            Object object = obj2 = new Object();
            synchronized (object) {
                logger.debug((Object)"wait for authorization process to be finnished");
                obj2.wait(10000L);
                logger.debug((Object)"Stop waiting!");
            }
            subEvtCollector.waitForEvent(10000L);
            this.operationSetPresence.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        }
        TestOperationSetPresence.assertTrue((String)"Subscription event dispatching failed.", (subEvtCollector.collectedEvents.size() > 0 ? 1 : 0) != 0);
        EventObject evt = null;
        for (EventObject elem : subEvtCollector.collectedEvents) {
            if (!(elem instanceof SubscriptionEvent) || ((SubscriptionEvent)elem).getEventID() != 1) continue;
            evt = elem;
        }
        Object source = null;
        Contact srcContact = null;
        ProtocolProviderService srcProvider = null;
        if (evt instanceof SubscriptionEvent) {
            SubscriptionEvent subEvt = (SubscriptionEvent)evt;
            source = subEvt.getSource();
            srcContact = subEvt.getSourceContact();
            srcProvider = subEvt.getSourceProvider();
        }
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (String)IcqSlickFixture.testerAgent.getIcqUIN(), (String)((Contact)source).getAddress());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (String)IcqSlickFixture.testerAgent.getIcqUIN(), (String)srcContact.getAddress());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider, (Object)srcProvider);
        subEvtCollector.collectedEvents.clear();
        logger.debug((Object)"Testing presence notifications.");
        IcqStatusEnum testerAgentOldStatus = IcqSlickFixture.testerAgent.getPresneceStatus();
        IcqStatusEnum testerAgentNewStatus = IcqStatusEnum.FREE_FOR_CHAT;
        long testerAgentNewStatusLong = 32L;
        if (testerAgentOldStatus.equals((Object)testerAgentNewStatus)) {
            testerAgentNewStatus = IcqStatusEnum.DO_NOT_DISTURB;
            testerAgentNewStatusLong = 2L;
        }
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(IcqSlickFixture.testerAgent.getIcqUIN(), testerAgentNewStatus);
        this.operationSetPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            if (!IcqSlickFixture.testerAgent.enterStatus(testerAgentNewStatusLong)) {
                throw new RuntimeException("Tester UserAgent Failed to switch to the " + testerAgentNewStatus.getStatusName() + " state.");
            }
            contactPresEvtCollector.waitForEvent(12000L);
            this.operationSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        if (contactPresEvtCollector.collectedEvents.size() == 0) {
            Object obj3;
            logger.info((Object)"PROBLEM. Authorisation process doesn't have finnished Server doesn't report us for changing authorization flag! Will try to authorize once again");
            IcqSlickFixture.testerAgent.sendAuthorizationReplay(IcqSlickFixture.icqAccountID.getUserID(), IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr, IcqSlickFixture.testerAgent.getAuthCmdFactory().ACCEPT);
            Object object = obj3 = new Object();
            synchronized (object) {
                logger.debug((Object)"wait for authorization process to be finnished for second time");
                obj3.wait(10000L);
                logger.debug((Object)"Stop waiting!");
            }
            testerAgentOldStatus = IcqSlickFixture.testerAgent.getPresneceStatus();
            testerAgentNewStatusLong = 32L;
            if (testerAgentOldStatus.equals((Object)testerAgentNewStatus)) {
                testerAgentNewStatus = IcqStatusEnum.OCCUPIED;
                testerAgentNewStatusLong = 16L;
            }
            contactPresEvtCollector = new ContactPresenceEventCollector(IcqSlickFixture.testerAgent.getIcqUIN(), testerAgentNewStatus);
            this.operationSetPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
            object = contactPresEvtCollector;
            synchronized (object) {
                if (!IcqSlickFixture.testerAgent.enterStatus(testerAgentNewStatusLong)) {
                    throw new RuntimeException("Tester UserAgent Failed to switch to the " + testerAgentNewStatus.getStatusName() + " state.");
                }
                contactPresEvtCollector.waitForEvent(12000L);
                this.operationSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
            }
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event dispatching failed.", (int)1, (int)contactPresEvtCollector.collectedEvents.size());
        ContactPresenceStatusChangeEvent presEvt = (ContactPresenceStatusChangeEvent)contactPresEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source:", (String)IcqSlickFixture.testerAgent.getIcqUIN(), (String)((Contact)presEvt.getSource()).getAddress());
        TestOperationSetPresence.assertEquals((String)"Presence Notif. event  Source Contact:", (String)IcqSlickFixture.testerAgent.getIcqUIN(), (String)presEvt.getSourceContact().getAddress());
        TestOperationSetPresence.assertSame((String)"Presence Notif. event  Source Provider:", (Object)this.fixture.provider, (Object)presEvt.getSourceProvider());
        PresenceStatus reportedNewStatus = presEvt.getNewStatus();
        PresenceStatus reportedOldStatus = presEvt.getOldStatus();
        TestOperationSetPresence.assertEquals((String)"Reported new PresenceStatus: ", (Object)testerAgentNewStatus, (Object)reportedNewStatus);
        TestOperationSetPresence.assertNotNull((String)"Reported old PresenceStatus: ", (Object)reportedOldStatus);
        Object object = obj = new Object();
        synchronized (object) {
            logger.debug((Object)"wait a moment. give time to server");
            obj.wait(4000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestUnsubscribe() throws Exception {
        logger.debug((Object)"Testing Unsubscribe and unsubscription event dispatch.");
        SubscriptionEventCollector subEvtCollector = new SubscriptionEventCollector();
        this.operationSetPresence.addSubscriptionListener((SubscriptionListener)subEvtCollector);
        Contact icqTesterAgentContact = this.operationSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
        TestOperationSetPresence.assertNotNull((String)"Failed to find an existing subscription for the tester agent", (Object)icqTesterAgentContact);
        SubscriptionEventCollector subscriptionEventCollector = subEvtCollector;
        synchronized (subscriptionEventCollector) {
            this.operationSetPresence.unsubscribe(icqTesterAgentContact);
            subEvtCollector.waitForEvent(40000L);
            this.operationSetPresence.removeSubscriptionListener((SubscriptionListener)subEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Subscription event dispatching failed.", (int)1, (int)subEvtCollector.collectedEvents.size());
        SubscriptionEvent subEvt = (SubscriptionEvent)subEvtCollector.collectedEvents.get(0);
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source:", (Object)icqTesterAgentContact, (Object)subEvt.getSource());
        TestOperationSetPresence.assertEquals((String)"SubscriptionEvent Source Contact:", (Object)icqTesterAgentContact, (Object)subEvt.getSourceContact());
        TestOperationSetPresence.assertSame((String)"SubscriptionEvent Source Provider:", (Object)this.fixture.provider, (Object)subEvt.getSourceProvider());
        subEvtCollector.collectedEvents.clear();
        logger.debug((Object)"Testing (lack of) presence notifications.");
        IcqStatusEnum testerAgentOldStatus = IcqSlickFixture.testerAgent.getPresneceStatus();
        IcqStatusEnum testerAgentNewStatus = IcqStatusEnum.FREE_FOR_CHAT;
        long testerAgentNewStatusLong = 32L;
        if (testerAgentOldStatus.equals((Object)testerAgentNewStatus)) {
            testerAgentNewStatus = IcqStatusEnum.DO_NOT_DISTURB;
            testerAgentNewStatusLong = 2L;
        }
        ContactPresenceEventCollector contactPresEvtCollector = new ContactPresenceEventCollector(IcqSlickFixture.testerAgent.getIcqUIN(), null);
        this.operationSetPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        ContactPresenceEventCollector contactPresenceEventCollector = contactPresEvtCollector;
        synchronized (contactPresenceEventCollector) {
            if (!IcqSlickFixture.testerAgent.enterStatus(testerAgentNewStatusLong)) {
                throw new RuntimeException("Tester UserAgent Failed to switch to the " + testerAgentNewStatus.getStatusName() + " state.");
            }
            contactPresEvtCollector.waitForEvent(10000L);
            this.operationSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)contactPresEvtCollector);
        }
        TestOperationSetPresence.assertEquals((String)"Presence Notifications were received after unsubscibing.", (int)0, (int)contactPresEvtCollector.collectedEvents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestReceiveAuthorizatinonRequest() {
        Object lock;
        logger.debug((Object)"Testing receive of authorization request!");
        String firstRequestResponse = "First Request will be denied!!!";
        TestOperationSetPresence.authEventCollector.responseToRequest = new AuthorizationResponse(AuthorizationResponse.REJECT, firstRequestResponse);
        logger.debug((Object)("authEventCollector " + authEventCollector));
        TestOperationSetPresence.authEventCollector.isAuthorizationRequestReceived = false;
        TestOperationSetPresence.authEventCollector.authorizationRequestReason = null;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr = "Deny my first request!";
        IcqSlickFixture.testerAgent.getAuthCmdFactory().isErrorAddingReceived = false;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr = null;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().isRequestAccepted = false;
        IcqSlickFixture.testerAgent.deleteBuddy(this.fixture.ourUserID);
        IcqSlickFixture.testerAgent.addBuddy(this.fixture.ourUserID);
        authEventCollector.waitForAuthRequest(25000L);
        TestOperationSetPresence.assertTrue((String)("Error adding buddy not recieved or the buddy(" + this.fixture.ourUserID + ") doesn't require authorization 1"), (boolean)IcqSlickFixture.testerAgent.getAuthCmdFactory().isErrorAddingReceived);
        TestOperationSetPresence.assertTrue((String)"We haven't received any authorization request ", (boolean)TestOperationSetPresence.authEventCollector.isAuthorizationRequestReceived);
        TestOperationSetPresence.assertNotNull((String)"We haven't received any reason for authorization", (Object)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        TestOperationSetPresence.assertEquals((String)"Error sent request reason is not as the received one", (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr, (String)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestOperationSetPresence.assertNotNull((String)"Agent haven't received any reason from authorization reply", (Object)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        TestOperationSetPresence.assertEquals((String)"Received auth response from agent is not as the sent one", (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr, (String)firstRequestResponse);
        boolean isAcceptedAuthReuest = TestOperationSetPresence.authEventCollector.responseToRequest.getResponseCode().equals(AuthorizationResponse.ACCEPT);
        TestOperationSetPresence.assertEquals((String)"Agent received Response is not as the sent one", (boolean)IcqSlickFixture.testerAgent.getAuthCmdFactory().isRequestAccepted, (boolean)isAcceptedAuthReuest);
        IcqSlickFixture.testerAgent.deleteBuddy(this.fixture.ourUserID);
        String secondRequestResponse = "Second Request will be accepted!!!";
        TestOperationSetPresence.authEventCollector.responseToRequest = new AuthorizationResponse(AuthorizationResponse.ACCEPT, secondRequestResponse);
        TestOperationSetPresence.authEventCollector.isAuthorizationRequestReceived = false;
        TestOperationSetPresence.authEventCollector.authorizationRequestReason = null;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr = "Accept my second request!";
        IcqSlickFixture.testerAgent.getAuthCmdFactory().isErrorAddingReceived = false;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr = null;
        IcqSlickFixture.testerAgent.getAuthCmdFactory().isRequestAccepted = false;
        IcqSlickFixture.testerAgent.addBuddy(this.fixture.ourUserID);
        authEventCollector.waitForAuthRequest(25000L);
        TestOperationSetPresence.assertTrue((String)("Error adding buddy not recieved or the buddy(" + this.fixture.ourUserID + ") doesn't require authorization 2"), (boolean)IcqSlickFixture.testerAgent.getAuthCmdFactory().isErrorAddingReceived);
        TestOperationSetPresence.assertTrue((String)"We haven't received any authorization request ", (boolean)TestOperationSetPresence.authEventCollector.isAuthorizationRequestReceived);
        TestOperationSetPresence.assertNotNull((String)"We haven't received any reason for authorization", (Object)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        TestOperationSetPresence.assertEquals((String)"Error sent request reason is not as the received one", (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().requestReasonStr, (String)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        Object object2 = lock;
        synchronized (object2) {
            try {
                lock.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TestOperationSetPresence.assertNotNull((String)"Agent haven't received any reason from authorization reply", (Object)TestOperationSetPresence.authEventCollector.authorizationRequestReason);
        TestOperationSetPresence.assertEquals((String)"Received auth response from agent is not as the sent one", (String)IcqSlickFixture.testerAgent.getAuthCmdFactory().responseReasonStr, (String)secondRequestResponse);
        isAcceptedAuthReuest = TestOperationSetPresence.authEventCollector.responseToRequest.getResponseCode().equals(AuthorizationResponse.ACCEPT);
        TestOperationSetPresence.assertEquals((String)"Agent received Response is not as the sent one", (boolean)IcqSlickFixture.testerAgent.getAuthCmdFactory().isRequestAccepted, (boolean)isAcceptedAuthReuest);
    }

    private static class UnsubscribeWait
    extends SubscriptionAdapter {
        private UnsubscribeWait() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForUnsubscribre(long waitFor) {
            UnsubscribeWait unsubscribeWait = this;
            synchronized (unsubscribeWait) {
                try {
                    ((Object)((Object)this)).wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionRemoved(SubscriptionEvent evt) {
            UnsubscribeWait unsubscribeWait = this;
            synchronized (unsubscribeWait) {
                logger.debug((Object)("Got subscriptionRemoved " + evt));
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    private static class AuthEventCollector
    implements AuthorizationHandler {
        boolean isAuthorizationRequestSent = false;
        String authorizationRequestReason = null;
        boolean isAuthorizationResponseReceived = false;
        AuthorizationResponse response = null;
        String authorizationResponseString = null;
        AuthorizationResponse responseToRequest = null;
        boolean isAuthorizationRequestReceived = false;

        private AuthEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthorizationResponse processAuthorisationRequest(AuthorizationRequest req, Contact sourceContact) {
            logger.debug((Object)("Processing in " + this));
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                Object lock;
                logger.trace((Object)("processAuthorisationRequest " + req + " " + sourceContact));
                this.isAuthorizationRequestReceived = true;
                this.authorizationRequestReason = req.getReason();
                this.notifyAll();
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.responseToRequest;
            }
        }

        public AuthorizationRequest createAuthorizationRequest(Contact contact) {
            logger.trace((Object)("createAuthorizationRequest " + contact));
            AuthorizationRequest authReq = new AuthorizationRequest();
            authReq.setReason(this.authorizationRequestReason);
            this.isAuthorizationRequestSent = true;
            return authReq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processAuthorizationResponse(AuthorizationResponse response, Contact sourceContact) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                this.isAuthorizationResponseReceived = true;
                this.response = response;
                this.authorizationResponseString = response.getReason();
                logger.trace((Object)("processAuthorizationResponse '" + this.authorizationResponseString + "' " + response.getResponseCode() + " " + sourceContact));
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAuthResponse(long waitFor) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                if (this.isAuthorizationResponseReceived) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAuthRequest(long waitFor) {
            AuthEventCollector authEventCollector = this;
            synchronized (authEventCollector) {
                if (this.isAuthorizationRequestReceived) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }
    }

    private class ContactPresenceEventCollector
    implements ContactPresenceStatusListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();
        private String trackedScreenName = null;
        private IcqStatusEnum status = null;

        ContactPresenceEventCollector(String screenname, IcqStatusEnum wantedStatus) {
            this.trackedScreenName = screenname;
            this.status = wantedStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            ContactPresenceEventCollector contactPresenceEventCollector = this;
            synchronized (contactPresenceEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
            ContactPresenceEventCollector contactPresenceEventCollector = this;
            synchronized (contactPresenceEventCollector) {
                if (this.trackedScreenName != null && !evt.getSourceContact().getAddress().equals(this.trackedScreenName)) {
                    return;
                }
                if (this.status != null && this.status != evt.getNewStatus()) {
                    return;
                }
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }

    private class SubscriptionEventCollector
    implements SubscriptionListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();

        private SubscriptionEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionCreated(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionRemoved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactModified(ContactPropertyChangeEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionMoved(SubscriptionMovedEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionFailed(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscriptionResolved(SubscriptionEvent evt) {
            SubscriptionEventCollector subscriptionEventCollector = this;
            synchronized (subscriptionEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }

    private class PresenceStatusEventCollector
    implements ProviderPresenceStatusListener {
        public ArrayList<EventObject> collectedPresEvents = new ArrayList();
        public ArrayList<EventObject> collectedStatMsgEvents = new ArrayList();

        private PresenceStatusEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedPresEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void providerStatusMessageChanged(PropertyChangeEvent evt) {
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                logger.debug((Object)("Collected stat.msg. evt(" + this.collectedPresEvents.size() + ")= " + evt));
                this.collectedStatMsgEvents.add(evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForPresEvent(long waitFor) {
            logger.trace((Object)"Waiting for a change in provider status.");
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                if (this.collectedPresEvents.size() > 0) {
                    logger.trace((Object)("Change already received. " + this.collectedPresEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedPresEvents.size() > 0) {
                        logger.trace((Object)"Received a change in provider status.");
                    } else {
                        logger.trace((Object)("No change received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a provider evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStatMsgEvent(long waitFor) {
            logger.trace((Object)"Waiting for a provider status message event.");
            PresenceStatusEventCollector presenceStatusEventCollector = this;
            synchronized (presenceStatusEventCollector) {
                if (this.collectedStatMsgEvents.size() > 0) {
                    logger.trace((Object)("Stat msg. evt already received. " + this.collectedStatMsgEvents));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedStatMsgEvents.size() > 0) {
                        logger.trace((Object)"Received a prov. stat. msg. evt.");
                    } else {
                        logger.trace((Object)("No prov. stat msg. received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a status msg evt", (Throwable)ex);
                }
            }
        }
    }
}

