/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class LastActivity
extends IQ {
    private static final Logger LOGGER = Logger.getLogger(LastActivity.class.getName());
    public long lastActivity = -1L;
    public String message;

    public LastActivity() {
        this.setType(IQ.Type.GET);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"jabber:iq:last\"");
        if (this.lastActivity != -1L) {
            buf.append(" seconds=\"").append(this.lastActivity).append("\"");
        }
        buf.append("></query>");
        return buf.toString();
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    public long getIdleTime() {
        return this.lastActivity;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public static LastActivity getLastActivity(Connection con, String jid) throws XMPPException {
        LastActivity activity = new LastActivity();
        jid = StringUtils.parseBareAddress(jid);
        activity.setTo(jid);
        return (LastActivity)con.createPacketCollectorAndSend(activity).nextResultOrThrow();
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            if (parser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            LastActivity lastActivity = new LastActivity();
            try {
                String seconds = parser.getAttributeValue("", "seconds");
                String message = parser.nextText();
                if (seconds != null) {
                    long xmlSeconds = new Double(seconds).longValue();
                    lastActivity.setLastActivity((int)xmlSeconds);
                }
                if (message != null) {
                    lastActivity.setMessage(message);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
            return lastActivity;
        }
    }
}

