/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.exceptions.NotConnected;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Error
extends Message {
    Error() {
    }

    public Error(String string, String string2, long l, String string3, Object ... objectArray) throws DBusException {
        this(null, string, string2, l, string3, objectArray);
    }

    public Error(String string, String string2, String string3, long l, String string4, Object ... objectArray) throws DBusException {
        super((byte)66, (byte)3, (byte)0);
        if (null == string3) {
            throw new MessageFormatException(Gettext._("Must specify error name to Errors."));
        }
        this.headers.put((byte)5, l);
        this.headers.put((byte)4, string3);
        Vector<Object[]> vector = new Vector<Object[]>();
        vector.add(new Object[]{(byte)4, new Object[]{"s", string3}});
        vector.add(new Object[]{(byte)5, new Object[]{"u", l}});
        if (null != string) {
            this.headers.put((byte)7, string);
            vector.add(new Object[]{(byte)7, new Object[]{"s", string}});
        }
        if (null != string2) {
            this.headers.put((byte)6, string2);
            vector.add(new Object[]{(byte)6, new Object[]{"s", string2}});
        }
        if (null != string4) {
            vector.add(new Object[]{(byte)8, new Object[]{"g", string4}});
            this.headers.put((byte)8, string4);
            this.setArgs(objectArray);
        }
        byte[] byArray = new byte[4];
        this.appendBytes(byArray);
        this.append("ua(yv)", this.serial, vector.toArray());
        this.pad((byte)8);
        long l2 = this.bytecounter;
        if (null != string4) {
            this.append(string4, objectArray);
        }
        this.marshallint(this.bytecounter - l2, byArray, 0, 4);
    }

    public Error(String string, Message message, Throwable throwable) throws DBusException {
        this(string, message.getSource(), AbstractConnection.dollar_pattern.matcher(throwable.getClass().getName()).replaceAll("."), message.getSerial(), "s", throwable.getMessage());
    }

    public Error(Message message, Throwable throwable) throws DBusException {
        this(message.getSource(), AbstractConnection.dollar_pattern.matcher(throwable.getClass().getName()).replaceAll("."), message.getSerial(), "s", throwable.getMessage());
    }

    private static Class<? extends DBusExecutionException> createExceptionClass(String string) {
        if (string == "org.freedesktop.DBus.Local.Disconnected") {
            return NotConnected.class;
        }
        Class<?> clazz = null;
        do {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            string = string.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == clazz && string.matches(".*\\..*"));
        return clazz;
    }

    public DBusExecutionException getException() {
        try {
            DBusExecutionException dBusExecutionException;
            Class<? extends DBusExecutionException> clazz = Error.createExceptionClass(this.getName());
            if (null == clazz || !DBusExecutionException.class.isAssignableFrom(clazz)) {
                clazz = DBusExecutionException.class;
            }
            Constructor<? extends DBusExecutionException> constructor = clazz.getConstructor(String.class);
            Object[] objectArray = this.getParameters();
            if (null == objectArray || 0 == objectArray.length) {
                dBusExecutionException = constructor.newInstance("");
            } else {
                String string = "";
                for (Object object : objectArray) {
                    string = string + object + " ";
                }
                dBusExecutionException = constructor.newInstance(string.trim());
            }
            dBusExecutionException.setType(this.getName());
            return dBusExecutionException;
        }
        catch (Exception exception) {
            DBusExecutionException dBusExecutionException;
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            Object[] objectArray = null;
            try {
                objectArray = this.getParameters();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (null == objectArray || 0 == objectArray.length) {
                dBusExecutionException = new DBusExecutionException("");
            } else {
                String string = "";
                for (Object object : objectArray) {
                    string = string + object + " ";
                }
                dBusExecutionException = new DBusExecutionException(string.trim());
            }
            dBusExecutionException.setType(this.getName());
            return dBusExecutionException;
        }
    }

    public void throwException() throws DBusExecutionException {
        throw this.getException();
    }
}

