/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.Writable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtraInfoData
implements Writable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_HASH_PRESENT = 1;
    public static final int FLAG_UPLOAD_ICON = 64;
    public static final int FLAG_ALREADY_HAVE_ICON = 128;
    public static final int FLAG_AVAILMSG_PRESENT = 4;
    public static final ByteBlock HASH_SPECIAL = ByteBlock.wrap(new byte[]{2, 1, -46, 4, 114});
    private final int flags;
    private final ByteBlock data;
    private final int totalSize;

    @NotNull
    public static ExtraInfoData getAvailableMessageBlock(@NotNull String message) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(message.length() + 10);
        try {
            byte[] bytes = message.getBytes("UTF-8");
            BinaryTools.writeUShort(bout, bytes.length);
            bout.write(bytes);
            BinaryTools.writeUShort(bout, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ExtraInfoData(4, ByteBlock.wrap(bout.toByteArray()));
    }

    @NotNull
    public static ExtraInfoData getItunesUrlBlock(@Nullable String band, @Nullable String album, @Nullable String song) {
        return ExtraInfoData.getAvailableMessageBlock(ExtraInfoData.buildItunesUrl(band, album, song));
    }

    @NotNull
    public static String readAvailableMessage(ExtraInfoData data) {
        ByteBlock msgBlock = data.getData();
        int len = BinaryTools.getUShort(msgBlock, 0);
        if (len == -1) {
            return "";
        }
        byte[] msgBytes = msgBlock.subBlock(2, len).toByteArray();
        try {
            return new String(msgBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException impossible) {
            throw new IllegalStateException(impossible);
        }
    }

    public static String buildItunesUrl(@Nullable String band, @Nullable String album, @Nullable String song) {
        StringBuilder buf = new StringBuilder();
        buf.append("itms://itunes.com/link?");
        boolean and = ExtraInfoData.appendParamIfNotNull(buf, "n=", song, false);
        and = ExtraInfoData.appendParamIfNotNull(buf, "an=", band, and);
        ExtraInfoData.appendParamIfNotNull(buf, "pn=", album, and);
        return buf.toString();
    }

    private static boolean appendParamIfNotNull(StringBuilder buf, String key, String value, boolean and) {
        if (value != null) {
            try {
                if (and) {
                    buf.append('&');
                }
                buf.append(key).append('=').append(URLEncoder.encode(value, "UTF-8"));
                return true;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    @Nullable
    public static ExtraInfoData readExtraInfoData(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() < 2) {
            return null;
        }
        short code = BinaryTools.getUByte(block, 0);
        short len = BinaryTools.getUByte(block, 1);
        if (block.getLength() < len + 2) {
            return null;
        }
        ByteBlock hash = block.subBlock(2, len);
        return new ExtraInfoData(code, hash, 2 + len);
    }

    private ExtraInfoData(int code, ByteBlock data, int totalSize) throws IllegalArgumentException {
        DefensiveTools.checkRange(code, "code", 0);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        DefensiveTools.checkRange(data.getLength(), "data length", 0, 255);
        this.flags = code;
        this.data = data;
        this.totalSize = totalSize;
    }

    public ExtraInfoData(int flags, ByteBlock data) throws IllegalArgumentException {
        this(flags, data, -1);
    }

    public final int getFlags() {
        return this.flags;
    }

    public final ByteBlock getData() {
        return this.data;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public long getWritableLength() {
        return 2L + (this.data == null ? 0L : this.data.getWritableLength());
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUByte(out, this.flags);
        if (this.data != null) {
            BinaryTools.writeUByte(out, this.data.getLength());
            this.data.write(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtraInfoData that = (ExtraInfoData)o;
        if (this.flags != that.flags) {
            return false;
        }
        return !(this.data != null ? !this.data.equals(that.data) : that.data != null);
    }

    public int hashCode() {
        int result = this.flags;
        result = 29 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExtraInfoData: flags=0x" + Integer.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(ExtraInfoData.class, this.flags, "FLAG_.*") + ")" + ", data=" + BinaryTools.describeData(this.data);
    }
}

