/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.netaddr;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import junit.framework.TestCase;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.slick.netaddr.NetworkAddressManagerServiceLick;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestNetworkAddressManagerService
extends TestCase {
    private NetworkAddressManagerService networkAddressManagerService = null;
    private static final String PROP_STUN_SERVER_ADDR = "net.java.sip.communicator.STUN_SERVER_ADDRESS";
    private static final String PROP_STUN_SERVER_PORT = "net.java.sip.communicator.STUN_SERVER_PORT";
    private static final String PROP_PREFERRED_NET_IFACE = "net.java.sip.communicator.PREFERRED_NETWORK_INTERFACE";
    private static final String PROP_PREFERRED_NET_ADDR = "net.java.sip.communicator.PREFERRED_NETWORK_ADDRESS";
    private ConfigurationService configurationService = null;

    public TestNetworkAddressManagerService(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        BundleContext context = NetworkAddressManagerServiceLick.bc;
        ServiceReference confRef = context.getServiceReference(ConfigurationService.class.getName());
        this.configurationService = (ConfigurationService)context.getService(confRef);
        ServiceReference netRef = context.getServiceReference(NetworkAddressManagerService.class.getName());
        this.networkAddressManagerService = (NetworkAddressManagerService)context.getService(netRef);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private static boolean isLocalInterfaceAddress(InetAddress address) {
        try {
            Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
            while (intfs.hasMoreElements()) {
                NetworkInterface intf = intfs.nextElement();
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    try {
                        InetAddress addr = addrs.nextElement();
                        if (!addr.equals(address)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isLocalInterfaceAddressIPv4(InetAddress address) {
        if (address instanceof Inet4Address) {
            return TestNetworkAddressManagerService.isLocalInterfaceAddress(address);
        }
        return false;
    }

    private static boolean isLocalInterfaceAddressIPv6(InetAddress address) {
        if (address instanceof Inet6Address) {
            return TestNetworkAddressManagerService.isLocalInterfaceAddress(address);
        }
        return false;
    }

    public void testDummyTest() {
    }

    private static boolean isLinkLocalIPv4Address(InetAddress add) {
        if (add instanceof Inet4Address) {
            byte[] address = add.getAddress();
            if ((address[0] & 0xFF) == 10) {
                return true;
            }
            if ((address[0] & 0xFF) == 172 && (address[1] & 0xFF) >= 16 && address[1] <= 31) {
                return true;
            }
            return (address[0] & 0xFF) == 192 && (address[1] & 0xFF) == 168;
        }
        return false;
    }

    private static boolean isRoutable(InetAddress address) {
        if (address instanceof Inet6Address) {
            return !address.isLoopbackAddress() && !address.isLinkLocalAddress();
        }
        return !address.isLoopbackAddress() && !TestNetworkAddressManagerService.isWindowsAutoConfiguredIPv4Address(address);
    }

    private static boolean isWindowsAutoConfiguredIPv4Address(InetAddress add) {
        return (add.getAddress()[0] & 0xFF) == 169 && (add.getAddress()[1] & 0xFF) == 254;
    }

    private void initProperties() {
        try {
            this.configurationService.setProperty(PROP_STUN_SERVER_ADDR, null);
            this.configurationService.setProperty(PROP_STUN_SERVER_PORT, null);
            this.configurationService.setProperty(PROP_PREFERRED_NET_IFACE, null);
            this.configurationService.setProperty(PROP_PREFERRED_NET_ADDR, null);
            this.configurationService.setProperty(PROP_STUN_SERVER_ADDR, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

