/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsEntryImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsServiceImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsSourceService;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsEntry;
import net.java.sip.communicator.service.googlecontacts.GoogleEntryCallback;
import net.java.sip.communicator.service.googlecontacts.GoogleQuery;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;

public class GoogleContactsQuery
extends AsyncContactQuery<GoogleContactsSourceService> {
    public static final int GOOGLECONTACTS_MAX_RESULTS = 20;
    private final int count;
    private GoogleQuery gQuery = null;

    protected GoogleContactsQuery(GoogleContactsSourceService contactSource, Pattern query, int count) {
        super((ContactSourceService)contactSource, query);
        this.count = count;
    }

    private void onGoogleContactsEntry(GoogleContactsEntry entry) {
        List<ContactDetail> contactDetails;
        String displayName = entry.getFullName();
        if (displayName == null || displayName.length() == 0) {
            if (!(entry.getGivenName() != null && entry.getGivenName().length() != 0 || entry.getFamilyName() != null && entry.getFamilyName().length() != 0)) {
                return;
            }
            displayName = entry.getGivenName() + " " + entry.getFamilyName();
        }
        if (!(contactDetails = this.getContactDetails(entry)).isEmpty()) {
            GenericSourceContact sourceContact = new GenericSourceContact(this.getContactSource(), displayName, contactDetails);
            try {
                byte[] img = GoogleContactsServiceImpl.downloadPhoto(((GoogleContactsEntryImpl)entry).getPhotoLink(), ((GoogleContactsSourceService)this.getContactSource()).getConnection().getGoogleService());
                sourceContact.setImage(img);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            this.addQueryResult((SourceContact)sourceContact);
        }
    }

    protected void run() {
        GoogleContactsServiceImpl service = GoogleContactsActivator.getGoogleContactsService();
        this.gQuery = new GoogleQuery(this.query);
        GoogleContactsConnectionImpl cnx = ((GoogleContactsSourceService)this.getContactSource()).getConnection();
        if (cnx == null) {
            return;
        }
        service.searchContact(cnx, this.gQuery, this.count, new GoogleEntryCallback(){

            @Override
            public void callback(GoogleContactsEntry entry) {
                GoogleContactsQuery.this.onGoogleContactsEntry(entry);
            }
        });
    }

    public synchronized void start() {
        boolean hasStarted = false;
        try {
            super.start();
            hasStarted = true;
        }
        finally {
            if (!hasStarted) {
                ((GoogleContactsSourceService)this.getContactSource()).removeQuery((ContactQuery)this);
            }
        }
    }

    private List<ContactDetail> getContactDetails(GoogleContactsEntry entry) {
        ArrayList<Class<OperationSetPersistentPresence>> supportedOpSets;
        LinkedList<ContactDetail> ret = new LinkedList<ContactDetail>();
        List<String> homeMails = entry.getHomeMails();
        List<String> workMails = entry.getWorkMails();
        List<String> mobilePhones = entry.getMobilePhones();
        List<String> homePhones = entry.getHomePhones();
        List<String> workPhones = entry.getWorkPhones();
        Map<String, GoogleContactsEntry.IMProtocol> ims = entry.getIMAddresses();
        ContactDetail detail = null;
        for (String string : homeMails) {
            supportedOpSets = new ArrayList<Class<OperationSetPersistentPresence>>(1);
            supportedOpSets.add(OperationSetPersistentPresence.class);
            detail = new ContactDetail(string, ContactDetail.Category.Email, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home});
            detail.setSupportedOpSets(supportedOpSets);
            ret.add(detail);
        }
        for (String string : workMails) {
            supportedOpSets = new ArrayList(1);
            supportedOpSets.add(OperationSetPersistentPresence.class);
            detail = new ContactDetail(string, ContactDetail.Category.Email, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work});
            detail.setSupportedOpSets(supportedOpSets);
            ret.add(detail);
        }
        for (String string : homePhones) {
            supportedOpSets = new ArrayList(2);
            supportedOpSets.add(OperationSetBasicTelephony.class);
            supportedOpSets.add(OperationSetPersistentPresence.class);
            String string2 = GoogleContactsActivator.getPhoneNumberI18nService().normalize(string);
            detail = new ContactDetail(string2, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Home});
            detail.setSupportedOpSets(supportedOpSets);
            ret.add(detail);
        }
        for (String string : workPhones) {
            supportedOpSets = new ArrayList(2);
            supportedOpSets.add(OperationSetBasicTelephony.class);
            supportedOpSets.add(OperationSetPersistentPresence.class);
            String string3 = GoogleContactsActivator.getPhoneNumberI18nService().normalize(string);
            detail = new ContactDetail(string3, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Work});
            detail.setSupportedOpSets(supportedOpSets);
            ret.add(detail);
        }
        for (String string : mobilePhones) {
            supportedOpSets = new ArrayList(2);
            supportedOpSets.add(OperationSetBasicTelephony.class);
            supportedOpSets.add(OperationSetPersistentPresence.class);
            String string4 = GoogleContactsActivator.getPhoneNumberI18nService().normalize(string);
            detail = new ContactDetail(string4, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{ContactDetail.SubCategory.Mobile});
            detail.setSupportedOpSets(supportedOpSets);
            ret.add(detail);
        }
        for (Map.Entry entry2 : ims.entrySet()) {
            ContactDetail.SubCategory imSubCat;
            if (entry2.getValue() == GoogleContactsEntry.IMProtocol.OTHER) continue;
            switch ((GoogleContactsEntry.IMProtocol)((Object)entry2.getValue())) {
                case AIM: {
                    imSubCat = ContactDetail.SubCategory.AIM;
                    break;
                }
                case ICQ: {
                    imSubCat = ContactDetail.SubCategory.ICQ;
                    break;
                }
                case JABBER: {
                    imSubCat = ContactDetail.SubCategory.Jabber;
                    break;
                }
                case SKYPE: {
                    imSubCat = ContactDetail.SubCategory.Skype;
                    break;
                }
                case GOOGLETALK: {
                    imSubCat = ContactDetail.SubCategory.GoogleTalk;
                    break;
                }
                default: {
                    imSubCat = null;
                }
            }
            detail = new ContactDetail((String)entry2.getKey(), ContactDetail.Category.InstantMessaging, new ContactDetail.SubCategory[]{imSubCat});
            this.setIMCapabilities(detail, (GoogleContactsEntry.IMProtocol)((Object)entry2.getValue()));
            detail.getSupportedOperationSets().add(OperationSetPersistentPresence.class);
            ret.add(detail);
        }
        return ret;
    }

    private ContactDetail setIMCapabilities(ContactDetail contactDetail, GoogleContactsEntry.IMProtocol protocol) {
        LinkedList<Class> supportedOpSets = new LinkedList<Class>();
        HashMap<Class, String> preferredProtocols = new HashMap<Class, String>();
        switch (protocol) {
            case GOOGLETALK: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "AIM");
                break;
            }
            case ICQ: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "ICQ");
                break;
            }
            case JABBER: {
                supportedOpSets.add(OperationSetBasicInstantMessaging.class);
                preferredProtocols.put(OperationSetBasicInstantMessaging.class, "Jabber");
                supportedOpSets.add(OperationSetBasicTelephony.class);
                preferredProtocols.put(OperationSetBasicTelephony.class, "Jabber");
                break;
            }
        }
        contactDetail.setSupportedOpSets(supportedOpSets);
        if (!preferredProtocols.isEmpty()) {
            contactDetail.setPreferredProtocols(preferredProtocols);
        }
        return contactDetail;
    }

    protected void stopped(boolean completed) {
        try {
            super.stopped(completed);
        }
        finally {
            ((GoogleContactsSourceService)this.getContactSource()).stopped(this);
        }
    }

    public void cancel() {
        if (this.gQuery != null) {
            this.gQuery.cancel();
        }
        super.cancel();
    }
}

