/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import org.jitsi.impl.neomedia.codec.audio.g729.Lspgetq;
import org.jitsi.impl.neomedia.codec.audio.g729.TabLd8k;
import org.jitsi.impl.neomedia.codec.audio.g729.Util;

class QuaLsp {
    private final float[][] freq_prev = new float[4][10];
    private static final float[] FREQ_PREV_RESET = new float[]{0.285599f, 0.571199f, 0.856798f, 1.142397f, 1.427997f, 1.713596f, 1.999195f, 2.284795f, 2.570394f, 2.855993f};

    QuaLsp() {
    }

    void qua_lsp(float[] lsp, float[] lsp_q, int[] ana) {
        int i;
        int M = 10;
        float[] lsf = new float[M];
        float[] lsf_q = new float[M];
        for (i = 0; i < M; ++i) {
            lsf[i] = (float)Math.acos(lsp[i]);
        }
        this.lsp_qua_cs(lsf, lsf_q, ana);
        for (i = 0; i < M; ++i) {
            lsp_q[i] = (float)Math.cos(lsf_q[i]);
        }
    }

    void lsp_encw_reset() {
        int M = 10;
        int MA_NP = 4;
        for (int i = 0; i < MA_NP; ++i) {
            Util.copy(FREQ_PREV_RESET, this.freq_prev[i], M);
        }
    }

    private void lsp_qua_cs(float[] flsp_in, float[] lspq_out, int[] code) {
        int M = 10;
        float[][][] fg = TabLd8k.fg;
        float[][] fg_sum = TabLd8k.fg_sum;
        float[][] fg_sum_inv = TabLd8k.fg_sum_inv;
        float[][] lspcb1 = TabLd8k.lspcb1;
        float[][] lspcb2 = TabLd8k.lspcb2;
        float[] wegt = new float[M];
        this.get_wegt(flsp_in, wegt);
        this.relspwed(flsp_in, wegt, lspq_out, lspcb1, lspcb2, fg, this.freq_prev, fg_sum, fg_sum_inv, code);
    }

    private void relspwed(float[] lsp, float[] wegt, float[] lspq, float[][] lspcb1, float[][] lspcb2, float[][][] fg, float[][] freq_prev, float[][] fg_sum, float[][] fg_sum_inv, int[] code_ana) {
        float GAP1 = 0.0012f;
        float GAP2 = 6.0E-4f;
        int M = 10;
        int MODE = 2;
        int NC = 5;
        int NC0_B = 7;
        int NC1_B = 5;
        int[] cand = new int[MODE];
        int[] tindex1 = new int[MODE];
        int[] tindex2 = new int[MODE];
        float[] tdist = new float[MODE];
        float[] rbuf = new float[M];
        float[] buf = new float[M];
        for (int mode = 0; mode < MODE; ++mode) {
            int j;
            int index;
            int cand_cur;
            Lspgetq.lsp_prev_extract(lsp, rbuf, fg[mode], freq_prev, fg_sum_inv[mode]);
            cand[mode] = cand_cur = this.lsp_pre_select(rbuf, lspcb1);
            tindex1[mode] = index = this.lsp_select_1(rbuf, lspcb1[cand_cur], wegt, lspcb2);
            for (j = 0; j < NC; ++j) {
                buf[j] = lspcb1[cand_cur][j] + lspcb2[index][j];
            }
            Lspgetq.lsp_expand_1(buf, GAP1);
            tindex2[mode] = index = this.lsp_select_2(rbuf, lspcb1[cand_cur], wegt, lspcb2);
            for (j = NC; j < M; ++j) {
                buf[j] = lspcb1[cand_cur][j] + lspcb2[index][j];
            }
            Lspgetq.lsp_expand_2(buf, GAP1);
            Lspgetq.lsp_expand_1_2(buf, GAP2);
            tdist[mode] = this.lsp_get_tdist(wegt, buf, rbuf, fg_sum[mode]);
        }
        int mode_index = this.lsp_last_select(tdist);
        code_ana[0] = mode_index << NC0_B | cand[mode_index];
        code_ana[1] = tindex1[mode_index] << NC1_B | tindex2[mode_index];
        Lspgetq.lsp_get_quant(lspcb1, lspcb2, cand[mode_index], tindex1[mode_index], tindex2[mode_index], fg[mode_index], freq_prev, lspq, fg_sum[mode_index]);
    }

    private int lsp_pre_select(float[] rbuf, float[][] lspcb1) {
        float FLT_MAX_G729 = 1.0E38f;
        int M = 10;
        int NC0 = 128;
        int cand = 0;
        float dmin = FLT_MAX_G729;
        for (int i = 0; i < NC0; ++i) {
            float dist = 0.0f;
            for (int j = 0; j < M; ++j) {
                float temp = rbuf[j] - lspcb1[i][j];
                dist += temp * temp;
            }
            if (!(dist < dmin)) continue;
            dmin = dist;
            cand = i;
        }
        return cand;
    }

    private int lsp_select_1(float[] rbuf, float[] lspcb1, float[] wegt, float[][] lspcb2) {
        int j;
        float FLT_MAX_G729 = 1.0E38f;
        int M = 10;
        int NC = 5;
        int NC1 = 32;
        float[] buf = new float[M];
        for (j = 0; j < NC; ++j) {
            buf[j] = rbuf[j] - lspcb1[j];
        }
        int index = 0;
        float dmin = FLT_MAX_G729;
        for (int k1 = 0; k1 < NC1; ++k1) {
            float dist = 0.0f;
            for (j = 0; j < NC; ++j) {
                float tmp = buf[j] - lspcb2[k1][j];
                dist += wegt[j] * tmp * tmp;
            }
            if (!(dist < dmin)) continue;
            dmin = dist;
            index = k1;
        }
        return index;
    }

    private int lsp_select_2(float[] rbuf, float[] lspcb1, float[] wegt, float[][] lspcb2) {
        int j;
        float FLT_MAX_G729 = 1.0E38f;
        int M = 10;
        int NC = 5;
        int NC1 = 32;
        float[] buf = new float[M];
        for (j = NC; j < M; ++j) {
            buf[j] = rbuf[j] - lspcb1[j];
        }
        int index = 0;
        float dmin = FLT_MAX_G729;
        for (int k1 = 0; k1 < NC1; ++k1) {
            float dist = 0.0f;
            for (j = NC; j < M; ++j) {
                float tmp = buf[j] - lspcb2[k1][j];
                dist += wegt[j] * tmp * tmp;
            }
            if (!(dist < dmin)) continue;
            dmin = dist;
            index = k1;
        }
        return index;
    }

    private float lsp_get_tdist(float[] wegt, float[] buf, float[] rbuf, float[] fg_sum) {
        int M = 10;
        float tdist = 0.0f;
        for (int j = 0; j < M; ++j) {
            float tmp = (buf[j] - rbuf[j]) * fg_sum[j];
            tdist += wegt[j] * tmp * tmp;
        }
        return tdist;
    }

    private int lsp_last_select(float[] tdist) {
        int mode_index = 0;
        if (tdist[1] < tdist[0]) {
            mode_index = 1;
        }
        return mode_index;
    }

    private void get_wegt(float[] flsp, float[] wegt) {
        float CONST12 = 1.2f;
        int M = 10;
        float PI04 = 0.12566371f;
        float PI92 = 2.8902655f;
        float tmp = flsp[1] - PI04 - 1.0f;
        wegt[0] = tmp > 0.0f ? 1.0f : tmp * tmp * 10.0f + 1.0f;
        for (int i = 1; i < M - 1; ++i) {
            tmp = flsp[i + 1] - flsp[i - 1] - 1.0f;
            wegt[i] = tmp > 0.0f ? 1.0f : tmp * tmp * 10.0f + 1.0f;
        }
        tmp = PI92 - flsp[M - 2] - 1.0f;
        wegt[M - 1] = tmp > 0.0f ? 1.0f : tmp * tmp * 10.0f + 1.0f;
        wegt[4] = wegt[4] * CONST12;
        wegt[5] = wegt[5] * CONST12;
    }
}

