/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.ArrayFrob;
import org.freedesktop.dbus.Container;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMap;
import org.freedesktop.dbus.DBusSerializable;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.Position;
import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.types.DBusListType;
import org.freedesktop.dbus.types.DBusMapType;
import org.freedesktop.dbus.types.DBusStructType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marshalling {
    private static Map<Type, String[]> typeCache = new HashMap<Type, String[]>();
    private static StringBuffer[] out = new StringBuffer[10];

    public static String getDBusType(Type[] typeArray) throws DBusException {
        StringBuffer stringBuffer = new StringBuffer();
        for (Type type : typeArray) {
            for (String string : Marshalling.getDBusType(type)) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String[] getDBusType(Type type) throws DBusException {
        String[] stringArray = typeCache.get(type);
        if (null != stringArray) {
            return stringArray;
        }
        stringArray = Marshalling.getDBusType(type, false);
        typeCache.put(type, stringArray);
        return stringArray;
    }

    public static String[] getDBusType(Type type, boolean bl) throws DBusException {
        return Marshalling.recursiveGetDBusType(type, bl, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] recursiveGetDBusType(Type type, boolean bl, int n) throws DBusException {
        Object object;
        block67: {
            int n2;
            Field[] fieldArray;
            block68: {
                int n3;
                int n4;
                Type[] typeArray;
                Vector<String> vector;
                block66: {
                    int n5;
                    Type[] typeArray2;
                    block65: {
                        block62: {
                            block63: {
                                block64: {
                                    block61: {
                                        if (out.length <= n) {
                                            object = new StringBuffer[out.length];
                                            System.arraycopy(out, 0, object, 0, out.length);
                                            out = object;
                                        }
                                        if (null == out[n]) {
                                            Marshalling.out[n] = new StringBuffer();
                                        } else {
                                            out[n].delete(0, out[n].length());
                                        }
                                        if (bl && !(type instanceof Class)) {
                                            throw new DBusException(type + Gettext._(" is not a basic type"));
                                        }
                                        if (type instanceof TypeVariable) {
                                            out[n].append('v');
                                            return new String[]{out[n].toString()};
                                        }
                                        if (type instanceof GenericArrayType) {
                                            out[n].append('a');
                                            object = Marshalling.recursiveGetDBusType(((GenericArrayType)type).getGenericComponentType(), false, n + 1);
                                            if (((Object)object).length != 1) {
                                                throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                                            }
                                            out[n].append((String)object[0]);
                                            return new String[]{out[n].toString()};
                                        }
                                        if ((!(type instanceof Class) || !DBusSerializable.class.isAssignableFrom((Class)type)) && (!(type instanceof ParameterizedType) || !DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()))) break block61;
                                        object = null;
                                        if (type instanceof Class) {
                                            for (Method method : ((Class)type).getDeclaredMethods()) {
                                                if (!method.getName().equals("deserialize")) continue;
                                                object = method.getGenericParameterTypes();
                                            }
                                        } else {
                                            for (Method method : ((Class)((ParameterizedType)type).getRawType()).getDeclaredMethods()) {
                                                if (!method.getName().equals("deserialize")) continue;
                                                object = method.getGenericParameterTypes();
                                            }
                                        }
                                        if (null == object) {
                                            throw new DBusException(Gettext._("Serializable classes must implement a deserialize method"));
                                        }
                                        break block62;
                                    }
                                    if (!(type instanceof ParameterizedType)) break block63;
                                    object = (ParameterizedType)type;
                                    if (object.getRawType().equals(Map.class)) {
                                        out[n].append("a{");
                                        Type[] typeArray3 = object.getActualTypeArguments();
                                        try {
                                            String[] stringArray = Marshalling.recursiveGetDBusType(typeArray3[0], true, n + 1);
                                            if (stringArray.length != 1) {
                                                throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                                            }
                                            out[n].append(stringArray[0]);
                                            stringArray = Marshalling.recursiveGetDBusType(typeArray3[1], false, n + 1);
                                            if (stringArray.length != 1) {
                                                throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                                            }
                                            out[n].append(stringArray[0]);
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            if (!AbstractConnection.EXCEPTION_DEBUG) throw new DBusException(Gettext._("Map must have 2 parameters"));
                                            // empty if block
                                            throw new DBusException(Gettext._("Map must have 2 parameters"));
                                        }
                                        out[n].append('}');
                                        return new String[]{out[n].toString()};
                                    }
                                    if (!List.class.isAssignableFrom((Class)object.getRawType())) break block64;
                                    typeArray2 = object.getActualTypeArguments();
                                    n5 = typeArray2.length;
                                    break block65;
                                }
                                if (object.getRawType().equals(Variant.class)) {
                                    out[n].append('v');
                                    return new String[]{out[n].toString()};
                                }
                                if (DBusInterface.class.isAssignableFrom((Class)object.getRawType())) {
                                    out[n].append('o');
                                    return new String[]{out[n].toString()};
                                }
                                if (!Tuple.class.isAssignableFrom((Class)object.getRawType())) {
                                    throw new DBusException(Gettext._("Exporting non-exportable parameterized type ") + type);
                                }
                                Type[] typeArray4 = object.getActualTypeArguments();
                                vector = new Vector<String>();
                                typeArray = typeArray4;
                                n4 = typeArray.length;
                                n3 = 0;
                                break block66;
                            }
                            if (type.equals(Byte.class)) {
                                out[n].append('y');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Byte.TYPE)) {
                                out[n].append('y');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Boolean.class)) {
                                out[n].append('b');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Boolean.TYPE)) {
                                out[n].append('b');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Short.class)) {
                                out[n].append('n');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Short.TYPE)) {
                                out[n].append('n');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(UInt16.class)) {
                                out[n].append('q');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Integer.class)) {
                                out[n].append('i');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Integer.TYPE)) {
                                out[n].append('i');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(UInt32.class)) {
                                out[n].append('u');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Long.class)) {
                                out[n].append('x');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Long.TYPE)) {
                                out[n].append('x');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(UInt64.class)) {
                                out[n].append('t');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Double.class)) {
                                out[n].append('d');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Double.TYPE)) {
                                out[n].append('d');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Float.class) && AbstractConnection.FLOAT_SUPPORT) {
                                out[n].append('f');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Float.class)) {
                                out[n].append('d');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Float.TYPE) && AbstractConnection.FLOAT_SUPPORT) {
                                out[n].append('f');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Float.TYPE)) {
                                out[n].append('d');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(String.class)) {
                                out[n].append('s');
                                return new String[]{out[n].toString()};
                            }
                            if (type.equals(Variant.class)) {
                                out[n].append('v');
                                return new String[]{out[n].toString()};
                            }
                            if (type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type)) {
                                out[n].append('o');
                                return new String[]{out[n].toString()};
                            }
                            if (type instanceof Class && Path.class.equals((Object)((Class)type))) {
                                out[n].append('o');
                                return new String[]{out[n].toString()};
                            }
                            if (type instanceof Class && ObjectPath.class.equals((Object)((Class)type))) {
                                out[n].append('o');
                                return new String[]{out[n].toString()};
                            }
                            if (type instanceof Class && ((Class)type).isArray()) {
                                if (Type.class.equals(((Class)type).getComponentType())) {
                                    out[n].append('g');
                                    return new String[]{out[n].toString()};
                                } else {
                                    out[n].append('a');
                                    object = Marshalling.recursiveGetDBusType(((Class)type).getComponentType(), false, n + 1);
                                    if (((Object)object).length != 1) {
                                        throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                                    }
                                    out[n].append((String)object[0]);
                                }
                                return new String[]{out[n].toString()};
                            }
                            if (!(type instanceof Class) || !Struct.class.isAssignableFrom((Class)type)) throw new DBusException(Gettext._("Exporting non-exportable type ") + type);
                            out[n].append('(');
                            object = Container.getTypeCache(type);
                            if (null != object) break block67;
                            Field[] fieldArray2 = ((Class)type).getDeclaredFields();
                            object = new Type[fieldArray2.length];
                            fieldArray = fieldArray2;
                            n2 = fieldArray.length;
                            break block68;
                        }
                        Object[] objectArray = new String[((Object)object).length];
                        int n6 = 0;
                        while (true) {
                            if (n6 >= objectArray.length) {
                                return objectArray;
                            }
                            String[] stringArray = Marshalling.recursiveGetDBusType((Type)object[n6], false, n + 1);
                            if (1 != stringArray.length) {
                                throw new DBusException(Gettext._("Serializable classes must serialize to native DBus types"));
                            }
                            objectArray[n6] = stringArray[0];
                            ++n6;
                        }
                    }
                    for (int i = 0; i < n5; ++i) {
                        Type type2 = typeArray2[i];
                        if (Type.class.equals((Object)type2)) {
                            out[n].append('g');
                            continue;
                        }
                        String[] stringArray = Marshalling.recursiveGetDBusType(type2, false, n + 1);
                        if (stringArray.length != 1) {
                            throw new DBusException(Gettext._("Multi-valued array types not permitted"));
                        }
                        out[n].append('a');
                        out[n].append(stringArray[0]);
                    }
                    return new String[]{out[n].toString()};
                }
                while (true) {
                    if (n3 >= n4) {
                        return vector.toArray(new String[0]);
                    }
                    Type type3 = typeArray[n3];
                    for (String string : Marshalling.recursiveGetDBusType(type3, false, n + 1)) {
                        vector.add(string);
                    }
                    ++n3;
                }
            }
            for (int i = 0; i < n2; ++i) {
                String[] stringArray = fieldArray[i];
                Position position = stringArray.getAnnotation(Position.class);
                if (null == position) continue;
                object[position.value()] = stringArray.getGenericType();
            }
            Container.putTypeCache(type, (Type[])object);
        }
        for (Field field : object) {
            if (field == null) continue;
            for (String string : Marshalling.recursiveGetDBusType((Type)((Object)field), false, n + 1)) {
                out[n].append(string);
            }
        }
        out[n].append(')');
        return new String[]{out[n].toString()};
    }

    public static int getJavaType(String string, List<Type> list, int n) throws DBusException {
        if (null == string || "".equals(string) || 0 == n) {
            return 0;
        }
        try {
            int n2;
            block21: for (n2 = 0; n2 < string.length() && (-1 == n || n > list.size()); ++n2) {
                switch (string.charAt(n2)) {
                    case '(': {
                        int n3 = n2 + 1;
                        int n4 = 1;
                        while (n4 > 0) {
                            if (')' == string.charAt(n3)) {
                                --n4;
                            } else if ('(' == string.charAt(n3)) {
                                ++n4;
                            }
                            ++n3;
                        }
                        Vector<Type> vector = new Vector();
                        int n5 = Marshalling.getJavaType(string.substring(n2 + 1, n3 - 1), vector, -1);
                        list.add(new DBusStructType(vector.toArray(new Type[0])));
                        n2 = n3;
                        continue block21;
                    }
                    case 'a': {
                        int n5;
                        Vector<Type> vector;
                        if ('{' == string.charAt(n2 + 1)) {
                            vector = new Vector();
                            n5 = Marshalling.getJavaType(string.substring(n2 + 2), vector, 2);
                            list.add(new DBusMapType(vector.get(0), vector.get(1)));
                            n2 += n5 + 2;
                            continue block21;
                        }
                        vector = new Vector();
                        n5 = Marshalling.getJavaType(string.substring(n2 + 1), vector, 1);
                        list.add(new DBusListType(vector.get(0)));
                        n2 += n5;
                        continue block21;
                    }
                    case 'v': {
                        list.add((Type)((Object)Variant.class));
                        continue block21;
                    }
                    case 'b': {
                        list.add((Type)((Object)Boolean.class));
                        continue block21;
                    }
                    case 'n': {
                        list.add((Type)((Object)Short.class));
                        continue block21;
                    }
                    case 'y': {
                        list.add((Type)((Object)Byte.class));
                        continue block21;
                    }
                    case 'o': {
                        list.add((Type)((Object)DBusInterface.class));
                        continue block21;
                    }
                    case 'q': {
                        list.add((Type)((Object)UInt16.class));
                        continue block21;
                    }
                    case 'i': {
                        list.add((Type)((Object)Integer.class));
                        continue block21;
                    }
                    case 'u': {
                        list.add((Type)((Object)UInt32.class));
                        continue block21;
                    }
                    case 'x': {
                        list.add((Type)((Object)Long.class));
                        continue block21;
                    }
                    case 't': {
                        list.add((Type)((Object)UInt64.class));
                        continue block21;
                    }
                    case 'd': {
                        list.add((Type)((Object)Double.class));
                        continue block21;
                    }
                    case 'f': {
                        list.add((Type)((Object)Float.class));
                        continue block21;
                    }
                    case 's': {
                        list.add((Type)((Object)String.class));
                        continue block21;
                    }
                    case 'g': {
                        list.add((Type)((Object)Type[].class));
                        continue block21;
                    }
                    case '{': {
                        list.add((Type)((Object)Map.Entry.class));
                        Vector<Type> vector = new Vector<Type>();
                        int n5 = Marshalling.getJavaType(string.substring(n2 + 1), vector, 2);
                        n2 += n5 + 1;
                        continue block21;
                    }
                    default: {
                        throw new DBusException(MessageFormat.format(Gettext._("Failed to parse DBus type signature: {0} ({1})."), string, Character.valueOf(string.charAt(n2))));
                    }
                }
            }
            return n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(Gettext._("Failed to parse DBus type signature: ") + string);
        }
    }

    public static Object[] convertParameters(Object[] objectArray, Type[] typeArray, AbstractConnection abstractConnection) throws DBusException {
        if (null == objectArray) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (null == objectArray[i]) continue;
            if (objectArray[i] instanceof DBusSerializable) {
                for (Method method : objectArray[i].getClass().getDeclaredMethods()) {
                    if (!method.getName().equals("deserialize")) continue;
                    Class<?>[] classArray = method.getParameterTypes();
                    Type[] typeArray2 = new Type[typeArray.length + classArray.length - 1];
                    System.arraycopy(typeArray, 0, typeArray2, 0, i);
                    System.arraycopy(classArray, 0, typeArray2, i, classArray.length);
                    System.arraycopy(typeArray, i + 1, typeArray2, i + classArray.length, typeArray.length - i - 1);
                    typeArray = typeArray2;
                    Object[] objectArray2 = ((DBusSerializable)objectArray[i]).serialize();
                    Object[] objectArray3 = new Object[objectArray.length + objectArray2.length - 1];
                    System.arraycopy(objectArray, 0, objectArray3, 0, i);
                    System.arraycopy(objectArray2, 0, objectArray3, i, objectArray2.length);
                    System.arraycopy(objectArray, i + 1, objectArray3, i + objectArray2.length, objectArray.length - i - 1);
                    objectArray = objectArray3;
                }
                --i;
                continue;
            }
            if (objectArray[i] instanceof Tuple) {
                Object[] objectArray5 = ((ParameterizedType)typeArray[i]).getActualTypeArguments();
                Type[] typeArray3 = new Type[typeArray.length + objectArray5.length - 1];
                System.arraycopy(typeArray, 0, typeArray3, 0, i);
                System.arraycopy(objectArray5, 0, typeArray3, i, objectArray5.length);
                System.arraycopy(typeArray, i + 1, typeArray3, i + objectArray5.length, typeArray.length - i - 1);
                typeArray = typeArray3;
                Object[] objectArray6 = ((Tuple)objectArray[i]).getParameters();
                Object[] objectArray4 = new Object[objectArray.length + objectArray6.length - 1];
                System.arraycopy(objectArray, 0, objectArray4, 0, i);
                System.arraycopy(objectArray6, 0, objectArray4, i, objectArray6.length);
                System.arraycopy(objectArray, i + 1, objectArray4, i + objectArray6.length, objectArray.length - i - 1);
                objectArray = objectArray4;
                --i;
                continue;
            }
            if (typeArray[i] instanceof TypeVariable && !(objectArray[i] instanceof Variant)) {
                objectArray[i] = new Variant<Object>(objectArray[i]);
                continue;
            }
            if (!(objectArray[i] instanceof DBusInterface)) continue;
            objectArray[i] = abstractConnection.getExportedObject((DBusInterface)objectArray[i]);
        }
        return objectArray;
    }

    static Object deSerializeParameter(Object object, Type type, AbstractConnection abstractConnection) throws Exception {
        int n;
        Object object2;
        Object object3;
        if (null == object) {
            return null;
        }
        if (type instanceof TypeVariable && object instanceof Variant) {
            object = ((Variant)object).getValue();
        }
        if (type instanceof Class && ((Class)type).isArray() && ((Class)type).getComponentType().equals(Type.class) && object instanceof String) {
            object3 = new Vector();
            Marshalling.getJavaType((String)object, (List<Type>)object3, -1);
            object = ((Vector)object3).toArray(new Type[0]);
        }
        if (object instanceof ObjectPath) {
            object = type instanceof Class && DBusInterface.class.isAssignableFrom((Class)type) ? abstractConnection.getExportedObject(((ObjectPath)object).source, ((ObjectPath)object).path) : new Path(((ObjectPath)object).path);
        }
        if (object instanceof Object[] && type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
            object3 = Container.getTypeCache(type);
            if (null == object3) {
                object2 = ((Class)type).getDeclaredFields();
                object3 = new Type[((Field[])object2).length];
                Field[] fieldArray = object2;
                n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    Position position = field.getAnnotation(Position.class);
                    if (null == position) continue;
                    object3[position.value()] = field.getGenericType();
                }
                Container.putTypeCache(type, (Type[])object3);
            }
            object = Marshalling.deSerializeParameters(object, (Type[])object3, abstractConnection);
            for (Constructor<?> constructor : ((Class)type).getDeclaredConstructors()) {
                try {
                    object = constructor.newInstance(object);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if (object instanceof Object[]) {
            object3 = new Type[((Object[])object).length];
            Arrays.fill((Object[])object3, object.getClass().getComponentType());
            object = Marshalling.deSerializeParameters(object, (Type[])object3, abstractConnection);
        }
        if (object instanceof List && null != (object3 = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : (type instanceof Class && ((Class)type).isArray() ? ((Class)type).getComponentType() : null)))) {
            object = Marshalling.deSerializeParameters((List)object, (Type)object3, abstractConnection);
        }
        if ((type.equals(Float.class) || type.equals(Float.TYPE)) && !(object instanceof Float)) {
            object = Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof Object[] || object instanceof List || object.getClass().isArray()) {
            if (type instanceof ParameterizedType) {
                object = ArrayFrob.convert(object, (Class)((ParameterizedType)type).getRawType());
            } else if (type instanceof GenericArrayType) {
                object3 = ((GenericArrayType)type).getGenericComponentType();
                object2 = null;
                if (object3 instanceof Class) {
                    object2 = (Class)object3;
                }
                if (object3 instanceof ParameterizedType) {
                    object2 = (Class)((ParameterizedType)object3).getRawType();
                }
                Object object4 = Array.newInstance(object2, 0);
                object = ArrayFrob.convert(object, object4.getClass());
            } else if (type instanceof Class && ((Class)type).isArray()) {
                object3 = ((Class)type).getComponentType();
                if ((object3.equals(Float.class) || object3.equals(Float.TYPE)) && object instanceof double[]) {
                    object2 = (double[])object;
                    float[] fArray = new float[((Object[])object2).length];
                    for (n = 0; n < ((Object)object2).length; ++n) {
                        fArray[n] = (float)object2[n];
                    }
                    object = fArray;
                }
                object2 = Array.newInstance(object3, 0);
                object = ArrayFrob.convert(object, object2.getClass());
            }
        }
        if (object instanceof DBusMap) {
            object3 = (DBusMap)object;
            object2 = ((ParameterizedType)type).getActualTypeArguments();
            for (int i = 0; i < ((DBusMap)object3).entries.length; ++i) {
                ((DBusMap)object3).entries[i][0] = Marshalling.deSerializeParameter(((DBusMap)object3).entries[i][0], (Type)object2[0], abstractConnection);
                ((DBusMap)object3).entries[i][1] = Marshalling.deSerializeParameter(((DBusMap)object3).entries[i][1], (Type)object2[1], abstractConnection);
            }
        }
        return object;
    }

    static List<Object> deSerializeParameters(List<Object> list, Type type, AbstractConnection abstractConnection) throws Exception {
        if (null == list) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (null == list.get(i)) continue;
            list.set(i, Marshalling.deSerializeParameter(list.get(i), type, abstractConnection));
        }
        return list;
    }

    static Object[] deSerializeParameters(Object[] objectArray, Type[] typeArray, AbstractConnection abstractConnection) throws Exception {
        if (null == objectArray) {
            return null;
        }
        if (typeArray.length == 1 && typeArray[0] instanceof ParameterizedType && Tuple.class.isAssignableFrom((Class)((ParameterizedType)typeArray[0]).getRawType())) {
            typeArray = ((ParameterizedType)typeArray[0]).getActualTypeArguments();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (i >= typeArray.length) {
                throw new DBusException(Gettext._("Error deserializing message: number of parameters didn't match receiving signature"));
            }
            if (null == objectArray[i]) continue;
            if (typeArray[i] instanceof Class && DBusSerializable.class.isAssignableFrom((Class)typeArray[i]) || typeArray[i] instanceof ParameterizedType && DBusSerializable.class.isAssignableFrom((Class)((ParameterizedType)typeArray[i]).getRawType())) {
                Class clazz = typeArray[i] instanceof Class ? (Class)typeArray[i] : (Class)((ParameterizedType)typeArray[i]).getRawType();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals("deserialize")) continue;
                    Type[] typeArray2 = method.getGenericParameterTypes();
                    try {
                        Object[] objectArray2 = new Object[typeArray2.length];
                        System.arraycopy(objectArray, i, objectArray2, 0, typeArray2.length);
                        objectArray2 = Marshalling.deSerializeParameters(objectArray2, typeArray2, abstractConnection);
                        DBusSerializable dBusSerializable = (DBusSerializable)clazz.newInstance();
                        method.invoke((Object)dBusSerializable, objectArray2);
                        Object[] objectArray3 = new Object[objectArray.length - typeArray2.length + 1];
                        System.arraycopy(objectArray, 0, objectArray3, 0, i);
                        objectArray3[i] = dBusSerializable;
                        System.arraycopy(objectArray, i + typeArray2.length, objectArray3, i + 1, objectArray.length - i - typeArray2.length);
                        objectArray = objectArray3;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (AbstractConnection.EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw new DBusException(MessageFormat.format(Gettext._("Not enough elements to create custom object from serialized data ({0} < {1})."), objectArray.length - i, typeArray2.length));
                    }
                }
                continue;
            }
            objectArray[i] = Marshalling.deSerializeParameter(objectArray[i], typeArray[i], abstractConnection);
        }
        return objectArray;
    }
}

