/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetPersistentPresence
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetPersistentPresence.class);
    private SipSlickFixture fixture = new SipSlickFixture();
    private OperationSetPersistentPresence opSetPersPresence1 = null;
    private OperationSetPersistentPresence opSetPersPresence2 = null;
    private static final String testGroupName = "NewGroup";
    private static final String testGroupName2 = "Renamed";

    public TestOperationSetPersistentPresence(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestCreateGroup"));
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestRenameGroup"));
        suite.addTest((Test)new TestOperationSetPersistentPresence("postTestRemoveGroup"));
        suite.addTest((Test)new TestOperationSetPersistentPresence("prepareContactList"));
        suite.addTestSuite(TestOperationSetPersistentPresence.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets1 = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Gibberish implementation. ");
        }
        this.opSetPersPresence1 = (OperationSetPersistentPresence)supportedOperationSets1.get(OperationSetPersistentPresence.class.getName());
        if (this.opSetPersPresence1 == null) {
            throw new NullPointerException("An implementation of the gibberish service must provide an implementation of at least the one of the Presence Operation Sets");
        }
        Map supportedOperationSets2 = this.fixture.provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this Gibberish implementation. ");
        }
        this.opSetPersPresence2 = (OperationSetPersistentPresence)supportedOperationSets2.get(OperationSetPersistentPresence.class.getName());
        if (this.opSetPersPresence2 == null) {
            throw new NullPointerException("An implementation of the Gibberish service must provide an implementation of at least the one of the Presence Operation Sets");
        }
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testRetrievingServerStoredContactList() {
        ContactGroup rootGroup = this.opSetPersPresence1.getServerStoredContactListRoot();
        logger.debug((Object)"=========== Server Stored Contact List =================");
        logger.debug((Object)("rootGroup=" + rootGroup.getGroupName() + " rootGroup.childContacts=" + rootGroup.countContacts() + "rootGroup.childGroups=" + rootGroup.countSubgroups() + "Printing rootGroupContents=\n" + rootGroup.toString()));
        Hashtable<String, List<String>> expectedContactList = SipSlickFixture.preInstalledBuddyList;
        logger.debug((Object)"============== Expected Contact List ===================");
        logger.debug(expectedContactList);
        Iterator groups = rootGroup.subgroups();
        while (groups.hasNext()) {
            ContactGroup group = (ContactGroup)groups.next();
            List<String> expectedContactsInGroup = expectedContactList.get(group.getGroupName());
            if (group.getGroupName().equals("NotInContactList")) continue;
            TestOperationSetPersistentPresence.assertNotNull((String)("Group " + group.getGroupName() + " was returned by the server but was not in the expected contact list."), expectedContactsInGroup);
            Iterator contactsIter = group.contacts();
            while (contactsIter.hasNext()) {
                String contactID = ((Contact)contactsIter.next()).getAddress();
                expectedContactsInGroup.remove(contactID);
            }
            if (expectedContactsInGroup.size() != 0) continue;
            expectedContactList.remove(group.getGroupName());
        }
        TestOperationSetPersistentPresence.assertTrue((String)("The following contacts were on the server sidec contact list, but were not returned by the pers. pres. op. set" + expectedContactList.toString()), (boolean)expectedContactList.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTestCreateGroup() throws Exception {
        Object o;
        this.fixture.clearProvidersLists();
        Object object = o = new Object();
        synchronized (object) {
            o.wait(3000L);
        }
        logger.trace((Object)"testing creation of server stored groups");
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence1.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        this.opSetPersPresence1.createServerStoredContactGroup(this.opSetPersPresence1.getServerStoredContactListRoot(), testGroupName);
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence1.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change events: ", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup group = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName);
        TestOperationSetPersistentPresence.assertNotNull((String)"A newly created group was not in the contact list.", (Object)group);
        TestOperationSetPersistentPresence.assertEquals((String)"New group name", (String)testGroupName, (String)group.getGroupName());
        try {
            this.opSetPersPresence1.subscribe(group, this.fixture.userID2);
            Object object2 = o;
            synchronized (object2) {
                o.wait(1500L);
            }
        }
        catch (Exception ex) {
            TestOperationSetPersistentPresence.fail((String)("error adding entry to group : " + group.getGroupName() + " " + ex.getMessage()));
        }
    }

    public void postTestRemoveGroup() {
        logger.trace((Object)"testing removal of server stored groups");
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence1.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        try {
            this.opSetPersPresence1.removeServerStoredContactGroup(this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName2));
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"error removing group", (Throwable)ex);
        }
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence1.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change event", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName2, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup group = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName2);
        TestOperationSetPersistentPresence.assertNull((String)"A freshly removed group was still on the contact list.", (Object)group);
    }

    public void postTestRenameGroup() {
        logger.trace((Object)"Testing renaming groups.");
        ContactGroup group = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName);
        GroupChangeCollector groupChangeCollector = new GroupChangeCollector();
        this.opSetPersPresence1.addServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        this.opSetPersPresence1.renameServerStoredContactGroup(group, testGroupName2);
        groupChangeCollector.waitForEvent(10000L);
        this.opSetPersPresence1.removeServerStoredGroupChangeListener((ServerStoredGroupListener)groupChangeCollector);
        TestOperationSetPersistentPresence.assertEquals((String)"Collected Group Change event", (int)1, (int)groupChangeCollector.collectedEvents.size());
        TestOperationSetPersistentPresence.assertEquals((String)"Group name.", (String)testGroupName2, (String)((ServerStoredGroupEvent)groupChangeCollector.collectedEvents.get(0)).getSourceGroup().getGroupName());
        ContactGroup oldGroup = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName);
        TestOperationSetPersistentPresence.assertNull((String)"A group was still findable by its old name after renaming.", (Object)oldGroup);
        ContactGroup newGroup = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(testGroupName2);
        TestOperationSetPersistentPresence.assertNotNull((String)"Could not find a renamed group by its new name.", (Object)newGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object o;
        this.fixture.clearProvidersLists();
        Object object = o = new Object();
        synchronized (object) {
            o.wait(3000L);
        }
        String contactList = System.getProperty("accounts.sip.CONTACT_LIST", null);
        logger.debug((Object)("The accounts.sip.CONTACT_LIST property is set to=" + contactList));
        if (contactList == null || contactList.trim().length() < 6) {
            throw new IllegalArgumentException("The accounts.sip.CONTACT_LIST property did not contain a contact list.");
        }
        StringTokenizer tokenizer = new StringTokenizer(contactList, " \n\t");
        logger.debug((Object)("tokens contained by the CL tokenized=" + tokenizer.countTokens()));
        Hashtable<String, ArrayList<String>> contactListToCreate = new Hashtable<String, ArrayList<String>>();
        while (tokenizer.hasMoreTokens()) {
            String groupUinToken = tokenizer.nextToken();
            int dotIndex = groupUinToken.indexOf(".");
            if (dotIndex == -1) {
                throw new IllegalArgumentException(groupUinToken + " is not a valid Group.UIN token");
            }
            String groupName = groupUinToken.substring(0, dotIndex);
            String uin = groupUinToken.substring(dotIndex + 1);
            if (groupName.trim().length() < 1 || uin.trim().length() < 4) {
                throw new IllegalArgumentException(groupName + " or " + uin + " are not a valid group name or Gibberish user id.");
            }
            ArrayList<String> uinInThisGroup = (ArrayList<String>)contactListToCreate.get(groupName);
            if (uinInThisGroup == null) {
                uinInThisGroup = new ArrayList<String>();
                contactListToCreate.put(groupName, uinInThisGroup);
            }
            uinInThisGroup.add(uin);
        }
        Enumeration newGroupsEnum = contactListToCreate.keys();
        while (newGroupsEnum.hasMoreElements()) {
            String groupName = (String)newGroupsEnum.nextElement();
            logger.debug((Object)("Will add group " + groupName));
            this.opSetPersPresence1.createServerStoredContactGroup(this.opSetPersPresence1.getServerStoredContactListRoot(), groupName);
            ContactGroup newlyCreatedGroup = this.opSetPersPresence1.getServerStoredContactListRoot().getGroup(groupName);
            for (String id : (List)contactListToCreate.get(groupName)) {
                logger.debug((Object)("Will add buddy " + id));
                this.opSetPersPresence1.subscribe(newlyCreatedGroup, id);
            }
        }
        SipSlickFixture.preInstalledBuddyList = contactListToCreate;
    }

    private class GroupChangeCollector
    implements ServerStoredGroupListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();

        private GroupChangeCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                if (this.collectedEvents.size() > 0) {
                    return;
                }
                try {
                    this.wait(waitFor);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupCreated(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupNameChanged(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupRemoved(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void groupResolved(ServerStoredGroupEvent evt) {
            GroupChangeCollector groupChangeCollector = this;
            synchronized (groupChangeCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + evt));
                this.collectedEvents.add((EventObject)evt);
                this.notifyAll();
            }
        }
    }
}

