/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Module;
import net.sf.fmj.media.ModuleListener;
import net.sf.fmj.media.OutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.StateTransistor;

public abstract class BasicModule
implements Module,
StateTransistor {
    protected Registry inputConnectors = new Registry();
    protected Registry outputConnectors = new Registry();
    protected InputConnector[] inputConnectorsArray;
    protected OutputConnector[] outputConnectorsArray;
    protected int protocol = 0;
    protected String name = null;
    protected ModuleListener moduleListener;
    protected BasicController controller;
    protected boolean resetted = false;
    protected boolean prefetchFailed = false;

    @Override
    public void abortPrefetch() {
    }

    @Override
    public void abortRealize() {
    }

    public boolean canRun() {
        int i;
        for (i = 0; i < this.inputConnectorsArray.length; ++i) {
            if (this.inputConnectorsArray[i].isValidBufferAvailable()) continue;
            return false;
        }
        for (i = 0; i < this.outputConnectorsArray.length; ++i) {
            if (this.outputConnectorsArray[i].isEmptyBufferAvailable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void connectorPushed(InputConnector inputConnector) {
        this.process();
    }

    @Override
    public void doClose() {
    }

    @Override
    public void doDealloc() {
    }

    @Override
    public void doFailedPrefetch() {
    }

    @Override
    public void doFailedRealize() {
    }

    @Override
    public boolean doPrefetch() {
        this.resetted = false;
        return true;
    }

    @Override
    public boolean doRealize() {
        return true;
    }

    @Override
    public void doSetMediaTime(Time t) {
    }

    @Override
    public float doSetRate(float r) {
        return r;
    }

    @Override
    public void doStart() {
        this.resetted = false;
    }

    @Override
    public void doStop() {
    }

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " error");
    }

    @Override
    public Object getControl(String s) {
        return null;
    }

    public final BasicController getController() {
        return this.controller;
    }

    @Override
    public Object[] getControls() {
        return null;
    }

    @Override
    public InputConnector getInputConnector(String connectorName) {
        return (InputConnector)this.inputConnectors.get(connectorName);
    }

    @Override
    public String[] getInputConnectorNames() {
        return this.inputConnectors.getNames();
    }

    public long getLatency() {
        return ((PlaybackEngine)this.controller).getLatency();
    }

    public long getMediaNanoseconds() {
        return this.controller.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.controller.getMediaTime();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public OutputConnector getOutputConnector(String connectorName) {
        return (OutputConnector)this.outputConnectors.get(connectorName);
    }

    @Override
    public String[] getOutputConnectorNames() {
        return this.outputConnectors.getNames();
    }

    public int getProtocol() {
        return this.protocol;
    }

    public final int getState() {
        return this.controller.getState();
    }

    @Override
    public final boolean isInterrupted() {
        return this.controller == null ? false : this.controller.isInterrupted();
    }

    public boolean isThreaded() {
        return true;
    }

    public boolean prefetchFailed() {
        return this.prefetchFailed;
    }

    protected abstract void process();

    @Override
    public void registerInputConnector(String name, InputConnector inputConnector) {
        this.inputConnectors.put(name, inputConnector);
        inputConnector.setModule(this);
    }

    @Override
    public void registerOutputConnector(String name, OutputConnector outputConnector) {
        this.outputConnectors.put(name, outputConnector);
        outputConnector.setModule(this);
    }

    @Override
    public void reset() {
        this.resetted = true;
    }

    public final void setController(BasicController c) {
        this.controller = c;
    }

    @Override
    public void setFormat(Connector connector, Format format) {
    }

    @Override
    public void setModuleListener(ModuleListener listener) {
        this.moduleListener = listener;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setProtocol(int protocol) {
        int i;
        this.protocol = protocol;
        Connector[] connectors = this.inputConnectors.getConnectors();
        for (i = 0; i < connectors.length; ++i) {
            connectors[i].setProtocol(protocol);
        }
        connectors = this.outputConnectors.getConnectors();
        for (i = 0; i < connectors.length; ++i) {
            connectors[i].setProtocol(protocol);
        }
    }

    protected boolean verifyBuffer(Buffer buffer) {
        if (buffer.isDiscard()) {
            return true;
        }
        Object data = buffer.getData();
        if (buffer.getLength() < 0) {
            System.err.println("warning: data length shouldn't be negative: " + buffer.getLength());
        }
        if (data == null) {
            System.err.println("warning: data buffer is null");
            if (buffer.getLength() != 0) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but data buffer is null!");
                return false;
            }
        } else if (data instanceof byte[]) {
            if (buffer.getLength() > ((byte[])data).length) {
                System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((byte[])data).length);
                return false;
            }
        } else if (data instanceof int[] && buffer.getLength() > ((int[])data).length) {
            System.err.println("buffer advertized length = " + buffer.getLength() + " but actual length = " + ((int[])data).length);
            return false;
        }
        return true;
    }

    class Registry
    extends Hashtable<String, Connector> {
        Connector def = null;

        Registry() {
        }

        Object get(String name) {
            if (name == null) {
                return this.def;
            }
            return super.get(name);
        }

        Connector[] getConnectors() {
            Enumeration connectorsEnum = this.elements();
            Connector[] connectorsArray = new Connector[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                connectorsArray[i] = (Connector)connectorsEnum.nextElement();
            }
            return connectorsArray;
        }

        String[] getNames() {
            Enumeration namesEnum = this.keys();
            String[] namesArray = new String[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                namesArray[i] = (String)namesEnum.nextElement();
            }
            return namesArray;
        }

        @Override
        public Connector put(String name, Connector connector) {
            if (this.containsKey(name)) {
                throw new RuntimeException("Connector '" + name + "' already exists in Module '" + BasicModule.this.getClass().getName() + "::" + name + "'");
            }
            if (this.def == null) {
                this.def = connector;
            }
            return super.put(name, connector);
        }
    }
}

