/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.state.DNSStateTask;

public class Canceler
extends DNSStateTask {
    static Logger logger = Logger.getLogger(Canceler.class.getName());

    public Canceler(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl, 0);
        this.setTaskState(DNSState.CANCELING_1);
        this.associate(DNSState.CANCELING_1);
    }

    @Override
    public String getName() {
        return "Canceler(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " state: " + (Object)((Object)this.getTaskState());
    }

    @Override
    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 1000L);
    }

    @Override
    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    @Override
    public String getTaskDescription() {
        return "canceling";
    }

    @Override
    protected boolean checkRunCondition() {
        return true;
    }

    @Override
    protected DNSOutgoing createOugoing() {
        return new DNSOutgoing(33792);
    }

    @Override
    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        for (DNSRecord dNSRecord : this.getDns().getLocalHost().answers(true, this.getTTL())) {
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, null, dNSRecord);
        }
        return dNSOutgoing2;
    }

    @Override
    protected DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl serviceInfoImpl, DNSOutgoing dNSOutgoing) throws IOException {
        DNSOutgoing dNSOutgoing2 = dNSOutgoing;
        for (DNSRecord dNSRecord : serviceInfoImpl.answers(true, this.getTTL(), this.getDns().getLocalHost())) {
            dNSOutgoing2 = this.addAnswer(dNSOutgoing2, null, dNSRecord);
        }
        return dNSOutgoing2;
    }

    @Override
    protected void recoverTask(Throwable throwable) {
        this.getDns().recover();
    }

    @Override
    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isCanceling()) {
            this.cancel();
        }
    }
}

