/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflater;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected final Deflater deflater;
    protected byte[] buffer;
    private boolean closed = false;
    private boolean syncFlush = false;
    private final byte[] buf1 = new byte[1];
    protected boolean mydeflater = false;
    private boolean close_out = true;
    protected static final int DEFAULT_BUFSIZE = 512;

    public DeflaterOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, new Deflater(-1), 512, true);
        this.mydeflater = true;
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) throws IOException {
        this(outputStream, deflater, 512, true);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) throws IOException {
        this(outputStream, deflater, n, true);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n, boolean bl) throws IOException {
        super(outputStream);
        if (outputStream == null || deflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size must be greater than 0");
        }
        this.deflater = deflater;
        this.buffer = new byte[n];
        this.close_out = bl;
    }

    @Override
    public void write(int n) throws IOException {
        this.buf1[0] = (byte)(n & 0xFF);
        this.write(this.buf1, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.deflater.finished()) {
            throw new IOException("finished");
        }
        if (n < 0 | n2 < 0 | n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n4 = this.syncFlush ? 2 : 0;
        this.deflater.setInput(byArray, n, n2, true);
        while (this.deflater.avail_in > 0 && (n3 = this.deflate(n4)) != 1) {
        }
    }

    public void finish() throws IOException {
        while (!this.deflater.finished()) {
            this.deflate(4);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            if (this.mydeflater) {
                this.deflater.end();
            }
            if (this.close_out) {
                this.out.close();
            }
            this.closed = true;
        }
    }

    protected int deflate(int n) throws IOException {
        this.deflater.setOutput(this.buffer, 0, this.buffer.length);
        int n2 = this.deflater.deflate(n);
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case -5: {
                if (this.deflater.avail_in <= 0 && n != 4) break;
            }
            default: {
                throw new IOException("failed to deflate");
            }
        }
        int n3 = this.deflater.next_out_index;
        if (n3 > 0) {
            this.out.write(this.buffer, 0, n3);
        }
        return n2;
    }

    @Override
    public void flush() throws IOException {
        if (this.syncFlush && !this.deflater.finished()) {
            int n;
            do {
                n = this.deflate(2);
            } while (this.deflater.next_out_index >= this.buffer.length && n != 1);
        }
        this.out.flush();
    }

    public long getTotalIn() {
        return this.deflater.getTotalIn();
    }

    public long getTotalOut() {
        return this.deflater.getTotalOut();
    }

    public void setSyncFlush(boolean bl) {
        this.syncFlush = bl;
    }

    public boolean getSyncFlush() {
        return this.syncFlush;
    }

    public Deflater getDeflater() {
        return this.deflater;
    }
}

