/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import cern.colt.matrix.DoubleMatrix2D;
import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.algorithms.matrix.GraphMatrixOperations;
import edu.uci.ics.jung.algorithms.util.Indexer;
import edu.uci.ics.jung.graph.UndirectedGraph;
import org.apache.commons.collections15.BidiMap;

public class RandomWalkSTBetweenness<V, E>
extends AbstractRanker<V, E> {
    public static final String CENTRALITY = "centrality.RandomWalkSTBetweennessCentrality";
    private DoubleMatrix2D mVoltageMatrix;
    private BidiMap<V, Integer> mIndexer;
    V mSource;
    V mTarget;

    public RandomWalkSTBetweenness(UndirectedGraph<V, E> g, V s, V t) {
        this.initialize(g, true, false);
        this.mSource = s;
        this.mTarget = t;
    }

    protected BidiMap<V, Integer> getIndexer() {
        return this.mIndexer;
    }

    protected DoubleMatrix2D getVoltageMatrix() {
        return this.mVoltageMatrix;
    }

    protected void setUp() {
        this.mVoltageMatrix = GraphMatrixOperations.computeVoltagePotentialMatrix((UndirectedGraph)this.getGraph());
        this.mIndexer = Indexer.create(this.getGraph().getVertices());
    }

    protected void computeBetweenness() {
        this.setUp();
        for (Object v : this.getGraph().getVertices()) {
            this.setVertexRankScore(v, this.computeSTBetweenness(v, this.mSource, this.mTarget));
        }
    }

    public double computeSTBetweenness(V ithVertex, V source, V target) {
        if (ithVertex == source || ithVertex == target) {
            return 1.0;
        }
        if (this.mVoltageMatrix == null) {
            this.setUp();
        }
        int i = (Integer)this.mIndexer.get(ithVertex);
        int s = (Integer)this.mIndexer.get(source);
        int t = (Integer)this.mIndexer.get(target);
        double betweenness = 0.0;
        for (Object jthVertex : this.getGraph().getSuccessors(ithVertex)) {
            int j = (Integer)this.mIndexer.get(jthVertex);
            double currentFlow = 0.0;
            currentFlow += this.mVoltageMatrix.get(i, s);
            currentFlow -= this.mVoltageMatrix.get(i, t);
            currentFlow -= this.mVoltageMatrix.get(j, s);
            betweenness += Math.abs(currentFlow += this.mVoltageMatrix.get(j, t));
        }
        return betweenness / 2.0;
    }

    @Override
    public String getRankScoreKey() {
        return CENTRALITY;
    }

    @Override
    public void step() {
        this.computeBetweenness();
    }
}

