/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout3d;

import edu.uci.ics.jung.algorithms.layout3d.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout3d.RandomLocationTransformer;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;

public class FRLayout<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    private double forceConstant;
    private double temperature;
    private int currentIteration;
    private int mMaxIterations = 700;
    private Map<V, Vector3f> frVertexData = LazyMap.decorate(new HashMap(), new Factory<Vector3f>(){

        @Override
        public Vector3f create() {
            return new Vector3f();
        }
    });
    private double attraction_multiplier = 0.75;
    private double attraction_constant;
    private double repulsion_multiplier = 0.75;
    private double repulsion_constant;
    private double EPSILON = 1.0E-6;

    public FRLayout(Graph<V, E> g) {
        super(g);
    }

    public FRLayout(Graph<V, E> g, BoundingSphere d) {
        super(g, new RandomLocationTransformer(d), d);
        this.initialize();
    }

    @Override
    public void setSize(BoundingSphere size) {
        this.setInitializer(new RandomLocationTransformer(size));
        super.setSize(size);
    }

    public void setAttractionMultiplier(double attraction) {
        this.attraction_multiplier = attraction;
    }

    public void setRepulsionMultiplier(double repulsion) {
        this.repulsion_multiplier = repulsion;
    }

    @Override
    public void reset() {
        this.doInit();
    }

    @Override
    public void initialize() {
        this.doInit();
    }

    private void doInit() {
        Graph graph = this.getGraph();
        BoundingSphere d = this.getSize();
        if (graph != null) {
            this.currentIteration = 0;
            this.temperature = d.getRadius() / 10.0;
            this.forceConstant = Math.sqrt(d.getRadius() * d.getRadius() * d.getRadius() / (double)graph.getVertexCount());
            this.attraction_constant = this.attraction_multiplier * this.forceConstant;
            this.repulsion_constant = this.repulsion_multiplier * this.forceConstant;
        }
    }

    @Override
    public synchronized void step() {
        ++this.currentIteration;
        while (true) {
            try {
                for (Object v1 : this.getGraph().getVertices()) {
                    this.calcRepulsion(v1);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object e : this.getGraph().getEdges()) {
                    this.calcAttraction(e);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    if (this.isLocked(v)) continue;
                    this.calcPositions(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        this.cool();
    }

    public synchronized void calcPositions(V v) {
        Vector3f fvd = this.frVertexData.get(v);
        if (fvd == null) {
            return;
        }
        Point3f xyd = this.transform(v);
        double deltaLength = Math.max(this.EPSILON, (double)fvd.length());
        Vector3f newDisp = new Vector3f(fvd);
        newDisp.scale((float)(Math.min(deltaLength, this.temperature) / deltaLength), (Tuple3f)fvd);
        xyd.add((Tuple3f)newDisp);
        double borderWidth = this.getSize().getRadius() / 50.0;
        double min = -this.getSize().getRadius() + borderWidth;
        double max = -min;
        double[] min_pos = new double[3];
        double[] max_pos = new double[3];
        for (int i = 0; i < 3; ++i) {
            min_pos[i] = min + Math.random() * borderWidth * 2.0;
            max_pos[i] = max - Math.random() * borderWidth * 2.0;
        }
        xyd.set((float)Math.min(Math.max((double)xyd.getX(), min_pos[0]), max_pos[0]), (float)Math.min(Math.max((double)xyd.getY(), min_pos[1]), max_pos[1]), (float)Math.min(Math.max((double)xyd.getZ(), min_pos[2]), max_pos[2]));
    }

    public void calcAttraction(E e) {
        Pair p = this.getGraph().getEndpoints(e);
        Object v1 = p.getFirst();
        Object v2 = p.getSecond();
        Point3f p1 = this.transform(v1);
        Point3f p2 = this.transform(v2);
        if (p1 == null || p2 == null) {
            return;
        }
        Vector3f delta = new Vector3f();
        delta.negate((Tuple3f)p2);
        delta.add((Tuple3f)p1);
        double deltaLength = Math.max(this.EPSILON, (double)delta.length());
        double force = deltaLength * deltaLength / this.attraction_constant;
        if (Double.isNaN(force)) {
            throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions [force]");
        }
        delta.scale((float)(force / deltaLength));
        this.frVertexData.get(v2).add((Tuple3f)delta);
        delta.negate();
        this.frVertexData.get(v1).add((Tuple3f)delta);
    }

    public void calcRepulsion(V v1) {
        Vector3f fvd1 = this.frVertexData.get(v1);
        if (fvd1 == null) {
            return;
        }
        fvd1.set(0.0f, 0.0f, 0.0f);
        try {
            for (Object v2 : this.getGraph().getVertices()) {
                if (v1 == v2) continue;
                Point3f p1 = this.transform(v1);
                Point3f p2 = this.transform(v2);
                if (p1 == null || p2 == null) continue;
                Vector3f delta = new Vector3f();
                delta.negate((Tuple3f)p2);
                delta.add((Tuple3f)p1);
                double deltaLength = Math.max(this.EPSILON, (double)delta.length());
                double force = this.repulsion_constant * this.repulsion_constant / deltaLength;
                if (Double.isNaN(force)) {
                    throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                }
                delta.scale((float)(force / deltaLength));
                fvd1.add((Tuple3f)delta);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calcRepulsion(v1);
        }
    }

    private void cool() {
        this.temperature *= 1.0 - (double)this.currentIteration / (double)this.mMaxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.mMaxIterations = maxIterations;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.currentIteration > this.mMaxIterations;
    }
}

