/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.ref.Converter;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.Histogram2D;
import hep.aida.ref.Histogram3D;
import hep.aida.ref.VariableAxis;
import java.util.Random;

public class Test2 {
    public static void main(String[] argv) {
        Random r = new Random();
        Histogram1D h1 = new Histogram1D("AIDA 1D Histogram", 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            h1.fill(r.nextGaussian());
        }
        Histogram2D h2 = new Histogram2D("AIDA 2D Histogram", 40, -3.0, 3.0, 40, -3.0, 3.0);
        for (int i = 0; i < 10000; ++i) {
            h2.fill(r.nextGaussian(), r.nextGaussian());
        }
        Test2.writeAsXML(h1, "aida1.xml");
        Test2.writeAsXML(h2, "aida2.xml");
        Test2.writeAsXML(h2.projectionX(), "projectionX.xml");
        Test2.writeAsXML(h2.projectionY(), "projectionY.xml");
    }

    public static void main2(String[] argv) {
        double[] bounds = new double[]{-30.0, 0.0, 30.0, 1000.0};
        Random r = new Random();
        Histogram1D h1 = new Histogram1D("AIDA 1D Histogram", new VariableAxis(bounds));
        for (int i = 0; i < 10000; ++i) {
            h1.fill(r.nextGaussian());
        }
        Histogram2D h2 = new Histogram2D("AIDA 2D Histogram", new VariableAxis(bounds), new VariableAxis(bounds));
        for (int i = 0; i < 10000; ++i) {
            h2.fill(r.nextGaussian(), r.nextGaussian());
        }
        Histogram3D h3 = new Histogram3D("AIDA 3D Histogram", 10, -2.0, 2.0, 5, -2.0, 2.0, 3, -2.0, 2.0);
        for (int i = 0; i < 10000; ++i) {
            h3.fill(r.nextGaussian(), r.nextGaussian(), r.nextGaussian());
        }
        Test2.writeAsXML(h1, "aida1.xml");
        Test2.writeAsXML(h2, "aida2.xml");
        Test2.writeAsXML(h3, "aida2.xml");
        Test2.writeAsXML(h2.projectionX(), "projectionX.xml");
        Test2.writeAsXML(h2.projectionY(), "projectionY.xml");
    }

    private static void writeAsXML(IHistogram1D h, String filename) {
        System.out.println(new Converter().toString(h));
    }

    private static void writeAsXML(IHistogram2D h, String filename) {
        System.out.println(new Converter().toString(h));
    }

    private static void writeAsXML(IHistogram3D h, String filename) {
        System.out.println(new Converter().toString(h));
    }
}

