/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data.resources;

import lcmc.data.resources.Resource;

public class Service
extends Resource {
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String crmId = null;
    private boolean removed = false;
    private boolean removing = false;
    private boolean modified = false;
    private boolean modifying = false;
    private boolean orphaned = false;
    private String resourceClass = null;
    private boolean master = false;
    private boolean stonith = false;
    public static final String RES_ID_PREFIX = "res_";
    public static final String STONITH_ID_PREFIX = "stonith_";
    public static final String GRP_ID_PREFIX = "grp_";
    public static final String CL_ID_PREFIX = "cl_";
    public static final String MS_ID_PREFIX = "ms_";
    private static final String CLONE_SET_NAME = "Clone Set";
    private static final String MASTER_SLAVE_SET_NAME = "Master/Slave Set";
    private static final String GROUP_NAME = "Group";

    public Service(String name) {
        super(name);
    }

    public final String getHeartbeatId() {
        return this.crmId;
    }

    public final String getId() {
        return this.id;
    }

    public final void setHeartbeatId(String crmId) {
        this.crmId = crmId;
        this.id = GROUP_NAME.equals(this.getName()) ? (crmId.equals(GRP_ID_PREFIX) ? "" : (crmId.startsWith(GRP_ID_PREFIX) ? crmId.substring(GRP_ID_PREFIX.length()) : crmId)) : (CLONE_SET_NAME.equals(this.getName()) ? (crmId.equals(CL_ID_PREFIX) ? "" : (crmId.startsWith(CL_ID_PREFIX) ? crmId.substring(CL_ID_PREFIX.length()) : crmId)) : (MASTER_SLAVE_SET_NAME.equals(this.getName()) ? (crmId.equals(MS_ID_PREFIX) ? "" : (crmId.startsWith(MS_ID_PREFIX) ? crmId.substring(MS_ID_PREFIX.length()) : crmId)) : (crmId.startsWith(RES_ID_PREFIX + this.getName() + "_") ? crmId.substring((RES_ID_PREFIX + this.getName()).length() + 1) : (crmId.startsWith(STONITH_ID_PREFIX + this.getName() + "_") ? crmId.substring((STONITH_ID_PREFIX + this.getName()).length() + 1) : crmId))));
        this.setValue("id", this.id);
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final String getCrmIdFromId(String id) {
        if (GROUP_NAME.equals(this.getName())) {
            if (id.startsWith(GRP_ID_PREFIX)) {
                return id;
            }
            return GRP_ID_PREFIX + id;
        }
        if (CLONE_SET_NAME.equals(this.getName())) {
            if (id.startsWith(CL_ID_PREFIX)) {
                return id;
            }
            return CL_ID_PREFIX + id;
        }
        if (MASTER_SLAVE_SET_NAME.equals(this.getName())) {
            if (id.startsWith(MS_ID_PREFIX)) {
                return id;
            }
            return MS_ID_PREFIX + id;
        }
        if (id.startsWith(RES_ID_PREFIX + this.getName() + "_")) {
            return id;
        }
        if (id.startsWith(STONITH_ID_PREFIX + this.getName() + "_")) {
            return id;
        }
        if (this.stonith) {
            return STONITH_ID_PREFIX + this.getName() + "_" + id;
        }
        return RES_ID_PREFIX + this.getName() + "_" + id;
    }

    public final void setIdAndCrmId(String id) {
        this.id = id;
        this.crmId = this.getCrmIdFromId(id);
        this.setValue("id", id);
    }

    public final void setRemoved(boolean removed) {
        this.removed = removed;
        if (removed) {
            this.removing = true;
        }
    }

    public final boolean isRemoved() {
        return this.removed || this.removing;
    }

    public final void doneRemoving() {
        this.removing = false;
    }

    public final void setModified(boolean modified) {
        this.modified = modified;
        if (modified) {
            this.modifying = true;
        }
    }

    public final void doneModifying() {
        this.modifying = false;
    }

    public final void setAvailable() {
        this.setNew(false);
        this.modified = false;
        this.removed = false;
    }

    public final boolean isAvailable() {
        return !this.isNew() && !this.modified && !this.removed && !this.modifying && !this.removing && !this.orphaned;
    }

    public final String isAvailableWithText() {
        if (this.isNew()) {
            return "it is not applied yet";
        }
        if (this.modified) {
            return "it is being modified";
        }
        if (this.removed) {
            return "it is being removed";
        }
        if (this.modifying) {
            return "it is being modified";
        }
        if (this.removing) {
            return "it is being removed";
        }
        if (this.orphaned) {
            return "cannot do that to an orphan";
        }
        return null;
    }

    public final void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public final String getResourceClass() {
        return this.resourceClass;
    }

    public final void setMaster(boolean master) {
        this.master = master;
    }

    public final boolean isMaster() {
        return this.master;
    }

    public final void setStonith(boolean stonith) {
        this.stonith = stonith;
    }

    public final boolean isOrphaned() {
        return this.orphaned;
    }

    public final void setOrphaned(boolean orphaned) {
        this.orphaned = orphaned;
    }
}

