/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.data.Hosts;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.CommStack;
import lcmc.gui.dialog.cluster.Connect;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.utilities.Tools;

final class ClusterHosts
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private final Map<JCheckBox, Host> checkBoxToHost = new LinkedHashMap<JCheckBox, Host>();
    private static final ImageIcon HOST_CHECKED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Cluster.ClusterHosts.HostCheckedIcon"));
    private static final ImageIcon HOST_UNCHECKED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Cluster.ClusterHosts.HostUncheckedIcon"));

    ClusterHosts(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
    }

    @Override
    protected void finishDialog() {
        this.getCluster().clearHosts();
        for (JCheckBox button : this.checkBoxToHost.keySet()) {
            if (!button.isSelected()) continue;
            Host host = this.checkBoxToHost.get(button);
            host.setCluster(this.getCluster());
            this.getCluster().addHost(host);
        }
        Tools.getGUIData().refreshClustersPanel();
    }

    @Override
    public WizardDialog nextDialog() {
        boolean allConnected = true;
        for (Host host : this.getCluster().getHosts()) {
            if (host.isConnected()) continue;
            allConnected = false;
        }
        if (allConnected) {
            return new CommStack(this, this.getCluster());
        }
        return new Connect(this, this.getCluster());
    }

    protected void checkCheckBoxes() {
        Tools.getConfigData().getHosts().removeHostsFromCluster(this.getCluster());
        int selected = 0;
        for (JCheckBox button : this.checkBoxToHost.keySet()) {
            if (!button.isSelected()) continue;
            ++selected;
        }
        boolean enable = true;
        ArrayList<String> hostnames = new ArrayList<String>();
        if (selected < 1 || selected == 1 && !Tools.getConfigData().isOneHostCluster()) {
            enable = false;
        } else {
            for (JCheckBox button : this.checkBoxToHost.keySet()) {
                if (!button.isSelected() || !button.isEnabled()) continue;
                Host host = this.checkBoxToHost.get(button);
                String hostname = host.getHostname();
                if (hostnames.contains(hostname)) {
                    enable = false;
                    break;
                }
                hostnames.add(hostname);
            }
        }
        final boolean enableButton = enable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterHosts.this.buttonClass(ClusterHosts.this.nextButton()).setEnabled(enableButton);
            }
        });
        if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.ClusterHosts.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.ClusterHosts.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterHosts.this.checkCheckBoxes();
            }
        });
        thread.start();
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
    }

    @Override
    protected JComponent getInputPane() {
        ScrollableFlowPanel p1 = new ScrollableFlowPanel(new FlowLayout(3, 1, 1));
        Hosts hosts = Tools.getConfigData().getHosts();
        ItemListener chListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ClusterHosts.this.checkCheckBoxes();
            }
        };
        Host lastHost1 = null;
        Host lastHost2 = null;
        if (this.getCluster().getHosts().size() == 0) {
            for (Host host : hosts.getHostsArray()) {
                if (this.getCluster().getHosts().contains(host) || host.isInCluster()) continue;
                if (lastHost2 != null && lastHost2.getIp() != null && lastHost2.getIp().equals(host.getIp())) {
                    lastHost2 = host;
                    continue;
                }
                lastHost1 = lastHost2;
                lastHost2 = host;
            }
        }
        JScrollPane sp = new JScrollPane(p1, 22, 31);
        JCheckBox lastButton = null;
        for (Host host : hosts.getHostsArray()) {
            JCheckBox button;
            lastButton = button = new JCheckBox(host.getName(), HOST_UNCHECKED_ICON);
            button.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
            button.setSelectedIcon(HOST_CHECKED_ICON);
            if (this.getCluster().getBrowser() != null && this.getCluster() == host.getCluster()) {
                button.setEnabled(false);
            } else if (host.isInCluster(this.getCluster())) {
                button.setEnabled(false);
            }
            this.checkBoxToHost.put(button, host);
            if (this.getCluster().getHosts().contains(host)) {
                button.setSelected(true);
            } else if (host == lastHost1 || host == lastHost2) {
                button.setSelected(true);
            } else {
                button.setSelected(false);
            }
            button.addItemListener(chListener);
            p1.add(button);
        }
        p1.setBackground(Color.WHITE);
        return sp;
    }

    private class ScrollableFlowPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        ScrollableFlowPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, this.getParent().getWidth(), height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getWidth(), this.getPreferredHeight());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int hundredth = (orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth()) / 100;
            return hundredth == 0 ? 1 : hundredth;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        private int getPreferredHeight() {
            int rv = 0;
            int count = this.getComponentCount();
            for (int k = 0; k < count; ++k) {
                Component comp = this.getComponent(k);
                Rectangle r = comp.getBounds();
                int height = r.y + r.height;
                if (height <= rv) continue;
                rv = height;
            }
            return rv += ((FlowLayout)this.getLayout()).getVgap();
        }
    }
}

