/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.Devices;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.SSH;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

public class Configuration
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private static final int MAX_HOPS = Tools.getDefaultInt("MaxHops");
    private Widget[] hostnameField = new Widget[MAX_HOPS];
    private Widget[] ipCombo = new Widget[MAX_HOPS];
    private String[] hostnames = new String[MAX_HOPS];
    private volatile boolean hostnameOk = false;
    private static final int COMBO_BOX_WIDTH = 120;
    private static final int DNS_TIMEOUT = 5000;

    public Configuration(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void finishDialog() {
        this.getHost().setHostname(Tools.join(",", this.hostnames, this.getHops()));
        int hops = this.getHops();
        String[] ipsA = new String[hops];
        for (int i = 0; i < hops; ++i) {
            ipsA[i] = this.ipCombo[i].getStringValue();
        }
        this.getHost().setIp(Tools.join(",", ipsA));
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.hostnameOk) {
            if (this.getHost().isConnected()) {
                return new Devices(this, this.getHost());
            }
            return new SSH(this, this.getHost());
        }
        return this;
    }

    @Override
    protected final void checkFields(Widget field) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JComponent btn : Configuration.this.nextButtons()) {
                    btn.setEnabled(Configuration.this.hostnameOk);
                }
            }
        });
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.Configuration.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.Configuration.Description");
    }

    protected final boolean checkDNS(int hop, String hostnameEntered) {
        InetAddress[] addresses = null;
        try {
            addresses = InetAddress.getAllByName(hostnameEntered);
        }
        catch (UnknownHostException e) {
            return false;
        }
        String hostname = null;
        String ip = null;
        Tools.debug(this, "addresses.length: " + addresses.length + " a: " + addresses[0].getHostAddress(), 2);
        if (addresses.length == 0) {
            Tools.debug(this, "lookup failed");
            return false;
        }
        if (addresses.length == 1) {
            ip = addresses[0].getHostAddress();
            try {
                hostname = InetAddress.getByName(ip).getHostName();
            }
            catch (UnknownHostException e) {
                Tools.appError("Host.Configuration.Unknown.Host", "", e);
                return false;
            }
        } else {
            hostname = hostnameEntered;
            ip = this.getHost().getIp(hop);
            if (ip == null) {
                ip = addresses[0].getHostAddress();
            }
        }
        String[] items = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            items[i] = addresses[i].getHostAddress();
        }
        this.getHost().setIps(hop, items);
        this.hostnames[hop] = hostname;
        this.hostnameField[hop].setValue(hostname);
        Tools.debug(this, "got " + hostname + " (" + ip + ")", 1);
        return true;
    }

    protected final int getHops() {
        String hostnameEntered = this.getHost().getHostnameEntered();
        return Tools.charCount(hostnameEntered, ',') + 1;
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(this.nextButtons());
    }

    @Override
    protected final void initDialogAfterVisible() {
        if (this.getHost().getIp() == null || "".equals(this.getHost().getIp())) {
            final CheckDNSThread[] checkDNSThread = new CheckDNSThread[MAX_HOPS];
            this.getProgressBar().start(5000);
            for (int i = 0; i < this.getHops(); ++i) {
                String hostnameEntered = this.getHost().getHostnameEntered().split(",")[i];
                this.hostnameField[i].setEnabled(false);
                if (Tools.isIp(hostnameEntered)) {
                    this.hostnames[i] = hostnameEntered;
                    this.hostnameField[i].setValue(hostnameEntered);
                    this.getHost().setIp(hostnameEntered);
                    this.getHost().setIps(i, new String[]{hostnameEntered});
                    this.ipCombo[i].reloadComboBox(hostnameEntered, new String[]{hostnameEntered});
                    this.hostnameOk = true;
                    continue;
                }
                checkDNSThread[i] = new CheckDNSThread(i, hostnameEntered);
                checkDNSThread[i].setPriority(1);
                checkDNSThread[i].start();
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < Configuration.this.getHops(); ++i) {
                        if (checkDNSThread[i] == null) continue;
                        try {
                            checkDNSThread[i].join();
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    Configuration.this.progressBarDone();
                    Configuration.this.getHost().setHostname(Tools.join(",", Configuration.this.hostnames, Configuration.this.getHops()));
                    String name = Configuration.this.getHost().getName();
                    if (name == null || "null".equals(name)) {
                        name = "";
                    }
                    Configuration.this.enableComponents();
                    if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
                        Tools.sleep(1000);
                        Configuration.this.pressNextButton();
                    }
                }
            });
            thread.start();
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Configuration.this.getHost().setHostname(Tools.join(",", Configuration.this.hostnames, Configuration.this.getHops()));
                    String name = Configuration.this.getHost().getName();
                    if (name == null || "null".equals(name)) {
                        name = "";
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < Configuration.this.getHops(); ++i) {
                                Configuration.this.hostnameField[i].setEnabled(false);
                            }
                        }
                    });
                    Configuration.this.enableComponents();
                    Configuration.this.hostnameOk = true;
                    if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
                        Tools.sleep(1000);
                        Configuration.this.pressNextButton();
                    }
                }
            });
            thread.start();
        }
    }

    @Override
    protected final JComponent getInputPane() {
        int hops = this.getHops();
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setAlignmentX(0.0f);
        JLabel hostnameLabel = new JLabel(Tools.getString("Dialog.Host.Configuration.Hostname"));
        inputPane.add(hostnameLabel);
        String hostname = this.getHost().getHostname();
        if (hostname == null || Tools.charCount(hostname, ',') == 0) {
            this.hostnames[0] = hostname;
        } else {
            this.hostnames = hostname.split(",");
        }
        for (int i = 0; i < hops; ++i) {
            this.hostnameField[i] = WidgetFactory.createInstance(Widget.GUESS_TYPE, this.hostnames[i], Widget.NO_ITEMS, Widget.NO_REGEXP, 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
            inputPane.add(this.hostnameField[i]);
        }
        JLabel ipLabel = new JLabel(Tools.getString("Dialog.Host.Configuration.Ip"));
        inputPane.add(ipLabel);
        for (int i = 0; i < hops; ++i) {
            if (this.getHost().getIp(i) == null) {
                this.getHost().setIps(i, null);
            }
            this.ipCombo[i] = WidgetFactory.createInstance(Widget.Type.COMBOBOX, this.getHost().getIp(i), this.getHost().getIps(i), Widget.NO_REGEXP, 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
            inputPane.add(this.ipCombo[i]);
            this.ipCombo[i].setEnabled(false);
        }
        SpringUtilities.makeCompactGrid(inputPane, 2, 1 + hops, 0, 0, 0, 0);
        JPanel pane = new JPanel(new SpringLayout());
        pane.setBorder(null);
        pane.add(inputPane);
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }

    protected JComponent[] nextButtons() {
        return new JComponent[]{this.buttonClass(this.nextButton())};
    }

    private class CheckDNSThread
    extends Thread {
        private final int hop;
        private final String hostnameEntered;

        CheckDNSThread(int hop, String hostnameEntered) {
            this.hop = hop;
            this.hostnameEntered = hostnameEntered;
        }

        @Override
        public void run() {
            Configuration.this.answerPaneSetText(Tools.getString("Dialog.Host.Configuration.DNSLookup"));
            Configuration.this.hostnameOk = Configuration.this.checkDNS(this.hop, this.hostnameEntered);
            if (Configuration.this.hostnameOk) {
                Configuration.this.answerPaneSetText(Tools.getString("Dialog.Host.Configuration.DNSLookupOk"));
            } else {
                Configuration.this.printErrorAndRetry(Tools.getString("Dialog.Host.Configuration.DNSLookupError"));
            }
            final String[] items = Configuration.this.getHost().getIps(this.hop);
            if (items != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Configuration.this.ipCombo[CheckDNSThread.this.hop].reloadComboBox(Configuration.this.getHost().getIp(CheckDNSThread.this.hop), items);
                        if (items.length > 1) {
                            Configuration.this.ipCombo[CheckDNSThread.this.hop].setEnabled(true);
                        }
                    }
                });
            }
        }
    }
}

