/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.Tools;

final class DistDetection
extends DialogHost {
    private static final long serialVersionUID = 1L;

    DistDetection(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
        String support = Tools.getDistString("Support", this.getHost().getDist(), this.getHost().getDistVersionString(), this.getHost().getArch());
        String answerText = "\nversion: " + this.getHost().getDetectedInfo() + " (support file: " + support + ")";
        this.answerPaneSetText(answerText);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return new CheckInstallation(this, this.getHost());
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DistDetection.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.DistDetection.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DistDetection.Executing")));
        SpringUtilities.makeCompactGrid(pane, 1, 1, 1, 1, 1, 1);
        return pane;
    }
}

