/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.LinbitLogin;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public class DrbdAvailFiles
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private Widget drbdVersionCombo = null;
    private Widget drbdBuildCombo = null;
    private boolean listenersAdded = false;

    public DrbdAvailFiles(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.listenersAdded = false;
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
        this.disableComponents(new JComponent[]{this.drbdVersionCombo, this.drbdBuildCombo});
    }

    @Override
    protected void initDialogAfterVisible() {
        String selectedItem;
        this.getProgressBar().start(4000);
        this.getHost().setDrbdBuildToInstall(this.getHost().getDetectedKernelVersion());
        Object[] versions = this.getHost().getAvailableDrbdVersions();
        if (versions != null && versions.length != 0) {
            String version2 = versions[versions.length - 1];
            this.drbdVersionCombo.reloadComboBox(version2, versions);
            Tools.waitForSwing();
        }
        if ((selectedItem = this.drbdVersionCombo.getStringValue()) == null) {
            this.allDone();
        } else {
            this.getHost().setDrbdVersionToInstall(selectedItem);
            this.availBuilds();
        }
    }

    protected final void availBuilds() {
        this.getHost().execCommand("DrbdAvailBuilds", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                String defaultValue = DrbdAvailFiles.this.getHost().getDrbdBuildToInstall();
                Object[] items = ans.split("\\r?\\n");
                boolean found = false;
                for (String string : items) {
                    if (!string.equals(defaultValue)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    defaultValue = defaultValue.replaceAll("-", "_");
                }
                String defaultValueCopy = defaultValue;
                DrbdAvailFiles.this.drbdBuildCombo.clear();
                DrbdAvailFiles.this.drbdBuildCombo.reloadComboBox(defaultValueCopy, items);
                Tools.waitForSwing();
                String selectedItem = DrbdAvailFiles.this.drbdBuildCombo.getStringValue();
                DrbdAvailFiles.this.drbdBuildCombo.setEnabled(true);
                if (selectedItem == null) {
                    DrbdAvailFiles.this.allDone();
                } else {
                    DrbdAvailFiles.this.getHost().setDrbdBuildToInstall(selectedItem);
                    if (!DrbdAvailFiles.this.listenersAdded) {
                        DrbdAvailFiles.this.availFiles();
                    }
                }
            }

            @Override
            public void doneError(final String ans, final int exitCode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdAvailFiles.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdAvailFiles.NoBuilds"), ans, exitCode);
                    }
                });
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    protected final void availFiles() {
        this.drbdBuildCombo.setEnabled(true);
        this.getHost().execCommand("DrbdAvailFiles", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                ArrayList<String> files = new ArrayList<String>(Arrays.asList(ans.split("\\r?\\n")));
                if (files.size() >= 2) {
                    if (files.size() > 4) {
                        files.remove(0);
                    }
                    final String[] filesA = files.toArray(new String[files.size()]);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DrbdAvailFiles.this.answerPaneSetText(Tools.join("\n", filesA));
                        }
                    });
                    DrbdAvailFiles.this.getHost().setDrbdPackagesToInstall(Tools.shellList(filesA));
                    DrbdAvailFiles.this.allDone();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DrbdAvailFiles.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdAvailFiles.NoFiles"));
                        }
                    });
                }
            }

            @Override
            public void doneError(final String ans, final int exitCode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdAvailFiles.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdAvailFiles.NoBuilds"), ans, exitCode);
                    }
                });
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    protected final void allDone() {
        this.nextDialogObject = new LinbitLogin(this, this.getHost());
        this.progressBarDone();
        this.enableComponents();
        this.buttonClass(this.nextButton()).requestFocus();
        if (!this.listenersAdded) {
            this.addListeners();
            this.listenersAdded = true;
        }
        if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected final String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DrbdAvailFiles.Title");
    }

    @Override
    protected final String getDescription() {
        return Tools.getString("Dialog.Host.DrbdAvailFiles.Description");
    }

    protected final JPanel getChoiceBoxes() {
        JPanel pane = new JPanel(new SpringLayout());
        this.drbdVersionCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        pane.add(this.drbdVersionCombo);
        this.drbdBuildCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        pane.add(this.drbdBuildCombo);
        SpringUtilities.makeCompactGrid(pane, 1, 2, 1, 1, 1, 1);
        return pane;
    }

    private void addListeners() {
        this.drbdVersionCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                DrbdAvailFiles.this.enableComponentsLater(new JComponent[]{DrbdAvailFiles.this.buttonClass(DrbdAvailFiles.this.nextButton())});
                DrbdAvailFiles.this.disableComponents(new JComponent[]{DrbdAvailFiles.this.drbdBuildCombo});
                final String item = DrbdAvailFiles.this.drbdVersionCombo.getStringValue();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdAvailFiles.this.getHost().setDrbdVersionToInstall(item);
                        DrbdAvailFiles.this.availBuilds();
                    }
                });
            }
        });
        this.drbdBuildCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                String item = DrbdAvailFiles.this.drbdBuildCombo.getStringValue();
                DrbdAvailFiles.this.getHost().setDrbdBuildToInstall(item);
                DrbdAvailFiles.this.availFiles();
            }
        });
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getChoiceBoxes());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DrbdAvailFiles.Executing")));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }
}

