/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;

abstract class DrbdGuiInfo
extends EditableInfo {
    protected static final String DRBD_RES_PARAM_AFTER = "resync-after";
    protected static final String DRBD_RES_PARAM_AFTER_8_3 = "after";

    public DrbdGuiInfo(String name, Browser browser) {
        super(name, browser);
    }

    @Override
    public final ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    public final Cluster getCluster() {
        return this.getBrowser().getCluster();
    }

    public final DrbdInfo getDrbdInfo() {
        return this.getBrowser().getDrbdGraph().getDrbdInfo();
    }

    @Override
    protected String getParamRegexp(String param) {
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return this.getBrowser().getDrbdXML().checkParam(param, newValue);
    }

    @Override
    public String getParamDefault(String param) {
        return this.getBrowser().getDrbdXML().getParamDefault(param);
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected final String getParamPreferred(String param) {
        return this.getBrowser().getDrbdXML().getParamPreferred(param);
    }

    @Override
    protected final Object[] getParamPossibleChoices(String param) {
        return this.getBrowser().getDrbdXML().getPossibleChoices(param);
    }

    @Override
    protected final String getParamShortDesc(String param) {
        return this.getBrowser().getDrbdXML().getParamShortDesc(param);
    }

    @Override
    protected final String getParamLongDesc(String param) {
        return this.getBrowser().getDrbdXML().getParamLongDesc(param);
    }

    @Override
    protected final boolean isRequired(String param) {
        return this.getBrowser().getDrbdXML().isRequired(param);
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (!Tools.areEqual(this.getParamDefault(param), this.getParamSaved(param))) {
            return false;
        }
        return this.getBrowser().getDrbdXML().isAdvanced(param);
    }

    @Override
    protected final ConfigData.AccessType getAccessType(String param) {
        return this.getBrowser().getDrbdXML().getAccessType(param);
    }

    @Override
    protected final boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected final boolean isInteger(String param) {
        return this.getBrowser().getDrbdXML().isInteger(param);
    }

    @Override
    protected final boolean isLabel(String param) {
        return this.getBrowser().getDrbdXML().isLabel(param);
    }

    @Override
    protected final boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected final boolean hasUnitPrefix(String param) {
        return this.getBrowser().getDrbdXML().hasUnitPrefix(param);
    }

    protected final String getUnitLong(String param) {
        return this.getBrowser().getDrbdXML().getUnitLong(param);
    }

    protected final String getDefaultUnit(String param) {
        return this.getBrowser().getDrbdXML().getDefaultUnit(param);
    }

    @Override
    protected final boolean isCheckBox(String param) {
        String type = this.getBrowser().getDrbdXML().getParamType(param);
        if (type == null) {
            return false;
        }
        return "boolean".equals(type);
    }

    @Override
    protected final String getParamType(String param) {
        return this.getBrowser().getDrbdXML().getParamType(param);
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi;
        Object[] possibleChoices = this.getParamPossibleChoices(param);
        this.getResource().setPossibleChoices(param, possibleChoices);
        if (this.hasUnitPrefix(param)) {
            String unit;
            String selectedValue = this.getParamSaved(param);
            if (selectedValue == null && (selectedValue = this.getParamPreferred(param)) == null) {
                selectedValue = this.getParamDefault(param);
            }
            if ((unit = this.getUnitLong(param)) == null) {
                unit = "";
            }
            int index = unit.indexOf(47);
            String unitPart = "";
            if (index > -1) {
                unitPart = unit.substring(index);
            }
            Object type = null;
            Unit[] units = null;
            units = "".equals(unit) ? new Unit[]{new Unit("", "", "", ""), new Unit("k", "K", "k", "k"), new Unit("m", "M", "m", "m"), new Unit("g", "G", "g", "g")} : new Unit[]{new Unit("", "", "Byte", "Bytes"), new Unit("K", "k", "KiByte" + unitPart, "KiBytes" + unitPart), new Unit("M", "m", "MiByte" + unitPart, "MiBytes" + unitPart), new Unit("G", "g", "GiByte" + unitPart, "GiBytes" + unitPart), new Unit("s", "s", "Sector" + unitPart, "Sectors" + unitPart)};
            paramWi = WidgetFactory.createInstance(Widget.Type.TEXTFIELDWITHUNIT, selectedValue, this.getPossibleChoices(param), units, Widget.NO_REGEXP, width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            this.widgetAdd(param, prefix, paramWi);
        } else {
            paramWi = super.createWidget(param, prefix, width);
            if (possibleChoices != null && !this.getBrowser().getDrbdXML().isStringType(param)) {
                paramWi.setEditable(false);
            }
        }
        return paramWi;
    }

    protected String drbdSectionsConfig(Host host) throws Exceptions.DrbdConfigException {
        StringBuilder config = new StringBuilder("");
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        String[] sections = dxml.getSections();
        boolean volumesAvailable = host.hasVolumes();
        for (String sectionString : sections) {
            String[] params;
            String section;
            if (!this.isSectionEnabled(sectionString) || "resource".equals(section = sectionString.replaceAll("-options$", "")) || "global".equals(section) || (params = dxml.getSectionParams(sectionString)).length == 0) continue;
            StringBuilder sectionConfig = new StringBuilder("");
            boolean inPlugin = false;
            for (String param : params) {
                String value = this.getComboBoxValue(param);
                if (value == null || "".equals(value) || value.equals(this.getParamDefault(param))) continue;
                if (param.startsWith("plugin-")) {
                    if (!inPlugin) {
                        sectionConfig.append("\t\tplugin {\n");
                        inPlugin = true;
                    }
                    sectionConfig.append("\t\t\t");
                    sectionConfig.append(param.substring("plugin-".length(), param.length()));
                    if (value.equals("yes")) {
                        sectionConfig.append(";\n");
                        continue;
                    }
                    sectionConfig.append(' ');
                    sectionConfig.append(value);
                    sectionConfig.append(";\n");
                    continue;
                }
                if (!volumesAvailable && (this.isCheckBox(param) || "booleanhandler".equals(this.getParamType(param)))) {
                    if (!value.equals("yes")) continue;
                    sectionConfig.append("\t\t" + param + ";\n");
                    continue;
                }
                if (DRBD_RES_PARAM_AFTER.equals(param)) {
                    if (value.equals(Tools.getString("ClusterBrowser.None")) || value == null) continue;
                    sectionConfig.append("\t\t");
                    sectionConfig.append(param);
                    sectionConfig.append('\t');
                    sectionConfig.append(Tools.escapeConfig(value));
                    sectionConfig.append(";\n");
                    continue;
                }
                if (DRBD_RES_PARAM_AFTER_8_3.equals(param)) {
                    if (value.equals(Tools.getString("ClusterBrowser.None"))) continue;
                    DrbdResourceInfo v0 = this.getBrowser().getDrbdResHash().get(value);
                    this.getBrowser().putDrbdResHash();
                    if (v0 == null) continue;
                    String v = v0.getName();
                    sectionConfig.append("\t\t");
                    sectionConfig.append(param);
                    sectionConfig.append('\t');
                    sectionConfig.append(Tools.escapeConfig(v));
                    sectionConfig.append(";\n");
                    continue;
                }
                if (inPlugin) {
                    sectionConfig.append("\t\t}\n");
                    inPlugin = false;
                }
                sectionConfig.append("\t\t");
                sectionConfig.append(param);
                sectionConfig.append('\t');
                sectionConfig.append(Tools.escapeConfig(value));
                sectionConfig.append(";\n");
            }
            if (inPlugin) {
                sectionConfig.append("\t\t}\n");
                inPlugin = false;
            }
            if (sectionConfig.length() <= 0) continue;
            config.append("\t" + section + " {\n");
            config.append((CharSequence)sectionConfig);
            config.append("\t}\n\n");
        }
        return config.toString();
    }
}

