/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.data.ResourceAgent;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.CRMGraph;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.dialog.ClusterLogs;
import lcmc.gui.resources.CloneInfo;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.DrbddiskInfo;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.FilesystemInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HbOrderInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.gui.resources.IPaddrInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.LinbitDrbdInfo;
import lcmc.gui.resources.PcmkRscSetsInfo;
import lcmc.gui.resources.RscDefaultsInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.VirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.MyList;
import lcmc.utilities.MyListModel;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.UpdatableItem;

public final class ServicesInfo
extends EditableInfo {
    private JComponent infoPanel = null;
    public static final CloneInfo NO_CLONE = null;

    public ServicesInfo(String name, Browser browser) {
        super(name, browser);
        this.setResource(new Resource(name));
    }

    @Override
    public ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    void setInfoPanel(JComponent infoPanel) {
        this.infoPanel = infoPanel;
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return null;
    }

    @Override
    public String[] getParametersFromXML() {
        CRMXML crmxml = this.getBrowser().getCRMXML();
        if (crmxml == null) {
            return null;
        }
        return crmxml.getGlobalParameters();
    }

    @Override
    protected String getParamLongDesc(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamLongDesc(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamShortDesc(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamDefault(param);
    }

    @Override
    protected String getParamPreferred(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamPreferred(param);
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamPossibleChoices(param);
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return this.getBrowser().getCRMXML().checkGlobalParam(param, newValue);
    }

    @Override
    protected boolean isInteger(String param) {
        return this.getBrowser().getCRMXML().isGlobalInteger(param);
    }

    @Override
    protected boolean isLabel(String param) {
        return this.getBrowser().getCRMXML().isGlobalLabel(param);
    }

    @Override
    protected boolean isTimeType(String param) {
        return this.getBrowser().getCRMXML().isGlobalTimeType(param);
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (!Tools.areEqual(this.getParamDefault(param), this.getParamSaved(param))) {
            return false;
        }
        return this.getBrowser().getCRMXML().isGlobalAdvanced(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return this.getBrowser().getCRMXML().getGlobalAccessType(param);
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected boolean isRequired(String param) {
        return this.getBrowser().getCRMXML().isGlobalRequired(param);
    }

    @Override
    protected boolean isCheckBox(String param) {
        return this.getBrowser().getCRMXML().isGlobalBoolean(param);
    }

    @Override
    protected String getParamType(String param) {
        return this.getBrowser().getCRMXML().getGlobalParamType(param);
    }

    @Override
    protected String getSection(String param) {
        return this.getBrowser().getCRMXML().getGlobalSection(param);
    }

    void apply(Host dcHost, boolean testOnly) {
        String[] params = this.getParametersFromXML();
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ServicesInfo.this.getApplyButton().setEnabled(false);
                    ServicesInfo.this.getRevertButton().setEnabled(false);
                    ServicesInfo.this.getApplyButton().setToolTipText(null);
                }
            });
        }
        this.getInfoPanel();
        this.waitForInfoPanel();
        HashMap<String, String> args = new HashMap<String, String>();
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (value.equals(this.getParamDefault(param)) || "".equals(value)) continue;
            args.put(param, value);
        }
        RscDefaultsInfo rdi = this.getBrowser().getRscDefaultsInfo();
        String[] rdiParams = rdi.getParametersFromXML();
        LinkedHashMap<String, String> rdiMetaArgs = new LinkedHashMap<String, String>();
        for (String param : rdiParams) {
            String value = rdi.getComboBoxValue(param);
            if (value.equals(rdi.getParamDefault(param)) || "".equals(value)) continue;
            rdiMetaArgs.put(param, value);
        }
        String rscDefaultsId = this.getBrowser().getClusterStatus().getRscDefaultsId(testOnly);
        CRM.setGlobalParameters(dcHost, args, rdiMetaArgs, rscDefaultsId, testOnly);
        if (!testOnly) {
            this.storeComboBoxValues(params);
            rdi.storeComboBoxValues(rdiParams);
        }
        for (ServiceInfo si : this.getBrowser().getExistingServiceList(null)) {
            if (!si.checkResourceFieldsCorrect(null, si.getParametersFromXML(), true, false, false) || !si.checkResourceFieldsChanged(null, si.getParametersFromXML(), true, false, false)) continue;
            si.apply(dcHost, testOnly);
        }
        if (!testOnly) {
            this.setApplyButtons(null, params);
        }
    }

    public void setGlobalConfig(ClusterStatus clStatus) {
        String[] params;
        for (String param : params = this.getParametersFromXML()) {
            String value = clStatus.getGlobalParam(param);
            String oldValue = this.getParamSaved(param);
            if (value == null || value.equals(oldValue)) continue;
            this.getResource().setValue(param, value);
            Widget wi = this.getWidget(param, null);
            if (wi == null) continue;
            wi.setValue(value);
        }
        if (this.infoPanel == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServicesInfo.this.getInfoPanel();
                }
            });
        }
    }

    private void setFilesystemWithDrbd(ServiceInfo siP, ServiceInfo si) {
        if (siP.getResourceAgent().isLinbitDrbd()) {
            ((FilesystemInfo)si).setLinbitDrbdInfo((LinbitDrbdInfo)siP);
        } else {
            ((FilesystemInfo)si).setDrbddiskInfo((DrbddiskInfo)siP);
        }
    }

    private CloneInfo setCreateCloneInfo(String cloneId, ClusterStatus clStatus, boolean testOnly) {
        CloneInfo newCi = null;
        newCi = (CloneInfo)this.getBrowser().getServiceInfoFromCRMId(cloneId);
        CRMGraph hg = this.getBrowser().getCRMGraph();
        if (newCi == null) {
            Point2D p = null;
            newCi = (CloneInfo)this.addServicePanel(this.getBrowser().getCRMXML().getHbClone(), p, false, cloneId, null, testOnly);
            this.getBrowser().addToHeartbeatIdList(newCi);
            Map<String, String> resourceNode = clStatus.getParamValuePairs(newCi.getHeartbeatId(testOnly));
            newCi.setParameters(resourceNode);
        } else {
            Map<String, String> resourceNode = clStatus.getParamValuePairs(newCi.getHeartbeatId(testOnly));
            newCi.setParameters(resourceNode);
            if (!testOnly) {
                newCi.setUpdated(false);
                hg.repaint();
            }
        }
        newCi.getService().setNew(false);
        return newCi;
    }

    private GroupInfo setCreateGroupInfo(String group, CloneInfo newCi, ClusterStatus clStatus, boolean testOnly) {
        GroupInfo newGi = null;
        newGi = (GroupInfo)this.getBrowser().getServiceInfoFromCRMId(group);
        CRMGraph hg = this.getBrowser().getCRMGraph();
        if (newGi == null) {
            Point2D p = null;
            newGi = (GroupInfo)this.addServicePanel(this.getBrowser().getCRMXML().getHbGroup(), p, false, group, newCi, testOnly);
            Map<String, String> resourceNode = clStatus.getParamValuePairs(newGi.getHeartbeatId(testOnly));
            newGi.setParameters(resourceNode);
            if (newCi != null) {
                newCi.addCloneServicePanel(newGi);
            }
        } else {
            Map<String, String> resourceNode = clStatus.getParamValuePairs(newGi.getHeartbeatId(testOnly));
            newGi.setParameters(resourceNode);
            if (!testOnly) {
                newGi.setUpdated(false);
                hg.repaint();
            }
        }
        newGi.getService().setNew(false);
        return newGi;
    }

    private void setGroupResources(Set<String> allGroupsAndClones, String grpOrCloneId, GroupInfo newGi, CloneInfo newCi, List<ServiceInfo> serviceIsPresent, List<ServiceInfo> groupServiceIsPresent, ClusterStatus clStatus, boolean testOnly) {
        HashMap<ServiceInfo, Map<String, String>> setParametersHash = new HashMap<ServiceInfo, Map<String, String>>();
        if (newCi != null) {
            setParametersHash.put(newCi, clStatus.getParamValuePairs(grpOrCloneId));
        } else if (newGi != null) {
            setParametersHash.put(newGi, clStatus.getParamValuePairs(grpOrCloneId));
        }
        CRMGraph hg = this.getBrowser().getCRMGraph();
        boolean newService = false;
        int pos = 0;
        List<String> gs = clStatus.getGroupResources(grpOrCloneId, testOnly);
        if (gs == null) {
            return;
        }
        for (String hbId : gs) {
            DefaultMutableTreeNode n;
            ServiceInfo newSi;
            if (clStatus.isOrphaned(hbId) && Tools.getConfigData().isNoLRM()) continue;
            if (allGroupsAndClones.contains(hbId)) {
                if (newGi != null) {
                    Tools.appWarning("group in group not implemented");
                    continue;
                }
                GroupInfo gi = this.setCreateGroupInfo(hbId, newCi, clStatus, testOnly);
                this.setGroupResources(allGroupsAndClones, hbId, gi, null, serviceIsPresent, groupServiceIsPresent, clStatus, testOnly);
                newSi = gi;
            } else {
                ResourceAgent newRA = clStatus.getResourceType(hbId);
                if (newRA == null) {
                    Tools.appWarning(hbId + ": could not find resource agent");
                }
                newSi = this.getBrowser().getServiceInfoFromCRMId(hbId);
                Map<String, String> resourceNode = clStatus.getParamValuePairs(hbId);
                if (newSi == null) {
                    newService = true;
                    String serviceName = newRA == null ? hbId : newRA.getName();
                    newSi = newRA != null && newRA.isFilesystem() ? new FilesystemInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser()) : (newRA != null && newRA.isLinbitDrbd() ? new LinbitDrbdInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser()) : (newRA != null && newRA.isDrbddisk() ? new DrbddiskInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser()) : (newRA != null && newRA.isIPaddr() ? new IPaddrInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser()) : (newRA != null && newRA.isVirtualDomain() ? new VirtualDomainInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser()) : new ServiceInfo(serviceName, newRA, hbId, resourceNode, this.getBrowser())))));
                    newSi.getService().setHeartbeatId(hbId);
                    this.getBrowser().addToHeartbeatIdList(newSi);
                    Point2D p = null;
                    if (newGi != null) {
                        newGi.addGroupServicePanel(newSi, false);
                    } else if (newCi != null) {
                        newCi.addCloneServicePanel(newSi);
                    } else {
                        this.addServicePanel(newSi, p, false, false, testOnly);
                    }
                } else {
                    this.getBrowser().addNameToServiceInfoHash(newSi);
                    setParametersHash.put(newSi, resourceNode);
                }
                newSi.getService().setNew(false);
                serviceIsPresent.add(newSi);
                if (newGi != null || newCi != null) {
                    groupServiceIsPresent.add(newSi);
                }
            }
            if ((n = newSi.getNode()) == null) continue;
            final int p = pos++;
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int i;
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)n.getParent();
                    if (parent != null && (i = parent.getIndex(n)) > p) {
                        parent.remove(n);
                        parent.insert(n, p);
                        ServicesInfo.this.getBrowser().reloadAndWait(parent, false);
                    }
                }
            });
        }
        for (ServiceInfo newSi : setParametersHash.keySet()) {
            newSi.setParameters((Map)setParametersHash.get(newSi));
            if (testOnly) continue;
            newSi.setUpdated(false);
        }
        if (newService) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServicesInfo.this.getBrowser().reloadAndWait(ServicesInfo.this.getBrowser().getServicesNode(), false);
                }
            });
        }
        hg.repaint();
    }

    public void setAllResources(ClusterStatus clStatus, boolean testOnly) {
        ServiceInfo siP;
        if (clStatus == null) {
            return;
        }
        Set<String> allGroupsAndClones = clStatus.getAllGroups();
        final CRMGraph hg = this.getBrowser().getCRMGraph();
        ArrayList<ServiceInfo> groupServiceIsPresent = new ArrayList<ServiceInfo>();
        ArrayList<ServiceInfo> serviceIsPresent = new ArrayList<ServiceInfo>();
        for (String groupOrClone : allGroupsAndClones) {
            CloneInfo newCi = null;
            GroupInfo newGi = null;
            if (clStatus.isClone(groupOrClone)) {
                newCi = this.setCreateCloneInfo(groupOrClone, clStatus, testOnly);
                serviceIsPresent.add(newCi);
            } else if (!"none".equals(groupOrClone)) {
                GroupInfo gi = (GroupInfo)this.getBrowser().getServiceInfoFromCRMId(groupOrClone);
                if (gi != null && gi.getCloneInfo() != null) {
                    groupServiceIsPresent.add(gi);
                    continue;
                }
                newGi = this.setCreateGroupInfo(groupOrClone, newCi, clStatus, testOnly);
                serviceIsPresent.add(newGi);
            }
            this.setGroupResources(allGroupsAndClones, groupOrClone, newGi, newCi, serviceIsPresent, groupServiceIsPresent, clStatus, testOnly);
        }
        hg.clearKeepColocationList();
        hg.clearKeepOrderList();
        List<CRMXML.RscSetConnectionData> rscSetConnections = clStatus.getRscSetConnections();
        if (rscSetConnections != null) {
            LinkedHashMap<CRMXML.RscSetConnectionData, ConstraintPHInfo> rdataToCphi = new LinkedHashMap<CRMXML.RscSetConnectionData, ConstraintPHInfo>();
            this.getBrowser().lockNameToServiceInfo();
            Map<String, ServiceInfo> idToInfoHash = this.getBrowser().getNameToServiceInfoHash("Placeholder");
            ArrayList<ConstraintPHInfo> preNewCphis = new ArrayList<ConstraintPHInfo>();
            if (idToInfoHash != null) {
                for (String id : idToInfoHash.keySet()) {
                    ConstraintPHInfo constraintPHInfo = (ConstraintPHInfo)idToInfoHash.get(id);
                    CRMXML.RscSetConnectionData rdataOrd = constraintPHInfo.getRscSetConnectionDataOrd();
                    CRMXML.RscSetConnectionData rdataCol = constraintPHInfo.getRscSetConnectionDataCol();
                    if (constraintPHInfo.getService().isNew()) {
                        preNewCphis.add(constraintPHInfo);
                    }
                    if (rdataOrd != null && !rdataOrd.isEmpty()) {
                        rdataToCphi.put(rdataOrd, constraintPHInfo);
                    }
                    if (rdataCol == null || rdataCol.isEmpty()) continue;
                    rdataToCphi.put(rdataCol, constraintPHInfo);
                }
            }
            this.getBrowser().unlockNameToServiceInfo();
            ArrayList<ConstraintPHInfo> newCphis = new ArrayList<ConstraintPHInfo>();
            for (CRMXML.RscSetConnectionData rscSetConnectionData : rscSetConnections) {
                ServiceInfo si;
                ConstraintPHInfo cphi = null;
                PcmkRscSetsInfo prsi = null;
                for (CRMXML.RscSetConnectionData ordata : rdataToCphi.keySet()) {
                    if (ordata == rscSetConnectionData || !rscSetConnectionData.equals((Object)ordata) && !rscSetConnectionData.equalsReversed(ordata)) continue;
                    cphi = (ConstraintPHInfo)rdataToCphi.get(ordata);
                    cphi.setRscSetConnectionData(rscSetConnectionData);
                    break;
                }
                if (cphi == null) {
                    for (CRMXML.RscSetConnectionData ordata : rdataToCphi.keySet()) {
                        if (ordata == rscSetConnectionData) {
                            cphi = (ConstraintPHInfo)rdataToCphi.get(ordata);
                            break;
                        }
                        if (((ConstraintPHInfo)rdataToCphi.get(ordata)).sameConstraintId(rscSetConnectionData)) {
                            prsi = ((ConstraintPHInfo)rdataToCphi.get(ordata)).getPcmkRscSetsInfo();
                        }
                        if (!((ConstraintPHInfo)rdataToCphi.get(ordata)).getService().isNew() && (!rscSetConnectionData.samePlaceholder(ordata) || !((ConstraintPHInfo)rdataToCphi.get(ordata)).sameConstraintId(rscSetConnectionData))) continue;
                        cphi = (ConstraintPHInfo)rdataToCphi.get(ordata);
                        cphi.setRscSetConnectionData(rscSetConnectionData);
                        prsi = cphi.getPcmkRscSetsInfo();
                        if (prsi == null) break;
                        if (rscSetConnectionData.isColocation()) {
                            prsi.addColocation(rscSetConnectionData.getConstraintId(), cphi);
                            break;
                        }
                        prsi.addOrder(rscSetConnectionData.getConstraintId(), cphi);
                        break;
                    }
                }
                if (cphi == null && !preNewCphis.isEmpty()) {
                    cphi = (ConstraintPHInfo)preNewCphis.remove(0);
                    rdataToCphi.put(rscSetConnectionData, cphi);
                    cphi.setRscSetConnectionData(rscSetConnectionData);
                }
                if (cphi == null) {
                    cphi = new ConstraintPHInfo(this.getBrowser(), rscSetConnectionData, ConstraintPHInfo.Preference.AND);
                    if (prsi == null) {
                        prsi = new PcmkRscSetsInfo(this.getBrowser());
                    }
                    if (rscSetConnectionData.isColocation()) {
                        prsi.addColocation(rscSetConnectionData.getConstraintId(), cphi);
                    } else {
                        prsi.addOrder(rscSetConnectionData.getConstraintId(), cphi);
                    }
                    cphi.setPcmkRscSetsInfo(prsi);
                    this.getBrowser().addNameToServiceInfoHash(cphi);
                    newCphis.add(cphi);
                    rdataToCphi.put(rscSetConnectionData, cphi);
                }
                serviceIsPresent.add(cphi);
                CRMXML.RscSet rscSet1 = rscSetConnectionData.getRscSet1();
                CRMXML.RscSet rscSet2 = rscSetConnectionData.getRscSet2();
                if (rscSetConnectionData.isColocation()) {
                    if (rscSet1 != null) {
                        for (String rscId : rscSet1.getRscIds()) {
                            si = this.getBrowser().getServiceInfoFromCRMId(rscId);
                            hg.addColocation(rscSetConnectionData.getConstraintId(), cphi, si);
                        }
                    }
                    if (rscSet2 != null) {
                        for (String rscId : rscSet2.getRscIds()) {
                            si = this.getBrowser().getServiceInfoFromCRMId(rscId);
                            hg.addColocation(rscSetConnectionData.getConstraintId(), si, cphi);
                        }
                    }
                } else {
                    if (rscSet1 != null) {
                        for (String rscId : rscSet1.getRscIds()) {
                            si = this.getBrowser().getServiceInfoFromCRMId(rscId);
                            hg.addOrder(rscSetConnectionData.getConstraintId(), si, cphi);
                        }
                    }
                    if (rscSet2 != null) {
                        for (String rscId : rscSet2.getRscIds()) {
                            si = this.getBrowser().getServiceInfoFromCRMId(rscId);
                            hg.addOrder(rscSetConnectionData.getConstraintId(), cphi, si);
                        }
                    }
                }
                if (testOnly || cphi == null) continue;
                cphi.setUpdated(false);
                cphi.getService().setNew(false);
            }
            for (ConstraintPHInfo constraintPHInfo : newCphis) {
                hg.addConstraintPlaceholder(constraintPHInfo, null, false);
            }
        }
        Map<String, List<CRMXML.ColocationData>> colocationMap = clStatus.getColocationRscMap();
        for (String rscId : colocationMap.keySet()) {
            List<CRMXML.ColocationData> withs = colocationMap.get(rscId);
            for (CRMXML.ColocationData colocationData : withs) {
                String withRscId = colocationData.getWithRsc();
                ServiceInfo withSi = this.getBrowser().getServiceInfoFromCRMId(withRscId);
                siP = this.getBrowser().getServiceInfoFromCRMId(rscId);
                hg.addColocation(colocationData.getId(), siP, withSi);
            }
        }
        Map<String, List<CRMXML.OrderData>> orderMap = clStatus.getOrderRscMap();
        for (String rscFirstId : orderMap.keySet()) {
            for (CRMXML.OrderData orderData : orderMap.get(rscFirstId)) {
                List<CRMXML.ColocationData> cds;
                String rscThenId = orderData.getRscThen();
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(rscThenId);
                if (si == null || (siP = this.getBrowser().getServiceInfoFromCRMId(rscFirstId)) == null || siP.getResourceAgent() == null) continue;
                if ((siP.getResourceAgent().isDrbddisk() || siP.getResourceAgent().isLinbitDrbd()) && si.getName().equals("Filesystem") && (cds = clStatus.getColocationDatas(rscFirstId)) != null) {
                    for (CRMXML.ColocationData cd : cds) {
                        if (!cd.getWithRsc().equals(rscThenId)) continue;
                        this.setFilesystemWithDrbd(siP, si);
                    }
                }
                hg.addOrder(orderData.getId(), siP, si);
            }
        }
        Enumeration<TreeNode> e = this.getNode().children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            ServiceInfo g = (ServiceInfo)n.getUserObject();
            if (g.getResourceAgent().isGroup() || g.getResourceAgent().isClone()) {
                Enumeration<TreeNode> enumeration = g.getNode().children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode gn = (DefaultMutableTreeNode)enumeration.nextElement();
                    ServiceInfo s = (ServiceInfo)gn.getUserObject();
                    if (!groupServiceIsPresent.contains(s) && !s.getService().isNew()) {
                        s.removeInfo();
                        continue;
                    }
                    if (testOnly) continue;
                    s.updateMenus(null);
                }
            }
            g.updateMenus(null);
        }
        hg.setServiceIsPresentList(serviceIsPresent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                hg.killRemovedEdges();
                Map<String, ServiceInfo> idToInfoHash = ServicesInfo.this.getBrowser().getNameToServiceInfoHash("Placeholder");
                if (idToInfoHash != null) {
                    for (String id : idToInfoHash.keySet()) {
                        ConstraintPHInfo cphi = (ConstraintPHInfo)idToInfoHash.get(id);
                        if (cphi.getService().isNew() || !cphi.isEmpty()) continue;
                        cphi.getService().setNew(true);
                    }
                }
                hg.killRemovedVertices();
                hg.scale();
            }
        });
    }

    @Override
    boolean selectAutomaticallyInTreeMenu() {
        return this.infoPanel == null;
    }

    @Override
    protected String getInfoType() {
        return "text/html";
    }

    @Override
    String getInfo() {
        if (this.getBrowser().clStatusFailed()) {
            return Tools.getString("ClusterBrowser.ClStatusFailed");
        }
        return null;
    }

    private void addRscDefaultsPanel(JPanel optionsPanel, int leftWidth, int rightWidth) {
        RscDefaultsInfo rdi = this.getBrowser().getRscDefaultsInfo();
        rdi.widgetClear();
        String[] params = rdi.getParametersFromXML();
        rdi.addParams(optionsPanel, params, leftWidth, rightWidth, null);
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.getBrowser().clStatusFailed()) {
            return super.getInfoPanel();
        }
        final CRMGraph hg = this.getBrowser().getCRMGraph();
        if (this.infoPanel != null) {
            hg.pickBackground();
            return this.infoPanel;
        }
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        if (this.getBrowser().getCRMXML() == null) {
            return newPanel;
        }
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                Host dcHost = ServicesInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                hg.stopTestAnimation(ServicesInfo.this.getApplyButton());
                ServicesInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                ServicesInfo.this.getApplyButton().setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                ServicesInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                hg.startTestAnimation(ServicesInfo.this.getApplyButton(), startTestLatch);
                Host dcHost = ServicesInfo.this.getBrowser().getDCHost();
                ServicesInfo.this.getBrowser().ptestLockAcquire();
                ClusterStatus clStatus = ServicesInfo.this.getBrowser().getClusterStatus();
                clStatus.setPtestData(null);
                ServicesInfo.this.apply(dcHost, true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                ServicesInfo.this.getApplyButton().setToolTipText(ptestData.getToolTip());
                clStatus.setPtestData(ptestData);
                ServicesInfo.this.getBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initCommitButton(buttonCallback);
        this.getBrowser().getRscDefaultsInfo().setApplyButton(this.getApplyButton());
        this.getBrowser().getRscDefaultsInfo().setRevertButton(this.getRevertButton());
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        buttonPanel.add((Component)this.getActionsButton(), "East");
        newPanel.add(buttonPanel);
        final String[] params = this.getParametersFromXML();
        this.addParams(optionsPanel, params, Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth"), Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth"), null);
        this.addRscDefaultsPanel(optionsPanel, Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth"), Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth"));
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ServicesInfo.this.getBrowser().clStatusLock();
                        ServicesInfo.this.apply(ServicesInfo.this.getBrowser().getDCHost(), false);
                        ServicesInfo.this.getBrowser().clStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.getRevertButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ServicesInfo.this.getBrowser().clStatusLock();
                        ServicesInfo.this.revert();
                        ServicesInfo.this.getBrowser().clStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServicesInfo.this.setApplyButtons(null, params);
            }
        });
        mainPanel.add(optionsPanel);
        newPanel.add(this.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        newPanel.add(new JScrollPane(mainPanel));
        hg.pickBackground();
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getCRMGraph().getGraphPanel();
    }

    ServiceInfo addServicePanel(ResourceAgent newRA, Point2D pos, boolean reloadNode, String heartbeatId, CloneInfo newCi, boolean testOnly) {
        ServiceInfo newServiceInfo;
        String name = newRA.getName();
        if (newRA.isFilesystem()) {
            newServiceInfo = new FilesystemInfo(name, newRA, this.getBrowser());
        } else if (newRA.isLinbitDrbd()) {
            newServiceInfo = new LinbitDrbdInfo(name, newRA, this.getBrowser());
        } else if (newRA.isDrbddisk()) {
            newServiceInfo = new DrbddiskInfo(name, newRA, this.getBrowser());
        } else if (newRA.isIPaddr()) {
            newServiceInfo = new IPaddrInfo(name, newRA, this.getBrowser());
        } else if (newRA.isVirtualDomain()) {
            newServiceInfo = new VirtualDomainInfo(name, newRA, this.getBrowser());
        } else if (newRA.isGroup()) {
            newServiceInfo = new GroupInfo(newRA, (Browser)this.getBrowser());
        } else if (newRA.isClone()) {
            boolean master = this.getBrowser().getClusterStatus().isMaster(heartbeatId);
            String cloneName = master ? "Master/Slave Set" : "Clone Set";
            newServiceInfo = new CloneInfo(newRA, cloneName, master, this.getBrowser());
        } else {
            newServiceInfo = new ServiceInfo(name, newRA, this.getBrowser());
        }
        if (heartbeatId != null) {
            newServiceInfo.getService().setHeartbeatId(heartbeatId);
            this.getBrowser().addToHeartbeatIdList(newServiceInfo);
        }
        if (newCi == null) {
            this.addServicePanel(newServiceInfo, pos, reloadNode, true, testOnly);
        }
        return newServiceInfo;
    }

    void addServicePanel(ServiceInfo newServiceInfo, Point2D pos, boolean reloadNode, boolean interactive, boolean testOnly) {
        newServiceInfo.getService().setResourceClass(newServiceInfo.getResourceAgent().getResourceClass());
        final CRMGraph hg = this.getBrowser().getCRMGraph();
        if (!hg.addResource(newServiceInfo, null, pos, false, false, testOnly)) {
            this.getBrowser().addNameToServiceInfoHash(newServiceInfo);
            DefaultMutableTreeNode newServiceNode = new DefaultMutableTreeNode(newServiceInfo);
            newServiceInfo.setNode(newServiceNode);
            this.getBrowser().getServicesNode().add(newServiceNode);
            if (interactive) {
                if (newServiceInfo.getResourceAgent().isProbablyMasterSlave()) {
                    newServiceInfo.changeType("Master/Slave");
                } else if (newServiceInfo.getResourceAgent().isProbablyClone()) {
                    newServiceInfo.changeType("Clone");
                }
            }
            if (reloadNode) {
                this.getBrowser().reload(this.getBrowser().getServicesNode(), false);
                this.getBrowser().reload(newServiceNode, true);
            }
            this.getBrowser().reloadAllComboBoxes(newServiceInfo);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    hg.scale();
                }
            });
        }
        hg.reloadServiceMenus();
    }

    List<ResourceAgent> getAddServiceList(String cl) {
        return this.getBrowser().globalGetAddServiceList(cl);
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        MyMenuItem addGroupMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.AddGroup"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                ServicesInfo.this.addServicePanel(ServicesInfo.this.getBrowser().getCRMXML().getHbGroup(), this.getPos(), true, null, null, false);
                ServicesInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        items.add(addGroupMenuItem);
        final ServicesInfo thisClass = this;
        MyMenu addServiceMenuItem = new MyMenu(Tools.getString("ClusterBrowser.Hb.AddService"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;
            private final Lock mUpdateLock;
            {
                super(x0, x1, x2);
                this.mUpdateLock = new ReentrantLock();
            }

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void update() {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (mUpdateLock.tryLock()) {
                            try {
                                this.updateThread();
                            }
                            finally {
                                mUpdateLock.unlock();
                            }
                        }
                    }
                });
                t.start();
            }

            private void updateThread() {
                ResourceAgent ipService;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setEnabled(false);
                    }
                });
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                Point2D pos = this.getPos();
                CRMXML crmXML = ServicesInfo.this.getBrowser().getCRMXML();
                final ResourceAgent fsService = crmXML.getResourceAgent("Filesystem", "heartbeat", "ocf");
                if (crmXML.isLinbitDrbdPresent()) {
                    ResourceAgent linbitDrbdService = crmXML.getHbLinbitDrbd();
                    final MyMenuItem ldMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.linbitDrbdMenuName"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void action() {
                            ServicesInfo.this.hidePopup();
                            if (!ServicesInfo.this.getBrowser().linbitDrbdConfirmDialog()) {
                                return;
                            }
                            FilesystemInfo fsi = (FilesystemInfo)ServicesInfo.this.addServicePanel(fsService, this.getPos(), true, null, null, false);
                            fsi.setDrbddiskIsPreferred(false);
                            ServicesInfo.this.getBrowser().getCRMGraph().repaint();
                        }
                    };
                    if (ServicesInfo.this.getBrowser().atLeastOneDrbddisk() || !crmXML.isLinbitDrbdPresent()) {
                        ldMenuItem.setEnabled(false);
                    }
                    ldMenuItem.setPos(pos);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.add(ldMenuItem);
                        }
                    });
                }
                if ((ipService = crmXML.getResourceAgent("IPaddr2", "heartbeat", "ocf")) != null) {
                    final MyMenuItem ipMenuItem = new MyMenuItem(ipService.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void action() {
                            ServicesInfo.this.hidePopup();
                            ServicesInfo.this.addServicePanel(ipService, this.getPos(), true, null, null, false);
                            ServicesInfo.this.getBrowser().getCRMGraph().repaint();
                        }
                    };
                    ipMenuItem.setPos(pos);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.add(ipMenuItem);
                        }
                    });
                }
                if (crmXML.isDrbddiskPresent() && (ServicesInfo.this.getBrowser().isDrbddiskPreferred() || ServicesInfo.this.getBrowser().atLeastOneDrbddisk() || !crmXML.isLinbitDrbdPresent())) {
                    ResourceAgent drbddiskService = crmXML.getHbDrbddisk();
                    final MyMenuItem ddMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.DrbddiskMenuName"), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void action() {
                            ServicesInfo.this.hidePopup();
                            FilesystemInfo fsi = (FilesystemInfo)ServicesInfo.this.addServicePanel(fsService, this.getPos(), true, null, null, false);
                            fsi.setDrbddiskIsPreferred(true);
                            ServicesInfo.this.getBrowser().getCRMGraph().repaint();
                        }
                    };
                    if (ServicesInfo.this.getBrowser().isOneLinbitDrbd() || !crmXML.isDrbddiskPresent()) {
                        ddMenuItem.setEnabled(false);
                    }
                    ddMenuItem.setPos(pos);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.add(ddMenuItem);
                        }
                    });
                }
                final ArrayList<JDialog> popups = new ArrayList<JDialog>();
                for (String cl : ClusterBrowser.HB_CLASSES) {
                    List<ResourceAgent> services = ServicesInfo.this.getAddServiceList(cl);
                    if (services.size() == 0) continue;
                    boolean mode = false;
                    if ("upstart".equals(cl) || "systemd".equals(cl)) {
                        mode = true;
                    }
                    if ("lsb".equals(cl) && !ServicesInfo.this.getAddServiceList("service").isEmpty()) {
                        mode = true;
                    }
                    final MyMenu classItem = new MyMenu(ClusterBrowser.getClassMenu(cl), new AccessMode(ConfigData.AccessType.ADMIN, mode), new AccessMode(ConfigData.AccessType.OP, mode));
                    MyListModel<MyMenuItem> dlm = new MyListModel<MyMenuItem>();
                    for (final ResourceAgent ra : services) {
                        MyMenuItem mmi = new MyMenuItem(ra.getMenuName(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public void action() {
                                ServicesInfo.this.hidePopup();
                                for (JDialog otherP : popups) {
                                    otherP.dispose();
                                }
                                if (ra.isLinbitDrbd() && !ServicesInfo.this.getBrowser().linbitDrbdConfirmDialog()) {
                                    return;
                                }
                                if (ra.isHbDrbd() && !ServicesInfo.this.getBrowser().hbDrbdConfirmDialog()) {
                                    return;
                                }
                                ServicesInfo.this.addServicePanel(ra, this.getPos(), true, null, null, false);
                                ServicesInfo.this.getBrowser().getCRMGraph().repaint();
                            }
                        };
                        mmi.setPos(pos);
                        dlm.addElement(mmi);
                    }
                    boolean ret = Tools.getScrollingMenu(ClusterBrowser.getClassMenu(cl), null, classItem, dlm, new MyList<MyMenuItem>(dlm, this.getBackground()), thisClass, popups, null);
                    if (!ret) {
                        classItem.setEnabled(false);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.add(classItem);
                        }
                    });
                }
                super.update();
            }
        };
        items.add(addServiceMenuItem);
        MyMenuItem addConstraintPlaceholderAnd = new MyMenuItem(Tools.getString("ServicesInfo.AddConstraintPlaceholderAnd"), null, Tools.getString("ServicesInfo.AddConstraintPlaceholderAnd.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                final CRMGraph hg = ServicesInfo.this.getBrowser().getCRMGraph();
                ConstraintPHInfo cphi = new ConstraintPHInfo(ServicesInfo.this.getBrowser(), null, ConstraintPHInfo.Preference.AND);
                cphi.getService().setNew(true);
                ServicesInfo.this.getBrowser().addNameToServiceInfoHash(cphi);
                hg.addConstraintPlaceholder(cphi, this.getPos(), false);
                PcmkRscSetsInfo prsi = new PcmkRscSetsInfo(ServicesInfo.this.getBrowser(), cphi);
                cphi.setPcmkRscSetsInfo(prsi);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        hg.scale();
                    }
                });
            }
        };
        items.add(addConstraintPlaceholderAnd);
        MyMenuItem addConstraintPlaceholderOr = new MyMenuItem(Tools.getString("ServicesInfo.AddConstraintPlaceholderOr"), null, Tools.getString("ServicesInfo.AddConstraintPlaceholderOr.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                String pmV = ServicesInfo.this.getBrowser().getDCHost().getPacemakerVersion();
                try {
                    if (pmV == null || Tools.compareVersions(pmV, "1.1.7") <= 0) {
                        return HbOrderInfo.NOT_AVAIL_FOR_PCMK_VERSION;
                    }
                }
                catch (Exceptions.IllegalVersionException e) {
                    Tools.appWarning("unkonwn version: " + pmV);
                }
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                final CRMGraph hg = ServicesInfo.this.getBrowser().getCRMGraph();
                ConstraintPHInfo cphi = new ConstraintPHInfo(ServicesInfo.this.getBrowser(), null, ConstraintPHInfo.Preference.OR);
                cphi.getService().setNew(true);
                ServicesInfo.this.getBrowser().addNameToServiceInfoHash(cphi);
                hg.addConstraintPlaceholder(cphi, this.getPos(), false);
                PcmkRscSetsInfo prsi = new PcmkRscSetsInfo(ServicesInfo.this.getBrowser(), cphi);
                cphi.setPcmkRscSetsInfo(prsi);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        hg.scale();
                    }
                });
            }
        };
        items.add(addConstraintPlaceholderOr);
        MyMenuItem stopAllMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.StopAllServices"), ServiceInfo.STOP_ICON, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServicesInfo.this.getBrowser().getExistingServiceList(null).isEmpty()) {
                    return "there are no services";
                }
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.isStopped(false) || si.getService().isOrphaned()) continue;
                    return null;
                }
                return "all services are stopped";
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                Host dcHost = ServicesInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getGroupInfo() != null || si.isStopped(false) || si.getService().isOrphaned() || si.getService().isNew()) continue;
                    si.stopResource(dcHost, false);
                }
                ServicesInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback stopAllItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, stopAllMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                Host thisDCHost = ServicesInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getGroupInfo() != null || si.isConstraintPH() || si.isStopped(true) || si.getService().isOrphaned() || si.getService().isNew()) continue;
                    si.stopResource(thisDCHost, true);
                }
            }
        };
        this.addMouseOverListener(stopAllMenuItem, stopAllItemCallback);
        items.add(stopAllMenuItem);
        MyMenuItem unmigrateAllMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.UnmigrateAllServices"), ServiceInfo.UNMIGRATE_ICON, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return this.enablePredicate() == null;
            }

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServicesInfo.this.getBrowser().getExistingServiceList(null).isEmpty()) {
                    return "there are no services";
                }
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getMigratedTo(false) == null && si.getMigratedFrom(false) == null) continue;
                    return null;
                }
                return "nothing to unmigrate";
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                Host dcHost = ServicesInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getMigratedTo(false) == null && si.getMigratedFrom(false) == null) continue;
                    si.unmigrateResource(dcHost, false);
                }
                ServicesInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.ClMenuItemCallback unmigrateAllItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser2, unmigrateAllMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                Host thisDCHost = ServicesInfo.this.getBrowser().getDCHost();
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getMigratedTo(false) == null && si.getMigratedFrom(false) == null) continue;
                    si.unmigrateResource(dcHost, true);
                }
            }
        };
        this.addMouseOverListener(unmigrateAllMenuItem, unmigrateAllItemCallback);
        items.add(unmigrateAllMenuItem);
        MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.RemoveAllServices"), ClusterBrowser.REMOVE_ICON, new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.ADMIN, true)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ServicesInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ServicesInfo.this.getBrowser().getExistingServiceList(null).isEmpty()) {
                    return "there are no services";
                }
                for (ServiceInfo si : ServicesInfo.this.getBrowser().getExistingServiceList(null)) {
                    if (si.getGroupInfo() != null || !si.isRunning(false)) continue;
                    return "there are running services";
                }
                return null;
            }

            @Override
            public void action() {
                ServicesInfo.this.hidePopup();
                if (Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmRemoveAllServices.Title"), Tools.getString("ClusterBrowser.confirmRemoveAllServices.Description"), Tools.getString("ClusterBrowser.confirmRemoveAllServices.Yes"), Tools.getString("ClusterBrowser.confirmRemoveAllServices.No"))) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            ResourceAgent ra;
                            Host dcHost = ServicesInfo.this.getBrowser().getDCHost();
                            List<ServiceInfo> services = ServicesInfo.this.getBrowser().getExistingServiceList(null);
                            for (ServiceInfo si : services) {
                                if (si.getGroupInfo() != null || (ra = si.getResourceAgent()) == null || ra.isClone()) continue;
                                si.getService().setRemoved(true);
                            }
                            CRM.erase(dcHost, false);
                            for (ServiceInfo si : services) {
                                if (si.getGroupInfo() != null) continue;
                                ra = si.getResourceAgent();
                                if (si.getService().isNew()) {
                                    si.removeMyself(false);
                                    continue;
                                }
                                if (ra == null || ra.isClone()) continue;
                                si.cleanupResource(dcHost, false);
                            }
                            ServicesInfo.this.getBrowser().getCRMGraph().repaint();
                        }
                    };
                    t.start();
                }
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.ClMenuItemCallback removeItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser3, removeMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public void action(Host dcHost) {
                Host thisDCHost = ServicesInfo.this.getBrowser().getDCHost();
                CRM.erase(dcHost, true);
            }
        };
        this.addMouseOverListener(removeMenuItem, removeItemCallback);
        items.add(removeMenuItem);
        MyMenuItem viewLogsItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.ViewLogs"), LOGFILE_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                ClusterLogs l = new ClusterLogs(ServicesInfo.this.getBrowser().getCluster());
                l.showDialog();
            }
        };
        items.add(viewLogsItem);
        return items;
    }

    @Override
    protected Unit[] getUnits() {
        return new Unit[]{new Unit("", "s", "Second", "Seconds"), new Unit("ms", "ms", "Millisecond", "Milliseconds"), new Unit("us", "us", "Microsecond", "Microseconds"), new Unit("s", "s", "Second", "Seconds"), new Unit("min", "m", "Minute", "Minutes"), new Unit("h", "h", "Hour", "Hours")};
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        RscDefaultsInfo rdi = this.getBrowser().getRscDefaultsInfo();
        boolean ret = true;
        if (!rdi.checkResourceFieldsCorrect(param, rdi.getParametersFromXML(), true)) {
            ret = false;
        }
        if (!super.checkResourceFieldsCorrect(param, params)) {
            ret = false;
        }
        for (ServiceInfo si : this.getBrowser().getExistingServiceList(null)) {
            if (si.checkResourceFieldsCorrect(null, si.getParametersFromXML(), true, false, false)) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        boolean changed = false;
        RscDefaultsInfo rdi = this.getBrowser().getRscDefaultsInfo();
        if (super.checkResourceFieldsChanged(param, params)) {
            changed = true;
        }
        if (rdi.checkResourceFieldsChanged(param, rdi.getParametersFromXML(), true)) {
            changed = true;
        }
        for (ServiceInfo si : this.getBrowser().getExistingServiceList(null)) {
            if (!si.checkResourceFieldsChanged(null, si.getParametersFromXML(), true, false, false)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void revert() {
        super.revert();
        RscDefaultsInfo rdi = this.getBrowser().getRscDefaultsInfo();
        rdi.revert();
        for (ServiceInfo si : this.getBrowser().getExistingServiceList(null)) {
            if (!si.checkResourceFieldsChanged(null, si.getParametersFromXML(), true, false, false)) continue;
            si.revert();
        }
    }

    private void copyPasteField(Widget oldWi, final Widget newWi) {
        if (newWi == null || oldWi == null) {
            return;
        }
        final String oldValue = oldWi.getStringValue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if ("".equals(oldValue)) {
                    newWi.setValueNoListeners(null);
                } else {
                    newWi.setValueNoListeners(oldValue);
                }
            }
        });
    }

    private void copyPasteFields(ServiceInfo oldSi, ServiceInfo newSi) {
        for (String param : oldSi.getParametersFromXML()) {
            if (("__drbdmcid".equals(param) || "__pckmkid".equals(param)) && this.getBrowser().isCRMId(oldSi.getService().getHeartbeatId())) continue;
            this.copyPasteField(oldSi.getWidget(param, null), newSi.getWidget(param, null));
        }
        this.copyPasteField(oldSi.getSameAsOperationsWi(), newSi.getSameAsOperationsWi());
        for (String op : oldSi.getResourceAgent().getOperationNames()) {
            for (String param : this.getBrowser().getCRMOperationParams(op)) {
                this.copyPasteField(oldSi.getOperationsComboBox(op, param), newSi.getOperationsComboBox(op, param));
            }
        }
        for (Host host : this.getBrowser().getClusterHosts()) {
            HostInfo hi = host.getBrowser().getHostInfo();
            this.copyPasteField(oldSi.getScoreComboBoxHash().get(hi), newSi.getScoreComboBoxHash().get(hi));
        }
        this.copyPasteField(oldSi.getPingComboBox(), newSi.getPingComboBox());
    }

    public void pasteServices(List<Info> oldInfos) {
        if (oldInfos.size() == 0) {
            return;
        }
        String cn = this.getBrowser().getCluster().getName();
        Tools.startProgressIndicator(cn, "paste");
        ClusterBrowser otherBrowser = (ClusterBrowser)oldInfos.get(0).getBrowser();
        this.getBrowser().getClusterViewPanel().setDisabledDuringLoad(true);
        otherBrowser.getClusterViewPanel().setDisabledDuringLoad(true);
        for (Info oldI : oldInfos) {
            CloneInfo oci = null;
            if (oldI instanceof CloneInfo) {
                oci = (CloneInfo)oldI;
                oldI = oci.getContainedService();
            }
            final CloneInfo oldCi = oci;
            if (!(oldI instanceof ServiceInfo)) continue;
            final ServiceInfo oldSi = (ServiceInfo)oldI;
            final ServiceInfo newSi = this.addServicePanel(oldSi.getResourceAgent(), null, true, null, null, false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!(newSi instanceof CloneInfo)) {
                        oldSi.getInfoPanel();
                        newSi.getInfoPanel();
                        oldSi.waitForInfoPanel();
                        newSi.waitForInfoPanel();
                    }
                    if (oldCi != null) {
                        CloneInfo oci = oldCi;
                        String v = newSi.getTypeRadioGroup().getStringValue();
                        if (oci.getService().isMaster()) {
                            if (!"Master/Slave".equals(v)) {
                                newSi.getTypeRadioGroup().setValue("Master/Slave");
                            }
                        } else if (!"Clone".equals(v)) {
                            newSi.getTypeRadioGroup().setValue("Clone");
                        }
                    }
                    ServicesInfo.this.copyPasteFields(oldSi, newSi);
                }
            });
            final CloneInfo newCi = newSi.getCloneInfo();
            if (newCi != null) {
                final CloneInfo oldCi0 = oldCi;
                for (final String param : oldCi0.getParametersFromXML()) {
                    if (("__drbdmcid".equals(param) || "__pckmkid".equals(param)) && this.getBrowser().isCRMId(oldCi0.getService().getHeartbeatId())) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ServicesInfo.this.copyPasteField(oldCi0.getWidget(param, null), newCi.getWidget(param, null));
                        }
                    });
                }
            }
            if (!(oldI instanceof GroupInfo)) continue;
            GroupInfo oldGi = (GroupInfo)oldI;
            final GroupInfo newGi = (GroupInfo)newSi;
            Enumeration<TreeNode> e = oldGi.getNode().children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                final ServiceInfo oldChild = (ServiceInfo)n.getUserObject();
                oldChild.getInfoPanel();
                oldChild.waitForInfoPanel();
                final ServiceInfo newChild = newGi.addGroupServicePanel(oldChild.getResourceAgent(), false);
                newChild.getInfoPanel();
                newChild.waitForInfoPanel();
                Tools.waitForSwing();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ServicesInfo.this.copyPasteFields(oldChild, newChild);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServicesInfo.this.getBrowser().reload(newGi.getNode(), false);
                }
            });
        }
        Tools.stopProgressIndicator(cn, "paste");
        otherBrowser.getClusterViewPanel().setDisabledDuringLoad(false);
        this.getBrowser().getClusterViewPanel().setDisabledDuringLoad(false);
    }
}

