/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

public final class VMSFilesystemInfo
extends VMSHardwareInfo {
    private final Map<String, Widget> sourceDirWi = new HashMap<String, Widget>();
    private final Map<String, Widget> sourceNameWi = new HashMap<String, Widget>();
    private final String[] sourceDirs;
    private String prevTargetBus = null;
    private static final String[] PARAMETERS = new String[]{"type", "source_dir", "source_name", "target_dir"};
    private static final String[] MOUNT_PARAMETERS = new String[]{"type", "source_dir", "target_dir"};
    private static final String[] TEMPLATE_PARAMETERS = new String[]{"type", "source_name", "target_dir"};
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>(Arrays.asList(new String[0]));
    private static final Set<String> IS_REQUIRED = new HashSet<String>(Arrays.asList("type", "target_dir"));
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String[]> TARGET_DEVICES_MAP = new HashMap<String, String[]>();
    private static final Map<String, String> SHORTNAME_MAP;
    private static final Map<String, String> PREFERRED_MAP;
    private static final Map<String, String> DEFAULTS_MAP;
    private static final Map<String, Object[]> POSSIBLE_VALUES;
    private static final String MOUNT_TYPE = "mount";
    private static final String TEMPLATE_TYPE = "template";
    private static final String LXC_SOURCE_DIR = "/var/lib/lxc";
    private JComponent tablePanel = null;

    VMSFilesystemInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
        List<Host> hosts = this.getVMSVirtualDomainInfo().getDefinedOnHosts();
        LinkedHashSet<String> sds = new LinkedHashSet<String>();
        sds.add(null);
        for (Host h : hosts) {
            sds.addAll(h.getGuiOptions("vm.filesystem.source.dir.lxc"));
        }
        this.sourceDirs = sds.toArray(new String[sds.size()]);
    }

    @Override
    protected void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel("Filesystem", "filesystems", VMSFilesystemInfo.getNewBtn(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSFilesystemInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return BlockDevInfo.HARDDISK_ICON;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return this.getParamShortDesc(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected String getParamPreferred(String param) {
        return PREFERRED_MAP.get(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    public String[] getRealParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("source_dir".equals(param)) {
            return this.sourceDirs;
        }
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return "Filesystem Options";
    }

    @Override
    protected boolean isRequired(String param) {
        String type = this.getComboBoxValue("type");
        if ("source_dir".equals(param) && MOUNT_TYPE.equals(type) || "source_name".equals(param) && TEMPLATE_TYPE.equals(type)) {
            return true;
        }
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSFilesystemInfo.this.getInfoPanel();
            }
        });
        String[] params = this.getRealParametersFromXML();
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (allParams) {
                if (Tools.areEqual(this.getParamDefault(param), value)) {
                    parameters.put(param, null);
                    continue;
                }
                parameters.put(param, value);
                continue;
            }
            if (Tools.areEqual(this.getParamSaved(param), value)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
                continue;
            }
            parameters.put(param, value);
        }
        parameters.put("saved_target_dir", this.getName());
        this.setName(this.getParamSaved("target_dir"));
        return parameters;
    }

    @Override
    void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSFilesystemInfo.this.getApplyButton().setEnabled(false);
                VMSFilesystemInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        String[] params = this.getRealParametersFromXML();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            String domainName = this.getVMSVirtualDomainInfo().getDomainName();
            Node domainNode = vmsxml.getDomainNode(domainName);
            this.modifyXML(vmsxml, domainNode, domainName, parameters);
            String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
            vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
        }
        this.getResource().setNew(false);
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSFilesystemInfo.this.tablePanel.setVisible(true);
            }
        });
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyFilesystemXML(node, domainName, params);
        }
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("filesystems".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getFilesystemDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getFilesystems(), true)};
        }
        return new Object[0][];
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean checkParam(String param, final String newValue) {
        if ("type".equals(param)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (String p : VMSFilesystemInfo.this.sourceDirWi.keySet()) {
                        ((Widget)VMSFilesystemInfo.this.sourceDirWi.get(p)).setVisible(VMSFilesystemInfo.MOUNT_TYPE.equals(newValue));
                    }
                    for (String p : VMSFilesystemInfo.this.sourceNameWi.keySet()) {
                        ((Widget)VMSFilesystemInfo.this.sourceNameWi.get(p)).setVisible(VMSFilesystemInfo.TEMPLATE_TYPE.equals(newValue));
                    }
                }
            });
        }
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    void updateParameters() {
        VMSXML.FilesystemData filesystemData;
        Map<String, VMSXML.FilesystemData> filesystems = this.getVMSVirtualDomainInfo().getFilesystems();
        if (filesystems != null && (filesystemData = filesystems.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = filesystemData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.updateTable("header");
        this.updateTable("filesystems");
        this.setApplyButtons(null, this.getRealParametersFromXML());
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_target_dir", this.getName());
            vmsxml.removeFilesystemXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String name = this.getName();
        if (name == null) {
            return "new FS...";
        }
        String type = this.getComboBoxValue("type");
        String saved = MOUNT_TYPE.equals(type) ? this.getParamSaved("source_dir") : this.getParamSaved("source_name");
        if (saved == null) {
            s.append("new...");
        } else {
            s.append(saved);
        }
        s.append(" -> ");
        s.append(name);
        return s.toString();
    }

    @Override
    protected String isRemoveable() {
        return null;
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Filesystem");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addFilesystemPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        if ("source_dir".equals(param)) {
            String sourceDir = this.getParamSaved("source_dir");
            String regexp = ".*[^/]?$";
            MyButton fileChooserBtn = new MyButton("Browse...");
            fileChooserBtn.miniButton();
            final Widget paramWi = WidgetFactory.createInstance(this.getFieldType(param), sourceDir, this.getParamPossibleChoices(param), ".*[^/]?$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), false), fileChooserBtn);
            paramWi.setAlwaysEditable(true);
            if (prefix == null) {
                this.sourceDirWi.put("", paramWi);
            } else {
                this.sourceDirWi.put(prefix, paramWi);
            }
            if (Tools.isWindows()) {
                paramWi.setTFButtonEnabled(false);
            }
            fileChooserBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String oldFile = paramWi.getStringValue();
                            String file = oldFile == null || "".equals(oldFile) ? VMSFilesystemInfo.LXC_SOURCE_DIR : oldFile;
                            VMSFilesystemInfo.this.startFileChooser(paramWi, file, true);
                        }
                    });
                    t.start();
                }
            });
            this.widgetAdd(param, prefix, paramWi);
            return paramWi;
        }
        if ("source_name".equals(param)) {
            String sourceName = this.getParamSaved("source_name");
            Widget paramWi = WidgetFactory.createInstance(this.getFieldType(param), sourceName, this.getParamPossibleChoices(param), Widget.NO_REGEXP, width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), false), Widget.NO_BUTTON);
            paramWi.setAlwaysEditable(true);
            if (prefix == null) {
                this.sourceNameWi.put("", paramWi);
            } else {
                this.sourceNameWi.put(prefix, paramWi);
            }
            this.widgetAdd(param, prefix, paramWi);
            return paramWi;
        }
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("source_dir".equals(param) || "target_dir".equals(param)) {
            paramWi.setAlwaysEditable(true);
        }
        return paramWi;
    }

    static {
        FIELD_TYPES.put("type", Widget.Type.RADIOGROUP);
        FIELD_TYPES.put("source_dir", Widget.Type.COMBOBOX);
        FIELD_TYPES.put("source_name", Widget.Type.TEXTFIELD);
        FIELD_TYPES.put("target_dir", Widget.Type.COMBOBOX);
        SHORTNAME_MAP = new HashMap<String, String>();
        SHORTNAME_MAP.put("type", "Type");
        SHORTNAME_MAP.put("source_dir", "Source Dir");
        SHORTNAME_MAP.put("source_name", "Source Name");
        SHORTNAME_MAP.put("target_dir", "Target Dir");
        PREFERRED_MAP = new HashMap<String, String>();
        DEFAULTS_MAP = new HashMap<String, String>();
        POSSIBLE_VALUES = new HashMap<String, Object[]>();
        POSSIBLE_VALUES.put("type", new StringInfo[]{new StringInfo("Mount", MOUNT_TYPE, null), new StringInfo("Template", TEMPLATE_TYPE, null)});
        POSSIBLE_VALUES.put("target_dir", new String[]{"/"});
        PREFERRED_MAP.put("type", MOUNT_TYPE);
        PREFERRED_MAP.put("target_dir", "/");
    }
}

